/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dpro.bclient;

import com.sas.dpro.client.AbstractClient;
import com.sas.dpro.common.DProUtil;
import com.sas.dpro.common.ErrorInfo;
import com.sas.dpro.common.FileList;
import com.sas.dpro.common.InputPromptInfo;
import com.sas.dpro.common.InvalidProviderNameException;
import com.sas.dpro.contract.messages.ContractCompletedMessage;
import com.sas.dpro.contract.messages.DPROSystemMessage;
import com.sas.dpro.contract.messages.InfoMessage;
import com.sas.dpro.contract.messages.Message;
import com.sas.dpro.contract.messages.ServiceCompletedMessage;
import com.sas.dpro.contract.messages.ShowReportMessage;
import com.sas.dpro.contract.messages.WorkUnitMessage;
import com.sas.dpro.controller.HonorContractContext;
import com.sas.dpro.controller.HonorContractParms;
import com.sas.dpro.controller.HonorContractParmsImpl;
import com.sas.dpro.provider.Provider;
import com.sas.dpro.provider.ProviderFactory;
import com.sas.dpro.provider.ProviderImpl;
import com.sas.dpro.reporting.ReportInfo;
import com.sas.dpro.results.testing.TestSuiteResult;
import com.sas.dpro.service.ServiceResults;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BatchClient
extends AbstractClient {
    public static final int RC_OK = 0;
    public static final int RC_ERROR_COMMAND_LINE = 1;
    public static final int RC_ERROR_RUNNING_CONTRACT = 2;
    public static final int RC_ERROR_INTERNAL = 3;
    public static final String PROP_ALWAYS_SHOW_STACK_TRACES = "alwaysShowStackTraces";
    private static final String LOG_FILE_NAME = "BatchClient.log";
    private static final String BUNDLE = "com.sas.dpro.bclient.BatchClient";
    private static final ResourceBundle msg = ResourceBundle.getBundle("com.sas.dpro.bclient.BatchClient");
    private static final String PARAM_CONTRACT = "-contract";
    private static final String PARAM_CONTRACT_LIST = "-contractList";
    private static final String PARAM_DUMPRES = "-dumpResults";
    private static final String PARAM_HELP = "-help";
    private static final String PARAM_INTERACTIVE = "-interactive";
    private static final String PARAM_PRINT_WORK_UNITS = "-printWorkUnits";
    private static final String PARAM_USAGE = "-usage";
    private static final String PARAM_VARFILE = "-variableFile";
    private static final String CLIENT_TYPE_STRING = "batch";
    private static final String LOGGER_NAME = "com.sas.dpro.bclient.BatchClient";
    private boolean dumpResults;
    private boolean interactive;
    private boolean printWorkUnits;
    private static final String APP_DATA_SUBDIR = "SASDeploymentTesterClient/2.2";

    protected BatchClient(Logger logger) {
        super(logger, APP_DATA_SUBDIR);
        this.configureLogger();
        this.initialize();
    }

    protected void dumpContractResults(ContractCompletedMessage message) {
        HonorContractContext hcc = message.getHonorContractContext();
        Long sessionIDLong = new Long(hcc.getContractSessionID());
        String desc = msg.getString("DumpResults.ContractCompleted.Header.fmt.txt");
        desc = MessageFormat.format(desc, sessionIDLong);
        System.out.println(desc);
        if (message.isTimeout()) {
            desc = msg.getString("DumpResults.Timeout.fmt.txt");
            desc = MessageFormat.format(desc, message.getContract());
            System.out.println(desc);
        } else if (message.isError()) {
            desc = msg.getString("DumpResults.Error.txt");
            System.out.println(desc);
            System.out.println(message.getErrorInfo().getErrorStackTrace());
        } else {
            desc = msg.getString("DumpResults.Successful.txt");
            System.out.println(desc);
        }
        desc = msg.getString("DumpResults.ContractCompleted.Footer.txt");
        System.out.println(desc);
    }

    protected void dumpServiceResults(ServiceCompletedMessage scm) {
        boolean timedOut;
        ServiceResults res = scm.getServiceResults();
        HonorContractContext hcc = scm.getHonorContractContext();
        Long sessionIDLong = new Long(hcc.getContractSessionID());
        String key = "DumpResults.ServiceCompleted.Header.fmt.txt";
        String text = DProUtil.formatString((ResourceBundle)msg, (String)key, (Object)hcc.getProviderName(), (Object)sessionIDLong);
        System.out.println(text);
        key = "DumpResults.ServiceCompleted.ServiceName.fmt.txt";
        text = DProUtil.formatString((ResourceBundle)msg, (String)key, (Object)res.getServiceName());
        System.out.println(text);
        boolean failed = res.getStatus() == 1;
        boolean bl = timedOut = res.getStatus() == 2;
        text = failed ? msg.getString("Service.Failed.txt") : (timedOut ? msg.getString("Service.TimedOut.txt") : msg.getString("Service.Completed.txt"));
        key = "DumpResults.ServiceCompleted.Status.fmt.txt";
        text = DProUtil.formatString((ResourceBundle)msg, (String)key, (Object)text);
        System.out.println(text);
        if (res.getCommandExecuted() != null) {
            key = "DumpResults.ServiceCompleted.Command.fmt.txt";
            text = DProUtil.formatString((ResourceBundle)msg, (String)key, (Object)res.getCommandExecuted());
        }
        key = "DumpResults.ServiceCompleted.Server.fmt.txt";
        text = DProUtil.formatString((ResourceBundle)msg, (String)key, (Object)res.getServiceInfo().getHost());
        System.out.println(text);
        key = "DumpResults.ServiceCompleted.RC.fmt.txt";
        text = DProUtil.formatString((ResourceBundle)msg, (String)key, (Object)("" + res.getReturnCode()));
        System.out.println(text);
        key = "DumpResults.ServiceCompleted.ResultsID.fmt.txt";
        text = DProUtil.formatString((ResourceBundle)msg, (String)key, (Object)res.getResultsID());
        System.out.println(text);
        key = "DumpResults.ServiceCompleted.Time.fmt.txt";
        text = DProUtil.formatString((ResourceBundle)msg, (String)key, (Object)("" + res.getTime()));
        System.out.println(text);
        FileList outFiles = res.getOutputFiles();
        if (!outFiles.isEmpty()) {
            text = msg.getString("DumpResults.ServiceCompleted.OutputFiles.fmt.txt");
            text = MessageFormat.format(text, outFiles.getProvider(), outFiles.getRoot(), outFiles.getID());
            System.out.println(text);
            text = msg.getString("DumpResults.ServiceCompleted.OutputFile.fmt.txt");
            for (int i = 0; i < outFiles.getSize(); ++i) {
                String text2 = MessageFormat.format(text, "" + (i + 1), outFiles.get(i));
                System.out.println(text2);
            }
        }
        System.out.println();
        text = msg.getString("DumpResults.ServiceCompleted.Footer.txt");
        System.out.println(text);
    }

    private int emptyMessageQueue(int contractCount) {
        Message message = null;
        int errorCount = 0;
        for (int completed = 0; completed < contractCount; ++completed) {
            do {
                message = this.controller.getNextMessage();
                this.handleMessage(message);
            } while (!(message instanceof ContractCompletedMessage));
            ContractCompletedMessage msg = (ContractCompletedMessage)message;
            errorCount += this.handleTimeoutOrFailure(msg, 0, 0);
            if (!this.getDumpResults()) continue;
            this.dumpContractResults(msg);
        }
        return errorCount;
    }

    public String getDefaultReportType() {
        return "_text";
    }

    protected String getDPROClientTypeString() {
        return CLIENT_TYPE_STRING;
    }

    public boolean getDumpResults() {
        return this.dumpResults;
    }

    public boolean getInteractive() {
        return this.interactive;
    }

    protected String getLoggerFileName() {
        return LOG_FILE_NAME;
    }

    public boolean getPrintWorkUnits() {
        return this.printWorkUnits;
    }

    protected void handleHandleMessageError(String desc, Exception e) {
        System.err.println(desc);
        e.printStackTrace();
    }

    protected void handleMessageDPROSystem(DPROSystemMessage dsm) {
        System.out.println(dsm.getMessage());
    }

    protected void handleMessageInfo(InfoMessage im) {
        System.out.println(im.getMessage());
    }

    protected void handleMessageServiceCompleted(ServiceCompletedMessage scm) {
        this.dumpServiceResults(scm);
    }

    protected void handleMessageWorkUnit(WorkUnitMessage wum) {
        if (this.getPrintWorkUnits()) {
            System.out.println(wum.getWorkUnit());
        }
    }

    private void handleRunActionFailed(ContractCompletedMessage ccm, int depth) {
        String depthStr = "";
        for (int i = 0; i < depth; ++i) {
            depthStr = depthStr + "   ";
        }
        ErrorInfo ei = ccm.getErrorInfo();
        ContractCompletedMessage[] ccms = ei.getContractCompletedMessages();
        if (ccms != null) {
            String desc = msg.getString("RunActionErrors.txt");
            System.out.println(depthStr + desc);
            int index = 1;
            for (int i = 0; i < ccms.length; ++i) {
                ContractCompletedMessage[] ccms2;
                if (ccms[i].isTimeout()) {
                    String temp = msg.getString("RunActionErrors.Timeout.txt");
                    this.handleRunActionFailedPrintItem(ccms[i], index, temp, depthStr);
                    ++index;
                    continue;
                }
                if (!ccms[i].isError()) continue;
                ErrorInfo ei2 = ccms[i].getErrorInfo();
                String temp = ei2.getErrorMessage();
                if (Boolean.getBoolean(PROP_ALWAYS_SHOW_STACK_TRACES)) {
                    temp = temp + "\n=> " + ei2.getErrorStackTrace();
                }
                if ((ccms2 = ei2.getContractCompletedMessages()) != null) {
                    temp = temp + "\n" + depthStr;
                    temp = temp + msg.getString("RunActionErrors.txt");
                    this.handleRunActionFailedPrintItem(ccms[i], index, temp, depthStr);
                    ++index;
                    int index2 = 1;
                    for (int j = 0; j < ccms2.length; ++j) {
                        int errorCount = this.handleTimeoutOrFailure(ccms2[j], depth + 1, index2);
                        if (errorCount <= 0) continue;
                        ++index2;
                    }
                    continue;
                }
                this.handleRunActionFailedPrintItem(ccms[i], index, temp, depthStr);
                ++index;
            }
        }
    }

    private void handleRunActionFailedPrintItem(ContractCompletedMessage ccm, int index, String text, String depthStr) {
        String desc = msg.getString("RunActionErrors.Item.fmt.txt");
        String provider = ccm.getHonorContractContext().getProviderName();
        String contract = ccm.getContract();
        if (contract == null) {
            contract = msg.getString("RunActionErrors.NoContract.txt");
        }
        desc = MessageFormat.format(desc, "" + index, provider, contract, text);
        System.out.println(depthStr + desc);
    }

    private int handleTimeoutOrFailure(ContractCompletedMessage msg, int depth, int index) {
        String depthStr = "";
        for (int i = 0; i < depth; ++i) {
            depthStr = depthStr + "   ";
        }
        int errorCount = 0;
        if (msg.isTimeout()) {
            String desc = BatchClient.msg.getString("DumpResults.Timeout.fmt.txt");
            desc = MessageFormat.format(desc, msg.getContract());
            String text = depthStr;
            if (index > 0) {
                text = text + index + ". ";
            }
            System.out.println(text + desc);
            System.out.println();
            ++errorCount;
        } else if (msg.isError()) {
            ErrorInfo ei = msg.getErrorInfo();
            String errorMessage = ei.getErrorMessage();
            String type = ei.getErrorType();
            boolean output = false;
            if (errorMessage != null && type != null) {
                String text = depthStr;
                if (index > 0) {
                    text = text + index + ". ";
                }
                if (type.startsWith("java.lang.InterruptedException")) {
                    System.out.println(text + errorMessage);
                    output = true;
                } else if (type.startsWith("com.sas.dpro.common.ContractSyntaxException")) {
                    System.out.println(text + errorMessage);
                    output = true;
                } else if (type.startsWith("com.sas.dpro.common.InvalidContractException")) {
                    System.out.println(text + errorMessage);
                    output = true;
                } else if (type.startsWith("com.sas.dpro.common.ServiceNotAvailableException")) {
                    System.out.println(text + errorMessage);
                    output = true;
                } else if (type.startsWith("com.sas.dpro.common.ServiceTimedOutException")) {
                    System.out.println(text + errorMessage);
                    output = true;
                } else if (type.startsWith("com.sas.dpro.common.ProviderNotAvailableException")) {
                    System.out.println(text + errorMessage);
                    output = true;
                } else if (type.startsWith("org.jdom2.input.JDOM")) {
                    System.out.println(text + errorMessage);
                    output = true;
                } else if (type.startsWith("com.sas.dpro.common.RunActionFailedException")) {
                    System.out.println(text + errorMessage);
                    this.handleRunActionFailed(msg, depth + 1);
                    output = true;
                }
            }
            if (!output || Boolean.getBoolean(PROP_ALWAYS_SHOW_STACK_TRACES)) {
                System.out.println(depthStr + ei.getErrorStackTrace());
            }
            System.out.println();
            ++errorCount;
        }
        return errorCount;
    }

    public void honorContract(String contract) {
        ArrayList<String> contractList = new ArrayList<String>(1);
        contractList.add(contract);
        this.honorContracts(contractList);
    }

    public int honorContracts(List contractList) {
        int count = contractList.size();
        for (int i = 0; i < count; ++i) {
            HonorContractParmsImpl parms = new HonorContractParmsImpl();
            parms.setClientDPROVersion(this.getClientDPROVersion());
            parms.setContract((String)contractList.get(i));
            parms.setLocale(null);
            parms.setMessageGranularity(this.controller.getMessageGranularity());
            parms.setOriginalContractSessionID(-1L);
            parms.setTimeout(-1L);
            this.controller.honorContract((HonorContractParms)parms);
        }
        int errorCount = this.emptyMessageQueue(count);
        return errorCount;
    }

    public List parseCommandLine(String[] args) throws IllegalArgumentException {
        int i;
        Level loggingLevel = Level.WARNING;
        ArrayList<String> contractList = new ArrayList<String>();
        for (i = 0; i < args.length; ++i) {
            String desc;
            if (PARAM_CONTRACT.equals(args[i])) {
                if (++i == args.length) {
                    String desc2 = msg.getString("BatchClient.InvalidContractSpecification.txt");
                    throw new IllegalArgumentException(desc2);
                }
                contractList.add(args[i++]);
                while (i < args.length && args[i].charAt(0) != '-') {
                    contractList.add(args[i++]);
                }
                --i;
                continue;
            }
            if (PARAM_CONTRACT_LIST.equals(args[i])) {
                if (++i == args.length) {
                    String desc3 = msg.getString("BatchClient.InvalidContractListFileSpecification.txt");
                    throw new IllegalArgumentException(desc3);
                }
                try {
                    contractList.addAll(DProUtil.parseListFile((String)args[i++], null, (boolean)true));
                    while (i < args.length && args[i].charAt(0) != '-') {
                        contractList.addAll(DProUtil.parseListFile((String)args[i], null, (boolean)true));
                        ++i;
                    }
                    --i;
                    continue;
                }
                catch (IOException ioe) {
                    desc = msg.getString("BatchClient.ErrorReadingContractListFile.fmt.txt");
                    desc = MessageFormat.format(desc, args[i], ioe.getMessage());
                    throw new IllegalArgumentException(desc);
                }
            }
            if (args[i].startsWith("-V") && args[i].indexOf(61) > -1) {
                int equalIndex = args[i].indexOf(61);
                String var = args[i].substring(2, equalIndex);
                String value = args[i].substring(equalIndex + 1);
                this.controller.setGlobalVariableValue(var, value);
                continue;
            }
            if (PARAM_VARFILE.equals(args[i])) {
                if (++i == args.length) {
                    String desc4 = msg.getString("BatchClient.NoVariableFileSpecified.txt");
                    throw new IllegalArgumentException(desc4);
                }
                try {
                    this.controller.loadVariablesFromFile(args[i]);
                    continue;
                }
                catch (IOException ioe) {
                    desc = msg.getString("BatchClient.ErrorReadingVariableFile.fmt.txt");
                    desc = MessageFormat.format(desc, args[i], ioe.getMessage());
                    throw new IllegalArgumentException(desc);
                }
            }
            if (PARAM_DUMPRES.equals(args[i])) {
                this.setDumpResults(true);
                continue;
            }
            if (PARAM_INTERACTIVE.equals(args[i])) {
                this.setInteractive(true);
                continue;
            }
            if (PARAM_PRINT_WORK_UNITS.equals(args[i])) {
                this.setPrintWorkUnits(true);
                continue;
            }
            if (PARAM_USAGE.equals(args[i]) || PARAM_HELP.equals(args[i])) {
                String usage = msg.getString("BatchClient.Usage.txt");
                throw new IllegalArgumentException(usage);
            }
            if ("-loggingLevel".equals(args[i])) {
                loggingLevel = AbstractClient.getCommandLineOptionLoggingLevel((String[])args, (int)(++i));
                continue;
            }
            if ("-parallel".equals(args[i])) {
                int parallel = AbstractClient.getCommandLineOptionParallel((String[])args, (int)(++i));
                this.controller.setMaxParallelContractCount(parallel);
                try {
                    Provider p = ProviderFactory.getProvider((String)"server-local");
                    if (!(p instanceof ProviderImpl)) continue;
                    ((ProviderImpl)p).setMaxParallelContractCount(parallel);
                }
                catch (InvalidProviderNameException p) {}
                continue;
            }
            AbstractClient.handleUnknownCommandLineOption((String)args[i]);
        }
        this.setLoggingLevel(loggingLevel);
        if (contractList.isEmpty() && !this.getInteractive()) {
            String desc = msg.getString("BatchClient.NoContractSpecified.txt");
            throw new IllegalArgumentException(desc);
        }
        for (i = 0; i < contractList.size(); ++i) {
            String orig = (String)contractList.get(i);
            String contract = this.controller.replaceGlobalVariables(orig);
            contractList.set(i, contract);
        }
        return contractList;
    }

    public String promptForInput(InputPromptInfo info) throws IOException {
        String[] choices = info.getChoices();
        String description = info.getDescription();
        String prompt = info.getPrompt();
        boolean allowCancel = info.getAllowCancelInput();
        boolean allowEmptyInput = info.getAllowEmptyInput();
        boolean trimWhitespace = info.getTrimWhitespace();
        Pattern formatPattern = info.getInputFormat();
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        String input = null;
        boolean error = false;
        do {
            Matcher m;
            block17: {
                error = false;
                if (description != null) {
                    System.out.println(description);
                }
                if (choices != null) {
                    String fmt = msg.getString("InputPromptChoice.fmt.txt");
                    if (allowCancel) {
                        String temp = MessageFormat.format(fmt, new Integer(0), msg.getString("Cancel.txt"));
                        System.out.println(temp);
                    }
                    for (int i = 0; i < choices.length; ++i) {
                        String temp = MessageFormat.format(fmt, new Integer(i + 1), choices[i]);
                        System.out.println(temp);
                    }
                }
                System.out.print(prompt);
                System.out.flush();
                input = r.readLine();
                if (input == null) {
                    return null;
                }
                if (choices != null) {
                    try {
                        int val = Integer.parseInt(input.trim()) - 1;
                        if (val >= 0 && val < choices.length) {
                            input = choices[val];
                            break block17;
                        }
                        if (val == -1 && allowCancel) {
                            input = null;
                            break block17;
                        }
                        throw new NumberFormatException();
                    }
                    catch (NumberFormatException nfe) {
                        error = true;
                    }
                } else {
                    if (input != null && trimWhitespace) {
                        input = input.trim();
                    }
                    if (!(input != null && input.length() != 0 || allowEmptyInput)) {
                        if (allowCancel) {
                            input = null;
                        } else {
                            error = true;
                        }
                    }
                }
            }
            if (error || input == null || formatPattern == null || (m = formatPattern.matcher(input)).matches()) continue;
            String errorMsg = info.getInputErrorMessage();
            if (errorMsg == null) {
                errorMsg = msg.getString("InputPrompt.InvalidInput.txt");
            }
            System.out.println(errorMsg);
            error = true;
        } while (error);
        return input;
    }

    public int runInteractively() throws IOException {
        String desc = msg.getString("Interactive.Instructions.txt");
        System.out.println(desc);
        StringBuilder sb = new StringBuilder();
        boolean appendHeaderFooter = false;
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        String line = r.readLine();
        if (!line.startsWith("<?xml ")) {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            sb.append("<contract version=\"1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
            sb.append(" xsi:noNamespaceSchemaLocation=\"http://www.sas.com/xml/schema/dpro/contract-1.6.xsd\">\n");
            sb.append("<main>");
            appendHeaderFooter = true;
        }
        while (!line.equals(".")) {
            sb.append(line).append('\n');
            line = r.readLine();
        }
        if (appendHeaderFooter) {
            sb.append("</main>\n</contract>\n");
        }
        String xml = sb.toString();
        HonorContractParmsImpl parms = new HonorContractParmsImpl();
        parms.setClientDPROVersion(this.getClientDPROVersion());
        parms.setContract(null);
        parms.setContractCode(xml);
        parms.setLocale(null);
        parms.setMessageGranularity(this.controller.getMessageGranularity());
        parms.setOriginalContractSessionID(-1L);
        parms.setTimeout(-1L);
        this.controller.honorContract((HonorContractParms)parms);
        int errorCount = this.emptyMessageQueue(1);
        return errorCount;
    }

    public void setDumpResults(boolean dumpResults) {
        this.dumpResults = dumpResults;
        this.controller.setMessageGranularity(2);
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
        String desc = null;
        desc = interactive ? msg.getString("Interactive.Enabled.txt") : msg.getString("Interactive.Disabled.txt");
        System.out.println(desc);
    }

    public void setPrintWorkUnits(boolean print) {
        this.printWorkUnits = print;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showReport(ShowReportMessage srm, ReportInfo ri) throws IOException, UnsupportedOperationException {
        block9: {
            if (Boolean.getBoolean("displayReport")) {
                if (!"_text".equals(ri.getReportType())) {
                    String desc = "ShowReport.UnsupportedType.fmt.txt";
                    desc = DProUtil.formatString((ResourceBundle)msg, (String)desc, (Object)ri.getReportType());
                    System.out.println(desc);
                    return;
                }
                try {
                    File f = new File(ri.getDirectory(), "index.txt");
                    try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), ri.getReportFileEncoding()));){
                        String line = null;
                        while ((line = r.readLine()) != null) {
                            System.out.println(line);
                        }
                        break block9;
                    }
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            String desc = this.getTestSuiteResultSummary(ri);
            System.out.println(desc);
            desc = "ShowReport.Location.fmt.txt";
            desc = DProUtil.formatString((ResourceBundle)msg, (String)desc, (Object)ri.getDirectory().getAbsolutePath());
            System.out.println(desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTestSuiteResultSummary(ReportInfo ri) {
        File resultsXMLFile = new File(ri.getDirectory(), ".results.xml");
        try {
            TestSuiteResult tsr = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(resultsXMLFile));){
                Document doc = DProUtil.streamToXMLDoc((InputStream)in);
                Element root = doc.getDocumentElement();
                tsr = new TestSuiteResult();
                tsr.read(doc, root);
            }
            String desc = null;
            Object[] params = null;
            if (tsr.getWarningCount() == 0) {
                desc = "ShowReport.TestSuiteCompleted.fmt.txt";
                params = new String[]{Integer.toString(tsr.getTestResultCount()), Integer.toString(tsr.getPassCount()), Integer.toString(tsr.getFailureCount()), Integer.toString(tsr.getErrorCount())};
            } else {
                desc = "ShowReport.TestSuiteCompleted2.fmt.txt";
                params = new String[]{Integer.toString(tsr.getTestResultCount()), Integer.toString(tsr.getPassCount()), Integer.toString(tsr.getFailureCount()), Integer.toString(tsr.getWarningCount()), Integer.toString(tsr.getErrorCount())};
            }
            desc = DProUtil.formatString((ResourceBundle)msg, (String)desc, (Object[])params);
            return desc;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            String text = e.getMessage();
            if (text == null) {
                text = e.toString();
            }
            String desc = "ShowReport.ErrorAnalyzingReport.fmt.txt";
            desc = DProUtil.formatString((ResourceBundle)msg, (String)desc, (Object)text);
            return desc;
        }
    }

    public static void main(String[] args) {
        BatchClient client = new BatchClient(Logger.getLogger("com.sas.dpro.bclient.BatchClient"));
        int rc = 0;
        try {
            List contractList = null;
            try {
                contractList = client.parseCommandLine(args);
            }
            catch (IllegalArgumentException iae) {
                System.err.println(iae.getMessage());
                System.exit(1);
            }
            if (!client.getInteractive()) {
                int errorCount = client.honorContracts(contractList);
                if (errorCount > 0) {
                    rc = 2;
                }
            } else {
                rc = client.runInteractively();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rc = 3;
        }
        System.exit(rc);
    }
}

