/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.visuals.ConsoleTree;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.tree.TreePath;

public class UpLevelAction
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    protected static WAdminResource bundle = new WAdminResource(UpLevelAction.class);
    protected ConsoleTree m_tree = null;

    public UpLevelAction(ConsoleTree consoleTree) {
        this.m_tree = consoleTree;
        MnemonicModel.setActionTextAndMnemonic(this, bundle.getString("UpLevelAction.Name.txt"), bundle.getString("UpLevelAction.ShortDescription.txt"), Resources.getImageIcon((String)bundle.getString("UpLevelAction.Icon.image"), (int)16));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ConsoleViewInterface currentView = ConsoleViewManager.getCurrentView();
        int viewType = currentView.getType();
        this.m_tree = (ConsoleTree)currentView.getComponent();
        TreePath selPath = this.m_tree.getSelectionPath();
        NodeInterface currentNode = null;
        if (selPath != null) {
            currentNode = (NodeInterface)selPath.getLastPathComponent();
        }
        NodeInterface parentNode = null;
        if (currentNode != null) {
            parentNode = (NodeInterface)currentNode.getParent();
        }
        if (parentNode == null) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            int childIndex = parentNode.getIndex(parentNode);
            Vector<IntObjPair> childInfo = new Vector<IntObjPair>();
            IntObjPair ioPair = new IntObjPair(childIndex, parentNode);
            childInfo.add(ioPair);
            if (viewType == 1) {
                ConsoleFolderView folderView = (ConsoleFolderView)currentView;
                folderView.fireFolderViewChange(16, parentNode, childInfo);
            } else if (viewType == 0) {
                PluginNavigationInterface plugin = parentNode.getPlugin();
                plugin.firePluginChange(4, parentNode, childInfo);
            }
        }
    }
}

