/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.utils.ServerUtil;
import com.sas.console.utils.WindowUtil;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.MainConsole;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalObjectPropertyDialogInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.visuals.Resources;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.VersionUtil;
import com.sas.workspace.plugins.PluginViewInterface;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;

public class PropertyAction
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    protected NodeInterface m_node;
    protected TableModelInterface m_tableModel;
    ElementInterface[] m_selectedObjects;
    ConsoleViewInterface m_view;
    MetadataInterface m_smartObject;
    protected static WAdminResource bundle = new WAdminResource(PropertyAction.class);

    public PropertyAction(NodeInterface node, ConsoleViewInterface view) {
        super("properties");
        this.m_node = node;
        this.m_view = view;
        this._initialize();
    }

    public PropertyAction(TableModelInterface tableModel, ListSelectionModel selectionModel) {
        super("properties");
        this.m_node = tableModel.getNode();
        this.m_tableModel = tableModel;
        this.m_selectedObjects = this.m_tableModel.getSelectedObjects(selectionModel);
        if (this.m_selectedObjects == null || this.m_selectedObjects.length > 1) {
            this.setEnabled(false);
        }
        this._initialize();
    }

    protected void _initialize() {
        this.putValue("Default", "PropertyAction.");
        this.putValue("LongDescription", this._getValueFromBundle("Long"));
        MnemonicModel.setActionTextAndMnemonic(this, this._getValueFromBundle("Name"), this._getValueFromBundle("Short"), Resources.getImageIcon((String)bundle.getString("PropertyAction.Icon.image"), (int)16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_tableModel != null) {
            this._displayPropertiesFromTable();
        } else {
            this._displayPropertiesFromTree();
        }
    }

    protected String _getValueFromBundle(String strValueName) {
        return bundle.getRawString(this.getValue("Default") + strValueName + ".txt");
    }

    protected String _getHelpProduct() {
        if (ConsoleViewManager.getCurrentViewType() == 1 || ConsoleViewManager.getCurrentViewType() == 2) {
            return "";
        }
        String pluginName = this.m_node.getPlugin().getClass().getName();
        if (pluginName.indexOf(".") != -1) {
            int index = pluginName.lastIndexOf(".");
            pluginName = pluginName.substring(0, index);
            index = pluginName.lastIndexOf(".");
            pluginName = pluginName.substring(index + 1, pluginName.length());
        }
        pluginName = pluginName.toLowerCase();
        return pluginName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _displayPropertiesFromTree() {
        try {
            Root metaObject;
            MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            int currentViewType = ConsoleViewManager.getCurrentViewType();
            ConsoleInterface console = ConsoleViewManager.getConsole();
            String strTitle = bundle.formatString("PropertyAction.Title.fmt.txt", (Object)this.m_node.toString());
            if (currentViewType == 1 && console.getDefaultRepository() == null) {
                MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                MessageUtil.displayMessage((String)bundle.getString("PropertyAction.FolderView.Message.NoProperties.txt"), (String)bundle.formatString("PropertyAction.Title.fmt.txt", (Object)"SAS Folders"), (int)1);
                return;
            }
            List tabList = new ArrayList(0);
            WAPropertyDialog dialog = new WAPropertyDialog((Frame)MainConsole.getWorkspace(), strTitle, true);
            if ((currentViewType == 1 || currentViewType == 2) && this.m_node instanceof BIAbstractNode) {
                BIAbstractNode node = (BIAbstractNode)this.m_node;
                LogicalObjectInterface loi = node.getLogicalObjectInterface();
                Factory loiFactory = Factory.getInstance();
                if (loi != null && loiFactory.isSmartObjectBasedDialog(loi)) {
                    ObjectFactoryInterface ofi = null;
                    List smartList = new ArrayList();
                    TypeInterface ti = loi.getTypeInterface();
                    if (ti != null) {
                        ofi = ti.getObjectFactory();
                    }
                    try {
                        ServerInterface si = ServerUtil.getServerInterface();
                        ChildServerInterface transaction = si.newChild(true);
                        String smartObjectKey = loi.getID() + "/" + loi.getTypeInterface().getMetadataType();
                        this.m_smartObject = transaction.fetch(smartObjectKey, true);
                        if (ofi != null && ofi instanceof LogicalObjectPropertyDialogInterface) {
                            dialog = ((LogicalObjectPropertyDialogInterface)ofi).getPropertyDialog((Frame)MainConsole.getWorkspace(), strTitle, true, loi);
                        }
                        smartList = loiFactory.getPropertyTabs(loi, transaction, this.m_smartObject, (Root)this.m_smartObject.getRepositoryEntity(), null);
                        dialog.setMetadataServiceObject(this.m_smartObject);
                    }
                    catch (RemoteException re) {
                        Workspace.getDefaultLogger().error((Object)"Failed to get properties for smart object:", (Throwable)re);
                    }
                    catch (ServiceException se) {
                        Workspace.getDefaultLogger().error((Object)"Failed to get properties for smart object:", (Throwable)se);
                    }
                    catch (MdException me) {
                        Workspace.getDefaultLogger().error((Object)"Failed to get properties for smart object:", (Throwable)me);
                    }
                    tabList.addAll(smartList);
                }
            }
            if (tabList.isEmpty()) {
                tabList = this.m_node.getPropertyTabs();
            }
            if (!this.showProperties(metaObject = this.m_node.getMetadataObject())) {
                return;
            }
            if (tabList == null || tabList.size() == 0) {
                Root copyRoot = null;
                if (metaObject != null) {
                    copyRoot = Server.createNewEditableObject((Root)metaObject);
                }
                String strMessage = bundle.getString("PropertyAction.Message.NoProperties.txt");
                if (copyRoot != null && currentViewType != 1) {
                    WAGeneralPropertyTab generalTab = new WAGeneralPropertyTab((CMetadata)copyRoot);
                    JOMANotesTab notesTab = new JOMANotesTab(copyRoot);
                    WAExtAttrPropertyTab extAttrTab = new WAExtAttrPropertyTab((CMetadata)copyRoot);
                    generalTab.setName(bundle.getString("PropertyAction.GeneralTab.txt"));
                    notesTab.setName(bundle.getString("PropertyAction.NotesTab.txt"));
                    extAttrTab.setName(bundle.getString("PropertyAction.ExtAttrTab.txt"));
                    if (this.m_smartObject == null) {
                        dialog.setMetadataObject((CMetadata)copyRoot);
                    }
                    dialog.addTab(generalTab.getName(), (WAPropertyTab)generalTab);
                    dialog.addTab(notesTab.getName(), (WAPropertyTab)notesTab);
                    dialog.addTab(extAttrTab.getName(), (WAPropertyTab)extAttrTab);
                    List extraViewList = this.getExtendedPropertyTabs(copyRoot);
                    for (int index = 0; index < extraViewList.size(); ++index) {
                        WAPropertyTab tab = (WAPropertyTab)extraViewList.get(index);
                        dialog.addTab(tab.getName(), tab);
                    }
                    dialog.pack();
                    WindowUtil.center((Window)dialog);
                    MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    dialog.show();
                    if (copyRoot.getObjectStore() != null) {
                        copyRoot.getObjectStore().dispose();
                    }
                } else {
                    MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)1);
                }
            } else {
                dialog.setHelpProduct(this._getHelpProduct());
                if (this.m_smartObject == null) {
                    dialog.setMetadataObject((CMetadata)metaObject);
                }
                List extraViewList = this.getExtendedPropertyTabs(metaObject);
                tabList.addAll(extraViewList);
                for (int index = 0; index < tabList.size(); ++index) {
                    WAPropertyTab tab = (WAPropertyTab)tabList.get(index);
                    dialog.addTab(tab.getName(), tab);
                }
                dialog.pack();
                WindowUtil.center((Window)dialog);
                MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                dialog.setVisible(true);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (ServiceException e) {
            Workspace.getDefaultLogger().error((Object)e);
        }
        catch (LogicalTypeException e) {
            e.printStackTrace();
        }
        finally {
            MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _displayPropertiesFromTable() {
        try {
            MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            List viewList = null;
            if (this.m_selectedObjects != null && this.m_selectedObjects.length >= 1) {
                viewList = this.m_selectedObjects[0].getPropertyTabs();
            }
            String strTitle = bundle.formatString("PropertyAction.Title.fmt.txt", (Object)this.m_selectedObjects[0].getName());
            Root metaObject = this.m_selectedObjects[0].getMetadataObject();
            if (!this.showProperties(metaObject)) {
                return;
            }
            if (viewList == null || viewList.size() == 0) {
                Root copyRoot = null;
                if (metaObject != null) {
                    copyRoot = Server.createNewEditableObject((Root)metaObject);
                }
                String strMessage = bundle.getString("PropertyAction.Message.NoProperties.txt");
                if (copyRoot != null && ConsoleViewManager.getCurrentViewType() != 1) {
                    WAGeneralPropertyTab generalTab = new WAGeneralPropertyTab((CMetadata)copyRoot);
                    JOMANotesTab notesTab = new JOMANotesTab(copyRoot);
                    WAExtAttrPropertyTab extAttrTab = new WAExtAttrPropertyTab((CMetadata)copyRoot);
                    generalTab.setName(bundle.getString("PropertyAction.GeneralTab.txt"));
                    notesTab.setName(bundle.getString("PropertyAction.NotesTab.txt"));
                    extAttrTab.setName(bundle.getString("PropertyAction.ExtAttrTab.txt"));
                    WAPropertyDialog dialog = new WAPropertyDialog((Frame)MainConsole.getWorkspace(), strTitle, true);
                    if (this.m_smartObject == null) {
                        dialog.setMetadataObject((CMetadata)copyRoot);
                    }
                    dialog.addTab(generalTab.getName(), (WAPropertyTab)generalTab);
                    dialog.addTab(notesTab.getName(), (WAPropertyTab)notesTab);
                    dialog.addTab(extAttrTab.getName(), (WAPropertyTab)extAttrTab);
                    List extraViewList = this.getExtendedPropertyTabs(copyRoot);
                    for (int index = 0; index < extraViewList.size(); ++index) {
                        WAPropertyTab tab = (WAPropertyTab)extraViewList.get(index);
                        dialog.addTab(tab.getName(), tab);
                    }
                    dialog.pack();
                    WindowUtil.center((Window)dialog);
                    MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    dialog.show();
                    if (copyRoot.getObjectStore() != null) {
                        copyRoot.getObjectStore().dispose();
                    }
                } else {
                    MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    MessageUtil.displayMessage((String)strMessage, (String)strTitle, (int)1);
                }
            } else {
                WAPropertyDialog dialog = new WAPropertyDialog((Frame)MainConsole.getWorkspace(), strTitle, true);
                dialog.setHelpProduct(this._getHelpProduct());
                if (this.m_smartObject == null) {
                    dialog.setMetadataObject((CMetadata)metaObject);
                }
                List extraViewList = this.getExtendedPropertyTabs(metaObject);
                viewList.addAll(extraViewList);
                for (int index = 0; index < viewList.size(); ++index) {
                    WAPropertyTab tab = (WAPropertyTab)viewList.get(index);
                    dialog.addTab(tab.getName(), tab);
                }
                dialog.pack();
                WindowUtil.center((Window)dialog);
                MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                dialog.setVisible(true);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            MainConsole.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected List getExtendedPropertyTabs(Root metaObject) {
        ConsoleInterface console = null;
        if (ConsoleViewManager.getCurrentViewType() == 0) {
            console = this.m_node.getPlugin().getConsole();
        } else if (this.m_view.getType() == 1) {
            console = this.m_view.getConsole();
        } else if (this.m_view.getType() == 2) {
            console = this.m_view.getConsole();
        }
        List extraViewList = this.m_tableModel != null ? console.getExtendedPropertyTabs(this.m_selectedObjects[0]) : console.getExtendedPropertyTabs(this.m_node);
        MainConsole mainConsole = (MainConsole)console;
        List extensionPlugins = mainConsole.getExtensionPlugins();
        for (int i = 0; i < extensionPlugins.size(); ++i) {
            Object extPlugin = extensionPlugins.get(i);
            if (!(extPlugin instanceof PluginViewInterface)) continue;
            PluginViewInterface viewPlugin = (PluginViewInterface)extPlugin;
            ArrayList metaPropTabs = viewPlugin.getPropertyTabs((CMetadata)metaObject);
            extraViewList.addAll(metaPropTabs);
        }
        return extraViewList;
    }

    private boolean showProperties(Root root) {
        boolean bShowProperties = true;
        if (root != null && (root instanceof ServerComponent || root instanceof Connection || root instanceof SASLibrary || root instanceof DatabaseSchema)) {
            try {
                if (!PrototypeUtil.isPrototypeCompatible((Root)root, (Component)Workspace.getWorkspace())) {
                    VersionUtil.displayPropertiesMessage((Window)Workspace.getWorkspace(), (String)bundle.getString("MainConsole.Title.txt"));
                    bShowProperties = false;
                }
            }
            catch (MdException exc) {
                MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
            }
        }
        return bShowProperties;
    }
}

