/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.utils.DesktopUtil;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.visuals.MainConsole;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;

public class PluginHelpAction
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    protected MainConsole m_console;
    protected PluginNavigationInterface m_plugin;
    protected static Point m_consolePoint;
    protected static WAdminResource bundle;

    public PluginHelpAction(MainConsole console, PluginNavigationInterface plugin) {
        this.m_console = console;
        this.m_plugin = plugin;
        m_consolePoint = console.getLocationOnScreen();
        MnemonicModel.setActionTextAndMnemonic(this, bundle.formatString("PluginHelpAction.Name.txt", (Object)plugin.getName()), null, Resources.getImageIcon((String)bundle.getString("Common.BlankIcon.image"), (int)16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String pluginName = null;
        try {
            Method getHelpProduct = this.m_plugin.getClass().getMethod("getHelpProduct", null);
            Object result = getHelpProduct.invoke((Object)this.m_plugin, (Object[])null);
            pluginName = result.toString();
        }
        catch (Exception getHelpProduct) {
            // empty catch block
        }
        if (pluginName == null) {
            pluginName = this.m_plugin.getClass().getName();
            int index = pluginName.lastIndexOf(".");
            pluginName = pluginName.substring(0, index);
            index = pluginName.lastIndexOf(".");
            pluginName = pluginName.substring(index + 1, pluginName.length());
            pluginName = pluginName.toLowerCase();
        }
        DesktopUtil.openHelpDoc(pluginName, null, "9.4", bundle.formatString("PluginHelpAction.ErrorMsg.txt", (Object)this.m_plugin.getName()));
    }

    static {
        bundle = new WAdminResource(PluginHelpAction.class);
    }
}

