/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.folderview.visuals.ConsoleFolderTree;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.visuals.ConsoleAction;
import com.sas.console.visuals.ConsolePluginTree;
import com.sas.console.visuals.ConsoleTable;
import com.sas.console.visuals.ConsoleTree;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.MainConsole;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.tree.TreePath;

public class OpenAction
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    protected ConsoleTree m_tree;
    protected TreePath m_currentPath;
    protected MainConsole m_console;
    protected boolean m_contextKnown;
    protected static WAdminResource bundle = new WAdminResource(OpenAction.class);

    public OpenAction(MainConsole console) {
        this._initialize();
        this.m_console = console;
        this.m_contextKnown = false;
    }

    public OpenAction(ConsoleTree tree, TreePath path) {
        this._initialize();
        this.m_tree = tree;
        this.m_currentPath = path;
        this.m_contextKnown = true;
        this.m_console = (MainConsole)Workspace.getWorkspace();
    }

    protected void _initialize() {
        MnemonicModel.setActionTextAndMnemonic(this, bundle.getString("Common.OpenAction.Name.txt"), bundle.getString("Common.OpenAction.ShortDescription.txt"), Resources.getImageIcon((String)bundle.getString("Common.OpenAction.Icon.image"), (int)16));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.m_contextKnown) {
            if (this.m_currentPath != null) {
                this.m_tree.expandPath(this.m_currentPath);
            }
        } else {
            ConsoleViewInterface currentView = ConsoleViewManager.getCurrentView();
            this.m_tree = (ConsoleTree)currentView.getComponent();
            TreePath selPath = this.m_tree.getSelectionPath();
            NodeInterface node = (NodeInterface)selPath.getLastPathComponent();
            int viewLastSelected = this.m_console.getViewLastSelected();
            boolean treeLastSelected = this.m_console.getTreeLastSelected();
            if (viewLastSelected > -1 && treeLastSelected) {
                if (selPath != null) {
                    this.m_tree.expandPath(selPath);
                }
            } else if (node.getListViewData() != null) {
                ConsoleAction cAction;
                ConsoleTable table = this.m_console.getTable();
                if (!table.getSelectionModel().isSelectionEmpty() && (cAction = this._getActionInList(((TableModelInterface)table.getModel()).getToolBarActions(table.getSelectionModel()))) != null) {
                    cAction.actionPerformed(new ActionEvent(table.m_popMenu, 0, ""));
                }
            } else {
                Component centerOnComponent = null;
                CustomViewInterface customView = this.m_console.getCustomView();
                if (this.m_tree instanceof ConsoleFolderTree) {
                    centerOnComponent = customView.getComponent();
                } else if (this.m_tree instanceof ConsolePluginTree) {
                    centerOnComponent = ((ConsolePluginTree)this.m_tree).m_popMenu;
                }
                ConsoleAction cAction = this._getActionInList(customView.getToolBarActions());
                if (cAction != null) {
                    cAction.actionPerformed(new ActionEvent(centerOnComponent, 0, ""));
                }
            }
        }
        this.m_console.updateToolBar(this.m_console.m_currentNode.getToolBarActions());
    }

    protected ConsoleAction _getActionInList(List actionsList) {
        ConsoleAction cAction = null;
        if (actionsList != null) {
            for (int i = 0; i < actionsList.size(); ++i) {
                Action action = (Action)actionsList.get(i);
                String actionName = (String)action.getValue("Name");
                if (!actionName.equalsIgnoreCase(Util.getLabelWithoutMnemonic((String)bundle.getString("Common.OpenAction.Name.txt")))) continue;
                cAction = new ConsoleAction(action);
                break;
            }
        }
        return cAction;
    }
}

