/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.visuals.ConsoleTable;
import com.sas.console.visuals.ConsoleTree;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.MainConsole;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellRenderer;

public class DetailsAction
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    protected MainConsole m_console;
    protected int m_rowHeight;
    protected ConsoleTable m_table;
    protected static WAdminResource bundle = new WAdminResource(DetailsAction.class);

    public DetailsAction(MainConsole console) {
        this.m_console = console;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ConsoleTree treeView = this.m_console.getTree();
        this.m_table = this.m_console.getTable();
        ConsoleViewInterface view = ConsoleViewManager.getCurrentView();
        if (view.getType() == 1) {
            treeView = (ConsoleTree)view.getComponent();
        }
        this.m_rowHeight = treeView.getRowHeight();
        if (this.m_rowHeight > 0) {
            this.m_table.setRowHeight(this.m_rowHeight);
        }
        for (int i = 0; i < this.m_table.getColumnCount(); ++i) {
            this.m_table.getColumnModel().getColumn(i).setHeaderRenderer(new ColumnHeaderCellRenderer());
        }
        int columnCount = this.m_table.getModel().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.m_table.getColumnModel().getColumn(i).setCellRenderer(new JLabelCellRenderer());
        }
        this.m_table.setShowGrid(false);
        this.m_table.getSelectionModel().addListSelectionListener(this.m_table);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this._setMouseListener();
    }

    protected void _setMouseListener() {
        MouseInputAdapter mouseListener = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DetailsAction.this.m_console.setViewLastSelected(ConsoleViewManager.getCurrentViewType());
                DetailsAction.this.m_console.checkIServerStatus();
                int[] selectedRows = DetailsAction.this.m_table.getSelectedRows();
                if (DetailsAction.this.m_table.rowAtPoint(e.getPoint()) != -1) {
                    if (selectedRows.length <= 1) {
                        int selectedRow = DetailsAction.this.m_table.rowAtPoint(e.getPoint());
                        DetailsAction.this.m_table.setRowSelectionInterval(selectedRow, selectedRow);
                    } else {
                        boolean bClickedOnSelectedRow = false;
                        for (int i = 0; i < selectedRows.length; ++i) {
                            if (selectedRows[i] != DetailsAction.this.m_table.rowAtPoint(e.getPoint())) continue;
                            bClickedOnSelectedRow = true;
                        }
                        if (!bClickedOnSelectedRow) {
                            int selectedRow = DetailsAction.this.m_table.rowAtPoint(e.getPoint());
                            DetailsAction.this.m_table.setRowSelectionInterval(selectedRow, selectedRow);
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 1 && (e.getModifiers() & 4) != 0) {
                    DetailsAction.this.m_table.showTablePopupMenu(e);
                }
            }
        };
        this.m_table.addMouseListener(mouseListener);
    }

    protected class ColumnHeaderCellRenderer
    implements TableCellRenderer {
        protected ColumnHeaderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel header = new JLabel((String)value, 0);
            header.setOpaque(true);
            header.setBorder(BorderFactory.createBevelBorder(0));
            int height = DetailsAction.this.m_rowHeight;
            header.setPreferredSize(new Dimension(10, height));
            return header;
        }
    }

    protected class JLabelCellRenderer
    implements TableCellRenderer {
        protected JLabelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)value;
            label.setOpaque(true);
            if (isSelected && column == 0 && table.hasFocus()) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else if (isSelected && column == 0 && !table.hasFocus()) {
                Color background = UIManager.getColor("TextField.inactiveForeground");
                Color foreground = UIManager.getColor("TextField.inactiveBackground");
                if (foreground == null) {
                    foreground = UIManager.getColor("TextField.background");
                }
                label.setBackground(background);
                label.setForeground(foreground);
            } else {
                label.setBackground(UIManager.getColor("List.background"));
                label.setForeground(SystemColor.textText);
            }
            return label;
        }
    }
}

