/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.ConsoleInterface;
import com.sas.console.visuals.ConsoleViewInterface;
import java.util.Collection;
import java.util.HashMap;

public class ConsoleViewManager {
    protected static ConsoleInterface m_console;
    protected static HashMap m_viewMap;
    protected static ConsoleViewInterface m_currentView;

    public ConsoleViewManager(ConsoleInterface console) {
        m_console = console;
        m_viewMap = new HashMap();
    }

    public void initializeViews() {
        Collection viewsList = m_viewMap.values();
        for (ConsoleViewInterface view : viewsList) {
            view.initialize();
        }
    }

    public void addView(ConsoleViewInterface view) {
        m_viewMap.put(new Integer(view.getType()), view);
    }

    public static ConsoleViewInterface getView(int viewType) {
        return (ConsoleViewInterface)m_viewMap.get(new Integer(viewType));
    }

    public static ConsoleViewInterface getCurrentView() {
        return m_currentView;
    }

    public static void setCurrentView(ConsoleViewInterface currentView) {
        m_currentView = currentView;
    }

    public static ConsoleInterface getConsole() {
        return m_console;
    }

    public static int getCurrentViewType() {
        return m_currentView.getType();
    }
}

