/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.ConsoleInterface;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.console.utils.FontUtil;
import com.sas.console.visuals.ConsolePluginTree;
import com.sas.console.visuals.ConsoleTable;
import com.sas.console.visuals.ConsoleTreeExpansionListener;
import com.sas.console.visuals.ConsoleTreeSelectionListener;
import com.sas.console.visuals.ConsoleViewInterface;
import com.sas.console.visuals.MainConsole;
import com.sas.workspace.WAdminResource;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeSelectionModel;

public class ConsolePluginView
implements ConsoleViewInterface {
    protected String m_name;
    protected String m_displayName;
    protected ConsolePluginTree m_pluginTree;
    protected JComponent m_treePanel;
    protected ConsoleInterface m_console;
    protected int m_index;
    protected TreeSelectionModel m_selectionModel;
    protected TreeSelectionListener m_treeSelectionListener;
    protected static WAdminResource bundle = new WAdminResource(ConsolePluginView.class);

    public ConsolePluginView(ConsoleInterface console) {
        this.m_console = console;
        this.m_index = 0;
        this.initialize();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String newName) {
        this.m_name = newName;
    }

    @Override
    public JComponent getComponent() {
        return this.m_pluginTree;
    }

    @Override
    public void setComponent(JComponent component) {
    }

    @Override
    public int getIndex() {
        return this.m_index;
    }

    @Override
    public void setIndex(int index) {
        this.m_index = index;
    }

    @Override
    public ConsoleInterface getConsole() {
        return this.m_console;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void initialize() {
        this.setName(bundle.getString("Common.PluginView.txt"));
        this.setDisplayName(bundle.getString("Common.Plugins.txt"));
        MainConsole mainConsole = (MainConsole)this.m_console;
        this.m_pluginTree = new ConsolePluginTree(mainConsole);
        FontUtil.setFontForHC(this.m_pluginTree);
        if (FontUtil.isHighContrast()) {
            this.m_pluginTree.setRowHeight(28);
        }
        this.m_selectionModel = this.m_pluginTree.getSelectionModel();
        this.m_treeSelectionListener = new ConsoleTreeSelectionListener(this.m_console, this.m_pluginTree);
        this.m_pluginTree.addTreeSelectionListener(this.m_treeSelectionListener);
        ConsoleTreeExpansionListener expansionListener = new ConsoleTreeExpansionListener();
        this.m_pluginTree.addTreeExpansionListener(expansionListener);
        this.m_pluginTree.addTreeWillExpandListener(expansionListener);
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    @Override
    public void cleanupChangeListeners(NodeInterface node) {
        MainConsole mainConsole = (MainConsole)this.m_console;
        ConsoleTable table = mainConsole.getTable();
        CustomViewInterface customView = mainConsole.getCustomView();
        if (node != null) {
            if (table != null) {
                node.getPlugin().removePluginChangeListener((TableModelInterface)table.getModel());
            }
            if (customView != null && customView.getNode() != null && customView.getNode().getPlugin() != null) {
                customView.getNode().getPlugin().removePluginChangeListener(mainConsole.getCustomView());
            }
            if (node.getParent() != null) {
                ((NodeInterface)node.getParent()).getPlugin().removePluginChangeListener((ConsolePluginTree.ConsoleTreeSelectionModel)this.m_selectionModel);
            }
        }
    }

    @Override
    public CustomViewInterface getCustomView() {
        return null;
    }
}

