/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.ConsoleInterface;
import com.sas.console.models.HelpKeyListener;
import com.sas.console.models.RefreshKeyListener;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeEvent;
import com.sas.console.plugins.PluginChangeListener;
import com.sas.console.plugins.Root.RootNode;
import com.sas.console.utils.FontUtil;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.visuals.AboutAction;
import com.sas.console.visuals.AboutSMCAction;
import com.sas.console.visuals.ConsoleAction;
import com.sas.console.visuals.ConsoleDNDTree;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.CopyAction;
import com.sas.console.visuals.DeleteAction;
import com.sas.console.visuals.MainConsole;
import com.sas.console.visuals.OpenAction;
import com.sas.console.visuals.PasteAction;
import com.sas.console.visuals.PropertyAction;
import com.sas.console.visuals.RefreshAction;
import com.sas.console.visuals.SubmenuAction;
import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.metadata.remote.MdFactory;
import com.sas.visuals.Resources;
import com.sas.workspace.IdentityUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ConsolePluginTree
extends ConsoleDNDTree {
    private static final long serialVersionUID = 9200000001L;
    protected ConsoleTreeSelectionModel m_selectionModel;
    protected MainConsole m_console;
    protected static WAdminResource bundle = new WAdminResource(ConsolePluginTree.class);

    public ConsolePluginTree(MainConsole console) {
        this.m_console = console;
        this._initialize();
        this.addKeyListener(new HelpKeyListener(console));
        this.addKeyListener(new ConsoleTreeKeyListener(console));
        this.addKeyListener(new RefreshKeyListener(console));
        this.addFocusListener(new PluginTreeFocusListener());
    }

    public ConsoleInterface getConsole() {
        return this.m_console;
    }

    protected void _initialize() {
        if (this.m_popMenu == null) {
            this.m_popMenu = new ToolTipStrippingJPopupMenu();
        }
        this.setRootVisible(true);
        this.setCellRenderer(new ConsoleTreeCellRenderer(this));
        int rowheight = 18;
        if (FontUtil.isHighContrast()) {
            this.rowHeight = 32;
        }
        this.setRowHeight(rowheight);
        MouseInputAdapter mouseListener = new MouseInputAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    int selectedRow = ConsolePluginTree.this.getRowForLocation(e.getX(), e.getY());
                    TreePath selectedPath = ConsolePluginTree.this.getPathForLocation(e.getX(), e.getY());
                    if (selectedRow != -1) {
                        ConsolePluginTree.this.setSelectionRow(selectedRow);
                        ConsolePluginTree.this._buildPopupMenu(selectedPath);
                        ConsolePluginTree.this.m_popMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.m_selectionModel = new ConsoleTreeSelectionModel();
        this.setSelectionModel(this.m_selectionModel);
        this.setBackground(UIManager.getColor("List.background"));
    }

    protected void _buildPopupMenu(TreePath path) {
        this.m_popMenu = new ToolTipStrippingJPopupMenu();
        Object node = path.getLastPathComponent();
        if (node != null && node instanceof NodeInterface) {
            ConsoleAction consoleRefreshAction;
            RefreshAction refreshAction;
            NodeInterface currentNode = (NodeInterface)node;
            boolean needSeparator = false;
            if (currentNode.getPlugin().needsConnection() && !currentNode.getPlugin().getConsole().isConnected()) {
                if (currentNode == currentNode.getPlugin().getRootNode()) {
                    ConsoleAction consoleRefreshAction2 = new ConsoleAction(new RefreshAction(currentNode, ConsoleViewManager.getCurrentView()));
                    this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consoleRefreshAction2));
                    ConsoleAction consoleAboutAction = new ConsoleAction(new AboutAction(this.m_console, currentNode.getPlugin()));
                    this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consoleAboutAction));
                }
                return;
            }
            Vector<Action> actionList = new Vector<Action>(0);
            List nodeActions = currentNode.getContextMenuActions();
            if (nodeActions != null) {
                actionList.addAll(nodeActions);
            }
            Action[] extendedActions = this.m_console.getExtendedContextMenuActions(currentNode);
            for (int index = 0; extendedActions != null && index < extendedActions.length; ++index) {
                actionList.add(extendedActions[index]);
            }
            if (currentNode == currentNode.getPlugin().getRootNode()) {
                refreshAction = new RefreshAction(currentNode, ConsoleViewManager.getCurrentView());
                consoleRefreshAction = new ConsoleAction(refreshAction);
                this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consoleRefreshAction));
            } else {
                if (!currentNode.isLeaf()) {
                    OpenAction openAction = new OpenAction(this, path);
                    ConsoleAction consoleOpenAction = new ConsoleAction(openAction);
                    if (this.isExpanded(path)) {
                        consoleOpenAction.setEnabled(false);
                    }
                    this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consoleOpenAction));
                }
                refreshAction = new RefreshAction(currentNode, ConsoleViewManager.getCurrentView());
                consoleRefreshAction = new ConsoleAction(refreshAction);
                this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consoleRefreshAction));
            }
            needSeparator = true;
            ImageIcon blankIcon = Resources.getImageIcon((String)bundle.getString("Common.BlankIcon.image"), (int)16);
            Object[] actions = actionList.toArray();
            for (int i = 0; i < actions.length; ++i) {
                Action actionObject = (Action)actions[i];
                if (actionObject instanceof SubmenuAction) {
                    SubmenuAction submenuAction = (SubmenuAction)actionObject;
                    JMenu submenu = SubmenuAction.generateSubmenu(submenuAction);
                    if (needSeparator) {
                        this.m_popMenu.addSeparator();
                        needSeparator = false;
                    }
                    this.m_popMenu.add(submenu);
                    continue;
                }
                if (actionObject == null) {
                    this.m_popMenu.addSeparator();
                    needSeparator = false;
                    continue;
                }
                if (actionObject.getValue("SmallIcon") == null) {
                    actionObject.putValue("SmallIcon", blankIcon);
                }
                Action newAction = actionObject;
                ConsoleAction newConsoleAction = new ConsoleAction(newAction);
                this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(newConsoleAction));
            }
            if (currentNode == currentNode.getPlugin().getRootNode()) {
                AbstractAction aboutAction = currentNode instanceof RootNode ? new AboutSMCAction((JFrame)((Object)this.m_console)) : new AboutAction(this.m_console, currentNode.getPlugin());
                ConsoleAction consoleAboutAction = new ConsoleAction(aboutAction);
                if (needSeparator) {
                    needSeparator = false;
                    this.m_popMenu.addSeparator();
                }
                this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consoleAboutAction));
            } else {
                boolean hasProperties = this.displaysProperties(currentNode);
                if (hasProperties) {
                    PropertyAction propertiesAction = new PropertyAction(currentNode, ConsoleViewManager.getCurrentView());
                    ConsoleAction consolePropertiesAction = new ConsoleAction(propertiesAction);
                    if (needSeparator) {
                        needSeparator = false;
                        this.m_popMenu.addSeparator();
                    }
                    if (currentNode != null && currentNode.getPlugin() != null && currentNode.getPlugin().needsConnection() && ((MainConsole)this.getConsole()).getServerStatus() == 3 && !IdentityUtil.isAdministrator((MdFactory)Workspace.getMdFactory())) {
                        consolePropertiesAction.setEnabled(false);
                    }
                    this.m_popMenu.add(MnemonicModel.getMenuItemWithMnemonic(consolePropertiesAction));
                }
            }
        }
    }

    protected boolean displaysProperties(NodeInterface node) {
        boolean ret = true;
        try {
            Method callback = node.getClass().getMethod("displaysSASMCProperties", null);
            Boolean result = (Boolean)callback.invoke((Object)node, (Object[])null);
            ret = result;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    protected class ConsoleTreeKeyListener
    extends KeyAdapter {
        public ConsoleTreeKeyListener(ConsoleInterface console) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 127: {
                    DeleteAction deleteAction = new DeleteAction(ConsolePluginTree.this.m_console);
                    deleteAction.actionPerformed(null);
                    break;
                }
                case 121: {
                    if ((e.getModifiersEx() & 0x40) == 0) break;
                    e.consume();
                    Rectangle rect = ConsolePluginTree.this.getPathBounds(ConsolePluginTree.this.getLeadSelectionPath());
                    Point pt = rect.getLocation();
                    MouseEvent me = new MouseEvent((Component)e.getSource(), 501, 0L, 0, pt.x + rect.width / 2, pt.y + rect.height / 2, 1, true);
                    int selectedRow = ConsolePluginTree.this.getRowForLocation(me.getX(), me.getY());
                    TreePath selectedPath = ConsolePluginTree.this.getPathForLocation(me.getX(), me.getY());
                    if (selectedRow == -1) break;
                    ConsolePluginTree.this.setSelectionRow(selectedRow);
                    ConsolePluginTree.this._buildPopupMenu(selectedPath);
                    ConsolePluginTree.this.m_popMenu.show(me.getComponent(), me.getX(), me.getY());
                    break;
                }
                case 525: {
                    e.consume();
                    Rectangle rect = ConsolePluginTree.this.getPathBounds(ConsolePluginTree.this.getLeadSelectionPath());
                    Point pt = rect.getLocation();
                    MouseEvent me = new MouseEvent((Component)e.getSource(), 501, 0L, 0, pt.x + rect.width / 2, pt.y + rect.height / 2, 1, true);
                    int selectedRow = ConsolePluginTree.this.getRowForLocation(me.getX(), me.getY());
                    TreePath selectedPath = ConsolePluginTree.this.getPathForLocation(me.getX(), me.getY());
                    if (selectedRow == -1) break;
                    ConsolePluginTree.this.setSelectionRow(selectedRow);
                    ConsolePluginTree.this._buildPopupMenu(selectedPath);
                    ConsolePluginTree.this.m_popMenu.show(me.getComponent(), me.getX(), me.getY());
                    break;
                }
                case 67: {
                    if (!e.isControlDown()) break;
                    e.consume();
                    CopyAction copyAction = new CopyAction();
                    copyAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
                    break;
                }
                case 86: {
                    if (!e.isControlDown()) break;
                    e.consume();
                    PasteAction pasteAction = new PasteAction();
                    pasteAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), ""));
                    break;
                }
            }
        }
    }

    class PluginTreeFocusListener
    implements FocusListener {
        PluginTreeFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            ConsolePluginTree.this.m_console.checkIServerStatus();
            if (ConsoleViewManager.getCurrentViewType() != 0) {
                return;
            }
            NodeInterface node = (NodeInterface)ConsolePluginTree.this.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            ConsolePluginTree.this.m_console.setViewLastSelected(0);
            ConsolePluginTree.this.m_console.setTreeLastSelected(true);
            if (node.getPlugin().needsConnection() && ConsolePluginTree.this.m_console.getDefaultRepository() == null) {
                return;
            }
            if (!ConsolePluginTree.this.m_console.getToolBarUpdated()) {
                List actionList = node.getToolBarActions();
                Action[] extendedActions = ConsolePluginTree.this.m_console.getExtendedToolBarActions(node);
                for (int index = 0; extendedActions != null && index < extendedActions.length; ++index) {
                    actionList.add(extendedActions[index]);
                }
                ConsolePluginTree.this.m_console.updateToolBar(actionList);
                ConsolePluginTree.this.m_console.updateMenuBar(true);
            }
            ConsolePluginTree.this.m_console.refreshStatusLineText(node);
        }

        @Override
        public void focusLost(FocusEvent e) {
            ConsolePluginTree.this.m_console.setToolBarUpdated(false);
        }
    }

    class ConsoleTreeCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private static final long serialVersionUID = 9200000001L;

        public ConsoleTreeCellRenderer(JTree source) {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = new JLabel();
            FontUtil.setFontForHC(label);
            if (value instanceof NodeInterface) {
                NodeInterface node = (NodeInterface)value;
                label.setText(node.getName());
                int iconSize = 16;
                if (node.getIcon(iconSize) == null) {
                    ImageIcon icon = Resources.getImageIcon((String)bundle.getString("MainConsole.ImageIcon.DefaultIcon.image"), (int)iconSize);
                    label.setIcon(icon);
                } else {
                    label.setIcon(node.getIcon(iconSize));
                }
            }
            label.setOpaque(true);
            int treeLastSelected = ConsolePluginTree.this.m_console.getViewLastSelected();
            if (selected && treeLastSelected == 0 && hasFocus) {
                label.setBackground(SystemColor.textHighlight);
                label.setForeground(SystemColor.textHighlightText);
            } else if (selected && treeLastSelected != 0 || selected && treeLastSelected == 0 && !hasFocus) {
                Color background = UIManager.getColor("TextField.inactiveForeground");
                Color foreground = UIManager.getColor("TextField.inactiveBackground");
                if (foreground == null) {
                    foreground = UIManager.getColor("TextField.background");
                }
                label.setBackground(background);
                label.setForeground(foreground);
            } else {
                label.setBackground(UIManager.getColor("List.background"));
                label.setForeground(SystemColor.textText);
            }
            return label;
        }
    }

    class ConsoleTreeSelectionModel
    extends DefaultTreeSelectionModel
    implements PluginChangeListener {
        private static final long serialVersionUID = 9200000001L;

        public ConsoleTreeSelectionModel() {
            this.setSelectionMode(1);
        }

        @Override
        public void pluginChange(PluginChangeEvent evt) {
            int eventType = evt.getEventType();
            NodeInterface parent = evt.getParentNode();
            if (eventType == 0) {
                TreePath currentPath = this.getSelectionPath();
                TreePath parentPath = parent.getTreePath();
                if (parentPath.isDescendant(currentPath) || currentPath == null) {
                    ConsolePluginTree.this.makeVisible(parentPath);
                    this.setSelectionPath(parentPath);
                    ConsolePluginTree.this.scrollPathToVisible(parentPath);
                }
            } else if (eventType == 4) {
                TreePath selPath = parent.getTreePath();
                ConsolePluginTree.this.makeVisible(selPath);
                this.setSelectionPath(selPath);
                ConsolePluginTree.this.scrollPathToVisible(selPath);
                if (!ConsolePluginTree.this.hasFocus()) {
                    ConsolePluginTree.this.requestFocus();
                }
            } else if (eventType == 3) {
                TreePath currentPath = this.getSelectionPath();
                if (currentPath == null) {
                    TreePath selPath = evt.getParentNode().getTreePath();
                    this.setSelectionPath(selPath);
                }
            } else if (eventType != 2 && eventType != 1) {
                System.out.println(" SelectionModel - unknown event type = " + eventType);
            }
        }
    }
}

