/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTable;

public class ConsoleDNDTable
extends JTable
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final long serialVersionUID = 9200000001L;
    protected DragSource m_dragSource = new DragSource();
    protected DropTarget m_dropTarget = null;
    protected NodeInterface m_currentNode = null;

    public ConsoleDNDTable() {
        this.m_dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.m_dropTarget = new DropTarget(this, this);
        this.m_dropTarget.setActive(true);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        MouseEvent dragEvent = null;
        Point lastPoint = null;
        Point origin = dge.getDragOrigin();
        Iterator<InputEvent> events = dge.iterator();
        while (events.hasNext()) {
            InputEvent dragObj = events.next();
            if (dragObj == null) continue;
            dragEvent = (MouseEvent)dragObj;
        }
        lastPoint = dragEvent.getPoint();
        if (lastPoint.distance(origin.getX(), origin.getY()) >= 5.0) {
            int[] rowIndexes = this.getSelectedRows();
            DNDObject dragItems = new DNDObject();
            for (int i = 0; i < rowIndexes.length; ++i) {
                TableModelInterface model = (TableModelInterface)this.getModel();
                Object tableObj = model.getObjectAt(rowIndexes[i]);
                dragItems.add(tableObj);
            }
            if (dragItems.size() != 0) {
                this.m_dragSource.startDrag(dge, DragSource.DefaultCopyDrop, (Transferable)dragItems, this);
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transfer = dtde.getTransferable();
            TableModelInterface model = (TableModelInterface)this.getModel();
            NodeInterface dropNode = model.getNode();
            if (dropNode != null) {
                PluginNavigationInterface plugin = dropNode.getPlugin();
                if (plugin.supportsDropOperations()) {
                    try {
                        dtde.acceptDrop(3);
                        Vector dropItems = (Vector)transfer.getTransferData(DNDObject.dndObjectDataFlavor);
                        dropNode.drop(dropItems);
                    }
                    catch (IOException ioe) {
                        MessageUtil.displayMessage((String)ioe.getMessage());
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
        }
        catch (UnsupportedFlavorException ufe) {
            MessageUtil.displayMessage((String)ufe.getMessage());
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }
}

