/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.visuals;

import com.sas.console.plugins.ConfirmActionInterface;
import com.sas.console.plugins.ConfirmWithInputActionInterface;
import com.sas.console.plugins.CustomActionInterface;
import com.sas.console.plugins.PluginActionException;
import com.sas.console.plugins.PromptActionInterface;
import com.sas.console.utils.WindowUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ConsoleAction
implements Action {
    protected static WAdminResource bundle = new WAdminResource(ConsoleAction.class);
    protected Action newConsoleAction = null;

    public ConsoleAction(Action action) {
        this.newConsoleAction = action;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String title = this.getValue("ShortDescription") != null ? this.getValue("ShortDescription").toString() : this.getValue("Name").toString();
        Object parent = event.getSource();
        Component comp = (Component)parent;
        try {
            if (this.newConsoleAction instanceof PromptActionInterface) {
                PromptActionInterface promptAction = (PromptActionInterface)this.newConsoleAction;
                String messageText = promptAction.getInputPrompt();
                int messageType = promptAction.getMessageType();
                String userInput = JOptionPane.showInputDialog(comp, messageText, title, messageType);
                promptAction.setValue(userInput);
                promptAction.actionPerformed(event);
            } else if (this.newConsoleAction instanceof ConfirmActionInterface) {
                int confirmation;
                ConfirmActionInterface confirmAction = (ConfirmActionInterface)this.newConsoleAction;
                String messageText = confirmAction.getConfirmPrompt();
                int messageType = confirmAction.getMessageType();
                if (messageType == 0) {
                    messageType = 3;
                }
                if ((confirmation = MessageUtil.displayMessage((String)messageText, (String)title, (int)messageType, (int)2)) == 0) {
                    confirmAction.actionPerformed(event);
                }
            } else if (this.newConsoleAction instanceof ConfirmWithInputActionInterface) {
                cConfirmWithInputRunnable run = new cConfirmWithInputRunnable((ConfirmWithInputActionInterface)this.newConsoleAction, event, comp, title);
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(run);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.newConsoleAction instanceof CustomActionInterface) {
                CustomActionInterface promptAction = (CustomActionInterface)this.newConsoleAction;
                Component customObj = promptAction.getView();
                if (customObj != null) {
                    WindowUtil.ShowComponentInDialog(customObj, title);
                    promptAction.actionPerformed(event);
                }
            } else {
                this.newConsoleAction.actionPerformed(event);
            }
        }
        catch (PluginActionException exc) {
            MessageUtil.displayMessage((String)exc.getMessage(), (String)bundle.getString("Common.Title.txt"), (int)1);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.newConsoleAction.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.newConsoleAction.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isEnabled() {
        return this.newConsoleAction.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.newConsoleAction.setEnabled(enabled);
    }

    @Override
    public void putValue(String key, Object value) {
        this.newConsoleAction.putValue(key, value);
    }

    @Override
    public Object getValue(String key) {
        return this.newConsoleAction.getValue(key);
    }

    protected static class cConfirmWithInputRunnable
    implements Runnable {
        protected ConfirmWithInputActionInterface m_confirmWithInputAction;
        protected ActionEvent m_event;
        protected Component m_parent;
        protected String m_sTitle;

        public cConfirmWithInputRunnable(ConfirmWithInputActionInterface action, ActionEvent event, Component parent, String sTitle) {
            this.m_confirmWithInputAction = action;
            this.m_event = event;
            this.m_parent = parent;
            this.m_sTitle = sTitle;
        }

        @Override
        public void run() {
            int confirmation;
            Object[] oaMessage = this.m_confirmWithInputAction.getConfirmWithInputPrompt();
            int messageType = this.m_confirmWithInputAction.getMessageType();
            if (messageType == 0) {
                messageType = 3;
            }
            if ((confirmation = JOptionPane.showConfirmDialog((Component)Workspace.getWorkspace(), oaMessage, this.m_sTitle, 2, messageType)) == 0) {
                this.m_confirmWithInputAction.actionPerformed(this.m_event);
            }
        }
    }
}

