/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class TextHandler
extends StreamHandler {
    private StringBuffer m_bfrText = new StringBuffer();

    public TextHandler() {
        this(null);
    }

    public TextHandler(Formatter formatter) {
        if (formatter == null) {
            this.setFormatter(this.getFormatter());
        } else {
            this.setFormatter(formatter);
        }
        this.setLevel(Level.INFO);
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String strMessage = this.getFormatter().format(record);
        this.m_bfrText.append(strMessage);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        int levelValue = this.getLevel().intValue();
        return record.getLevel().intValue() >= levelValue && levelValue != Level.OFF.intValue();
    }

    public StringBuffer getText() {
        return this.m_bfrText;
    }
}

