/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import com.sas.console.visuals.ConsoleViewManager;
import com.sas.meta.SASOMI.IServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;
import org.omg.CORBA.StringHolder;

public class ServerUtil {
    public static final int STATUS_ERROR = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_PAUSED = 1;
    public static final int STATUS_STOPPED = 2;
    public static final int STATUS_PAUSED_ADMIN = 3;

    public static int serverStatus(IServer iserver) {
        int platformVersion;
        int rc = -1;
        String statusStr = null;
        int preStatusI = -1;
        int postStatusI = -1;
        StringHolder returnInfo = new StringHolder("");
        String options = "";
        try {
            platformVersion = Workspace.getMdFactory().getConnection().getPlatformVersion(iserver);
        }
        catch (Exception e) {
            platformVersion = 9200;
        }
        try {
            String inmeta = platformVersion < 9200 ? "<state/>" : "<ServerState/>";
            rc = iserver.Status(inmeta, returnInfo, options);
            String preStatus = platformVersion < 9200 ? "<state>" : "<ServerState>";
            String postStatus = platformVersion < 9200 ? "</state>" : "</ServerState>";
            preStatusI = returnInfo.value.indexOf(preStatus);
            postStatusI = returnInfo.value.indexOf(postStatus);
            statusStr = returnInfo.value.substring(preStatusI + preStatus.length(), postStatusI);
            rc = platformVersion < 9200 ? (statusStr.equals("0") ? 0 : (statusStr.equals("1") ? 1 : -1)) : (statusStr.equalsIgnoreCase("ONLINE") || statusStr.equalsIgnoreCase("READONLY") ? 0 : (statusStr.equalsIgnoreCase("OFFLINE") ? 1 : (statusStr.equalsIgnoreCase("ADMIN") ? 3 : -1)));
        }
        catch (Exception e) {
            rc = 2;
        }
        return rc;
    }

    public static SessionContextInterface getSessionContextInterface() {
        return ConsoleViewManager.getConsole().getSessionContext();
    }

    public static ServerInterface getServerInterface() throws RemoteException {
        return ServerUtil.getServerInterface(ServerUtil.getSessionContextInterface());
    }

    public static ServerInterface getServerInterface(SessionContextInterface session) throws RemoteException {
        ServerInterface serverInt = null;
        UserContextInterface userContext = session.getUserContext();
        List allServers = userContext.getServers();
        if (!allServers.isEmpty()) {
            serverInt = (ServerInterface)allServers.get(0);
        } else {
            Workspace.getDefaultLogger().debug((Object)"RepositoryRootNode: init - no ServerInterface object");
        }
        return serverInt;
    }
}

