/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.swing.visuals.util.Util;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MnemonicModel {
    public static void setActionTextAndMnemonic(AbstractAction action, String strStart, String shortDesc, Icon icon) {
        Util.setLabelAndMnemonicOnAction((Action)action, (String)strStart);
        if (shortDesc != null) {
            action.putValue("ShortDescription", Util.getDisplayLabel((String)shortDesc));
        }
        if (icon != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    public static void setMenuTextAndMnemonic(JMenu menu, String item) {
        String text = Util.getLabelWithoutMnemonic((String)item);
        menu.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            menu.setMnemonic(mnemonic);
            menu.setDisplayedMnemonicIndex(index);
        }
    }

    public static void setLabelTextAndMnemonic(JLabel field, String item) {
        String text = Util.getLabelWithoutMnemonic((String)item);
        field.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            field.setDisplayedMnemonic(mnemonic);
            field.setDisplayedMnemonicIndex(index);
        }
    }

    public static void setButtonTextAndMnemonic(AbstractButton field, String item) {
        String text = Util.getLabelWithoutMnemonic((String)item);
        field.setText(text);
        int index = Util.getDisplayedMnemonicIndex((String)item);
        if (index > -1) {
            int mnemonic = Util.getDisplayedMnemonic((String)item);
            field.setMnemonic(mnemonic);
            field.setDisplayedMnemonicIndex(index);
        }
    }

    public static void setListSelectorTextAndMnemonic(DualListSelector list, String source, String target) {
        MnemonicModel.setDualSelectorTextAndMnemonic((BaseDualSelector)list, source, target);
    }

    public static void setDualSelectorTextAndMnemonic(BaseDualSelector dualSelector, String source, String target) {
        String labelText = Util.getLabelWithoutMnemonic((String)source);
        dualSelector.setSourceLabel(labelText);
        JLabel label = (JLabel)dualSelector.getSourceLabelComponent();
        MnemonicModel.setLabelTextAndMnemonic(label, source);
        labelText = Util.getLabelWithoutMnemonic((String)target);
        dualSelector.setTargetLabel(labelText);
        label = (JLabel)dualSelector.getTargetLabelComponent();
        MnemonicModel.setLabelTextAndMnemonic(label, target);
    }

    public static String getLabelWithoutMnemonic(String item) {
        String returnItem = "";
        if (item != null) {
            returnItem = Util.getLabelWithoutMnemonic((String)item);
        }
        return returnItem;
    }

    public static String getDisplayLabel(String item) {
        String returnItem = "";
        if (item != null) {
            returnItem = Util.getDisplayLabel((String)item);
        }
        return returnItem;
    }

    public static JMenuItem getMenuItemWithMnemonic(Action action) {
        JMenuItem newItem = new JMenuItem(action);
        Integer mnemonicIndex = (Integer)action.getValue("MnemonicIndex");
        if (mnemonicIndex != null) {
            newItem.setDisplayedMnemonicIndex(mnemonicIndex);
        }
        return newItem;
    }

    public static JButton getButtonWithMnemonic(Action action) {
        JButton newButton = new JButton(action);
        Integer mnemonicIndex = (Integer)action.getValue("MnemonicIndex");
        if (mnemonicIndex != null) {
            newButton.setDisplayedMnemonicIndex(mnemonicIndex);
        }
        return newButton;
    }
}

