/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.List;

public class FolderUtil {
    public static final String ASSOCIATION_PARENTTREE_NAME = "ParentTree";
    public static final String SYSTEM_FOLDER = "System";

    public static List getMembersRecursive(Tree folder) throws MdException, RemoteException {
        AssociationList lstMembers = folder.getMembers();
        AssociationList lstFolders = folder.getSubTrees();
        for (int folderIndex = 0; folderIndex < lstFolders.size(); ++folderIndex) {
            Tree subfolder = (Tree)lstFolders.get(folderIndex);
            lstMembers.addAll(FolderUtil.getMembersRecursive(subfolder));
        }
        return lstMembers;
    }

    public static boolean isTopLevelFolder(Tree folder) throws RemoteException, LogicalTypeException {
        if (folder == null) {
            return false;
        }
        LogicalObjectInterface loi = LogicalTypesAndServicesAdapter.getInstance().getFactory().getObject((Root)folder);
        if (loi instanceof FolderInterface) {
            return ((FolderInterface)loi).isTopLevel();
        }
        return false;
    }

    public static boolean isRootFolder(Tree folder) throws RemoteException, LogicalTypeException {
        if (folder == null) {
            return false;
        }
        FolderInterface folderLogicalObject = (FolderInterface)LogicalTypesAndServicesAdapter.getInstance().getFactory().getObject((Root)folder);
        return folderLogicalObject.isRoot();
    }

    public static boolean isSystemFolder(Tree folder) {
        if (folder == null) {
            return false;
        }
        try {
            MetadataInterface smartObject = UtilPlatformServices.getSmartObject((Root)folder);
            if (smartObject instanceof com.sas.services.information.metadata.FolderInterface && ((com.sas.services.information.metadata.FolderInterface)smartObject).getFolderType().equals(SYSTEM_FOLDER)) {
                return true;
            }
        }
        catch (ServiceException smartObject) {
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Root getParentContainer(Root metadataObject) throws MdException, RemoteException {
        SoftwareComponent parentObject;
        block16: {
            String objectType = metadataObject.getCMetadataType();
            parentObject = null;
            if (objectType.equalsIgnoreCase("Tree")) {
                Tree folder = (Tree)metadataObject;
                try {
                    if (FolderUtil.isTopLevelFolder(folder)) {
                        parentObject = UtilMetadata.locateFoundationSoftwareComponentFromTopLevelTree((Tree)folder);
                        break block16;
                    }
                    parentObject = folder.getParentTree();
                }
                catch (LogicalTypeException logicalTypeException) {}
            } else if (metadataObject.getTrees().size() > 0) {
                AssociationList treeList = metadataObject.getTrees();
                if (!treeList.isEmpty()) {
                    parentObject = (Tree)treeList.get(0);
                }
            } else {
                try {
                    Class<?> jomaClass = Class.forName("com.sas.metadata.remote.impl." + metadataObject.getCMetadataType() + "Impl");
                    Method parentContainerMethod = jomaClass.getMethod("getParentContainer", new Class[0]);
                    Object parentContainer = parentContainerMethod.invoke((Object)metadataObject, new Object[0]);
                    if (parentContainer != null) {
                        parentObject = (Root)parentContainer;
                    }
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return parentObject;
    }
}

