/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.utils;

import com.sas.console.folderview.visuals.TableView;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.CustomTablePane;
import com.sas.console.plugins.CustomViewInterface;
import java.awt.Component;
import java.util.Date;
import javax.swing.JComponent;

public class CustomTableUtil {
    private static Date BLANK_DATE = new Date(Integer.MAX_VALUE);

    public static Date getBlankDate() {
        return BLANK_DATE;
    }

    private static boolean saveSettingsForCustomTablePane(Object inputCustomTable) {
        CustomViewInterface customView;
        Component temp;
        boolean saved = false;
        CustomTableInterface customTableInterface = null;
        if (inputCustomTable instanceof CustomTableInterface) {
            customTableInterface = (CustomTableInterface)inputCustomTable;
        } else if (inputCustomTable instanceof CustomViewInterface && (temp = (customView = (CustomViewInterface)inputCustomTable).getComponent()) instanceof CustomTableInterface) {
            customTableInterface = (CustomTableInterface)((Object)temp);
        }
        if (customTableInterface != null) {
            saved = true;
            CustomTablePane customTable = (CustomTablePane)customTableInterface;
            customTable.saveSettings();
        }
        return saved;
    }

    private static boolean saveSettingsForTableView(Object inputTableView) {
        boolean saved = false;
        if (inputTableView instanceof TableView) {
            saved = true;
            TableView tableView = (TableView)inputTableView;
            CustomTableUtil.saveSettingsForCustomTablePane(tableView.getComponent());
        }
        return saved;
    }

    private static boolean saveSettingsForJComponent(Object inputComponent) {
        boolean saved = false;
        if (inputComponent instanceof JComponent) {
            saved = true;
            JComponent component = (JComponent)inputComponent;
            Component[] customTables = component.getComponents();
            for (int i = customTables.length - 1; i >= 0; --i) {
                Component object = customTables[i];
                CustomTableUtil.saveSettingsForCustomTablePane(object);
            }
        }
        return saved;
    }

    public static void saveSettings(Object inputComponent) {
        if (inputComponent != null) {
            boolean saved = CustomTableUtil.saveSettingsForTableView(inputComponent);
            if (!saved) {
                CustomTableUtil.saveSettingsForCustomTablePane(inputComponent);
            }
            if (!saved) {
                CustomTableUtil.saveSettingsForJComponent(inputComponent);
            }
        }
    }
}

