/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.searchview;

import com.sas.console.ConsoleChangeEvent;
import com.sas.console.ConsoleChangeListener;
import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.TableAbstractColumn;
import com.sas.console.folderview.visuals.TableColumnDescription;
import com.sas.console.folderview.visuals.TableColumnIcon;
import com.sas.console.folderview.visuals.TableColumnLastUpdated;
import com.sas.console.folderview.visuals.TableColumnName;
import com.sas.console.folderview.visuals.TableColumnType;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.searchview.LocationColumnThread;
import com.sas.console.searchview.NoSearchResultsCustomView;
import com.sas.console.searchview.RB;
import com.sas.console.searchview.ResultsTable;
import com.sas.console.searchview.ResultsTableItem;
import com.sas.console.searchview.TableColumnLocation;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.console.visuals.CustomConsoleViewInterface;
import com.sas.console.visuals.MainConsole;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.visuals.search.DefaultSearchPanel;
import com.sas.metadata.logical.visuals.search.SearchEventListener;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SearchView
implements CustomConsoleViewInterface,
ConsoleChangeListener {
    protected ConsoleInterface m_console;
    protected DefaultSearchPanel m_searchPanel;
    protected ResultsTable m_searchTable;
    private Vector<TableItem> _itemList;
    private boolean m_clearSearch = true;
    private boolean m_searchCompleted = false;
    LocationColumnThread m_locThread = null;

    public SearchView(ConsoleInterface console) {
        this.m_console = console;
        this.m_console.addConsoleListener(this);
    }

    @Override
    public void cleanupChangeListeners(NodeInterface node) {
    }

    @Override
    public JComponent getComponent() {
        return this.m_searchPanel;
    }

    @Override
    public ConsoleInterface getConsole() {
        return this.m_console;
    }

    @Override
    public String getDisplayName() {
        return RB.getStringResource("Common.Search.txt");
    }

    @Override
    public int getIndex() {
        return 2;
    }

    @Override
    public String getName() {
        return RB.getStringResource("Common.SearchView.txt");
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void initialize() {
        this.setName(RB.getStringResource("Common.SearchTab.txt"));
        this.setDisplayName(RB.getStringResource("Common.Search.txt"));
    }

    public void initSearchTab() {
        if (this.m_searchPanel == null) {
            this.m_searchPanel = new DefaultSearchPanel();
            this.m_searchPanel.addSearchListener((SearchEventListener)new SearchListener());
            this.m_searchPanel.addFocusListener((FocusListener)new SearchViewFocusListener());
            this.m_searchPanel.setSortSearchResults(true);
        }
        try {
            this.m_searchPanel.loadInitialData();
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        this.m_searchPanel.layoutComponents();
        this.m_searchPanel.setSearchButtonAsDefaultButton();
    }

    @Override
    public void setComponent(JComponent component) {
    }

    @Override
    public void setDisplayName(String displayName) {
    }

    @Override
    public void setIndex(int index) {
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public Component getRightSideComponent() {
        JPanel panel = new JPanel();
        if (this.m_searchTable == null) {
            this.m_searchTable = (ResultsTable)this.createClearCustomTable();
        }
        Component customTable = this.m_searchTable.getComponent();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(customTable, gbc);
        panel.add(customTable);
        panel.setBackground(UIManager.getColor("List.background"));
        return panel;
    }

    @Override
    public CustomViewInterface getCustomView() {
        if (this.m_clearSearch) {
            this.createClearCustomTable();
            return this.m_searchTable;
        }
        List searchResultsList = null;
        if (!this.m_searchCompleted) {
            return this.m_searchTable;
        }
        searchResultsList = this.m_searchPanel.getSearchResults();
        if (searchResultsList == null || searchResultsList.size() == 0) {
            this.setResultsCountOnStatusLine(0);
            return new NoSearchResultsCustomView();
        }
        this._itemList = new Vector();
        for (int i = 0; i < searchResultsList.size(); ++i) {
            PublicObjectInterface po = (PublicObjectInterface)searchResultsList.get(i);
            ResultsTableItem ti = new ResultsTableItem(po);
            this._itemList.add(ti);
        }
        this.setResultsCountOnStatusLine(searchResultsList.size());
        TableAbstractColumn[] _columnModels = new TableAbstractColumn[TableAbstractColumn.NUMBER_OF_COLUMNS + 1];
        _columnModels[0] = new TableColumnIcon(null, this._itemList);
        _columnModels[1] = new TableColumnName(null, this._itemList);
        _columnModels[2] = new TableColumnDescription(null, this._itemList);
        _columnModels[3] = new TableColumnType(null, this._itemList);
        _columnModels[4] = new TableColumnLastUpdated(null, this._itemList);
        TableColumnLocation pathColumn = new TableColumnLocation(null, this._itemList);
        _columnModels[5] = pathColumn;
        if (this.m_searchTable != null) {
            this.m_searchTable.unregisterMetadataListener();
            this.m_console.removeConsoleListener(this.m_searchTable);
        }
        this.m_searchTable = new ResultsTable(this.m_console, _columnModels, TableAbstractColumn.NUMBER_OF_COLUMNS + 1, this._itemList, "com.sas.console.searchView.SearchResultsTable");
        CustomTableInterface customTable = (CustomTableInterface)((Object)this.m_searchTable.getComponent());
        customTable.setRowHeaderVisible(false);
        OMIServer server = Workspace.getWorkspace().getMetadataServer();
        this.m_locThread = new LocationColumnThread(pathColumn, (ServerInterface)server, this.m_searchTable, searchResultsList, _columnModels);
        this.m_locThread.start();
        return this.m_searchTable;
    }

    private CustomViewInterface createClearCustomTable() {
        Vector itemList = new Vector();
        TableAbstractColumn[] _columnModels = new TableAbstractColumn[TableAbstractColumn.NUMBER_OF_COLUMNS + 1];
        _columnModels[0] = new TableColumnIcon(null, this._itemList);
        _columnModels[1] = new TableColumnName(null, this._itemList);
        _columnModels[2] = new TableColumnDescription(null, this._itemList);
        _columnModels[3] = new TableColumnType(null, this._itemList);
        _columnModels[4] = new TableColumnLastUpdated(null, this._itemList);
        _columnModels[5] = new TableColumnLocation(null, this._itemList);
        if (this.m_searchTable != null) {
            this.m_searchTable.unregisterMetadataListener();
            this.m_console.removeConsoleListener(this.m_searchTable);
        }
        this.m_searchTable = new ResultsTable(this.m_console, _columnModels, TableAbstractColumn.NUMBER_OF_COLUMNS + 1, itemList, "com.sas.console.searchView.SearchResultsTable");
        return this.m_searchTable;
    }

    @Override
    public void consoleChange(ConsoleChangeEvent event) {
        switch (event.getEventType()) {
            case 4: {
                this.m_searchPanel = null;
                this.m_searchTable = null;
                break;
            }
            case 13: {
                this.m_searchCompleted = false;
                break;
            }
            case 2: {
                this.m_searchTable = null;
                this.m_clearSearch = true;
            }
        }
    }

    public void setResultsCountOnStatusLine(int numberOfObjects) {
        String objCnt = UtilMisc.getMessage((String)RB.getStringResource("SearchView.ObjectCountLabel.fmt.txt"), (Object)numberOfObjects);
        this.m_console.setStatusLineText(objCnt);
    }

    public void clearSearchTable() {
        this.m_clearSearch = true;
        this.m_searchCompleted = false;
        MainConsole console = (MainConsole)ConsoleViewManager.getConsole();
        console.fireConsoleChange(15);
    }

    private class SearchListener
    implements SearchEventListener {
        private SearchListener() {
        }

        public void searchCanceled() {
        }

        public void searchCompleted(List<PublicObjectInterface> objects) {
            SearchView.this.m_clearSearch = false;
            SearchView.this.m_searchCompleted = true;
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            MainConsole console = (MainConsole)ConsoleViewManager.getConsole();
            console.fireConsoleChange(15);
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }

        public void searchStarted() {
            SearchView.this.m_clearSearch = true;
            SearchView.this.m_searchCompleted = false;
            MainConsole console = (MainConsole)ConsoleViewManager.getConsole();
            if (SearchView.this.m_locThread != null && SearchView.this.m_locThread.isActive()) {
                SearchView.this.m_locThread.stopThread();
            }
            console.fireConsoleChange(15);
        }
    }

    class SearchViewFocusListener
    implements FocusListener {
        MainConsole console;

        SearchViewFocusListener() {
            this.console = (MainConsole)SearchView.this.m_console;
        }

        @Override
        public void focusGained(FocusEvent event) {
            this.console.checkIServerStatus();
            if (ConsoleViewManager.getCurrentViewType() != 2) {
                return;
            }
            this.console.setViewLastSelected(2);
            this.console.setTreeLastSelected(true);
            if (SearchView.this.m_console.getDefaultRepository() == null) {
                return;
            }
            if (!this.console.getToolBarUpdated()) {
                ArrayList actionList = new ArrayList();
                this.console.updateToolBar(actionList);
                this.console.updateMenuBar(true);
            }
            this.console.setStatusLineText("");
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.console.setToolBarUpdated(false);
        }
    }
}

