/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.plugins.Root;

import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.PluginInterface;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.plugins.Root.CategoryNode;
import com.sas.console.plugins.Root.DesktopView;
import com.sas.console.plugins.TableModelInterface;
import com.sas.console.visuals.MainConsole;
import com.sas.workspace.WAdminResource;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class RootNode
extends AbstractNode {
    protected List m_categoryNodes;
    protected List m_availablePlugins;
    protected DesktopView m_desktopView;
    protected static WAdminResource bundle = new WAdminResource(RootNode.class);

    public RootNode(PluginNavigationInterface plugin, List availablePlugins) {
        super(plugin);
        this.m_availablePlugins = availablePlugins;
        this.setName(plugin.getName());
        this.m_categoryNodes = new ArrayList(4);
        CategoryNode environment = new CategoryNode("Environment", this);
        this.m_categoryNodes.add(environment);
        CategoryNode monitor = new CategoryNode("Monitor", environment);
        environment.insert(monitor, environment.getNonPluginChildCount());
        this.m_categoryNodes.add(monitor);
        CategoryNode maint = new CategoryNode("Maintenance", environment);
        environment.insert(maint, environment.getNonPluginChildCount());
        this.m_categoryNodes.add(maint);
        this.m_categoryNodes.add(new CategoryNode("Application", this));
        this._assignPlugins();
        this.m_desktopView = new DesktopView((MainConsole)plugin.getConsole(), this);
    }

    protected void _assignPlugins() {
        block0: for (int index = 0; index < this.m_availablePlugins.size(); ++index) {
            PluginInterface simplePlugin = (PluginInterface)this.m_availablePlugins.get(index);
            if (!(simplePlugin instanceof PluginNavigationInterface)) continue;
            PluginNavigationInterface plugin = (PluginNavigationInterface)simplePlugin;
            String strCategoryType = plugin.getCategoryID();
            for (int i = 0; i < this.m_categoryNodes.size(); ++i) {
                CategoryNode node = (CategoryNode)this.m_categoryNodes.get(i);
                if (strCategoryType != node.getCategoryID()) continue;
                node.addPlugin(plugin);
                plugin.getRootNode().setParent(node);
                continue block0;
            }
        }
    }

    protected boolean _assignASinglePlugin(PluginInterface simplePlugin) {
        if (simplePlugin instanceof PluginNavigationInterface) {
            PluginNavigationInterface plugin = (PluginNavigationInterface)simplePlugin;
            String strCategoryType = plugin.getCategoryID();
            for (int i = 0; i < this.m_categoryNodes.size(); ++i) {
                CategoryNode node = (CategoryNode)this.m_categoryNodes.get(i);
                if (strCategoryType != node.getCategoryID()) continue;
                boolean added = node.addPlugin(plugin);
                if (!added) break;
                plugin.getRootNode().setParent(node);
                return added;
            }
        }
        return false;
    }

    @Override
    public List getContextMenuActions() {
        return null;
    }

    @Override
    public TableModelInterface getListViewData() {
        return null;
    }

    @Override
    public Icon getIcon(int size) {
        return this.m_plugin.getIcon(size);
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index == 0) {
            return (TreeNode)this.m_categoryNodes.get(index);
        }
        return (TreeNode)this.m_categoryNodes.get(3);
    }

    @Override
    public int getChildCount() {
        return this.m_categoryNodes.size() - 2;
    }

    @Override
    public CustomViewInterface getCustomView() {
        return this.m_desktopView;
    }

    @Override
    public List getToolBarActions() {
        return null;
    }

    @Override
    public String getStatusLineText() {
        return bundle.getString("StatusLine.Welcome.txt");
    }

    @Override
    public void refresh() {
    }

    protected void addChild(PluginInterface newChild) {
        if (this._assignASinglePlugin(newChild)) {
            this.m_availablePlugins.add(newChild);
        }
    }

    protected void removeChild(PluginInterface newChild) {
        if (newChild instanceof PluginNavigationInterface) {
            PluginNavigationInterface plugin = (PluginNavigationInterface)newChild;
            String strCategoryType = plugin.getCategoryID();
            block0: for (int i = 0; i < this.m_categoryNodes.size(); ++i) {
                CategoryNode node = (CategoryNode)this.m_categoryNodes.get(i);
                if (strCategoryType != node.getCategoryID()) continue;
                List plugins = node.getPlugins();
                for (int j = 0; j < plugins.size(); ++j) {
                    if (!plugins.get(j).equals(plugin)) continue;
                    node.removePlugin(plugin);
                    continue block0;
                }
            }
        }
    }

    public List getRegisteredPlugins() {
        return this.m_availablePlugins;
    }

    public List getCategoryNodes() {
        return this.m_categoryNodes;
    }

    public void removeAllPlugins() {
        for (int i = 0; i < this.m_categoryNodes.size(); ++i) {
            ((CategoryNode)this.m_categoryNodes.get(i)).removeAllPlugins();
        }
    }
}

