/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.plugins;

import com.sas.console.plugins.CustomTableColumnInterface;
import com.sas.console.plugins.CustomTableFactory;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeEvent;
import java.awt.Component;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class GenericCustomTableView
implements CustomViewInterface {
    protected NodeInterface m_node;
    protected CustomTableColumnInterface[] m_columnModels;
    protected CustomTableInterface m_customTable;
    protected int m_rowCount;
    protected String m_settingsPrefix;
    protected AbstractMap m_properties;

    public GenericCustomTableView(NodeInterface node, CustomTableColumnInterface[] columnModels, int rowCount, String settingsPrefix) {
        this(node, columnModels, rowCount, settingsPrefix, null);
    }

    public GenericCustomTableView(NodeInterface node, CustomTableColumnInterface[] columnModels, int rowCount, String settingsPrefix, AbstractMap properties) {
        this.m_node = node;
        this.m_columnModels = columnModels;
        this.m_rowCount = rowCount;
        this.m_settingsPrefix = settingsPrefix;
        if (properties == null) {
            properties = new TableProperties();
        }
        this.m_properties = properties;
    }

    @Override
    public List getToolBarActions() {
        return this.m_customTable.getToolBarActions();
    }

    @Override
    public List getContextMenuActions() {
        return this.m_customTable.getContextMenuActions();
    }

    @Override
    public NodeInterface getNode() {
        return this.m_node;
    }

    @Override
    public Component getComponent() {
        if (this.m_customTable == null) {
            this.m_customTable = CustomTableFactory.createCustomTable(this.m_columnModels, this.m_rowCount, this.m_settingsPrefix);
        }
        this.m_customTable.setTableProperties(this.m_properties);
        return (Component)((Object)this.m_customTable);
    }

    public void updateModel(CustomTableColumnInterface[] columnModels, int rows) {
        this.m_columnModels = columnModels;
        this.m_rowCount = rows;
        this.m_customTable.refresh(this.m_columnModels, this.m_rowCount);
    }

    @Override
    public void pluginChange(PluginChangeEvent evt) {
    }

    protected class TableProperties
    extends AbstractMap {
        protected TableProperties() {
        }

        @Override
        public Set entrySet() {
            MyPropertyKeySet keys = new MyPropertyKeySet();
            return keys;
        }
    }

    protected class MyMapEntry
    implements Map.Entry {
        Object m_key;
        Object m_value;

        public MyMapEntry(String key, boolean value) {
            this(key, new Boolean(value));
        }

        public MyMapEntry(String key, Object value) {
            this.m_key = key;
            this.m_value = value;
        }

        public Object getValue() {
            return this.m_value;
        }

        public Object getKey() {
            return this.m_key;
        }

        public void setKey(Object key) {
            this.m_key = key;
        }

        public Object setValue(Object value) {
            this.m_value = value;
            return this.m_value;
        }
    }

    protected class MyPropertyKeySet
    extends AbstractSet {
        List propertyList = new Vector(1);

        public MyPropertyKeySet() {
            this.propertyList.add(new MyMapEntry("ROW_HEADERS_VISIBLE", false));
        }

        @Override
        public Iterator iterator() {
            return this.propertyList.iterator();
        }

        @Override
        public int size() {
            return this.propertyList.size();
        }
    }
}

