/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.plugins;

import com.sas.console.plugins.CustomTableColumnInterface;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.CustomTablePane;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.visuals.ConsoleAction;
import com.sas.console.visuals.CustomTablePropertyAction;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAdminResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class CustomTableDefaultAction
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    private CustomTableInterface m_customTable;
    private static WAdminResource bundle = new WAdminResource(CustomTableDefaultAction.class);

    protected CustomTableDefaultAction(CustomTableInterface customTable) {
        this.m_customTable = customTable;
        this.putValue("Name", "CustomTableDefaultAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedRow;
        ElementInterface element;
        CustomTablePane pane;
        boolean displayProperties;
        CustomTableColumnInterface column = this.m_customTable.getCurrentColumn();
        if (column == null) {
            return;
        }
        int[] rows = this.m_customTable.getSelectedRows();
        Action openAction = null;
        ArrayList<Action> nonNullActions = new ArrayList<Action>();
        boolean showProperties = true;
        String openActionBundleName = Util.getDisplayLabel((String)bundle.getString("Common.OpenAction.Name.txt"));
        List actions = column.getContextMenuActions(rows);
        for (int i = actions.size() - 1; i >= 0 && openAction == null; --i) {
            String actionNameWithoutMnemonic;
            Action tempAction = (Action)actions.get(i);
            if (tempAction == null) continue;
            nonNullActions.add(tempAction);
            String actionName = (String)tempAction.getValue("ShortDescription");
            if (actionName == null) {
                actionName = (String)tempAction.getValue("Name");
            }
            if (!openActionBundleName.equalsIgnoreCase(actionNameWithoutMnemonic = Util.getDisplayLabel((String)actionName))) continue;
            openAction = tempAction;
        }
        if (openAction != null) {
            ConsoleAction consoleAction = this.getConsoleAction(openAction);
            consoleAction.actionPerformed(e);
            showProperties = false;
        } else if (nonNullActions.size() == 1 && !(displayProperties = (pane = (CustomTablePane)this.m_customTable).displaysProperties(element = column.getElementInterface(selectedRow = rows[0])))) {
            showProperties = false;
            Action action = (Action)nonNullActions.get(0);
            ConsoleAction consoleAction = this.getConsoleAction(action);
            consoleAction.actionPerformed(e);
        }
        if (showProperties) {
            ConsoleAction consoleAction = this.getConsoleAction(new CustomTablePropertyAction(this.m_customTable));
            consoleAction.actionPerformed(e);
        }
    }

    private ConsoleAction getConsoleAction(Action inputAction) {
        ConsoleAction consoleAction = null;
        consoleAction = inputAction instanceof ConsoleAction ? (ConsoleAction)inputAction : new ConsoleAction(inputAction);
        return consoleAction;
    }
}

