/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.FolderViewDefaultAction;
import com.sas.console.folderview.visuals.TableAbstractColumn;
import com.sas.console.folderview.visuals.TableSorter;
import com.sas.console.plugins.CustomTableFactory;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.CustomTablePane;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeEvent;
import com.sas.console.searchview.ClearSearchResultsAction;
import com.sas.console.searchview.ResultsTable;
import com.sas.console.searchview.SearchView;
import com.sas.console.visuals.ConsoleViewManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class TableView
implements CustomViewInterface {
    private NodeInterface _node;
    private TableAbstractColumn[] _columnModels;
    protected CustomTableInterface _customTable;
    protected int _visibleColumns;
    protected String _settingsPrefix;
    public Vector _itemList;

    public TableView(NodeInterface node, TableAbstractColumn[] columnModels, int visibleColumns, Vector itemList, String settingsPrefix) {
        this._node = node;
        this._columnModels = columnModels;
        this._visibleColumns = visibleColumns;
        this._itemList = itemList;
        this._settingsPrefix = settingsPrefix;
    }

    @Override
    public List getToolBarActions() {
        ArrayList<ClearSearchResultsAction> actionsList = new ArrayList<ClearSearchResultsAction>(0);
        if (this instanceof ResultsTable) {
            actionsList.add(new ClearSearchResultsAction((SearchView)ConsoleViewManager.getView(2)));
        }
        if (this._customTable != null && this._customTable.getToolBarActions() != null) {
            actionsList.addAll(this._customTable.getToolBarActions());
        }
        return actionsList;
    }

    @Override
    public List getContextMenuActions() {
        if (this instanceof ResultsTable && this._itemList.size() == 0) {
            return new ArrayList();
        }
        return this._customTable.getContextMenuActions();
    }

    @Override
    public NodeInterface getNode() {
        return this._node;
    }

    @Override
    public Component getComponent() {
        if (this._customTable == null) {
            this._customTable = CustomTableFactory.createCustomTable(this._columnModels, this._itemList.size(), this._settingsPrefix);
            ((CustomTablePane)this._customTable).setDefaultAction(new FolderViewDefaultAction(this._customTable));
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("GRID_VISIBLE", new Boolean(false));
            this._customTable.setTableProperties(map);
            this._customTable.setSorter(new TableSorter(this._itemList));
            this._customTable.setAutoResizeMode(0);
        }
        return (Component)((Object)this._customTable);
    }

    @Override
    public void pluginChange(PluginChangeEvent evt) {
    }
}

