/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.FolderItem;
import com.sas.console.folderview.visuals.NonFolderContainerItem;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.CustomTableSorter;
import com.sas.workspace.WsAbstractSorter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class TableSorter
extends WsAbstractSorter
implements CustomTableSorter {
    Vector _itemList;

    TableSorter(Vector itemList) {
        this._itemList = itemList;
    }

    @Override
    public int[] sort(Object[][] sortArg) {
        int i;
        boolean ascendingSortNeeded = this.m_aDirections[0] == 1;
        int size = sortArg.length;
        Object[] membersToOrder = new ItemWrapper[size];
        Object[] foldersToOrder = new ItemWrapper[size];
        int membersSize = 0;
        int foldersSize = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            TableItem candidate = (TableItem)this._itemList.get(i2);
            if (this.isItemAMember(candidate)) {
                membersToOrder[membersSize] = new ItemWrapper(candidate, i2, sortArg);
                ++membersSize;
                continue;
            }
            foldersToOrder[foldersSize] = new ItemWrapper(candidate, i2, sortArg);
            ++foldersSize;
        }
        if (membersSize > 0) {
            Arrays.sort(membersToOrder, 0, membersSize);
        }
        if (foldersSize > 0) {
            Arrays.sort(foldersToOrder, 0, foldersSize);
        }
        int[] order = new int[size];
        int nextInsertionPoint = 0;
        for (i = 0; i < foldersSize; ++i) {
            order[nextInsertionPoint] = ((ItemWrapper)foldersToOrder[i]).m_count;
            ++nextInsertionPoint;
        }
        for (i = 0; i < membersSize; ++i) {
            order[nextInsertionPoint] = ((ItemWrapper)membersToOrder[i]).m_count;
            ++nextInsertionPoint;
        }
        if (!ascendingSortNeeded) {
            int[] reversedorder = new int[size];
            for (int i3 = 0; i3 < size; ++i3) {
                reversedorder[i3] = order[size - (i3 + 1)];
            }
            order = reversedorder;
        }
        return order;
    }

    private boolean isItemAMember(TableItem item) {
        return item instanceof NonFolderContainerItem || !(item instanceof FolderItem);
    }

    public class ItemWrapper
    implements Comparable {
        TableItem m_item = null;
        int m_count = -1;
        Object[][] m_sortArg;

        ItemWrapper(TableItem item, int ordinal, Object[][] sortArg) {
            this.m_item = item;
            this.m_count = ordinal;
            this.m_sortArg = sortArg;
        }

        public int compareTo(Object right) {
            Comparator c = TableSorter.this.m_aComparators[0];
            return c.compare(this.m_sortArg[this.m_count][0], this.m_sortArg[((ItemWrapper)right).m_count][0]);
        }
    }
}

