/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.ActionCopy;
import com.sas.console.folderview.visuals.ActionDelete;
import com.sas.console.folderview.visuals.ActionOpen;
import com.sas.console.folderview.visuals.ActionRename;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.BIActionFactory;
import com.sas.console.folderview.visuals.BIActionInterface;
import com.sas.console.folderview.visuals.FolderItem;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.NonFolderContainerItem;
import com.sas.console.folderview.visuals.NonFolderContainerNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.CustomTableColumnInterface;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.metadata.logical.ActionContextInterface;
import com.sas.metadata.logical.ActionType;
import com.sas.metadata.logical.ContainerContextInterface;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.visuals.UpgradeLogicalObjectVersionAction;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.visuals.CopyPasteManager;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Root;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.IdentityUtil;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractVersionedObjectManager;
import com.sas.workspace.WsComparatorFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;

public abstract class TableAbstractColumn
implements CustomTableColumnInterface {
    public static final int COLUMN_INDEX_ICON = 0;
    public static final int COLUMN_INDEX_NAME = 1;
    public static final int COLUMN_INDEX_DESCRIPTION = 2;
    public static final int COLUMN_INDEX_TYPE = 3;
    public static final int COLUMN_INDEX_LAST_UPDATED = 4;
    public static int NUMBER_OF_COLUMNS = 5;
    public List _itemsList;
    private BIAbstractNode _node;
    static Comparator _comparatorDate = WsComparatorFactory.createComparator(Date.class);
    static Comparator _comparatorString = SASCollatorFactory.createCollator();

    public TableAbstractColumn(BIAbstractNode node, List itemsList) {
        this._node = node;
        this._itemsList = itemsList;
    }

    public TableAbstractColumn(List itemsList) {
        this._itemsList = itemsList;
    }

    @Override
    public abstract String getColumnName();

    @Override
    public abstract int getColumnType();

    @Override
    public abstract int getDefaultWidth();

    @Override
    public abstract int getIndex();

    @Override
    public abstract Object getDisplayValue(int var1);

    private List getItemSpecificActions(int[] selectedRows, boolean separatorsSupported) {
        try {
            ArrayList<Action> actionsList = new ArrayList<Action>();
            boolean addedActionsSinceLastSeparator = false;
            ElementInterface[] tableItems = this.getSelectedElements(selectedRows);
            ArrayList<PublicObjectInterface> publicObjectsList = new ArrayList<PublicObjectInterface>(0);
            if (tableItems.length > 1) {
                boolean isUnrestrictedUser = false;
                try {
                    isUnrestrictedUser = IdentityUtil.isUnrestricted((MdFactory)Workspace.getMdFactory());
                }
                catch (Exception ee) {
                    Workspace.getDefaultLogger().error((Object)("\n\nCheck if user is unrestricted " + ee.getLocalizedMessage()));
                }
                HashSet<String> logicalTypeNamesPresent = new HashSet<String>();
                ArrayList<LogicalObjectInterface> lo = new ArrayList<LogicalObjectInterface>();
                ArrayList<Root> ro = new ArrayList<Root>();
                boolean deleteEnabled = true;
                boolean upgradeShown = true;
                boolean copyShown = true;
                for (int i = 0; i < tableItems.length && (copyShown || deleteEnabled || upgradeShown); ++i) {
                    LogicalObjectInterface loi;
                    TableItem ti = (TableItem)tableItems[i];
                    Root metaObject = ti.getRoot();
                    if (metaObject != null) {
                        ro.add(metaObject);
                    }
                    if ((loi = ti.getLogicalObjectInterface()) == null) continue;
                    publicObjectsList.add(ti.getPublicObjectInterface());
                    lo.add(loi);
                    TypeInterface type = loi.getTypeInterface();
                    logicalTypeNamesPresent.add(type.getPublicType());
                    try {
                        FolderInterface folder;
                        if (!isUnrestrictedUser && deleteEnabled && loi instanceof FolderInterface && (folder = (FolderInterface)loi).isCustomRepositoryRoot()) {
                            deleteEnabled = false;
                        }
                        if (!isUnrestrictedUser && deleteEnabled && !loi.isDeleteAllowed()) {
                            deleteEnabled = false;
                        }
                    }
                    catch (LogicalTypeException e) {
                        UtilGui.displayExceptionError((Exception)((Object)e));
                        deleteEnabled = false;
                    }
                    if (!upgradeShown || WsAbstractVersionedObjectManager.isUpgradeable((String)type.getPublicType(), (UsageVersion)loi.getUsageVersion())) continue;
                    upgradeShown = false;
                    if (!copyShown || !type.getPublicType().equals("FavoritesGroup")) continue;
                    copyShown = false;
                }
                LogicalObjectInterface[] logicalObjects = new LogicalObjectInterface[lo.size()];
                lo.toArray(logicalObjects);
                Root[] roots = new Root[ro.size()];
                ro.toArray(roots);
                if (copyShown) {
                    ActionCopy copyAction = new ActionCopy(publicObjectsList);
                    actionsList.add(copyAction);
                    try {
                        if (!CopyPasteManager.isCopyAllowed(publicObjectsList)) {
                            copyAction.setEnabled(false);
                        }
                    }
                    catch (ServiceException e) {
                        UtilGui.displayExceptionError((Exception)((Object)e));
                    }
                    if (separatorsSupported) {
                        actionsList.add(null);
                    }
                }
                try {
                    Action deleteAction = this.createDeleteAction(tableItems);
                    if (deleteAction != null) {
                        deleteAction.setEnabled(deleteEnabled);
                        actionsList.add(deleteAction);
                        addedActionsSinceLastSeparator = true;
                    }
                }
                catch (Exception e) {
                    UtilGui.displayExceptionError((Exception)e);
                }
                for (BIActionInterface biai : BIActionFactory.getBIActionInterfaces()) {
                    List actionsForThisBIAI;
                    if (!this.doesActionSupportAllSelections(logicalTypeNamesPresent, biai) || (actionsForThisBIAI = biai.getActionsForTableItems(tableItems, this._node)).size() <= 0) continue;
                    if (separatorsSupported && addedActionsSinceLastSeparator) {
                        actionsList.add(null);
                        addedActionsSinceLastSeparator = false;
                    }
                    for (int i = 0; i < actionsForThisBIAI.size(); ++i) {
                        Action action = (Action)actionsForThisBIAI.get(i);
                        this.checkForContextActions(action);
                        actionsList.add(action);
                        addedActionsSinceLastSeparator = true;
                    }
                }
                if (upgradeShown) {
                    UpgradeLogicalObjectVersionAction upAction = new UpgradeLogicalObjectVersionAction(logicalObjects);
                    if (separatorsSupported && addedActionsSinceLastSeparator) {
                        actionsList.add(null);
                        addedActionsSinceLastSeparator = false;
                    }
                    actionsList.add((Action)upAction);
                    addedActionsSinceLastSeparator = true;
                }
                TypeInterface[] types = null;
                try {
                    types = LogicalTypesAndServicesAdapter.getInstance().getFactory().getTypesSupported();
                }
                catch (LogicalTypeException e) {
                    Workspace.getDefaultLogger().error((Object)("\n\nCouldn't load type dictionary. Cause: " + e.getLocalizedMessage()));
                }
                for (int i = 0; i < types.length; ++i) {
                    Action[] actions;
                    TypeInterface ti = types[i];
                    ObjectFactoryInterface ofi = ti.getObjectFactory();
                    if (ofi == null || (actions = ofi.getActions(logicalObjects, roots, null)) == null || actions.length <= 0) continue;
                    if (separatorsSupported && addedActionsSinceLastSeparator) {
                        actionsList.add(null);
                        addedActionsSinceLastSeparator = false;
                    }
                    for (int j = 0; j < actions.length; ++j) {
                        Action action = actions[j];
                        if (action == null) {
                            if (!separatorsSupported || !addedActionsSinceLastSeparator) continue;
                            actionsList.add(action);
                            addedActionsSinceLastSeparator = false;
                            continue;
                        }
                        actionsList.add(action);
                        addedActionsSinceLastSeparator = true;
                    }
                }
            } else if (tableItems.length == 1) {
                ElementInterface selectedItem = tableItems[0];
                if (selectedItem instanceof FolderItem) {
                    FolderItem fi = (FolderItem)selectedItem;
                    actionsList.add(new ActionOpen(fi));
                    if (separatorsSupported) {
                        actionsList.add(null);
                    }
                    actionsList.addAll(fi.getCorrespondingNode().constructActionList(separatorsSupported, true));
                } else if (selectedItem instanceof TableItem) {
                    Action action;
                    TableItem tableItem = (TableItem)selectedItem;
                    LogicalObjectInterface loi = tableItem.getLogicalObjectInterface();
                    TypeInterface ti = loi.getTypeInterface();
                    try {
                        Action renameAction;
                        Action deleteAction;
                        publicObjectsList.add(tableItem.getPublicObjectInterface());
                        if (selectedItem instanceof NonFolderContainerItem) {
                            NonFolderContainerItem nfci = (NonFolderContainerItem)selectedItem;
                            actionsList.add(new ActionOpen(nfci));
                            if (separatorsSupported) {
                                actionsList.add(null);
                            }
                        }
                        if (!ti.getPublicType().equals("FavoritesGroup")) {
                            ActionCopy copyAction = new ActionCopy(publicObjectsList);
                            actionsList.add(copyAction);
                            if (!CopyPasteManager.isCopyAllowed(publicObjectsList)) {
                                copyAction.setEnabled(false);
                            }
                            addedActionsSinceLastSeparator = true;
                            if (separatorsSupported && addedActionsSinceLastSeparator) {
                                actionsList.add(null);
                                addedActionsSinceLastSeparator = false;
                            }
                        }
                        if ((deleteAction = this.createDeleteAction(tableItem)) != null) {
                            actionsList.add(deleteAction);
                            addedActionsSinceLastSeparator = true;
                        }
                        if ((renameAction = this.createRenameAction(tableItem)) != null) {
                            actionsList.add(renameAction);
                            addedActionsSinceLastSeparator = true;
                        }
                    }
                    catch (Exception e) {
                        UtilGui.displayExceptionError((Exception)e);
                    }
                    ElementInterface[] eiArray = new ElementInterface[]{tableItem};
                    for (BIActionInterface biai : BIActionFactory.getBIActionInterfaces()) {
                        List actionsForThisBIAI;
                        if (!biai.getLogicalTypeNamesOfInterest().contains(loi.getTypeInterface().getPublicType()) || (actionsForThisBIAI = biai.getActionsForTableItems(tableItems, this._node)).size() <= 0) continue;
                        if (separatorsSupported && addedActionsSinceLastSeparator) {
                            actionsList.add(null);
                        }
                        for (int i = 0; i < actionsForThisBIAI.size(); ++i) {
                            action = (Action)actionsForThisBIAI.get(i);
                            this.checkForContextActions(action);
                            actionsList.add(action);
                        }
                        addedActionsSinceLastSeparator = true;
                    }
                    ObjectFactoryInterface ofi = ti.getObjectFactory();
                    if (ofi != null) {
                        Action[] actions = null;
                        try {
                            actions = ofi.getActions(loi, tableItem.getRoot(), null);
                        }
                        catch (Throwable t) {
                            Workspace.getDefaultLogger().error((Object)("\n\nCouldn't get actions for object. Cause: " + t.getLocalizedMessage()));
                        }
                        if (actions != null && actions.length > 0) {
                            if (separatorsSupported && addedActionsSinceLastSeparator) {
                                actionsList.add(null);
                            }
                            for (int j = 0; j < actions.length; ++j) {
                                action = actions[j];
                                this.checkForContextActions(action);
                                if (action == null) {
                                    if (!separatorsSupported) continue;
                                    actionsList.add(action);
                                    continue;
                                }
                                actionsList.add(action);
                            }
                            addedActionsSinceLastSeparator = true;
                        }
                    }
                    if (separatorsSupported && addedActionsSinceLastSeparator) {
                        actionsList.add(null);
                    }
                }
            } else if (this._node != null) {
                actionsList.addAll(this._node.constructActionList(false, false));
            }
            return actionsList;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    private Action createDeleteAction(TableItem tableItem) throws LogicalTypeException, RemoteException, ServiceException {
        LogicalObjectInterface parentLogicalObject;
        ObjectFactoryInterface objFactory;
        if (this._node != null && this._node.m_isFavorite && !this._node.getTypeName().equals("FavoritesGroup")) {
            return null;
        }
        LogicalObjectInterface loi = tableItem.getLogicalObjectInterface();
        NodeInterface parentNode = tableItem.getNode();
        if (parentNode instanceof NonFolderContainerNode && (objFactory = (parentLogicalObject = ((BIAbstractNode)parentNode).getLogicalObjectInterface()).getTypeInterface().getObjectFactory()) instanceof ContainerContextInterface) {
            ArrayList<LogicalObjectInterface> objects = new ArrayList<LogicalObjectInterface>(1);
            objects.add(loi);
            boolean isSupported = ((ContainerContextInterface)objFactory).isActionSupportedForMembers(ActionType.DELETE, parentLogicalObject, objects);
            if (!isSupported) {
                return null;
            }
        }
        ActionDelete deleteAction = new ActionDelete(new TableItem[]{tableItem});
        deleteAction.setEnabled(loi.isDeleteAllowed());
        return deleteAction;
    }

    private Action createDeleteAction(ElementInterface[] tableItems) throws LogicalTypeException, RemoteException, ServiceException {
        LogicalObjectInterface parentLogicalObject;
        ObjectFactoryInterface objFactory;
        if (tableItems == null || tableItems.length == 0) {
            return null;
        }
        if (this._node != null && this._node.m_isFavorite && !this._node.getTypeName().equals("FavoritesGroup")) {
            return null;
        }
        NodeInterface parentNode = ((TableItem)tableItems[0]).getNode();
        if (parentNode instanceof NonFolderContainerNode && (objFactory = (parentLogicalObject = ((BIAbstractNode)parentNode).getLogicalObjectInterface()).getTypeInterface().getObjectFactory()) instanceof ContainerContextInterface) {
            ArrayList<LogicalObjectInterface> objects = new ArrayList<LogicalObjectInterface>(1);
            for (int i = 0; i < tableItems.length; ++i) {
                objects.add(((TableItem)tableItems[i]).getLogicalObjectInterface());
            }
            boolean isSupported = ((ContainerContextInterface)objFactory).isActionSupportedForMembers(ActionType.DELETE, parentLogicalObject, objects);
            if (!isSupported) {
                return null;
            }
        }
        ActionDelete deleteAction = new ActionDelete(tableItems);
        return deleteAction;
    }

    private Action createRenameAction(TableItem tableItem) throws LogicalTypeException, RemoteException, ServiceException {
        LogicalObjectInterface parentLogicalObject;
        ObjectFactoryInterface objFactory;
        if (this._node != null && this._node.m_isFavorite && !this._node.getTypeName().equals("FavoritesGroup")) {
            return null;
        }
        LogicalObjectInterface loi = tableItem.getLogicalObjectInterface();
        NodeInterface parentNode = tableItem.getNode();
        if (parentNode instanceof NonFolderContainerNode && (objFactory = (parentLogicalObject = ((BIAbstractNode)parentNode).getLogicalObjectInterface()).getTypeInterface().getObjectFactory()) instanceof ContainerContextInterface) {
            ArrayList<LogicalObjectInterface> objects = new ArrayList<LogicalObjectInterface>(1);
            objects.add(loi);
            boolean isSupported = ((ContainerContextInterface)objFactory).isActionSupportedForMembers(ActionType.RENAME, parentLogicalObject, objects);
            if (!isSupported) {
                return null;
            }
        }
        ActionRename renameAction = new ActionRename(tableItem);
        renameAction.setEnabled(loi.isRenameAllowed());
        return renameAction;
    }

    private boolean doesActionSupportAllSelections(HashSet logicalTypeNamesPresent, BIActionInterface biai) {
        Set supportedLogicalTypeNames = biai.getLogicalTypeNamesOfInterest();
        return supportedLogicalTypeNames.containsAll(logicalTypeNamesPresent);
    }

    @Override
    public List getToolbarActions(int[] selectedRows) {
        ArrayList actionsList = new ArrayList(this.getItemSpecificActions(selectedRows, false));
        for (int i = 0; i < actionsList.size(); ++i) {
            AbstractAction aa = (AbstractAction)actionsList.get(i);
            if (!(aa instanceof ActionRename)) continue;
            actionsList.remove(i);
            break;
        }
        return actionsList;
    }

    @Override
    public List getContextMenuActions(int[] selectedRows) {
        List actionsList = this.getItemSpecificActions(selectedRows, true);
        return actionsList;
    }

    @Override
    public List getHeaderContextMenuActions() {
        return null;
    }

    @Override
    public List getRowHeaderContextMenuActions(int[] selectedRows) {
        return null;
    }

    protected void checkForContextActions(Action action) {
        String context;
        if (action != null && action instanceof ActionContextInterface && "FAVORITES_CONTEXT".equals(context = ((ActionContextInterface)action).getActionContext()) && this._node != null) {
            action.addPropertyChangeListener(this._node.new BIAbstractNode.FavoritesChangeListener());
        }
    }

    @Override
    public ElementInterface getElementInterface(int row) {
        TableItem item = (TableItem)this._itemsList.get(row);
        return item;
    }

    public ElementInterface[] getSelectedElements(int[] selectedRows) {
        ElementInterface[] selectedItems = new ElementInterface[selectedRows.length];
        if (!this._itemsList.isEmpty()) {
            for (int i = 0; i < selectedRows.length; ++i) {
                TableItem thisone = (TableItem)this._itemsList.get(selectedRows[i]);
                selectedItems[i] = thisone;
            }
        }
        return selectedItems;
    }

    @Override
    public boolean isInitiallyHidden() {
        return false;
    }

    @Override
    public Comparator getComparator() {
        int columnType = this.getColumnType();
        if (columnType == 1) {
            return _comparatorString;
        }
        if (columnType == 6) {
            return _comparatorDate;
        }
        return null;
    }
}

