/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.ConsoleChangeEvent;
import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.ActionPaste;
import com.sas.console.folderview.visuals.ActionPasteSpecial;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.BIActionFactory;
import com.sas.console.folderview.visuals.BIActionInterface;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.HomeFolderNode;
import com.sas.console.folderview.visuals.Images;
import com.sas.console.folderview.visuals.LogicalTypesAndServicesAdapter;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.RootFolderNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.CustomTableInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.visuals.MainConsole;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.unknown.UnknownLogicalObject;
import com.sas.metadata.logical.visuals.ActionNewFolder;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.visuals.CopyPasteManager;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.UsersFolderNode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public final class RootNode
extends BIAbstractNode
implements Comparable {
    private boolean _populateNodeCalledFromConsoleChangeEventContext;
    private FolderInterface _repositoryInterface;
    private Root _rootCopy;
    private SoftwareComponent _softwareComponent;
    private static MdObjectStore _primaryObjectStore;

    public RootNode(NodeInterface parent, String strName, ConsoleInterface console) {
        super(parent, strName);
        this.m_console = (MainConsole)console;
        this.m_console.addConsoleListener(this);
        this.setParent(parent);
    }

    @Override
    public Icon getIcon(int size) {
        return Images.getSASFoldersRootIcon();
    }

    @Override
    public int compareTo(Object o) {
        return FolderViewUtil.compare(this, o);
    }

    @Override
    public List getPropertyTabs() {
        ArrayList actionList = new ArrayList(0);
        if (this.m_console.getDefaultRepository() != null) {
            Config config = new Config();
            config.setInitValue(ConfigGeneralPanel.NAME, (Object)RB.getStringResource("ConfigGeneralPanel.SASFolders.txt"));
            config.setUserControlled(ConfigGeneralPanel.NAME);
            config.setEnabled(ConfigGeneralPanel.NAME, false);
            try {
                this.refreshObjectFromServer();
                LogicalObjectInterface rootLogicalObject = this.getLogicalObjectInterface();
                if (rootLogicalObject == null) {
                    return actionList;
                }
                this._rootCopy = (Root)UtilMetadata.createANewStoreAndGetObjectIntoIt((CMetadata)this._softwareComponent);
                actionList = (ArrayList)LogicalTypesAndServicesAdapter.getInstance().getFactory().getPropertyTabs(rootLogicalObject, this._rootCopy, config);
            }
            catch (RemoteException e) {
                Workspace.getDefaultLogger().debug((Object)e.getLocalizedMessage());
            }
            catch (MdException e) {
                Workspace.getDefaultLogger().debug((Object)e.getLocalizedMessage());
            }
        }
        return actionList;
    }

    private void updateLastUpdated() {
        FolderInterface rootLogicalObject = (FolderInterface)this.getLogicalObjectInterface();
        if (rootLogicalObject == null) {
            return;
        }
    }

    static MdObjectStore getPrimaryObjectStore() {
        return _primaryObjectStore;
    }

    @Override
    public LogicalObjectInterface getLogicalObjectInterface() {
        try {
            LogicalObjectInterface rootLogicalObject = LogicalTypesAndServicesAdapter.getInstance().convertToLogicalObject((Root)this.getSoftwareComponent());
            if (rootLogicalObject instanceof UnknownLogicalObject) {
                Workspace.getDefaultLogger().error((Object)"\n\n \"SAS Folders\" is not recognized as a logical object. Please run the \"Upgrade Metadata\" tool in the Metadata Manager plug-in. \n\n");
                return null;
            }
            this._repositoryInterface = (FolderInterface)rootLogicalObject;
        }
        catch (Exception re) {
            throw new RuntimeException("A logical object could not be retrieved for this object.", re.getCause());
        }
        return this._repositoryInterface;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.m_console.isConnected();
    }

    public SoftwareComponent getSoftwareComponent() {
        this._softwareComponent = null;
        try {
            this._softwareComponent = UtilMetadata.locateSoftwareComponent((String)UtilMetadata.getFoundationRepositoryID(), (MdObjectStore)_primaryObjectStore);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this._softwareComponent;
    }

    @Override
    protected List doConstructActionList(boolean separatorsSupported, boolean isNodeSelected) {
        boolean addedActionsSinceLastSeparator;
        try {
            if (this.getSoftwareComponent() == null || _primaryObjectStore == null || _primaryObjectStore.isDisposed()) {
                return new ArrayList(0);
            }
        }
        catch (RemoteException e1) {
            Workspace.getDefaultLogger().debug((Object)("RootNode:doConstructActionsList - " + e1.getLocalizedMessage()));
        }
        MainConsole frame = this.m_console;
        ArrayList<AbstractAction> actionsList = new ArrayList<AbstractAction>();
        try {
            if (CopyPasteManager.isPasteAllowed()) {
                boolean allowed = CopyPasteManager.isPasteAllowed((PublicObjectContainerInterface)this.m_containerNodeInterface);
                ActionPaste actPaste = new ActionPaste(this);
                actPaste.setEnabled(allowed);
                actionsList.add(actPaste);
                if (separatorsSupported) {
                    ActionPasteSpecial actPasteSpecial = new ActionPasteSpecial(this);
                    actionsList.add(actPasteSpecial);
                    actPasteSpecial.setEnabled(allowed);
                }
                if (separatorsSupported) {
                    actionsList.add(null);
                }
            }
        }
        catch (ServiceException allowed) {
        }
        catch (RemoteException allowed) {
            // empty catch block
        }
        FolderInterface rootLogicalObject = (FolderInterface)this.getLogicalObjectInterface();
        if (rootLogicalObject == null) {
            return actionsList;
        }
        ActionNewFolder newFolderAction = new ActionNewFolder(rootLogicalObject, (Frame)((Object)frame), LogicalTypesAndServicesAdapter.getInstance().getFactory(), null);
        newFolderAction.putValue("SmallIcon", (Object)Images.getNewFolderIcon16());
        try {
            newFolderAction.setEnabled(rootLogicalObject.isCreateChildAllowed());
        }
        catch (RemoteException actPasteSpecial) {
        }
        catch (LogicalTypeException actPasteSpecial) {
            // empty catch block
        }
        actionsList.add((AbstractAction)newFolderAction);
        boolean bl = addedActionsSinceLastSeparator = actionsList.size() > 0;
        if (separatorsSupported && addedActionsSinceLastSeparator) {
            actionsList.add(null);
        }
        for (BIActionInterface biai : BIActionFactory.getBIActionInterfaces()) {
            List actionsForThisBIAI = biai.getActionsForNode(this, isNodeSelected, this.getElementsOfInterestToBIActionInterface(biai));
            if (actionsForThisBIAI.size() <= 0) continue;
            actionsList.addAll(actionsForThisBIAI);
            if (!separatorsSupported) continue;
            actionsList.add(null);
        }
        return actionsList;
    }

    @Override
    public Root getMetadataObject() {
        if (this._rootCopy == null) {
            try {
                this._rootCopy = (Root)UtilMetadata.createANewStoreAndGetObjectIntoIt((CMetadata)this._softwareComponent);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (MdException e) {
                e.printStackTrace();
            }
        }
        return this._rootCopy;
    }

    private HomeFolderNode getHomeFolderNode() {
        HomeFolderNode homeFolderNode = null;
        for (int i = this._folderNodeList.size() - 1; i >= 0 && homeFolderNode == null; --i) {
            Object tempNode = this._folderNodeList.get(i);
            homeFolderNode = tempNode instanceof HomeFolderNode ? (HomeFolderNode)tempNode : null;
        }
        return homeFolderNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void populateNode(boolean populateFolders, boolean populateMembers) {
        if (_primaryObjectStore == null) {
            return;
        }
        boolean errorCondition = false;
        StringBuffer errorString = new StringBuffer();
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (populateFolders) {
                this.m_containerNodeInterface = this.m_view.getSASFoldersModel().getRootFolder();
                this.m_containerNodeInterface.refresh();
                List folderList = this.m_containerNodeInterface.getChildren();
                for (int i = 0; i < folderList.size(); ++i) {
                    ContainerNodeInterface folder = (ContainerNodeInterface)folderList.get(i);
                    if (folder instanceof UsersFolderNode && this.getHomeFolderNode() == null) {
                        try {
                            HomeFolderNode homeFolderNode = new HomeFolderNode(this, folder);
                            this._folderNodeList.add(homeFolderNode);
                            this._itemList.add(homeFolderNode.getItem());
                        }
                        catch (LogicalTypeException e) {
                            String userInfo = RB.getStringResource("HomeFolderNotFound.info.txt");
                            Workspace.getDefaultLogger().error((Object)("\n \n" + userInfo + " Reason: " + e.getLocalizedMessage()));
                        }
                        continue;
                    }
                    try {
                        RootFolderNode fn = new RootFolderNode(this, folder);
                        this._folderNodeList.add(fn);
                        this._itemList.add(fn.getItem());
                        continue;
                    }
                    catch (LogicalTypeException lte) {
                        errorCondition = true;
                        String specificFolderError = MessageFormat.format(RB.getStringResource("Folder.LoadFolderError.txt"), new String(folder.getName()));
                        errorString.append(specificFolderError + lte.getLocalizedMessage() + "\n\n");
                    }
                }
            }
            if (errorCondition) {
                String generalError = RB.getStringResource("Folder.LoadFolderError.General.txt");
                MessageUtil.displayDetailsMessage((String)generalError, (String)errorString.toString());
            }
            Collections.sort(this._folderNodeList);
            Collections.sort(this._itemList);
        }
        catch (ServiceException se) {
            if (!this._populateNodeCalledFromConsoleChangeEventContext) {
                UtilGui.displayError((String)se.getLocalizedMessage());
            }
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void refreshObjectFromServer() {
        try {
            this._softwareComponent = (SoftwareComponent)UtilMetadata.locateExistingObject((MdObjectStore)((MdObjectStore)this._softwareComponent.getObjectStore()), (String)"SoftwareComponent", (String)this._softwareComponent.getFQID());
            this.updateLastUpdated();
        }
        catch (Exception e) {
            UtilGui.displayExceptionError((Exception)e);
        }
    }

    @Override
    public void consoleChange(ConsoleChangeEvent event) {
        int eventType = event.getEventType();
        switch (eventType) {
            case 1: {
                if (this.m_view == null) break;
                this.m_view.initRootNode();
                break;
            }
            case 2: {
                try {
                    if (Workspace.getMdFactory().getOMIUtil().getRepositories().size() == 0) {
                        this.initialize();
                    }
                }
                catch (MdException mdException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            case 8: 
            case 9: {
                if (_viewBeingDisplayed == null) break;
                ((CustomTableInterface)((Object)_viewBeingDisplayed.getComponent())).saveSettings();
                _viewBeingDisplayed = null;
                break;
            }
            case 12: {
                LogicalTypesAndServicesAdapter.getInstance().clearObjectCache();
                CopyPasteManager.clearCopyList();
            }
        }
    }

    void initialize() {
        try {
            MdObjectStore storeToDiscard = _primaryObjectStore;
            if (this.m_console.isConnected() && this.m_console.getDefaultRepository() != null) {
                _primaryObjectStore = Workspace.getMdFactory().createObjectStore(null, "FolderViewStore");
            } else {
                _primaryObjectStore = null;
                this._softwareComponent = null;
                LogicalTypesAndServicesAdapter.getInstance().clearObjectCache();
            }
            Vector tempList = new Vector(1);
            tempList.addAll(this._folderNodeList);
            this._populateNodeCalledFromConsoleChangeEventContext = true;
            try {
                this.refresh();
            }
            finally {
                this._populateNodeCalledFromConsoleChangeEventContext = false;
            }
            Vector<IntObjPair> childList = new Vector<IntObjPair>(1);
            int newSize = this.getChildCount();
            if (newSize > 0) {
                for (int i = 0; i < newSize; ++i) {
                    IntObjPair childPair = new IntObjPair(i, this.getChildAt(i));
                    childList.add(childPair);
                }
            } else {
                for (int i = 0; i < tempList.size(); ++i) {
                    IntObjPair childPair = new IntObjPair(i, tempList.get(i));
                    childList.add(childPair);
                }
            }
            if (childList.size() > 0) {
                this.m_view.fireFolderViewChange(8, this, childList);
            }
            if (storeToDiscard != null) {
                storeToDiscard.dispose();
            }
            CopyPasteManager.clearCopyList();
            if (_viewBeingDisplayed != null) {
                ((CustomTableInterface)((Object)_viewBeingDisplayed.getComponent())).saveSettings();
                _viewBeingDisplayed = null;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    @Override
    protected void addElement(PublicObjectNodeInterface po) {
        throw new IllegalStateException("Logic error: should never be called.");
    }

    @Override
    public TableItem getItem() {
        return null;
    }
}

