/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.ConsoleInterface;
import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.folderview.visuals.FolderViewEvent;
import com.sas.console.folderview.visuals.FolderViewListener;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.visuals.MainConsole;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FolderTreeModel
extends DefaultTreeModel
implements FolderViewListener {
    private static final long serialVersionUID = 9200000001L;
    MainConsole m_console;
    ConsoleFolderView m_folderView;

    public FolderTreeModel(BIAbstractNode rootNode, ConsoleInterface console) {
        super(new DefaultMutableTreeNode(""));
        this.m_console = (MainConsole)console;
        this.m_folderView = (ConsoleFolderView)this.m_console.getConsoleView(1);
        this.m_folderView.addFolderViewListener(this);
        this.setRoot((RootNode)rootNode);
        this.setAsksAllowsChildren(true);
    }

    @Override
    public void folderViewChanged(FolderViewEvent evt) {
        int eventType = evt.getEventType();
        NodeInterface parent = evt.getParentNode();
        List childList = evt.getPairList();
        TreePath path = parent.getTreePath();
        int num = childList.size();
        Object[] children = new Object[num];
        int[] childIndex = new int[num];
        for (int i = 0; i < num; ++i) {
            IntObjPair ioPair = (IntObjPair)childList.get(i);
            childIndex[i] = ioPair.getIndex();
            children[i] = ioPair.getChild();
        }
        if (children.length > 0 && !(children[0] instanceof NodeInterface)) {
            return;
        }
        if (eventType == 2) {
            this.fireTreeNodesRemoved(this, path.getPath(), childIndex, children);
        } else if (eventType == 1) {
            this.fireTreeNodesInserted(this, path.getPath(), childIndex, children);
        } else if (eventType == 4) {
            this.fireTreeNodesChanged(this, path.getPath(), childIndex, children);
        } else if (eventType == 8) {
            this.fireTreeStructureChanged(this, path.getPath(), childIndex, children);
        }
    }
}

