/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.ImagesPromotion;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.utils.MnemonicModel;
import com.sas.metadata.promotion.visuals.ExportWizard;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.workspace.Workspace;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public final class ActionExport
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    private ArrayList<PublicObjectInterface> _selectedObjects;
    private Tree _tree;
    private SoftwareComponent _bipService;
    private String _title;
    private ContainerNodeInterface _container;

    public ActionExport(Tree tree) {
        this._tree = tree;
        this._initialize(RB.getStringResource("AE.Title.txt"));
    }

    public ActionExport(SoftwareComponent bipService) {
        this._bipService = bipService;
        this._initialize(RB.getStringResource("AE.Title.txt"));
    }

    public ActionExport(ContainerNodeInterface container) {
        this._container = container;
        this._initialize(RB.getStringResource("AE.Title.txt"));
    }

    ActionExport(ElementInterface[] eis) {
        this.getListOfItemsToExport(eis);
        this._initialize(RB.getStringResource("AE.Title.txt"));
    }

    private void getListOfItemsToExport(ElementInterface[] modelItems) {
        int length = modelItems.length;
        if (length == 1) {
            TableItem ti = (TableItem)modelItems[0];
            Root meta = ti.getRoot();
            try {
                if (meta.getCMetadataType().equals("Tree")) {
                    this._tree = (Tree)meta;
                    return;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return;
            }
        }
        this._selectedObjects = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            TableItem ti = (TableItem)modelItems[i];
            PublicObjectInterface poi = ti.getPublicObjectInterface();
            this._selectedObjects.add(poi);
        }
    }

    private void _initialize(String title) {
        this._title = title;
        MnemonicModel.setActionTextAndMnemonic(this, RB.getStringResource("AE.Name.txt"), this._title, ImagesPromotion.getExportIcon16());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ExportWizard wizard;
        if (this._selectedObjects != null) {
            wizard = new ExportWizard(this._selectedObjects, null, this._title);
        } else if (this._tree != null) {
            wizard = new ExportWizard(this._tree, null, this._title);
        } else if (this._bipService != null) {
            wizard = new ExportWizard(this._bipService, null, this._title);
        } else if (this._container != null) {
            wizard = new ExportWizard((PublicObjectContainerInterface)this._container, null, this._title);
        } else {
            return;
        }
        wizard.setDescription(RB.getStringResource("AE.Desc.txt"));
        wizard.show();
    }
}

