/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.folderview.visuals;

import com.sas.console.folderview.visuals.BIAbstractNode;
import com.sas.console.folderview.visuals.ConsoleFolderView;
import com.sas.console.folderview.visuals.ContainerItemInterface;
import com.sas.console.folderview.visuals.ElementItem;
import com.sas.console.folderview.visuals.FolderItem;
import com.sas.console.folderview.visuals.FolderNode;
import com.sas.console.folderview.visuals.FolderViewUtil;
import com.sas.console.folderview.visuals.NonFolderContainerItem;
import com.sas.console.folderview.visuals.NonFolderContainerNode;
import com.sas.console.folderview.visuals.RB;
import com.sas.console.folderview.visuals.RootNode;
import com.sas.console.folderview.visuals.TableItem;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.utils.FolderUtil;
import com.sas.console.utils.MnemonicModel;
import com.sas.console.visuals.ConsoleViewManager;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.visuals.AbstractOperationUserInteraction;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersModel;
import com.sas.services.information.sasfolders.SASFoldersModelInterface;
import com.sas.text.Message;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public final class ActionDelete
extends AbstractAction {
    private static final long serialVersionUID = 9200000001L;
    private Object[] _modelItems;
    BIAbstractNode m_parentNode;

    public ActionDelete(BIAbstractNode folderNode) {
        this();
        this._modelItems = new BIAbstractNode[]{folderNode};
    }

    public ActionDelete(Object[] modelItems) {
        this();
        this._modelItems = modelItems;
    }

    private ActionDelete() {
        WAdminResource bundle = FolderViewUtil.getMainConsoleResourceBundle();
        MnemonicModel.setActionTextAndMnemonic(this, bundle.getString("Common.DeleteAction.Name.txt"), bundle.getString("Common.DeleteAction.ShortDescription.txt"), Resources.getImageIcon((String)bundle.getString("Common.DeleteAction.Icon.image"), (int)16));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String message;
        final ArrayList deletedObjectsArray = new ArrayList(0);
        MdFactory mdFactory = Workspace.getMdFactory();
        MdFactoryListener factoryListener = new MdFactoryListener(){

            public void MdObjectsCreated(MdFactoryEvent e) throws RemoteException {
            }

            public void MdObjectsDeleted(MdFactoryEvent e) throws RemoteException {
                String[] objectIDArray = e.getObjectIDs();
                for (int i = 0; i < objectIDArray.length; ++i) {
                    deletedObjectsArray.add(objectIDArray[i]);
                }
            }

            public void MdObjectsModified(MdFactoryEvent e) throws RemoteException {
            }
        };
        try {
            mdFactory.addMdFactoryListener(factoryListener);
        }
        catch (RemoteException e1) {
            Workspace.getDefaultLogger().debug((Object)"Unable to create factory listener on delete action in folder view");
        }
        final ArrayList<Object> elementsToDelete = new ArrayList<Object>();
        final ArrayList<BIAbstractNode> containersToDelete = new ArrayList<BIAbstractNode>();
        int length = this._modelItems.length;
        for (int i = 0; i < length; ++i) {
            if (this._modelItems[i] instanceof ContainerItemInterface || this._modelItems[i] instanceof FolderNode || this._modelItems[i] instanceof NonFolderContainerNode) {
                BIAbstractNode node;
                if (this._modelItems[i] instanceof FolderItem) {
                    FolderItem fi = (FolderItem)this._modelItems[i];
                    node = fi.getCorrespondingNode();
                } else if (this._modelItems[i] instanceof NonFolderContainerItem) {
                    NonFolderContainerItem cn = (NonFolderContainerItem)this._modelItems[i];
                    node = cn.getCorrespondingNode();
                } else if (this._modelItems[i] instanceof FolderNode) {
                    node = (FolderNode)this._modelItems[i];
                    Root metadataObject = node.getItem().getRoot();
                    if (metadataObject instanceof Tree && FolderUtil.isSystemFolder((Tree)metadataObject)) {
                        String title;
                        String message2 = MessageFormat.format(RB.getStringResource("AD.SystemFolderWarning.txt"), new String(node.getName()));
                        int answer = MessageUtil.displayMessage((String)message2, (String)(title = RB.getStringResource("AD.SystemFolderWarning.Title.txt")), (int)2, (int)0);
                        if (answer != 0) continue;
                        containersToDelete.add(node);
                    }
                } else {
                    node = (NonFolderContainerNode)this._modelItems[i];
                }
                if (containersToDelete.indexOf(node) >= 0) continue;
                containersToDelete.add(node);
                continue;
            }
            if (!(this._modelItems[i] instanceof TableItem)) continue;
            elementsToDelete.add(this._modelItems[i]);
        }
        int numberOfItemsToDelete = containersToDelete.size() + elementsToDelete.size();
        if (numberOfItemsToDelete > 1) {
            message = Message.format((ResourceBundle)RB.getResources(), (String)"AD.DelItems.fmt.txt", (Object)new Integer(numberOfItemsToDelete));
        } else if (numberOfItemsToDelete == 1) {
            String name;
            if (containersToDelete.size() == 1) {
                name = ((BIAbstractNode)containersToDelete.get(0)).getItem().getName();
                message = Message.format((ResourceBundle)RB.getResources(), (String)"COM.DelDlgText.fmt.txt", (Object)name);
            } else {
                name = ((TableItem)elementsToDelete.get(0)).getName();
                message = Message.format((ResourceBundle)RB.getResources(), (String)"COM.DelDlgText.fmt.txt", (Object)name);
            }
        } else {
            return;
        }
        int promptAnswer = MessageUtil.displayMessage((String)message, (String)RB.getStringResource("COM.ConfDel.DlgTitle.txt"), (int)3, (int)0);
        if (promptAnswer != 0) {
            return;
        }
        final int numberOfItemsToDeleteF = numberOfItemsToDelete;
        final OpRequestUI orui = new OpRequestUI((Frame)Workspace.getWorkspace(), RB.getStringResource("AD.ProgDlg.Template.txt"), RB.getStringResource("AD.ProgDlg.DlgTitle.txt"));
        orui.execute(new Runnable(){

            @Override
            public void run() {
                BIAbstractNode parentNode = null;
                AbstractOperationUserInteraction oui = new AbstractOperationUserInteraction(){

                    public void updateProgress(String name) {
                        orui.setMessage(name);
                    }
                };
                int countOfElementsToDelete = elementsToDelete.size();
                for (int i = 0; i < countOfElementsToDelete; ++i) {
                    ElementItem ei = (ElementItem)elementsToDelete.get(i);
                    if (parentNode == null) {
                        parentNode = (BIAbstractNode)ei.getNode();
                    }
                    try {
                        if (deletedObjectsArray.contains(ei.getRoot().getFQID())) continue;
                        ei.deleteSelf((OperationUserInteractionInterface)oui);
                        continue;
                    }
                    catch (Exception e) {
                        LogicalObjectInterface loi = ei.getLogicalObjectInterface();
                        String itemName = loi.getName();
                        if (numberOfItemsToDeleteF == 1) {
                            String excpText = UtilMisc.getExceptionMessageText((Exception)e);
                            String messageText = UtilMisc.getMessage((String)RB.getStringResource("AD.ExcpOccurd1.fmt.txt"), (Object)loi.getTypeInterface().getDisplayType(), (Object)itemName, (Object)excpText);
                            MessageUtil.displayMessage((String)messageText, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0, (int)-1);
                            return;
                        }
                        if (oui.continueOperationWithPrompting()) {
                            String messageText = ActionDelete.getErrorMessage(parentNode, itemName, loi.getTypeInterface().getDisplayType(), e);
                            int choice = oui.displayMessage(RB.getStringResource("COM.ErrDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                            OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
                        }
                        if (!oui.isOperationCancelled()) continue;
                        return;
                    }
                }
                ArrayList<BIAbstractNode> topLevelFoldersThatWillBeDeleted = new ArrayList<BIAbstractNode>();
                Vector<IntObjPair> deleteChildList = new Vector<IntObjPair>();
                Vector<IntObjPair> restructureChildList = new Vector<IntObjPair>();
                for (BIAbstractNode containerNode : containersToDelete) {
                    int indexOfNode;
                    if (parentNode == null) {
                        parentNode = (BIAbstractNode)containerNode.getParent();
                    }
                    if ((indexOfNode = parentNode.getIndex(containerNode)) == -1) {
                        for (int i = 0; i < parentNode.getChildCount(); ++i) {
                            if (!((BIAbstractNode)parentNode._folderNodeList.get(i)).getName().equals(containerNode.m_name)) continue;
                            indexOfNode = i;
                            Workspace.getDefaultLogger().debug((Object)"internal error...my parent's child list did not include me");
                        }
                    }
                    IntObjPair ioPair = new IntObjPair(indexOfNode, containerNode);
                    LogicalObjectInterface loi = containerNode.getItem().getLogicalObjectInterface();
                    if (!deletedObjectsArray.contains(loi.getID())) {
                        try {
                            SASFoldersModelInterface folderModel = ((ConsoleFolderView)ConsoleViewManager.getView(1)).getSASFoldersModel();
                            PublicObjectNodeInterface publicObjectNode = ((SASFoldersModel)folderModel).getObject(loi.getID(), loi.getTypeInterface().getPublicType());
                            ((SASFoldersModel)folderModel).removeNodeFromParent(publicObjectNode);
                            if (loi.delete((OperationUserInteractionInterface)oui)) {
                                CopyPasteUtil.removeItemFromCopyList((SimpleLogicalObjectInterface)loi);
                                deleteChildList.add(ioPair);
                                topLevelFoldersThatWillBeDeleted.add(containerNode);
                            } else {
                                restructureChildList.add(ioPair);
                            }
                        }
                        catch (LogicalTypeException e) {
                            if (oui.continueOperationWithPrompting()) {
                                String messageText = ActionDelete.getErrorMessage(parentNode, loi.getName(), loi.getTypeInterface().getDisplayType(), (Exception)((Object)e));
                                int choice = oui.displayMessage(RB.getStringResource("COM.ErrDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
                            }
                        }
                        catch (RemoteException ex) {
                            Workspace.handleRemoteException((RemoteException)ex);
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!oui.isOperationCancelled()) continue;
                    break;
                }
                final BIAbstractNode parentNodeF = parentNode;
                ActionDelete.this.m_parentNode = parentNode;
                if (restructureChildList.size() > 0) {
                    final Vector<IntObjPair> restructureChildListF = restructureChildList;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ConsoleFolderView view = (ConsoleFolderView)ConsoleViewManager.getView(1);
                                view.fireFolderViewChange(8, parentNodeF, restructureChildListF);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                Iterator it = topLevelFoldersThatWillBeDeleted.iterator();
            }
        });
        deletedObjectsArray.clear();
        try {
            mdFactory.removeMdFactoryListener(factoryListener);
        }
        catch (RemoteException e1) {
            Workspace.getDefaultLogger().debug((Object)"Unable to remove factory listener on delete action in folder view");
        }
    }

    static String getErrorMessage(BIAbstractNode parent, String name, String type, Exception e) {
        String parentFolderName = ActionDelete.getParentFolderNameForErrorMessage(parent);
        String messageText = parentFolderName == null ? UtilMisc.getMessage((String)RB.getStringResource("AD.ExcpOccurd2.fmt.txt"), (Object)type, (Object)name, (Object)UtilMisc.getExceptionMessageText((Exception)e)) : UtilMisc.getMessage((String)RB.getStringResource("AD.ExcpOccurd3.fmt.txt"), (Object)type, (Object)name, (Object)parentFolderName, (Object)UtilMisc.getExceptionMessageText((Exception)e));
        return messageText;
    }

    private static String getParentFolderNameForErrorMessage(BIAbstractNode parent) {
        String parentFolderName = null;
        if (!(parent instanceof RootNode)) {
            FolderNode parentFolder = (FolderNode)parent;
            try {
                MetadataInterface mi = UtilPlatformServices.getSmartObject((Root)parentFolder.getTree());
                parentFolderName = mi.getPath(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parentFolderName;
    }
}

