/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.impl.ObjectFactoryException;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.impl.DISPromptLogFactory;
import com.sas.etl.models.prompts.impl.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinition;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.prompts.util.PromptContentHandler;
import com.sas.prompts.visuals.swing.designtime.PromptUtility;
import com.sas.prompts.visuals.swing.designtime.PropertiesCommunicator;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.MetadataDescriptorResolver;
import com.sas.services.information.metadata.prompt.OMRPromptGroup;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.UserInfoInterface;
import com.sas.util.ValueItem;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.IntegratedWritingContext;
import com.sas.util.xmlpersist.MetadataDescriptor;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import com.sas.workspace.Workspace;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PromptUtils {
    private static final int MAX_VARIABLE_NAME_LENGTH = 32;
    private static final char UNDERSCORE = '_';
    public static String COLUMN_PROMPT_ID = "DIS Data Source Column";
    public static String BOOLEAN_YES_NO_PROMPT_ID = "Boolean Yes/No";
    public static String BOOLEAN_TRUE_FALSE_PROMPT_ID = "Boolean True/False";
    public static final String YES = "Yes";
    public static final String NO = "No";
    public static final String TRUE = "True";
    public static final String FALSE = "False";
    private static DocumentBuilder _builder;
    private static SAXParser _parser;
    private static String KEEP_COLUMN_NEWLINE_TAB;
    private static final int MAXIMUM_MACRO_VALUE_LENGTH = 32000;
    private static long muchtime;
    private static String INDENT;

    public static PromptGroupInterface createPromptGroup() {
        com.sas.prompts.groups.PromptGroup promptGroup = new com.sas.prompts.groups.PromptGroup();
        promptGroup.setPromptGroupLabel(RB.getStringResource("PromptGroup.RootGroup.Name.txt"), Locale.getDefault());
        promptGroup.setPromptGroupDescription(RB.getStringResource("PromptGroup.RootGroup.Desc.txt"), Locale.getDefault());
        return promptGroup;
    }

    public static TextDefinition createBooleanDefinition(PropertiesCommunicator communicator, boolean trueFalse) {
        TextDefinition definition = null;
        definition = communicator != null ? (TextDefinition)PromptUtility.newConfiguredPrompt((PropertiesCommunicator)communicator, (String)"TextDefinition") : new TextDefinition();
        definition.setAllowMultipleLines(false);
        definition.setAllowUserValues(false);
        if (trueFalse) {
            definition.addUserInfo("Boolean Type", BOOLEAN_TRUE_FALSE_PROMPT_ID);
        } else {
            definition.addUserInfo("Boolean Type", BOOLEAN_YES_NO_PROMPT_ID);
        }
        return definition;
    }

    public static ValueProviderInterface getValueProviderForBooleanDefinition(TextDefinition definition) {
        UserInfoInterface info = definition.getUserInfo();
        if (info != null && BOOLEAN_YES_NO_PROMPT_ID.equals(info.get("Boolean Type"))) {
            return PromptUtils.getValueProviderForBooleanDefinition(false);
        }
        return PromptUtils.getValueProviderForBooleanDefinition(true);
    }

    public static ValueProviderInterface getValueProviderForBooleanDefinition(boolean trueFalse) {
        return PromptUtils.getValueProviderForBooleanDefinition(trueFalse, false);
    }

    public static ValueProviderInterface getValueProviderForBooleanDefinition(boolean trueFalse, boolean upcaseValues) {
        String[][] tValues = new String[2][2];
        StaticValueProvider sp = new StaticValueProvider();
        if (trueFalse) {
            tValues[0][0] = upcaseValues ? TRUE.toUpperCase() : TRUE;
            tValues[0][1] = RB.getStringResource("Common.True.txt");
            tValues[1][0] = upcaseValues ? FALSE.toUpperCase() : FALSE;
            tValues[1][1] = RB.getStringResource("Common.False.txt");
        } else {
            tValues[0][0] = upcaseValues ? YES.toUpperCase() : YES;
            tValues[0][1] = RB.getStringResource("Common.Yes.txt");
            tValues[1][0] = upcaseValues ? NO.toUpperCase() : NO;
            tValues[1][1] = RB.getStringResource("Common.No.txt");
        }
        if (tValues != null && tValues.length > 0) {
            ArrayList<ValueItem> valueList = new ArrayList<ValueItem>();
            int size = tValues.length;
            for (int i = 0; i < size; ++i) {
                String label = tValues[i][1];
                String value = tValues[i][0];
                ValueItem vItem = new ValueItem((Object)label, (Object)value);
                valueList.add(vItem);
            }
            sp.setValues(valueList, Locale.getDefault());
            sp.setValuesAsLabel(false);
        }
        return sp;
    }

    public static PromptsReadingContext getPromptReadingContext(UserContextInterface userContext) throws SAXException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        PromptsReadingContext rc = PersistenceFactoryWithServices.newReadingContext((UserContextInterface)userContext);
        HashMap<String, SAXParser> optionsMap = new HashMap<String, SAXParser>(1);
        optionsMap.put("_SAS_SAX_Parser", parser);
        rc.setOptionsMap(optionsMap);
        return rc;
    }

    public static PromptGroupInterface getPromptGroupFromFile(URL promptXMLUrl) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        return PromptUtils.getPromptGroupFromFile(Workspace.getWorkspace().getUserContext(), promptXMLUrl);
    }

    public static PromptGroupInterface combinePromptGroups(PromptGroupInterface pg1, PromptGroupInterface pg2) {
        PromptGroupInterface newPromptGroup = PromptUtils.copyPromptGroup(Workspace.getWorkspace().getUserContext(), pg1);
        List subGrps = pg2.getPromptSubgroups(false);
        int size = subGrps.size();
        for (int i = 0; i < size; ++i) {
            PromptGroupInterface sub = (PromptGroupInterface)subGrps.get(i);
            PromptGroupInterface foundGroup = PromptUtils.findSubGroup(newPromptGroup.getPromptSubgroups(true), sub.getPromptGroupLabel(Locale.US));
            if (foundGroup == null) {
                newPromptGroup.addPromptSubgroup(sub, newPromptGroup.getPromptSubgroups(false).size());
                continue;
            }
            foundGroup.addPromptDefinitions(sub.getPromptDefinitions(true));
        }
        return newPromptGroup;
    }

    private static PromptGroupInterface findSubGroup(List subgroups, String enLabel) {
        for (int i = 0; i < subgroups.size(); ++i) {
            PromptGroupInterface grp = (PromptGroupInterface)subgroups.get(i);
            if (!grp.getPromptGroupLabel(Locale.US).equals(enLabel)) continue;
            return grp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PromptGroupInterface getPromptGroupFromFile(UserContextInterface userContext, URL promptXMLURL) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        String encoding = "UTF-8";
        InputStream stream = null;
        com.sas.prompts.groups.PromptGroup prmptGroup = null;
        if (promptXMLURL != null) {
            stream = promptXMLURL.openStream();
        }
        if (stream != null) {
            try {
                BufferedReader bis = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                prmptGroup = (com.sas.prompts.groups.PromptGroup)PromptUtil.newObjectFromXML((Reader)bis, (LoggerFactoryInterface)DISPromptLogFactory.getInstance(), (PromptsReadingContext)PromptUtils.getPromptReadingContext(userContext));
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        return prmptGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PromptGroupInterface getPromptGroupFromString(UserContextInterface userContext, String promptXML) throws UnsupportedEncodingException, FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        String encoding = "UTF-8";
        InputStream stream = null;
        com.sas.prompts.groups.PromptGroup prmptGroup = null;
        if (promptXML != null && promptXML.length() > 0) {
            stream = new ByteArrayInputStream(promptXML.getBytes("UTF-8"));
        }
        if (stream != null) {
            try {
                BufferedReader bis = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                prmptGroup = (com.sas.prompts.groups.PromptGroup)PromptUtil.newObjectFromXML((Reader)bis, (LoggerFactoryInterface)DISPromptLogFactory.getInstance(), (PromptsReadingContext)PromptUtils.getPromptReadingContext(userContext));
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        return prmptGroup;
    }

    public static StringBuffer getXMLForObject(PersistenceInterface obj, Map options) throws ParserConfigurationException, BackingStoreException {
        Document doc = PromptUtils.newDocument();
        PromptsWritingContext writingContext = PersistenceFactory.newWritingContext((PersistenceInterface)obj, null);
        if (options != null) {
            writingContext.setOptionsMap(options);
        }
        Element element = obj.write((Node)doc, (IntegratedWritingContext)writingContext);
        PersistHelper.removeUnreferencedPersistenceIDs((Element)element, (PromptsWritingContext)writingContext);
        StringBuffer outputBuffer = new StringBuffer();
        XmlUtil.serializeNode((Node)doc, (StringBuffer)outputBuffer, (boolean)true);
        return outputBuffer;
    }

    protected static final Document newDocument() throws ParserConfigurationException {
        if (_builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            _builder = factory.newDocumentBuilder();
        }
        return _builder.newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PathUrl getURL(UserContextInterface userContext, String url) throws MdException, RemoteException {
        PathUrl pathurl;
        block6: {
            pathurl = null;
            try {
                if (url.startsWith("SBIP")) {
                    pathurl = new PathUrl(url);
                    break block6;
                }
                ServerInterface authServer = userContext.getAuthServer();
                ChildServerInterface childServer = authServer.newChild(true);
                try {
                    pathurl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)childServer, (String)url);
                }
                finally {
                    childServer.destroy();
                }
            }
            catch (ServiceException exc) {
                throw new MdException((Throwable)exc);
            }
        }
        return pathurl;
    }

    public static IOMRPersistable getObjectByURL(UserContextInterface userContext, IModel model, String url) throws MdException, RemoteException {
        PathUrl pathurl = PromptUtils.getURL(userContext, url);
        return pathurl != null ? PromptUtils.getObjectByURL(userContext, model, pathurl) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOMRPersistable getObjectByURL(UserContextInterface userContext, IModel model, PathUrl url) throws MdException, RemoteException {
        IOMRPersistable root;
        block10: {
            root = null;
            try {
                ServerInterface server = userContext.getAuthServer();
                ChildServerInterface transaction = server.newChild(true);
                try {
                    MetadataInterface mI = transaction.getObjectByPath(url);
                    if (mI == null || !(mI.getRepositoryEntity() instanceof Root)) break block10;
                    Root repositoryObject = (Root)mI.getRepositoryEntity();
                    String fqid = mI.getReposId();
                    root = (IOMRPersistable)((Object)model.getObject(fqid));
                    if (root != null) break block10;
                    boolean undo = model.isUndoSupported();
                    model.setUndoSupported(false);
                    OMRAdapter omr = new OMRAdapter(model, repositoryObject.getObjectStore().getFactory(), "PromptUtils: Adapter");
                    try {
                        Root mdObject = omr.acquireOMRObject(fqid, repositoryObject.getCMetadataType());
                        try {
                            root = omr.acquireObjectUsingTemplate(mdObject);
                        }
                        catch (ObjectFactoryException objectFactoryException) {
                            // empty catch block
                        }
                    }
                    finally {
                        omr.dispose();
                        model.setUndoSupported(undo);
                    }
                }
                finally {
                    transaction.destroy();
                }
            }
            catch (ServiceException exc) {
                throw new MdException((Throwable)exc);
            }
        }
        return root;
    }

    public static String getValidOMRObjectName(String name) {
        String str = name;
        StringBuffer buf = new StringBuffer();
        int stopIndex = 32;
        if (Character.isDigit(str.charAt(0))) {
            buf.append('_');
            stopIndex = 31;
        }
        for (int i = 0; i < str.length() && i < stopIndex; ++i) {
            char x = str.charAt(i);
            if (x == '/' || x == '\\' || x == '%') {
                buf.append('_');
                continue;
            }
            buf.append(x);
        }
        String current = buf.toString().trim();
        return current;
    }

    private static SAXParser getParser() throws SAXException, ParserConfigurationException {
        if (_parser == null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            _parser = factory.newSAXParser();
        }
        _parser.reset();
        return _parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectForXML(UserContextInterface userContext, String xml) throws SAXException, IOException, ParserConfigurationException {
        String encoding = "UTF-8";
        PersistenceInterface obj = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            PromptsReadingContext rc = PromptUtils.getPromptReadingContext(userContext);
            SAXParser parser = PromptUtils.getParser();
            InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF-8");
            PromptContentHandler handler = PromptContentHandler.newHandler2((LoggerFactoryInterface)DISPromptLogFactory.getInstance(), (PromptsReadingContext)rc);
            InputSource source = new InputSource(reader);
            parser.parse(source, (DefaultHandler)handler);
            ((InputStream)stream).reset();
            reader = new InputStreamReader((InputStream)stream, "UTF-8");
            obj = PromptUtil.newObjectFromXML((Reader)reader, (LoggerFactoryInterface)DISPromptLogFactory.getInstance(), (PromptsReadingContext)rc);
        }
        return obj;
    }

    public static OMRPromptGroupInterface savePromptGroupToMetadataObject(UserContextInterface userContext, String newPromptGroupId, PromptGroupInterface promptGroup, Root meta) throws RemoteException, MdException {
        OMRPromptGroupInterface promptSmartObject = null;
        try {
            promptSmartObject = PromptUtils.getPromptGroupSmartObject(userContext, meta);
            if (promptSmartObject == null) {
                promptSmartObject = PromptUtils.createPromptGroupSmartObject(userContext, newPromptGroupId, meta, promptGroup);
            }
            PromptsWritingContext writingContext = PersistenceFactory.newWritingContext((PersistenceInterface)promptGroup, (LoggerFactoryInterface)DISPromptLogFactory.getInstance());
            promptSmartObject = PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)promptGroup, (UserContextInterface)userContext, (OMRPromptGroupInterface)promptSmartObject, (PromptsWritingContext)writingContext);
            List descs = writingContext.getMetadataDescriptors();
            if (!descs.isEmpty()) {
                PromptUtils.updateValueSourcesClassifier((PromptGroup)promptSmartObject.getRepositoryEntity());
                for (MetadataDescriptor descriptor : descs) {
                    MetadataInterface out = MetadataDescriptorResolver.resolve((MetadataDescriptor)descriptor, (UserContextInterface)userContext);
                    if (null == out) continue;
                    promptSmartObject.addValueSource(out);
                }
            }
            if (promptSmartObject.getRepositoryEntity() instanceof PromptGroup) {
                PromptGroup jomaPG = (PromptGroup)promptSmartObject.getRepositoryEntity();
                jomaPG.setUsageVersion(OMRPromptGroup.CURRENT_VERSION.encode());
                jomaPG.setPublicType("Embedded:PromptGroup");
            }
        }
        catch (ServiceException e) {
            throw new MdException((Throwable)e);
        }
        return promptSmartObject;
    }

    public static PromptGroupInterface getPromptGroupFromMetadataObject(UserContextInterface userContext, Root meta) throws RemoteException, MdException {
        com.sas.prompts.groups.PromptGroup promptGroup = null;
        try {
            PromptGroup p = PromptUtils.getJOMAPromptGroupObject(meta);
            if (p != null) {
                promptGroup = (com.sas.prompts.groups.PromptGroup)PromptUtils.getObjectForXML(userContext, p.getGroupInfo());
            }
        }
        catch (SAXException e) {
            throw new MdException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MdException((Throwable)e);
        }
        catch (IOException e) {
            throw new MdException((Throwable)e);
        }
        return promptGroup;
    }

    public static PromptGroup getJOMAPromptGroupObject(Root meta) throws MdException, RemoteException {
        CMetadata promptMeta;
        PromptGroup promptGroup = null;
        AssociationList pList = meta.getPrompts();
        if (!pList.isEmpty() && (promptMeta = (CMetadata)meta.getPrompts().get(0)) instanceof PromptGroup) {
            promptGroup = (PromptGroup)promptMeta;
        }
        return promptGroup;
    }

    public static OMRPromptGroupInterface getPromptGroupSmartObject(UserContextInterface userContext, Root meta) throws MdException, RemoteException, ServiceException {
        OMRPromptGroup promptGroup = null;
        PromptGroup jomaPromptGroup = PromptUtils.getJOMAPromptGroupObject(meta);
        if (jomaPromptGroup != null) {
            promptGroup = new OMRPromptGroup(jomaPromptGroup);
            RepositoryInterface grpRepos = promptGroup.getRepository();
            ServerInterface server = null;
            server = grpRepos == null ? userContext.getAuthServer() : promptGroup.getRepository().getServer();
            RepositoryInterface repos = server.getRepository(server.getRepositoryName("A0000001." + meta.getRepositoryID()));
            promptGroup.setRepository(repos);
        }
        return promptGroup;
    }

    private static void updateValueSourcesClassifier(PromptGroup jomaPromptGroup) throws RemoteException, MdException {
        Transformation trans = jomaPromptGroup.getValueSource();
        if (trans == null) {
            trans = (Transformation)jomaPromptGroup.getObjectStore().getFactory().createComplexMetadataObject((MdObjectStore)jomaPromptGroup.getObjectStore(), jomaPromptGroup.getName(), "ClassifierMap", jomaPromptGroup.getRepositoryID());
            jomaPromptGroup.setValueSource(trans);
        }
    }

    public static OMRPromptGroupInterface createPromptGroupSmartObject(UserContextInterface userContext, String newPromptGroupId, Root meta, PromptGroupInterface group) throws MdException, RemoteException, ServiceException {
        OMRPromptGroupInterface promptGroup = PromptUtils.getPromptGroupSmartObject(userContext, meta);
        if (promptGroup == null) {
            PromptGroup jomaPG = (PromptGroup)meta.getObjectStore().getFactory().createComplexMetadataObject((MdObjectStore)meta.getObjectStore(), group.getPromptGroupLabel(Locale.getDefault()), "PromptGroup", newPromptGroupId);
            jomaPG.setUsageVersion(OMRPromptGroup.CURRENT_VERSION.encode());
            jomaPG.setPublicType("Embedded:PromptGroup");
            meta.getPrompts().clear();
            meta.getPrompts().add((Object)jomaPG);
            promptGroup = PromptUtils.getPromptGroupSmartObject(userContext, meta);
        }
        return promptGroup;
    }

    public static StringBuffer getTablePercentLetStatements(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table, boolean genKeepMacro, ITransformTableOptions transformTableOptions, IMapping[] targetMappings, boolean generateMappingMacros) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException, ServerException, BadServerDefinitionException {
        return PromptUtils.getTablePercentLetStatements(codeSegment, macroPrefix, table, genKeepMacro, transformTableOptions, targetMappings, generateMappingMacros, true);
    }

    public static StringBuffer getTablePercentLetStatements(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table, boolean genKeepMacro, ITransformTableOptions transformTableOptions, IMapping[] targetMappings, boolean generateMappingMacros, boolean colMacroVars) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException, ServerException, BadServerDefinitionException {
        StringBuffer code = new StringBuffer();
        code.append(PromptUtils.getPhysicalTableNameMacroCode(codeSegment, macroPrefix, table));
        if (colMacroVars) {
            code.append(PromptUtils.getExplicitSQLMacroCode(codeSegment, macroPrefix, table != null ? table.getClientLibrary(codeSegment) : null)).append(PromptUtils.getDataTypeMacroCode(macroPrefix, table)).append(PromptUtils.getTableOptionMacroCode(codeSegment, macroPrefix, table, transformTableOptions)).append(PromptUtils.getPhysicalTableURLandType(codeSegment, macroPrefix, table));
        }
        if (genKeepMacro) {
            code.append(PromptUtils.getTableKeepLetStatement(codeSegment, macroPrefix, table));
            if (colMacroVars && generateMappingMacros) {
                code.append(PromptUtils.getTableColumnStatement(codeSegment, macroPrefix, table, targetMappings));
            }
        }
        return code;
    }

    public static StringBuffer getExplicitSQLMacroCode(ICodeSegment codeSegment, String macroPrefix, ILibrary lib) throws RemoteException, MdException, CodegenException {
        StringBuffer code = new StringBuffer();
        code.append("%let ").append(macroPrefix).append("_connect = ");
        if (lib != null) {
            code.append(lib.getDBMSType().getConnect(codeSegment, lib));
        }
        code.append(";\n");
        code.append("%let ").append(macroPrefix).append("_engine = ");
        if (lib != null) {
            code.append(lib.getEngine());
        }
        code.append(";\n");
        return code;
    }

    public static Map<String, String> getExplicitSQLMacroCodeMap(ICodeSegment codeSegment, String macroPrefix, ILibrary lib) throws RemoteException, MdException, CodegenException {
        HashMap<String, String> code = new HashMap<String, String>();
        StringBuffer connectStringBuffer = null;
        if (lib != null) {
            connectStringBuffer = lib.getDBMSType().getConnect(codeSegment, lib);
        }
        code.put(macroPrefix + "_connect", connectStringBuffer != null ? connectStringBuffer.toString() : "");
        code.put(macroPrefix + "_engine", lib != null ? lib.getEngine() : "");
        return code;
    }

    public static Map<String, String> getTablePercentLetStatementsMap(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table, boolean genKeepMacro, ITransformTableOptions transformTableOptions, IMapping[] targetMappings, boolean generateMappingMacros, boolean colMacroVars) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException, ServerException, BadServerDefinitionException {
        HashMap<String, String> code = new HashMap<String, String>();
        code.putAll(PromptUtils.getPhysicalTableNameMacroCodeValues(codeSegment, macroPrefix, table));
        if (colMacroVars) {
            code.putAll(PromptUtils.getExplicitSQLMacroCodeMap(codeSegment, macroPrefix, table != null ? table.getClientLibrary(codeSegment) : null));
            code.putAll(PromptUtils.getDataTypeMacroCodeMap(macroPrefix, table));
            code.putAll(PromptUtils.getTableOptionMacroCodeMap(codeSegment, macroPrefix, table, transformTableOptions));
            code.putAll(PromptUtils.getPhysicalTableURLandTypeMap(codeSegment, macroPrefix, table));
        }
        if (genKeepMacro) {
            code.putAll(PromptUtils.getTableKeepLetStatementMap(codeSegment, macroPrefix, table));
            if (colMacroVars && generateMappingMacros) {
                code.putAll(PromptUtils.getTableColumnStatementMap(codeSegment, macroPrefix, table, targetMappings));
            }
        }
        return code;
    }

    public static StringBuffer getTableColumnStatement(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable target, IMapping[] targetMappings) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException, BadServerDefinitionException, ServerException {
        StringBuffer code = new StringBuffer();
        IColumn[] targetColumns = target != null ? target.getColumns() : new IColumn[]{};
        code.append("%let ").append(macroPrefix).append("_col_count = ").append(targetColumns.length).append(";\n");
        for (int i = 0; i < targetColumns.length; ++i) {
            IColumn targetColumn = targetColumns[i];
            String columnPrefix = "_col" + i;
            code.append("%let ").append(macroPrefix).append(columnPrefix).append("_name = ").append(targetColumn.getColumnName(codeSegment)).append(";\n");
            code.append(PromptUtils.getPhysicalTableNameMacroCode(codeSegment, macroPrefix + columnPrefix + "_table", target));
            if (targetMappings == null) continue;
            code.append("%let ").append(macroPrefix).append(columnPrefix).append("_length = ").append(targetColumn.getLength()).append(";\n");
            code.append("%let ").append(macroPrefix).append(columnPrefix).append("_type = ").append(targetColumn.getType() == 0 ? "$" : "").append(";\n");
            code.append("%let ").append(macroPrefix).append(columnPrefix).append("_format = ").append(targetColumn.getValidFormat()).append(";\n");
            code.append("%let ").append(macroPrefix).append(columnPrefix).append("_informat = ").append(targetColumn.getValidInformat()).append(";\n");
            code.append("%let ").append(macroPrefix).append(columnPrefix).append("_label = %nrquote(").append(codeSegment.getEscapedMacroValue(targetColumn.getDescription())).append(");\n");
            IColumn[] sources = null;
            int inputCount = 0;
            String exp = "";
            for (int j = 0; j < targetMappings.length; ++j) {
                if (!targetMappings[j].containsInTargets(targetColumn)) continue;
                sources = targetMappings[j].getSources();
                inputCount = sources.length;
                IExpression expression = targetMappings[j].getExpression();
                if ("DERIVED".equals(targetMappings[j].getType()) && expression != null) {
                    exp = expression.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting(), false);
                }
                for (int k = 0; k < sources.length; ++k) {
                    code.append("%let ").append(macroPrefix).append(columnPrefix).append("_input").append(k).append(" = ").append(sources[k].getColumnName(codeSegment)).append(";\n");
                    code.append("%let ").append(macroPrefix).append(columnPrefix).append("_input").append(k).append("_table").append(" = ").append(sources[k].getTable().getFullNameQuotedAsNeeded(codeSegment)).append(";\n");
                }
                break;
            }
            code.append("%let ").append(macroPrefix).append(columnPrefix).append("_exp = ").append(exp).append(";\n");
            code.append(PromptUtils.getLongColumnLetStatement(macroPrefix + columnPrefix + "_input", null, codeSegment, sources));
            code.append("%let ").append(macroPrefix).append(columnPrefix).append("_input_count = ").append(inputCount).append(";\n");
        }
        return code;
    }

    public static Map<String, String> getTableColumnStatementMap(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable target, IMapping[] targetMappings) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException, BadServerDefinitionException, ServerException {
        HashMap<String, String> code = new HashMap<String, String>();
        IColumn[] targetColumns = target != null ? target.getColumns() : new IColumn[]{};
        code.put(macroPrefix + "_col_count", Integer.toString(targetColumns.length));
        for (int i = 0; i < targetColumns.length; ++i) {
            IColumn targetColumn = targetColumns[i];
            String columnPrefix = "_col" + i;
            code.put(macroPrefix + columnPrefix + "_name", targetColumn.getColumnName(codeSegment));
            code.putAll(PromptUtils.getPhysicalTableNameMacroCodeValues(codeSegment, macroPrefix + columnPrefix + "_table", target));
            if (targetMappings == null) continue;
            code.put(macroPrefix + columnPrefix + "_length", Integer.toString(targetColumn.getLength()));
            code.put(macroPrefix + columnPrefix + "_type", targetColumn.getType() == 0 ? "$" : "");
            code.put(macroPrefix + columnPrefix + "_format", targetColumn.getValidFormat());
            code.put(macroPrefix + columnPrefix + "_informat", targetColumn.getValidInformat());
            code.put(macroPrefix + columnPrefix + "_label", "%nrquote(" + codeSegment.getEscapedMacroValue(targetColumn.getDescription()) + ")");
            IColumn[] sources = null;
            int inputCount = 0;
            String exp = "";
            for (int j = 0; j < targetMappings.length; ++j) {
                if (!targetMappings[j].containsInTargets(targetColumn)) continue;
                sources = targetMappings[j].getSources();
                inputCount = sources.length;
                IExpression expression = targetMappings[j].getExpression();
                if ("DERIVED".equals(targetMappings[j].getType()) && expression != null) {
                    exp = expression.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting(), false);
                }
                for (int k = 0; k < sources.length; ++k) {
                    code.put(macroPrefix + columnPrefix + "_input" + Integer.toString(k), sources[k].getColumnName(codeSegment));
                    code.put(macroPrefix + columnPrefix + "_input" + Integer.toString(k) + "_table", sources[k].getTable().getFullNameQuotedAsNeeded(codeSegment));
                }
                break;
            }
            code.put(macroPrefix + columnPrefix + "_exp", exp);
            code.putAll(PromptUtils.getLongColumnLetStatementMap(macroPrefix + columnPrefix + "_input", null, codeSegment, sources));
            code.put(macroPrefix + columnPrefix + "_input_count", Integer.toString(inputCount));
        }
        return code;
    }

    public static Map<String, String> getTableKeepLetStatementMap(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException {
        if (table != null) {
            return PromptUtils.getLongColumnLetStatementMap(macroPrefix + "_keep", RB.getStringResource("PromptUtils.Keep.comment.txt"), codeSegment, table.getColumns());
        }
        return new HashMap<String, String>();
    }

    public static StringBuffer getTableKeepLetStatement(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException {
        if (table != null) {
            return PromptUtils.getTableKeepLetStatement(codeSegment, macroPrefix, table.getColumns());
        }
        return new StringBuffer();
    }

    public static StringBuffer getTableKeepLetStatement(ICodeSegment codeSegment, String macroPrefix, IColumn[] tableColumns) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException {
        return PromptUtils.getTableKeepLetStatement(codeSegment, macroPrefix, "_keep", tableColumns);
    }

    public static StringBuffer getTableKeepLetStatement(ICodeSegment codeSegment, String macroPrefix, String keepSuffix, IColumn[] tableColumns) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException {
        return PromptUtils.getLongColumnLetStatement(macroPrefix + keepSuffix, RB.getStringResource("PromptUtils.Keep.comment.txt"), codeSegment, tableColumns);
    }

    public static StringBuffer getLongColumnLetStatement(String macroName, String comment, ICodeSegment codeSegment, IColumn[] tableColumns) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException {
        StringBuffer code = new StringBuffer();
        if (tableColumns == null || tableColumns.length == 0) {
            return code;
        }
        String columns = codeSegment.makeColumnList(tableColumns, KEEP_COLUMN_NEWLINE_TAB, codeSegment.isQuoting(), " ");
        if (columns != null && columns.length() > 32000) {
            int i;
            columns = columns.replaceAll(KEEP_COLUMN_NEWLINE_TAB, "");
            List<String> lines = codeSegment.splitString(columns, 32000, false);
            int lineSize = lines.size();
            code.append("%let etls_svserror=;\n");
            code.append("data _null_;\n");
            for (i = 0; i < lineSize; ++i) {
                code.append("   ").append("if symexist('etls_").append(macroName).append(Integer.toString(i)).append("') then call symdel('etls_").append(macroName).append(Integer.toString(i)).append("');\n");
            }
            code.append("call symput('etls_svserror',getoption('serror'));\n").append("run;\n\n").append("options noserror;\n");
            if (comment != null && comment.length() > 0) {
                code.append(codeSegment.makeComment(comment));
            }
            code.append("%let ").append(macroName).append(" = ");
            for (i = 0; i < lineSize; ++i) {
                code.append("&etls_").append(macroName).append(Integer.toString(i));
                if (i >= lineSize - 1) continue;
                code.append(" ");
            }
            code.append(";\n\n");
            for (i = 0; i < lineSize; ++i) {
                code.append("%let etls_").append(macroName).append(Integer.toString(i)).append(" = ").append(lines.get(i).toString()).append(";\n");
            }
            code.append("options &etls_svserror;\n\n");
        } else {
            if (comment != null && comment.length() > 0) {
                code.append(codeSegment.makeComment(comment));
            }
            code.append("%let ").append(macroName).append(" = ").append(columns.trim()).append(";\n");
        }
        return code;
    }

    public static Map<String, String> getLongColumnLetStatementMap(String macroName, String comment, ICodeSegment codeSegment, IColumn[] tableColumns) throws MdException, RemoteException, BadLibraryDefinitionException, CodegenException {
        HashMap<String, String> code = new HashMap<String, String>();
        if (tableColumns == null || tableColumns.length == 0) {
            return code;
        }
        String columns = codeSegment.makeColumnList(tableColumns, KEEP_COLUMN_NEWLINE_TAB, codeSegment.isQuoting(), " ");
        code.put(macroName, columns.trim());
        return code;
    }

    public static StringBuffer getPhysicalTableURLandType(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table) throws MdException {
        StringBuffer code = new StringBuffer();
        code.append("%let ").append(macroPrefix).append("_path = ");
        if (table != null) {
            code.append("%nrquote(").append(codeSegment.getEscapedMacroValue(table.getSBIPUrl())).append(")");
        }
        code.append(";\n");
        code.append("%let ").append(macroPrefix).append("_type = ");
        code.append(1L);
        code.append(";\n");
        code.append("%let ").append(macroPrefix).append("_label = %nrquote(");
        if (table != null) {
            code.append(codeSegment.getEscapedMacroValue(table.getDescription()));
        }
        code.append(");\n");
        return code;
    }

    public static Map<String, String> getPhysicalTableURLandTypeMap(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table) throws MdException {
        HashMap<String, String> code = new HashMap<String, String>();
        code.put(macroPrefix + "_path", table != null ? "%nrquote(" + codeSegment.getEscapedMacroValue(table.getSBIPUrl()) + ")" : "");
        code.put(macroPrefix + "_type", Long.toString(1L));
        code.put(macroPrefix + "_label", table != null ? codeSegment.getEscapedMacroValue(table.getDescription()) : "");
        return code;
    }

    public static StringBuffer getPhysicalTableNameMacroCode(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        StringBuffer code = new StringBuffer();
        if (table != null && table.isQuoted() && !codeSegment.isQuoting()) {
            codeSegment.genValidvarnameOptionAny(true);
            codeSegment.setQuoting(true);
        }
        code.append("%let ").append(macroPrefix).append(" = ");
        if (table != null) {
            code.append(table.getFullNameQuotedAsNeeded(codeSegment));
        }
        code.append(";\n");
        return code;
    }

    public static Map<String, String> getPhysicalTableNameMacroCodeValues(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table) throws CodegenException, BadLibraryDefinitionException {
        HashMap<String, String> code = new HashMap<String, String>();
        code.put(macroPrefix, table != null ? table.getFullNameQuotedAsNeeded(codeSegment) : "");
        return code;
    }

    public static StringBuffer getDataTypeMacroCode(String macroPrefix, IPhysicalTable table) {
        StringBuffer code = new StringBuffer();
        code.append("%let ").append(macroPrefix).append("_memtype = ");
        if (table != null) {
            code.append(table.isView() ? "VIEW" : "DATA");
        }
        code.append(";\n");
        return code;
    }

    public static Map<String, String> getDataTypeMacroCodeMap(String macroPrefix, IPhysicalTable table) {
        HashMap<String, String> code = new HashMap<String, String>();
        code.put(macroPrefix + "_memtype", table != null ? (table.isView() ? "VIEW" : "DATA") : "");
        return code;
    }

    public static StringBuffer getTableOptionMacroCode(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table, ITransformTableOptions transformTableOptions) {
        StringBuffer code = new StringBuffer();
        String tableOptions = "";
        if (transformTableOptions != null) {
            tableOptions = transformTableOptions.getTableOptions(false, null);
        } else if (table != null) {
            tableOptions = table.getTableOptions(false);
        }
        code.append("%let ").append(macroPrefix).append("_options = %nrquote(").append(codeSegment.getEscapedMacroValue(tableOptions)).append(");\n");
        code.append("%let ").append(macroPrefix).append("_alter = %nrquote(").append(codeSegment.getEscapedMacroValue(codeSegment.parsePasswordOption(tableOptions, ICodeSegment.ALTER_PASSWORD_PATTERN))).append(");\n");
        return code;
    }

    public static Map<String, String> getTableOptionMacroCodeMap(ICodeSegment codeSegment, String macroPrefix, IPhysicalTable table, ITransformTableOptions transformTableOptions) {
        HashMap<String, String> code = new HashMap<String, String>();
        String tableOptions = "";
        if (transformTableOptions != null) {
            tableOptions = transformTableOptions.getTableOptions(false, null);
        } else if (table != null) {
            tableOptions = table.getTableOptions(false);
        }
        code.put(macroPrefix + "_options", "%nrquote(" + codeSegment.getEscapedMacroValue(tableOptions) + ")");
        code.put(macroPrefix + "_alter", "%nrquote(" + codeSegment.getEscapedMacroValue(codeSegment.parsePasswordOption(tableOptions, ICodeSegment.ALTER_PASSWORD_PATTERN)) + ")");
        return code;
    }

    public static PromptGroupInterface copyPromptGroup(UserContextInterface userContext, PromptGroupInterface pg1) {
        if (pg1 != null) {
            try {
                long beginning = System.currentTimeMillis();
                PromptGroupInterface newPromptGroup = null;
                if (!PromptUtils.hasCascade(pg1)) {
                    newPromptGroup = pg1.copy(null);
                    PromptUtils.copyDefinitionsAndSubgroups(newPromptGroup, pg1);
                } else {
                    newPromptGroup = PromptUtils.copyPromptGroupByXML(userContext, pg1);
                }
                long ending = System.currentTimeMillis();
                muchtime += ending - beginning;
                return newPromptGroup;
            }
            catch (Exception e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    private static PromptGroupInterface copyPromptGroupByXML(UserContextInterface userContext, PromptGroupInterface pg1) {
        if (pg1 != null) {
            try {
                StringBuffer promptXML = PromptUtils.getXMLForObject((PersistenceInterface)pg1, null);
                PromptGroupInterface newPromptGroup = null;
                if (promptXML != null) {
                    newPromptGroup = (PromptGroupInterface)PromptUtils.getObjectForXML(userContext, promptXML.toString());
                }
                return newPromptGroup;
            }
            catch (Exception e) {
                ModelLogger.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean hasCascade(PromptGroupInterface promptGroup) {
        boolean cascadeFound = false;
        List promptsFromCascadingGroup = promptGroup.getPromptDefinitions(true);
        for (PromptDefinitionInterface prompt : promptsFromCascadingGroup) {
            Collection dependencies = prompt.getDependentPrompts(Locale.US, null);
            if (dependencies == null || dependencies.size() == 0) continue;
            cascadeFound = true;
            break;
        }
        return cascadeFound;
    }

    public static void copyDefinitionsAndSubgroups(PromptGroupInterface rolledUpGroup, PromptGroupInterface startingGroup) {
        try {
            List definitionsAndSubgroups = startingGroup.getPromptDefinitionsAndSubgroups();
            for (Object definitionOrSubgroup : definitionsAndSubgroups) {
                if (definitionOrSubgroup instanceof PromptDefinitionInterface) {
                    PromptDefinitionInterface promptDefinition = (PromptDefinitionInterface)definitionOrSubgroup;
                    rolledUpGroup.addPromptDefinition((PromptDefinitionInterface)promptDefinition.clone());
                    continue;
                }
                if (definitionOrSubgroup instanceof PromptGroupInterface) {
                    PromptGroupInterface promptDefinitionGroup = (PromptGroupInterface)definitionOrSubgroup;
                    PromptGroupInterface newGroup = promptDefinitionGroup.copy(null);
                    if (!(newGroup instanceof SharedPromptGroupInterface)) {
                        PromptUtils.copyDefinitionsAndSubgroups(newGroup, promptDefinitionGroup);
                    }
                    rolledUpGroup.addPromptSubgroup(newGroup);
                    continue;
                }
                throw new IllegalStateException("Groups should only contain definitions or other groups");
            }
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static String getStringPathToPrompt(PromptGroupInterface rootGroup, PromptDefinitionInterface def) {
        List key = PromptUtil.getPathToPromptDefinition((PromptGroupInterface)rootGroup, (PromptDefinitionInterface)def);
        key.add(def.getPromptName());
        String pathToPrompt = null;
        for (Object o : key) {
            pathToPrompt = pathToPrompt == null ? "" : pathToPrompt + " --> ";
            if (o instanceof PromptGroupInterface) {
                pathToPrompt = pathToPrompt + "\"" + ((PromptGroupInterface)o).getPromptGroupLabel(Locale.getDefault()) + "\"";
                continue;
            }
            if (o instanceof PromptDefinitionInterface) {
                pathToPrompt = pathToPrompt + "\"" + ((PromptDefinitionInterface)o).getPromptLabel(Locale.getDefault()) + "\"";
                continue;
            }
            pathToPrompt = pathToPrompt + "\"" + o + "\"";
        }
        return pathToPrompt;
    }

    private static Map getDuplicateMacrosByName(PromptGroupInterface promptGroup) {
        List definitions = PromptUtil.getVisualOrderOfDefinitions((PromptValuesInterface)new PromptValues(promptGroup), (boolean)false);
        List defs = promptGroup.getPromptDefinitions(true);
        LinkedHashMap map = new LinkedHashMap();
        for (PromptDefinitionInterface definition : defs) {
            Map conflicts = PromptUtil.getConflictingPromptsBasedOnMacroVariableName((Collection)definitions, (PromptDefinitionInterface)definition);
            if (conflicts.isEmpty()) continue;
            Set c = conflicts.entrySet();
            for (Map.Entry entry : c) {
                map.put(PromptUtils.getStringPathToPrompt(promptGroup, definition) + " " + RB.getStringResource("Common.And.txt") + "\n " + PromptUtils.getStringPathToPrompt(promptGroup, (PromptDefinitionInterface)entry.getKey()), entry.getValue());
            }
        }
        return map;
    }

    public static StringBuffer getDuplicateMacroNameList(PromptGroupInterface promptGroup) {
        StringBuffer dups = new StringBuffer();
        Map conflicts = PromptUtils.getDuplicateMacrosByName(promptGroup);
        ArrayList conflictingNames = new ArrayList();
        Set entries = conflicts.entrySet();
        for (Map.Entry entry : entries) {
            if (conflictingNames.contains(entry.getKey())) continue;
            dups.append(MessageFormat.format(RB.getStringResource("PromptUtils.MacroNameDups.txt"), PromptUtils.transformPromptName(entry.getValue()), PromptUtils.indent(entry.getKey()))).append("\n");
        }
        return dups;
    }

    private static String indent(Object value) {
        String val = "";
        val = INDENT + value.toString().replaceAll("\n", "\n" + INDENT);
        return val;
    }

    private static String transformPromptName(Object o) {
        String ret;
        if (o instanceof PromptDefinitionInterface) {
            ret = ((PromptDefinitionInterface)o).getPromptName();
        } else if (o instanceof PromptGroupInterface) {
            ret = ((PromptGroupInterface)o).getPromptGroupLabel(Locale.getDefault());
        } else if (o instanceof List) {
            List lst = (List)o;
            ret = "";
            for (int i = 0; i < lst.size(); ++i) {
                ret = ret + lst.get(i).toString();
                if (i >= lst.size() - 1) continue;
                ret = ret + ", ";
            }
        } else {
            ret = o.toString();
        }
        return ret;
    }

    public static Map getDuplicateMacrosByName(PromptValuesInterface promptValues) {
        LinkedHashMap duplicates = new LinkedHashMap();
        PromptGroupInterface rootGroup = promptValues.getPromptGroup();
        List defs = rootGroup.getPromptDefinitions(true);
        LinkedHashMap map = new LinkedHashMap();
        for (PromptDefinitionInterface definition : defs) {
            Map conflicts = PromptUtil.getConflictingPromptsBasedOnMacroVariableName((PromptGroupInterface)rootGroup, (PromptDefinitionInterface)definition);
            if (conflicts.isEmpty()) continue;
            Set c = conflicts.entrySet();
            for (Map.Entry entry : c) {
                map.put(PromptUtils.getStringPathToPrompt(rootGroup, definition) + "\n" + PromptUtils.getStringPathToPrompt(rootGroup, (PromptDefinitionInterface)entry.getKey()), entry.getValue());
            }
        }
        return duplicates;
    }

    static {
        KEEP_COLUMN_NEWLINE_TAB = "        ";
        INDENT = "   ";
    }
}

