/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.IPromptValueChangeListener;
import com.sas.etl.models.prompts.impl.BasePromptModel;
import com.sas.etl.models.prompts.impl.BaseTransformModelListener;
import com.sas.etl.models.prompts.impl.BaseTransformValueChangedListener;
import com.sas.metadata.remote.MdException;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValues;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class BaseTransformPromptModel
extends BasePromptModel
implements IPromptModel {
    private PromptGroupInterface m_transformPromptGroup;

    public BaseTransformPromptModel(IModel model, ITransform owner) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        super(model, owner);
    }

    public BaseTransformPromptModel(IModel model, ITransform owner, IDataObject[] sources, IDataObject[] targets) throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        super(model, (IObject)owner, sources, targets);
    }

    protected void setTransformPromptGroup(PromptGroupInterface group) {
        this.m_transformPromptGroup = group;
    }

    protected PromptGroupInterface getTransformPromptGroup() {
        return this.m_transformPromptGroup;
    }

    @Override
    protected PromptGroupInterface getPromptGroup() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException {
        PromptGroupInterface grp = super.getPromptGroup();
        PromptGroupInterface grp1 = this.createPromptGroup(BaseTransformPromptModel.class.getResource("res/Options_StandardTransform_Template.xml"));
        PromptGroupInterface combined = this.combinePromptGroups(grp1, grp);
        this.setTransformPromptGroup(combined);
        return combined;
    }

    protected IPromptDefinitionValue[] getTransformDefinitionValues() {
        ArrayList<IPromptDefinitionValue> defValues = new ArrayList<IPromptDefinitionValue>();
        PromptGroupInterface group = this.getTransformPromptGroup();
        if (group != null) {
            List definitions = PromptUtil.getVisualOrderOfDefinitions((PromptValuesInterface)new PromptValues(group), (boolean)false);
            for (int i = 0; i < definitions.size(); ++i) {
                IPromptDefinitionValue defValue = this.getPromptDefinitionValue(((PromptDefinitionInterface)definitions.get(i)).getPromptName());
                if (defValue == null) continue;
                defValues.add(defValue);
            }
        }
        return defValues.toArray(new IPromptDefinitionValue[defValues.size()]);
    }

    @Override
    protected IPromptValueChangeListener createChangeListener() {
        return new BaseTransformValueChangedListener((ITransform)this.getOwner(), (IPromptModel)this);
    }

    @Override
    protected void setValuesFromModel() throws RemoteException, MdException, ServerConnectionException, ServiceException {
        super.setValuesFromModel();
        ITransform transform = (ITransform)this.getOwner();
        this.setOptionValue("SystemOptions", (Object)transform.getSystemOptions());
        this.setOptionValue("ETLS_DIAGNOSTICS", (Object)(transform.isCollectingDiagnostics() ? "YES" : "NO"));
        this.setOptionValue("ENABLECHECKPOINT", (Object)(transform.isCheckpointEnabled() ? "YES" : "NO"));
        this.setOptionValue("RUN_ALWAYS", (Object)(transform.isRunAlways() ? "YES" : "NO"));
        this.setOptionValue("CLEARLIBREFSTRANSFORM", (Object)((ITransform)this.getOwner()).getClearLibrefGeneration());
    }

    @Override
    protected IModelListener createModelListener() {
        return new BaseTransformModelListener(this.getOwner(), this);
    }
}

