/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.job.ITransform;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BasePromptModelListener;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import java.rmi.RemoteException;

public class BaseTransformModelListener
extends BasePromptModelListener {
    public BaseTransformModelListener(IObject modelObject, IPromptModel promptModel) {
        super(modelObject, promptModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelChanged(ModelEvent ev) {
        if (ev.getModelObject() != this.getModelObject()) {
            return;
        }
        super.modelChanged(ev);
        this.getPromptModel().setListeningForChanges(false);
        String type = ev.getType();
        try {
            if (type.equals("ITransform:SystemOptionsChanged")) {
                this.m_promptModel.setOptionValue("SystemOptions", (Object)((ITransform)ev.getModelObject()).getSystemOptions());
            } else if (type.equals("ITransform:CollectDiagnosticsChanged")) {
                this.m_promptModel.setOptionValue("ETLS_DIAGNOSTICS", (Object)(((ITransform)ev.getModelObject()).isCollectingDiagnostics() ? "YES" : "NO"));
            } else if ("ITransform:CheckpointEnabledChanged".equals(type)) {
                this.m_promptModel.setOptionValue("ENABLECHECKPOINT", (Object)(((ITransform)ev.getModelObject()).isCheckpointEnabled() ? "YES" : "NO"));
            } else if ("ITransform:RunAlwaysChanged".equals(type)) {
                this.m_promptModel.setOptionValue("RUN_ALWAYS", (Object)(((ITransform)ev.getModelObject()).isRunAlways() ? "YES" : "NO"));
            } else if (type.equals("ITransform::ClearLibrefTransformChanged")) {
                this.m_promptModel.setOptionValue("CLEARLIBREFSTRANSFORM", (Object)((ITransform)ev.getModelObject()).getClearLibrefGeneration());
            }
        }
        catch (RemoteException exc) {
            ModelLogger.getDefaultLogger().error((Object)"RemoteException", (Throwable)exc);
        }
        catch (MdException exc) {
            ModelLogger.getDefaultLogger().error((Object)"MdException", (Throwable)exc);
        }
        catch (ServerConnectionException exc) {
            ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)exc);
        }
        catch (ServiceException exc) {
            ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)exc);
        }
        finally {
            this.getPromptModel().setListeningForChanges(true);
        }
    }
}

