/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.prompts.impl;

import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BaseTransformValueChangedListener;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.definitions.PromptDefinitionInterface;

public class BaseDataTransformValueChangedListener
extends BaseTransformValueChangedListener
implements PromptValueChangeListener {
    private IDataTransform m_dataTransform;

    public BaseDataTransformValueChangedListener(IDataTransform owner, IPromptModel model) {
        super(owner, model);
        this.m_dataTransform = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promptValueChanged(PromptValueChangeEventInterface event) {
        if (!this.isListeningForChanges()) {
            return;
        }
        this.getOwner().getModel().startCompoundUndoable();
        try {
            super.promptValueChanged(event);
            PromptDefinitionInterface def = event.getPromptDefinition();
            if (def.getPromptName().equals("SYSLAST")) {
                Object value = this.m_model.getOptionValue(def.getPromptName());
                if (value == null) {
                    value = "YES";
                }
                this.m_dataTransform.setSYSLASTVariableGenerationEnabled(value.equals("YES"));
            } else if (def.getPromptName().equals("GENERATEFORMATSINFORMATS")) {
                Object value = this.m_model.getOptionValue(def.getPromptName());
                if (value == null) {
                    value = "JOB";
                }
                this.m_dataTransform.setFormatInformatGeneration((String)value);
            } else if (def.getPromptName().equals("USECONNECTUSING")) {
                Object value = this.m_model.getOptionValue(def.getPromptName());
                if (value == null) {
                    value = "JOB";
                }
                this.m_dataTransform.setUseConnectUsing((String)value);
            } else if (def.getPromptName().equals("GenerateIndexesOnTargets")) {
                Object value = this.m_model.getOptionValue(def.getPromptName());
                if (value == null) {
                    value = "YES";
                }
                this.m_dataTransform.setGenerateIndexesOnTargetTables(value.equals("YES"));
            } else if ("OPTION_DBI_DIRECT_EXEC".equals(def.getPromptName())) {
                Object value = event.getNewValue();
                if (value == null) {
                    value = "";
                }
                this.m_dataTransform.setDBIDirectExec((String)value);
            } else if ("APPENDFORCE".equals(def.getPromptName())) {
                Object value = this.m_model.getOptionValue(def.getPromptName());
                if (value == null) {
                    value = "YES";
                }
                this.m_dataTransform.setAppendForceEnabled(value.equals("YES"));
            } else if ("COLMACROVARS".equals(def.getPromptName())) {
                Object value = this.m_model.getOptionValue(def.getPromptName());
                if (value == null) {
                    value = "YES";
                }
                this.m_dataTransform.setColMacroVarsEnabled(value.equals("YES"));
            } else if ("FILEMACROVARS".equals(def.getPromptName())) {
                Object value = this.m_model.getOptionValue(def.getPromptName());
                if (value == null) {
                    value = "YES";
                }
                this.m_dataTransform.setFileMacroVarsEnabled(value.equals("YES"));
            }
        }
        finally {
            this.getOwner().getModel().endCompoundUndoable();
        }
    }
}

