/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.AbstractComplexPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.INote;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TextStore;
import com.sas.services.information.metadata.OMRNote;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class BaseNote
extends AbstractComplexPersistableObject
implements INote {
    private String m_sText = "";

    public static String getTextRole() {
        return "Note";
    }

    public BaseNote(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getText() {
        return this.m_sText;
    }

    @Override
    public void setText(String sText) {
        if (sText == null) {
            throw new IllegalArgumentException("Text must not be null");
        }
        if (this.m_sText.equals(sText)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTextUndoable(this.m_sText, sText));
        }
        this.m_sText = sText;
        this.fireModelChangedEvent("Note:TextChanged", null);
    }

    @Override
    public String getOMRType() {
        return "Document";
    }

    public String getPublicType() {
        return "Note";
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return OMRNote.CURRENT_VERSION;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Document mdoNote = (Document)omr.acquireOMRObject(this);
        mdoNote.setPublicType("Note");
        mdoNote.setUsageVersion(OMRNote.CURRENT_VERSION.encode());
        mdoNote.setTextRole(BaseNote.getTextRole());
        TextStore mdoText = (TextStore)omr.acquireOMRObject(this.createIDForNewObject(), "TextStore");
        mdoText.setName(this.getName());
        mdoText.setTextRole(BaseNote.getTextRole());
        mdoText.setTextType("html");
        mdoText.setStoredText(this.m_sText);
        AssociationList lNotes = mdoNote.getNotes(false);
        lNotes.clear();
        lNotes.add(mdoText);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Document mdoDoc = (Document)omr.acquireOMRObject(this);
        AssociationList lNotes = mdoDoc.getNotes();
        if (!lNotes.isEmpty()) {
            TextStore mdoNote = (TextStore)lNotes.get(0);
            this.setText(mdoNote.getStoredText());
        }
        this.setChanged(false);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("Notes");
        return map;
    }

    private class SetTextUndoable
    extends AbstractUndoableEdit {
        private String m_oldText;
        private String m_newText;

        public SetTextUndoable(String oldText, String newText) {
            this.m_oldText = oldText;
            this.m_newText = newText;
        }

        @Override
        public void undo() {
            super.undo();
            BaseNote.this.setText(this.m_oldText);
        }

        @Override
        public void redo() {
            super.redo();
            BaseNote.this.setText(this.m_newText);
        }
    }
}

