/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IConnection;
import com.sas.etl.models.other.ILASRServer;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.impl.BaseServer;
import com.sas.etl.models.other.impl.RB;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.text.MessageFormat;

public class BaseLASRServer
extends BaseServer
implements ILASRServer {
    private static final String PROPERTY_LASR_FILE = "LASR";

    public BaseLASRServer(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "ServerComponent";
    }

    @Override
    public String getServerFile() throws ServerException {
        ISASClientConnection connection = this.getConnectClient();
        if (connection == null) {
            throw new ServerException(MessageFormat.format(RB.getStringResource("BaseServer.NoClientConnection.msg.txt"), this.getName()));
        }
        IProperty property = connection.getProperty(PROPERTY_LASR_FILE);
        if (property == null) {
            throw new ServerException(MessageFormat.format(RB.getStringResource("BaseLASRServer.NoLasrFile.msg.txt"), this.getName()));
        }
        return property.getDefaultValue();
    }

    @Override
    protected void loadClientConnections(OMRAdapter omr) throws MdException, RemoteException {
        IProperty hostProperty;
        super.loadClientConnections(omr);
        IConnection connection = this.getConnection();
        if (connection != null && (hostProperty = connection.getProperty("HOST")) != null) {
            connection.setHostName(hostProperty.getDefaultValue());
        }
    }

    @Override
    public String getSignerURI() {
        IConnection connection = this.getConnection();
        if (connection != null) {
            IProperty signerProperty = connection.getProperty("SIGNER");
            return signerProperty.getDefaultValue();
        }
        return null;
    }
}

