/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.common.IExtendedAttributesPropertySet;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IConnection;
import com.sas.etl.models.other.IHadoopServer;
import com.sas.etl.models.other.IProperty;
import com.sas.etl.models.other.ISASClientConnection;
import com.sas.etl.models.other.impl.BaseServer;
import com.sas.etl.models.other.impl.RB;
import com.sas.workspace.WsAppServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

public class BaseHadoopServer
extends BaseServer
implements IHadoopServer {
    private static String PROPERTY_NAME_CONFIGURATION_XML = "ConfigurationXML";
    private static String PROPERTY_SET_ADVANCED_OPTIONS = "AdvancedProperties";
    private static final String PROPERTY_SERVER = "SERVER";
    private static final String PROPERTY_GRIDINSTALL = "INSTALL";

    public BaseHadoopServer(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getOMRType() {
        return "ServerComponent";
    }

    @Override
    public String getProductName() {
        return "HADOOP";
    }

    private InputStream fromString(String str) {
        byte[] bytes = str.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public String getPropertyUrl(String propertyName) {
        IProperty property;
        IConnection connection = this.getConnection();
        if (connection != null && (property = connection.findPropertyInPropertySet(PROPERTY_SET_ADVANCED_OPTIONS, propertyName)) != null) {
            String sURL = property.getDefaultValue();
            if (sURL == null || sURL.length() == 0) {
                return null;
            }
            if (!sURL.startsWith("http")) {
                sURL = "http://" + sURL;
            }
            try {
                return new URL(sURL).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords, String fileName) throws BadServerDefinitionException {
        return this.getServerOptions(useAuthDomain, encodePasswords, fileName, true);
    }

    @Override
    public String getServerOptions(boolean useAuthDomain, boolean encodePasswords, String fileName, boolean includeEngine) throws BadServerDefinitionException {
        IConnection connection = this.getConnection();
        if (connection == null) {
            throw new BadServerDefinitionException(MessageFormat.format(RB.getStringResource("BaseServer.NoClientConnection.msg.txt"), this.getName()));
        }
        StringBuffer options = new StringBuffer();
        if (includeEngine) {
            options.append("device=").append(WsAppServer.FILE_ACCESS_METHOD_HADOOP).append(" ");
        }
        options.append(this.getUserIdPasswordString(useAuthDomain, "user", "pass")).append("\n");
        return options.toString();
    }

    @Override
    public String getGeneratedFileNameDSCode(String fileref) throws ConfigurationException, CodegenException {
        return this.getGeneratedFileNameDSCode(fileref, null);
    }

    @Override
    public String getGeneratedFileNameDSCode(String fileref, IExtendedAttributesPropertySet overrides) throws ConfigurationException, CodegenException {
        return "";
    }

    private void addProperty(XMLConfiguration xmlConfig, String name, String value) {
        xmlConfig.addProperty("property(-1).name", (Object)name);
        xmlConfig.addProperty("property.value", (Object)value);
    }

    @Override
    public String getAccessMethodNickName() {
        return "HADOOP";
    }

    @Override
    public String getAccessMethodFilePath(String filename) throws BadServerDefinitionException {
        return filename;
    }

    @Override
    public String getDirectoryListingOption() {
        return "dir";
    }

    @Override
    public String getSASGridOptions() throws ServerException {
        ISASClientConnection connection = this.getConnectClient();
        if (connection == null) {
            throw new ServerException(MessageFormat.format(RB.getStringResource("BaseServer.NoClientConnection.msg.txt"), this.getName()));
        }
        StringBuilder sb = new StringBuilder();
        IProperty gridInstall = connection.getProperty(PROPERTY_GRIDINSTALL);
        IProperty server = connection.getProperty(PROPERTY_SERVER);
        if (server != null) {
            sb.append("host = \"").append(server.getDefaultValue()).append("\"\n");
        }
        if (gridInstall != null) {
            sb.append("install = \"").append(gridInstall.getDefaultValue()).append("\"\n");
        }
        return sb.toString();
    }
}

