/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.impl.AbstractCondition;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Condition;
import com.sas.metadata.remote.ConditionActionSet;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.Iterator;

public class BaseConditionInstance
extends AbstractCondition {
    public BaseConditionInstance(String sID, IModel model, ICondition templateCondition) {
        super(sID, model);
        this.setUniqueIdentifier(templateCondition.getUniqueIdentifier());
        this.m_sConditionType = templateCondition.getConditionType();
        this.m_iInstanceVersion = templateCondition.getConditionInstance();
    }

    public BaseConditionInstance(String sID, IModel model, String sType) {
        super(sID, model);
        this.m_sUniqueIdentifier = sType;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        Condition mdoCondition = (Condition)omr.acquireOMRObject(this);
        if (this.getUniqueIdentifier().length() > 0) {
            this.setUniqueIdentifier(mdoCondition.getUniqueIdentifier());
        }
        if (this.getConditionType().length() > 0) {
            this.setConditionType(mdoCondition.getConditionType());
        }
        this.setInstanceVersion(mdoCondition.getInstanceVersion());
        if (mdoCondition.getConditionActionSets() != null && mdoCondition.getConditionActionSets().size() > 0) {
            ConditionActionSet set = (ConditionActionSet)mdoCondition.getConditionActionSets().get(0);
            this.m_owningSet = (IConditionActionSet)omr.acquireObject((Root)set);
        } else {
            this.m_owningSet = null;
        }
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.saveToOMR(omr);
        Condition mdo = (Condition)omr.acquireOMRObject(this);
        ConditionActionSet owningSet = (ConditionActionSet)omr.acquireOMRObject(this.m_owningSet);
        owningSet.setAssociatedCondition(mdo);
        AssociationList lCAS = mdo.getConditionActionSets(false);
        boolean found = false;
        Iterator iter = lCAS.iterator();
        while (iter.hasNext()) {
            ConditionActionSet cas = (ConditionActionSet)iter.next();
            if (!cas.equals((Object)owningSet)) {
                iter.remove();
                continue;
            }
            found = true;
        }
        if (!found) {
            mdo.getConditionActionSets().add((Object)owningSet);
        }
        mdo.setConditionType(this.getConditionType());
        mdo.setUniqueIdentifier(this.getUniqueIdentifier());
        this.setInstanceVersion(mdo.getInstanceVersion());
        mdo.setPublicType(this.getPublicType());
        mdo.setUsageVersion(1000000.0);
    }
}

