/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.other.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.other.impl.RB;
import com.sas.metadata.remote.MdException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.MissingResourceException;

public abstract class AbstractCondition
extends AbstractPersistableObject
implements ICondition {
    protected String m_sUniqueIdentifier = "";
    protected IConditionActionSet m_owningSet = null;
    protected int m_iInstanceVersion = 1;
    protected String m_sConditionType = "";

    public AbstractCondition(String sID, IModel model, String sUniqueIdentifier) {
        super(sID, model);
        this.m_sUniqueIdentifier = sUniqueIdentifier;
        this.setName(this.getName());
    }

    public AbstractCondition(String sID, IModel model) {
        super(sID, model);
        this.setName(this.getName());
    }

    @Override
    public String getOMRType() {
        return "Condition";
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    public String getPublicType() {
        return "Embedded:Condition";
    }

    public UsageVersion getArchitectureVersionNumber() {
        return new UsageVersion(1, 0);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        this.setChanged(false);
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.saveToOMR(omr);
    }

    public IConditionActionSet getOwningSet() {
        return this.m_owningSet;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.m_sUniqueIdentifier;
    }

    @Override
    public void setUniqueIdentifier(String sValue) {
        if (sValue == null || sValue.length() == 0) {
            throw new IllegalArgumentException("Value may not be null or empty");
        }
        if (sValue.equals(this.m_sUniqueIdentifier)) {
            return;
        }
        this.m_sUniqueIdentifier = sValue;
    }

    protected void setInstanceVersion(int iVersion) {
        if (iVersion == this.m_iInstanceVersion) {
            return;
        }
        this.m_iInstanceVersion = iVersion;
    }

    @Override
    public String getConditionType() {
        return this.m_sConditionType;
    }

    @Override
    public int getConditionInstance() {
        return this.m_iInstanceVersion;
    }

    protected void setConditionType(String sType) {
        if (sType == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (sType == this.m_sConditionType) {
            return;
        }
        this.m_sConditionType = sType;
    }

    @Override
    public String getName() {
        String sName = RB.getStringResource("NoNameYet.txt");
        if (this.m_sUniqueIdentifier == null || this.m_sUniqueIdentifier.length() == 0) {
            return sName;
        }
        try {
            sName = RB.getStringResource(this.m_sUniqueIdentifier + ".Name.txt");
        }
        catch (MissingResourceException ex) {
            sName = RB.getStringResource("NoNameYet.txt");
        }
        return sName;
    }

    public String getDesc() {
        String sDesc = "";
        try {
            sDesc = RB.getStringResource(this.m_sUniqueIdentifier + ".Description.txt");
        }
        catch (MissingResourceException ex) {
            sDesc = "";
        }
        return sDesc;
    }

    @Override
    public IConditionActionSet getConditionActionSet() {
        return this.m_owningSet;
    }

    @Override
    public void setConditionActionSet(IConditionActionSet set) {
        this.m_owningSet = set;
    }

    @Override
    public String getConditionMacroCall(String sMacroVar) {
        String sReturnString = "";
        if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CSUCCESSFUL")) {
            sReturnString = "%if (&" + sMacroVar + " eq 0) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CWARNINGS")) {
            sReturnString = "%if (&" + sMacroVar + " ge " + "3" + " and &" + sMacroVar + " lt " + "5" + " ) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CRC1")) {
            sReturnString = "%if (&" + sMacroVar + " eq 1) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CRC2")) {
            sReturnString = "%if (&" + sMacroVar + " eq 2) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CRC3")) {
            sReturnString = "%if (&" + sMacroVar + " eq " + "3" + ") %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CERRORS")) {
            sReturnString = "%if (&" + sMacroVar + " ge " + "5" + ") %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CDATAMODIFIED")) {
            sReturnString = "%if (&send gt 0 and &syserr = 0 and &sqlrc = 0) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CTABLECREATED")) {
            sReturnString = "%if (&syserr eq 0) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CTABLEDROPPED")) {
            sReturnString = "%if (&syserr eq 0) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CTABLETRUNCATED")) {
            sReturnString = "%if (&sqlrc eq 0) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CTABLEDOESNOTEXIST")) {
            sReturnString = "%if (&dbxrc eq 0) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CTABLENOMATCHMETADATA")) {
            sReturnString = "%if (&sqlrc ne 0) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CDATAEXCEPTION")) {
            sReturnString = "%if (&m_excp eq 1) %then";
        } else if (this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CJOBSTATUS") || this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CLOOKUPMISSING") || this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CNOLOOKUPROWS") || this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CLOOKUPFAILED") || this.m_sUniqueIdentifier.equalsIgnoreCase("DIS_CERRORINPROCESS")) {
            // empty if block
        }
        return sReturnString;
    }
}

