/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.impl.AbstractTable;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Role;
import com.sas.services.information.metadata.OMRPhysicalTable;
import com.sas.util.UsageVersion;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SubqueryTargetTable
extends AbstractTable
implements ISubqueryTargetTable {
    public static final String SUBQUERY_TABLE_ROLE = "SubQuery";
    private String m_sRole = "SubQuery";
    private String m_sRoleID;
    private static final String TARGET_TABLE_DEFAULT_NAME = RB.getStringResource("Subquery.TargetTableName.txt");
    private IQuery m_parentQuery;

    public SubqueryTargetTable(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    public String getDefaultName() {
        String sName = WsMetadataNameUtil.getUniqueNameForType((String)"QueryTable", (String)TARGET_TABLE_DEFAULT_NAME);
        return sName.replaceAll(" ", "_");
    }

    @Override
    public void setRole(String sRole) {
        this.m_sRole = sRole;
    }

    @Override
    public String getRole() {
        return this.m_sRole;
    }

    @Override
    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean environmentQuoting, boolean passthru, boolean quotes, String prefix) {
        return null;
    }

    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean environmentQuoting) {
        return null;
    }

    @Override
    public String getFullNameQuotedAsNeeded(ICodeSegment codeSegment) {
        return null;
    }

    @Override
    public String getFullNameQuotedAsNeeded(ICodeSegment codeSegment, boolean passthru) throws BadLibraryDefinitionException {
        return null;
    }

    @Override
    public String getFullNameQuotedAsNeeded(IServer currentServer, boolean environmentQuoting, boolean passthru) throws BadLibraryDefinitionException {
        return null;
    }

    @Override
    public String getOMRType() {
        return "QueryTable";
    }

    @Override
    public boolean isChanged() {
        return super.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        QueryTable mdoQueryTable = (QueryTable)omr.acquireOMRObject(this);
        String sRoleID = this.m_sRoleID == null || this.m_sRoleID.length() == 0 ? this.createIDForNewObject() : this.m_sRoleID;
        Role mdoRole = (Role)omr.acquireOMRObject(sRoleID, "Role");
        mdoRole.setContext(this.getRole());
        mdoRole.setObjectRole(this.getRole());
        mdoRole.setName(this.getRole());
        AssociationList lRoles = mdoQueryTable.getRoles();
        lRoles.clear();
        lRoles.add(mdoRole);
        this.setChanged(false);
    }

    @Override
    protected void saveRoles(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        QueryTable mdoQueryTable = (QueryTable)omr.acquireOMRObject(this);
        AssociationList lRoles = mdoQueryTable.getRoles();
        if (!lRoles.isEmpty()) {
            Role mdoRole = (Role)lRoles.get(0);
            this.m_sRoleID = mdoRole.getFQID();
            this.m_sRole = mdoRole.getContext();
        }
        this.setChanged(false);
    }

    @Override
    protected void loadColumns(OMRAdapter omr) throws MdException, RemoteException {
        DataTable mdoTable = (DataTable)omr.acquireOMRObject(this);
        List lColumns = this.verifyColumns(mdoTable);
        ((ModelList)this.m_lColumns).loadFromOMR(omr, lColumns);
    }

    private List verifyColumns(DataTable table) throws MdException, RemoteException {
        ArrayList<Column> lGoodColumns = new ArrayList<Column>();
        AssociationList lColumns = table.getColumns();
        for (int i = 0; i < lColumns.size(); ++i) {
            Column col = (Column)lColumns.get(i);
            String sName = col.getSASColumnName();
            if (sName == null || sName.length() <= 0) continue;
            lGoodColumns.add(col);
        }
        return lGoodColumns;
    }

    @Override
    protected void loadRoles(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_sRoleID != null && this.m_sRoleID.length() > 0) {
            omr.deleteOMRObject(this.m_sRoleID, "Role");
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_sRoleID != null && this.m_sRoleID.length() > 0) {
            this.m_sRoleID = this.updateSubordinateID(this.m_sRoleID, mapIDs);
        }
    }

    @Override
    public String getPublicType() {
        return "";
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("Roles");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("Roles");
        }
        return map;
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return OMRPhysicalTable.CURRENT_VERSION;
    }

    @Override
    public IQuery getParentQuery() {
        return this.m_parentQuery;
    }

    @Override
    public void setParentQuery(IQuery query) {
        this.m_parentQuery = query;
    }
}

