/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodeGenerationEnvironment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IFromContainer;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.etl.models.job.transforms.sql.impl.BaseQuery;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.SelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.impl.SetSQLSourceParentHelper;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Subquery
extends BaseQuery
implements ISubquery {
    public static final String SUBQUERY_TRANSFORM_ROLE = "SUBQUERY";
    public static final String QUERY_TABLE_ROLE = "SubQuery";
    public static final String SUBQUERY_OPERAND = "SubQueryOperand";
    public static final String IN_LINE_VIEW_ROLE = "InLineView";
    private SetSQLSourceParentHelper m_setParentHelper = new SetSQLSourceParentHelper(this);
    private IAliasTable m_alias;
    private String m_sRole;
    private IQuery m_parentQuery;

    public Subquery(String sID, IModel model) {
        super(sID, model);
        if (this.isNew() && !this.getModel().isCopyPaste()) {
            this.setSelectResults(new SelectResultsContainer(this.getID(), this.getModel(), this));
            this.setUseImplicit(true);
            this.setTargetTable(this.getModel().getObjectFactory().createNewSQLSubqueryTargetTable(this.getID()));
            this.setAliasTable(this.getModel().getObjectFactory().createNewSQLAliasTable(this.getID()));
            this.m_alias.setRole("Alias");
            this.m_alias.setAliasedTable(this.getTargetTable());
        }
        this.setRole(SUBQUERY_TRANSFORM_ROLE);
    }

    @Override
    public void setTargetTable(ITable target) {
        if (target == null) {
            return;
        }
        if (this.getTargetTable() == target) {
            return;
        }
        super.setTargetTable(target);
        if (target instanceof ISubqueryTargetTable) {
            ((ISubqueryTargetTable)target).setParentQuery(this);
        }
    }

    @Override
    public String getDefaultName() {
        return "Subquery";
    }

    public static String getTransformRole() {
        return SUBQUERY_TRANSFORM_ROLE;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.SUBQUERY;
    }

    @Override
    public String getAliasName() {
        return this.m_alias.getAliasName();
    }

    @Override
    public boolean isAliased() {
        return this.getAliasName().length() > 0;
    }

    @Override
    public void setAliasName(String sAliasName) {
        this.m_alias.setAliasName(sAliasName);
    }

    @Override
    public void setAliasTable(IAliasTable aliasTable) {
        this.m_alias = aliasTable;
    }

    @Override
    public IAliasTable getAliasTable() {
        return this.m_alias;
    }

    @Override
    public void setRole(String sRole) {
        this.m_sRole = sRole;
    }

    @Override
    public String getRole() {
        return this.m_sRole;
    }

    @Override
    public void addQuerySourceTable(int index, ISourceTable source) {
        super.addQuerySourceTable(index, source);
        if (this.getTransformModel().getQuery() != null) {
            this.getTransformModel().getQuery().addSubquerySourceTable(source);
            this.updateSubqueryTargetForCaseSensitive();
            return;
        }
        if (this.m_parentQuery != null && this.m_parentQuery != this) {
            this.m_parentQuery.addSubquerySourceTable(source);
        }
        this.updateSubqueryTargetForCaseSensitive();
    }

    @Override
    public void removeQuerySourceTable(ISourceTable source) {
        super.removeQuerySourceTable(source);
        if (this.getTransformModel().getQuery() != null) {
            this.getTransformModel().getQuery().removeSubquerySourceTable(source);
        }
        this.updateSubqueryTargetForCaseSensitive();
    }

    private void updateSubqueryTargetForCaseSensitive() {
        List lSources = this.getAllSourceTables();
        boolean isQuotes = false;
        for (int i = 0; i < lSources.size(); ++i) {
            ISourceTable source = (ISourceTable)lSources.get(i);
            if (!source.isQuoted()) continue;
            this.getTargetTable().setCaseSensitive(true);
            isQuotes = true;
            break;
        }
        if (!isQuotes) {
            this.getTargetTable().setCaseSensitive(false);
        }
    }

    @Override
    public void setParent(IClause clause) {
        this.m_setParentHelper.set(clause);
    }

    @Override
    public IClause getParent() {
        return (IClause)this.m_setParentHelper.get();
    }

    @Override
    public void setParentQuery(IQuery query) {
        this.m_parentQuery = query;
    }

    @Override
    public IQuery getParentQuery() {
        if (this.m_parentQuery == null) {
            return this;
        }
        return this.m_parentQuery;
    }

    @Override
    public boolean hasOpenPorts() {
        ISQLSource oFrom = this.getSourceOfFrom();
        if (oFrom == null) {
            return true;
        }
        return oFrom.hasOpenPorts();
    }

    @Override
    public ISQLSource[] getObjectsWithOpenPorts() {
        ArrayList<ISQLSource> lObjects = new ArrayList<ISQLSource>();
        if (this.getSourceOfFrom() != null) {
            ISQLSource[] alObjects = this.getSourceOfFrom().getObjectsWithOpenPorts();
            lObjects.addAll(Arrays.asList(alObjects));
        } else {
            lObjects.add(this);
        }
        ISubquery[] alSubqueries = this.getSubqueries();
        for (int i = 0; i < alSubqueries.length; ++i) {
            ISubquery subquery = alSubqueries[i];
            ISQLSource source = subquery.getSourceOfFrom();
            ISQLSource[] alObjects = source.getObjectsWithOpenPorts();
            lObjects.addAll(Arrays.asList(alObjects));
        }
        return lObjects.toArray(new ISQLSource[lObjects.size()]);
    }

    @Override
    public ISourceTable[] getSQLSourceTables() {
        ArrayList<ISourceTable> lObjects = new ArrayList<ISourceTable>();
        if (this.getSourceOfFrom() != null) {
            ISourceTable[] alObjects = this.getSourceOfFrom().getSQLSourceTables();
            lObjects.addAll(Arrays.asList(alObjects));
        }
        ISubquery[] alSubqueries = this.getSubqueries();
        for (int i = 0; i < alSubqueries.length; ++i) {
            ISubquery subquery = alSubqueries[i];
            ISQLSource source = subquery.getSourceOfFrom();
            if (source == null) continue;
            ISourceTable[] alObjects = source.getSQLSourceTables();
            lObjects.addAll(Arrays.asList(alObjects));
        }
        return lObjects.toArray(new ISourceTable[lObjects.size()]);
    }

    @Override
    public ISubquery[] getSQLSourceSubqueries() {
        ArrayList<Subquery> lSubqueries = new ArrayList<Subquery>();
        lSubqueries.add(this);
        lSubqueries.addAll(this.getSubqueryList());
        return lSubqueries.toArray(new ISubquery[lSubqueries.size()]);
    }

    @Override
    public ITable[] getSourcesInFrom() {
        IQuery parent;
        ArrayList<ITable> lTables = new ArrayList<ITable>();
        if (this.getSourceOfFrom() != null) {
            lTables.addAll(Arrays.asList(this.getSourceOfFrom().getInputTables()));
        }
        if (this.getParent() == null && (parent = this.getParentQuery()) != null) {
            lTables.addAll(Arrays.asList(parent.getQueryOnlySourceTables()));
        }
        return lTables.toArray(new ITable[lTables.size()]);
    }

    @Override
    public ITable[] getInputTables() {
        return new ITable[]{this.getAliasTable()};
    }

    @Override
    public List getAllJoins() {
        ArrayList lJoins = new ArrayList();
        if (this.getSourceOfFrom() != null && this.getSourceOfFrom() instanceof IJoin) {
            lJoins.addAll(this.getSourceOfFrom().getAllJoins());
        }
        ISubquery[] alSubqueries = this.getSubqueries();
        for (int i = 0; i < alSubqueries.length; ++i) {
            ISubquery subquery = alSubqueries[i];
            if (subquery.equals(this)) continue;
            lJoins.addAll(((ISQLSource)subquery).getAllJoins());
        }
        return lJoins;
    }

    @Override
    public boolean containsColumn(IColumn column) {
        ArrayList lSourceTables = new ArrayList();
        lSourceTables.addAll(this.getQuerySourceTableList());
        lSourceTables.addAll(this.getSubquerySourceTableList());
        for (int i = 0; i < lSourceTables.size(); ++i) {
            IColumn[] alColumns;
            List<IColumn> lColumns;
            ISourceTable source = (ISourceTable)lSourceTables.get(i);
            IPhysicalTable pTable = (IPhysicalTable)source.getAliasedTable();
            if (pTable == null || !(lColumns = Arrays.asList(alColumns = pTable.getColumns())).contains(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTable(ITable table) {
        if (this.getQuerySourceTableList().contains(table)) {
            return true;
        }
        return this.getSubquerySourceTableList().contains(table);
    }

    @Override
    public String getExpressionType() {
        return SUBQUERY_OPERAND;
    }

    @Override
    public boolean contentEquals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.equals(this);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getText(currentServer, quotes, false);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String alias;
        CodeGenerationEnvironment environment = new CodeGenerationEnvironment(currentServer);
        ICodeSegment codeSegment = environment.createNewCodeSegment(this);
        codeSegment.addSourceCode("(\n").indent();
        codeSegment.addSourceCode(super.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting(), passthru));
        codeSegment.unIndent().addSourceCode(")");
        IClause parentClause = this.getParent();
        if ((parentClause instanceof IFromContainer || parentClause instanceof IJoin && this.isAliased()) && (alias = this.getAliasName()) != null && alias.length() > 0) {
            codeSegment.addSourceCode(this.getParentQuery().getTransformModel().getDBMSType().getTableAliasKeyword(passthru)).addSourceCode(alias);
        }
        return codeSegment.getGeneratedCode().toString();
    }

    @Override
    public IObject[] getSources() {
        return this.getQuerySourceTables();
    }

    @Override
    public boolean isUseSQLSyntax() {
        return true;
    }

    @Override
    public void setUseSQLSyntax(boolean useSQLSyntax) {
    }

    public ICodeSegment getGeneratedCode(ICodeSegment parentSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getGeneratedCode(parentSegment, this.getTransformModel().isPassThru());
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment parentSegment, boolean isPassThru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String alias;
        ICodeSegment codeSegment = parentSegment.createNewCodeSegment(this);
        codeSegment.addSourceCode("(\n").indent();
        super.getGeneratedQuery(codeSegment, isPassThru);
        codeSegment.unIndent().addSourceCode(")");
        IClause parentClause = this.getParent();
        if ((parentClause instanceof IFromContainer || parentClause instanceof IJoin && this.isAliased()) && (alias = this.getAliasName()) != null && alias.length() > 0) {
            codeSegment.addSourceCode(this.getParentQuery().getTransformModel().getDBMSType().getTableAliasKeyword(isPassThru)).addSourceCode(alias);
        }
        return codeSegment;
    }

    @Override
    public List getWarnings() {
        ArrayList<String> reasons = new ArrayList<String>();
        try {
            String text = this.getText(null, true);
            int lineBreakIndex = text.indexOf("\n");
            if (text.length() > 150 && lineBreakIndex == -1) {
                reasons.add(MessageFormat.format(RB.getStringResource("Expression.ReasonsIncomplete.NoLineBreaks.txt"), new Integer(255)));
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().debug((Object)"RemoteExcpetion", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().debug((Object)"CodegenException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"BadServerDefinitionException", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ServerException", (Throwable)e);
        }
        return reasons;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        Select mdoSelect = (Select)omr.acquireOMRObject(this);
        mdoSelect.setTransformRole(this.getRole());
        AssociationList lClsTargets = mdoSelect.getClassifierTargets(false);
        lClsTargets.clear();
        ISubqueryTargetTable target = (ISubqueryTargetTable)this.getTargetTable();
        target.saveToOMR(omr);
        this.m_alias.saveToOMR(omr);
        QueryTable mdoQT = (QueryTable)omr.acquireOMRObject(target);
        lClsTargets.add(mdoQT);
        mdoSelect.getTransformationSources(false).add((Object)this.m_alias.getClassifierMapObject(omr));
        this.setChanged(false);
    }

    @Override
    protected void saveQueryProperties(OMRAdapter omr) throws MdException, RemoteException {
        this.saveStringOptionToOMR(omr, "SelectProperties", "Distinct", this.useDistinct() ? "YES" : "NO");
        this.saveStringOptionToOMR(omr, "SelectProperties", "Implicit", this.useImplicit() ? "YES" : "NO");
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Select mdoSelect = (Select)omr.acquireOMRObject(this);
        this.setRole(mdoSelect.getTransformRole());
        AssociationList lClsTargets = mdoSelect.getClassifierTargets();
        if (!lClsTargets.isEmpty()) {
            QueryTable mdoQT = (QueryTable)lClsTargets.get(0);
            this.setTargetTable((ITable)omr.acquireObject((Root)mdoQT));
            AssociationList lClsSources = mdoQT.getSourceClassifierMaps();
            for (int i = 0; i < lClsSources.size(); ++i) {
                ClassifierMap mdoCM = (ClassifierMap)lClsSources.get(i);
                String role = mdoCM.getTransformRole();
                if (!role.equalsIgnoreCase("TableAlias")) continue;
                AssociationList lTargets = mdoCM.getClassifierTargets();
                if (!lTargets.isEmpty()) {
                    QueryTable mdoAlias = (QueryTable)lTargets.get(0);
                    this.m_alias = (IAliasTable)this.getModel().getObject(mdoAlias.getFQID());
                    if (this.m_alias != null) continue;
                    this.m_alias = this.getModel().getObjectFactory().createSQLAliasTable(mdoAlias.getFQID());
                    this.m_alias.setClassifierMapID(mdoCM.getFQID());
                    this.m_alias.loadFromOMR(omr);
                    continue;
                }
                this.m_alias = this.getModel().getObjectFactory().createNewSQLAliasTable(this.getID());
                this.m_alias.setClassifierMapID(mdoCM.getFQID());
                this.m_alias.setRole("Alias");
                this.m_alias.setAliasedTable(this.getTargetTable());
            }
            if (this.m_alias == null || lClsSources.isEmpty()) {
                this.m_alias = this.getModel().getObjectFactory().createNewSQLAliasTable(this.getID());
                this.m_alias.setClassifierMapID(this.createIDForNewObject());
                this.m_alias.setRole("Alias");
                this.m_alias.setAliasedTable(this.getTargetTable());
            }
        }
        super.loadFromOMR(omr);
        for (int index = 0; index < this.getQuerySourceTableCount(); ++index) {
            ISQLTransform model = this.getTransformModel();
            if (model == null) continue;
            IQuery query = model.getQuery();
            query.addSubquerySourceTable(this.getQuerySourceTables()[index]);
        }
        this.setChanged(false);
    }

    @Override
    protected void loadQueryProperties(OMRAdapter omr) throws MdException, RemoteException {
        this.setUseDistinct(this.loadStringOptionFromOMR(omr, "SelectProperties", "Distinct", "NO").equalsIgnoreCase("YES"));
        this.setUseImplicit(this.loadStringOptionFromOMR(omr, "SelectProperties", "Implicit", "NO").equalsIgnoreCase("YES"));
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_alias != null) {
            this.m_alias.deleteFromOMR(omr);
        }
        if (this.getTargetTable() != null) {
            this.getTargetTable().deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_alias != null) {
            this.m_alias.updateIDs(mapIDs);
        }
    }

    @Override
    public void notify(NotifyEvent e) {
        String type;
        ModelEvent me = e.getModelEvent();
        if (me != null && "Table:CaseChanged".equals(type = me.getType())) {
            IObject source = me.getModelObject();
            for (Object obj : this.getAllSourceTables()) {
                if (((ISourceTable)obj).getAliasedTable() != source) continue;
                this.updateSubqueryTargetForCaseSensitive();
                break;
            }
        }
        super.notify(e);
    }

    @Override
    public void setTransformModel(ISQLTransform model) {
        ISubquery[] queryArr;
        super.setTransformModel(model);
        if (this.getSourceOfFrom() instanceof IQuery) {
            if (((IQuery)((Object)this.getSourceOfFrom())).getTransformModel() == null) {
                ((IQuery)((Object)this.getSourceOfFrom())).setTransformModel(model);
            }
        } else if (this.getSourceOfFrom() instanceof IJoin) {
            if (((IJoin)this.getSourceOfFrom()).getLeftSide() instanceof IQuery && ((IQuery)((Object)((IJoin)this.getSourceOfFrom()).getLeftSide())).getTransformModel() == null) {
                ((IQuery)((Object)((IJoin)this.getSourceOfFrom()).getLeftSide())).setTransformModel(model);
            }
            if (((IJoin)this.getSourceOfFrom()).getRightSide() instanceof IQuery && ((IQuery)((Object)((IJoin)this.getSourceOfFrom()).getRightSide())).getTransformModel() == null) {
                ((IQuery)((Object)((IJoin)this.getSourceOfFrom()).getRightSide())).setTransformModel(model);
            }
        }
        if ((queryArr = this.getSubqueries()) != null) {
            for (int j = 0; j < queryArr.length; ++j) {
                if (queryArr[j].getTransformModel() != null) continue;
                queryArr[j].setTransformModel(model);
            }
        }
    }
}

