/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLSetOperatorsTransform;
import com.sas.etl.models.job.transforms.sql.ISetOperator;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.impl.BaseQuery;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class SetOperator
extends AbstractPersistableObject
implements ISetOperator {
    private static final String SET_OPERATOR_TRANSFORM_NAME = "SQLSetOperator";
    private static final String MINUS = "minus";
    private IQuery m_oFirstQuery;
    private IQuery m_oSecondQuery;
    private String m_sType = "Union";
    private boolean m_bIncludeDuplicates;
    private boolean m_bMatchByName;
    private boolean m_bHasParenthesis;
    private ISQLSetOperatorsTransform m_owner;

    public SetOperator(String sid, IModel model) {
        super(sid, model);
        this.setDescription(RB.getStringResource("SetOperator.UnionDescription.txt"));
        this.m_bIncludeDuplicates = true;
        this.m_bMatchByName = false;
        this.m_bHasParenthesis = false;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_oFirstQuery != null && this.m_oFirstQuery.isChanged() || this.m_oSecondQuery != null && this.m_oSecondQuery.isChanged();
    }

    @Override
    public boolean isComplete() {
        return this.m_oFirstQuery != null && this.m_oFirstQuery.isComplete() || this.m_oSecondQuery != null && this.m_oSecondQuery.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (this.m_oFirstQuery == null) {
            reasons.add(RB.getStringResource("SetOperator.ReasonIncomplete.MissingFirstQuery.txt"));
        } else {
            reasons.addAll(this.m_oFirstQuery.getReasonsIncomplete());
        }
        if (this.m_oSecondQuery == null) {
            reasons.add(RB.getStringResource("SetOperator.ReasonIncomplete.MissingSecondQuery.txt"));
        } else {
            reasons.addAll(this.m_oSecondQuery.getReasonsIncomplete());
        }
        return reasons;
    }

    @Override
    public String getDefaultName() {
        return SET_OPERATOR_TRANSFORM_NAME;
    }

    public static String getTransformRole() {
        return "SetOperator";
    }

    @Override
    public void setOwner(ISQLSetOperatorsTransform transform) {
        this.m_owner = transform;
    }

    @Override
    public IQuery getFirstQuery() {
        return this.m_oFirstQuery;
    }

    @Override
    public void setFirstQuery(IQuery query) {
        if (this.m_oFirstQuery == null && query == null) {
            return;
        }
        if (this.m_oFirstQuery != null) {
            if (this.m_oFirstQuery == query) {
                return;
            }
            this.m_oFirstQuery.removeNotifyListener(this);
            if (this.m_owner != null) {
                this.m_owner.addToTransformsDeletedObjects(this.m_oFirstQuery);
            } else {
                this.addToDeletedObjects(this.m_oFirstQuery);
            }
        }
        if (query != null) {
            if (this.m_owner != null) {
                this.m_owner.removeFromTransformsDeletedObjects(query);
            } else {
                this.removeFromDeletedObjects(query);
            }
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetFirstQueryUndoable(this.m_oFirstQuery, query));
        }
        this.m_oFirstQuery = query;
        if (this.m_oFirstQuery != null) {
            this.m_oFirstQuery.addNotifyListener(this);
        }
        this.fireModelChangedEvent("SetOperators:FirstQueryChanged", query);
    }

    @Override
    public ISourceTable getFirstQueryTable() {
        ISourceTable[] tables;
        if (this.m_oFirstQuery != null && (tables = this.m_oFirstQuery.getQuerySourceTables()).length > 0) {
            return tables[0];
        }
        return null;
    }

    @Override
    public IQuery getSecondQuery() {
        return this.m_oSecondQuery;
    }

    @Override
    public void setSecondQuery(IQuery query) {
        if (this.m_oSecondQuery == query) {
            return;
        }
        if (this.m_oSecondQuery != null) {
            if (this.m_oSecondQuery == query) {
                return;
            }
            this.m_oSecondQuery.removeNotifyListener(this);
            if (this.m_owner != null) {
                this.m_owner.addToTransformsDeletedObjects(this.m_oSecondQuery);
            } else {
                this.addToDeletedObjects(this.m_oSecondQuery);
            }
        }
        if (query != null) {
            if (this.m_owner != null) {
                this.m_owner.removeFromTransformsDeletedObjects(query);
            } else {
                this.removeFromDeletedObjects(query);
            }
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSecondQueryUndoable(this.m_oSecondQuery, query));
        }
        this.m_oSecondQuery = query;
        if (this.m_oSecondQuery != null) {
            this.m_oSecondQuery.addNotifyListener(this);
        }
        this.fireModelChangedEvent("SetOperators:SecondQueryChanged", query);
    }

    @Override
    public ISourceTable getSecondQueryTable() {
        ISourceTable[] tables;
        if (this.m_oSecondQuery != null && (tables = this.m_oSecondQuery.getQuerySourceTables()).length > 0) {
            return tables[0];
        }
        return null;
    }

    @Override
    public String getType() {
        return this.m_sType;
    }

    @Override
    public void setType(String sType) {
        if (sType == null) {
            throw new NullPointerException("Set operator type must not be null");
        }
        if (this.m_sType.equals(sType)) {
            return;
        }
        if (!(sType.equals("Union") || sType.equals("Intersect") || sType.equals("Except") || sType.equals("Outer Union"))) {
            throw new UnsupportedOperationException("InvalidType:  Does not support the type, " + sType);
        }
        this.startCompoundUndoable();
        try {
            if (sType.equals("Outer Union")) {
                this.setIncludeDuplicates(false);
            }
            this.setTypeImpl(sType);
            this.setDescriptionImpl(sType);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void setTypeImpl(String sType) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetOperatorTypeUndoable(this.m_sType, sType));
        }
        this.m_sType = sType;
        this.fireModelChangedEvent("SetOperators:TypeChanged", null);
    }

    private void setDescriptionImpl(String sType) {
        if (sType.equalsIgnoreCase("Union")) {
            this.setDescription(RB.getStringResource("SetOperator.UnionDescription.txt"));
        } else if (sType.equalsIgnoreCase("Except")) {
            this.setDescription(RB.getStringResource("SetOperator.ExceptDescription.txt"));
        } else if (sType.equalsIgnoreCase("Intersect")) {
            this.setDescription(RB.getStringResource("SetOperator.IntersectDescription.txt"));
        } else if (sType.equalsIgnoreCase("Outer Union")) {
            this.setDescription(RB.getStringResource("SetOperator.OuterUnionDescription.txt"));
        }
    }

    @Override
    public boolean useIncludeDuplicates() {
        return this.m_bIncludeDuplicates;
    }

    @Override
    public void setIncludeDuplicates(boolean includeDuplicates) {
        if (this.m_bIncludeDuplicates == includeDuplicates) {
            return;
        }
        this.m_bIncludeDuplicates = includeDuplicates;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetIncludeDuplicatesUndoable(this.m_bIncludeDuplicates));
        }
        this.fireModelChangedEvent("SetOperators:IncludeDuplicatesChanged", null);
    }

    @Override
    public boolean useMatchColumnsByName() {
        return this.m_bMatchByName;
    }

    @Override
    public void setMatchColumnsByName(boolean bMatchByName) {
        if (this.m_bMatchByName == bMatchByName) {
            return;
        }
        this.m_bMatchByName = bMatchByName;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMatchColumnsByNameUndoable(this.m_bMatchByName));
        }
        this.fireModelChangedEvent("SetOperators:MatchByNameChanged", null);
    }

    @Override
    public void setHasParenthesis(boolean bHasParenthesis) {
        if (this.m_bHasParenthesis == bHasParenthesis) {
            return;
        }
        this.m_bHasParenthesis = bHasParenthesis;
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetHasParenthesisUndoable(this.m_bHasParenthesis));
        }
        this.fireModelChangedEvent("SetOperators:ParenthesisChanged", null);
    }

    @Override
    public boolean hasParenthesis() {
        return this.m_bHasParenthesis;
    }

    @Override
    public String getOMRType() {
        return "ClassifierMap";
    }

    @Override
    public void notify(NotifyEvent ev) {
        int iType = ev.getType();
        if (iType == 1) {
            this.fireModelChangedEvent("SetOperators:QueryObjectHasChanged", this);
        } else {
            super.notify(ev);
        }
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this);
        mdoCM.setTransformRole("SetOperator");
        AssociationList lTranSrcs = mdoCM.getTransformationSources(false);
        lTranSrcs.clear();
        AssociationList lTranTgts = mdoCM.getTransformationTargets(false);
        lTranTgts.clear();
        if (this.m_oFirstQuery != null) {
            this.m_oFirstQuery.saveToOMR(omr);
            lTranSrcs.add((Object)omr.acquireOMRObject(this.m_oFirstQuery));
        }
        if (this.m_oSecondQuery != null) {
            this.m_oSecondQuery.saveToOMR(omr);
            lTranTgts.add((Object)omr.acquireOMRObject(this.m_oSecondQuery));
        }
        this.saveBooleanOptionToOMR(omr, "IncludeDuplicates", this.m_bIncludeDuplicates);
        this.saveBooleanOptionToOMR(omr, "MatchColumnsByName", this.m_bMatchByName);
        this.saveStringOptionToOMR(omr, "SetOperatorType", this.m_sType);
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IOMRPersistable object;
        Root secondQuery;
        AssociationList lTranTgts;
        IOMRPersistable object2;
        Root firstQuery;
        super.loadFromOMR(omr);
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this);
        AssociationList lTranSrcs = mdoCM.getTransformationSources();
        if (lTranSrcs.size() > 0 && (firstQuery = (Root)lTranSrcs.get(0)) != null && (object2 = omr.acquireObject(firstQuery)) instanceof IQuery) {
            this.setFirstQuery((IQuery)object2);
        }
        if ((lTranTgts = mdoCM.getTransformationTargets()).size() > 0 && (secondQuery = (Root)lTranTgts.get(0)) != null && (object = omr.acquireObject(secondQuery)) instanceof IQuery) {
            this.setSecondQuery((IQuery)object);
        }
        this.setType(this.loadStringOptionFromOMR(omr, "SetOperatorType", "Union"));
        this.setIncludeDuplicates(this.loadBooleanOptionFromOMR(omr, "IncludeDuplicates", false));
        this.setMatchColumnsByName(this.loadBooleanOptionFromOMR(omr, "MatchColumnsByName", false));
        this.setChanged(false);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_oFirstQuery != null) {
            this.m_oFirstQuery.updateIDs(mapIDs);
        }
        if (this.m_oSecondQuery != null) {
            this.m_oSecondQuery.updateIDs(mapIDs);
        }
    }

    @Override
    public void delete() {
        if (this.m_oFirstQuery != null) {
            this.m_oFirstQuery.delete();
        }
        if (this.m_oSecondQuery != null) {
            this.m_oSecondQuery.delete();
        }
        super.delete();
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_oFirstQuery != null) {
            this.m_oFirstQuery.deleteFromOMR(omr);
        }
        if (this.m_oSecondQuery != null) {
            this.m_oSecondQuery.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment parentSegment, boolean isPassThru, boolean isFirstSetOperator, boolean doesNextOneHaveParenthesis, boolean bOnlyOne) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        ICodeSegment codeSegment = parentSegment.createNewCodeSegment(this);
        codeSegment.setParentSegment(null);
        String desc = this.getDescription();
        if (desc.length() > 0) {
            codeSegment.addCommentLine(desc);
        }
        if (isFirstSetOperator && this.m_oFirstQuery != null) {
            if (this.hasParenthesis()) {
                codeSegment.addSourceCode("(");
            }
            ((BaseQuery)this.m_oFirstQuery).getGeneratedQuery(codeSegment, isPassThru);
        } else if (isFirstSetOperator && this.m_oFirstQuery == null) {
            ((BaseQuery)this.m_oSecondQuery).getGeneratedQuery(codeSegment, isPassThru);
            parentSegment.addSourceCode(codeSegment);
            return codeSegment;
        }
        if (bOnlyOne && this.m_oSecondQuery == null) {
            parentSegment.addSourceCode(codeSegment);
            return codeSegment;
        }
        String type = this.getType();
        if (7 == this.m_owner.getDBMSType().getDBMSTypeID() && this.m_owner.isPassThru() && this.m_owner.isPassThruEnabled() && "Except".equals(type)) {
            codeSegment.addSourceCode(MINUS).addSourceCode(" ");
        } else {
            codeSegment.addSourceCode(type.toLowerCase()).addSourceCode(" ");
        }
        if (this.useMatchColumnsByName()) {
            codeSegment.addSourceCode("corr").addSourceCode(" ");
        }
        if (this.useIncludeDuplicates()) {
            codeSegment.addSourceCode("all").addSourceCode(" ");
        }
        codeSegment.addSourceCode(" \n");
        if (doesNextOneHaveParenthesis) {
            codeSegment.addSourceCode("(");
        }
        if (isFirstSetOperator && this.m_oFirstQuery == null) {
            return codeSegment;
        }
        if (this.m_oSecondQuery != null) {
            ((BaseQuery)this.m_oSecondQuery).getGeneratedQuery(codeSegment, isPassThru);
        }
        if (this.hasParenthesis()) {
            codeSegment.addSourceCode(")");
        }
        if (this.m_oSecondQuery != null) {
            parentSegment.addSourceCode(codeSegment);
        }
        return codeSegment;
    }

    private class SetFirstQueryUndoable
    extends AbstractUndoableEdit {
        private IQuery m_oldQuery;
        private IQuery m_newQuery;

        public SetFirstQueryUndoable(IQuery oldQuery, IQuery newQuery) {
            this.m_oldQuery = oldQuery;
            this.m_newQuery = newQuery;
        }

        @Override
        public void undo() {
            super.undo();
            SetOperator.this.setFirstQuery(this.m_oldQuery);
        }

        @Override
        public void redo() {
            super.redo();
            SetOperator.this.setFirstQuery(this.m_newQuery);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldQuery = null;
            this.m_newQuery = null;
        }
    }

    private class SetSecondQueryUndoable
    extends AbstractUndoableEdit {
        private IQuery m_oldQuery;
        private IQuery m_newQuery;

        public SetSecondQueryUndoable(IQuery oldQuery, IQuery newQuery) {
            this.m_oldQuery = oldQuery;
            this.m_newQuery = newQuery;
        }

        @Override
        public void undo() {
            super.undo();
            SetOperator.this.setSecondQuery(this.m_oldQuery);
        }

        @Override
        public void redo() {
            super.redo();
            SetOperator.this.setSecondQuery(this.m_newQuery);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldQuery = null;
            this.m_newQuery = null;
        }
    }

    private class SetOperatorTypeUndoable
    extends AbstractUndoableEdit {
        private String m_oldType;
        private String m_newType;

        public SetOperatorTypeUndoable(String oldType, String newType) {
            this.m_oldType = oldType;
            this.m_newType = newType;
        }

        @Override
        public void undo() {
            super.undo();
            SetOperator.this.setTypeImpl(this.m_oldType);
        }

        @Override
        public void redo() {
            super.redo();
            SetOperator.this.setTypeImpl(this.m_newType);
        }
    }

    private class SetIncludeDuplicatesUndoable
    extends AbstractUndoableEdit {
        private boolean m_bNewValue;

        public SetIncludeDuplicatesUndoable(boolean bNewValue) {
            this.m_bNewValue = bNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            SetOperator.this.setIncludeDuplicates(!this.m_bNewValue);
        }

        @Override
        public void redo() {
            super.redo();
            SetOperator.this.setIncludeDuplicates(this.m_bNewValue);
        }
    }

    private class SetMatchColumnsByNameUndoable
    extends AbstractUndoableEdit {
        private boolean m_bNewValue;

        public SetMatchColumnsByNameUndoable(boolean bNewValue) {
            this.m_bNewValue = bNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            SetOperator.this.setMatchColumnsByName(!this.m_bNewValue);
        }

        @Override
        public void redo() {
            super.redo();
            SetOperator.this.setMatchColumnsByName(this.m_bNewValue);
        }
    }

    private class SetHasParenthesisUndoable
    extends AbstractUndoableEdit {
        private boolean m_bNewValue;

        public SetHasParenthesisUndoable(boolean bNewValue) {
            this.m_bNewValue = bNewValue;
        }

        @Override
        public void undo() {
            super.undo();
            SetOperator.this.setHasParenthesis(!this.m_bNewValue);
        }

        @Override
        public void redo() {
            super.redo();
            SetOperator.this.setHasParenthesis(this.m_bNewValue);
        }
    }
}

