/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.BaseMapping;
import com.sas.etl.models.job.transforms.sql.IAliasColumn;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.etl.models.job.transforms.sql.impl.SelectResultsContainer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.QueryTable;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.Text;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class SQLMapping
extends BaseMapping {
    private ISelectResultsContainer m_parent;
    private static final String SOURCES_CUSTOMLIST_NAME = "SQLMappingSourceTables";

    public SQLMapping(String sID, IModel model, ISelectResultsContainer parent) {
        super(sID, model);
        this.m_parent = parent;
    }

    @Override
    public void notify(NotifyEvent ev) {
        Object source = ev.getSource();
        if (ev.getType() == 1) {
            if (source instanceof ICaseStatement) {
                this.fireModelChangedEvent("Mapping:ExpressionChanged", this);
            }
            if (source instanceof ISubquery) {
                this.fireModelChangedEvent("Mapping:ExpressionChanged", this);
            }
        }
        super.notify(ev);
    }

    @Override
    public IExpression createNewExpression() {
        ITextOperand expr = this.getModel().getObjectFactory().createNewSQLTextOperand(this.getID(), this.m_parent.getParentQuery());
        ITextExpression text = this.getModel().getObjectFactory().createNewSQLTextExpression(this.getID(), this.m_parent.getParentQuery());
        expr.setTextExpression(text);
        return expr;
    }

    @Override
    public void setExpression(IExpression expression) {
        IExpression newExpr;
        IExpression oldExpr = this.getExpression();
        super.setExpression(expression);
        if (oldExpr != null) {
            oldExpr.removeNotifyListener(this);
        }
        if ((newExpr = this.getExpression()) != null && (newExpr instanceof ICaseStatement || newExpr instanceof ISubquery)) {
            this.getExpression().addNotifyListener(this);
        }
    }

    @Override
    protected void saveSourcesToOMR(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        IColumn[] alCols = this.getSources();
        AssociationList lSources = mdoFM.getFeatureSources(false);
        lSources.clear();
        ArrayList<IAliasTable> lTables = new ArrayList<IAliasTable>();
        for (int iSource = 0; iSource < alCols.length; ++iSource) {
            IColumn column = alCols[iSource];
            if (column instanceof IAliasColumn) {
                IAliasTable table = (IAliasTable)column.getTable();
                lTables.add(table);
            }
            lSources.add(omr.acquireOMRObject(column));
        }
        if (!lTables.isEmpty()) {
            this.saveCustomListToOMR(omr, SOURCES_CUSTOMLIST_NAME, lTables.toArray(new ITable[lTables.size()]));
        }
    }

    @Override
    protected void loadSourcesFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws RemoteException, MdException {
        IPersistableObject[] alTables = this.loadCustomListFromOMR(omr, SOURCES_CUSTOMLIST_NAME);
        AssociationList lSources = mdoFM.getFeatureSources();
        for (int iSource = 0; iSource < lSources.size(); ++iSource) {
            ITable qTable;
            IAliasColumn aliasColumn;
            IColumn column;
            block11: {
                block13: {
                    ITable table;
                    Column mdoColumn;
                    block12: {
                        mdoColumn = (Column)lSources.get(iSource);
                        DataTable mdoTable = mdoColumn.getTable();
                        column = (IColumn)omr.acquireObject((Root)mdoColumn);
                        if (!(mdoTable instanceof QueryTable)) break block11;
                        table = (ITable)omr.acquireObject((Root)mdoTable);
                        if (!(table instanceof ISubqueryTargetTable)) break block12;
                        IQuery subquery = ((ISubqueryTargetTable)table).getParentQuery();
                        if (subquery == null || (aliasColumn = ((IAliasTable)(table = ((ISubquery)subquery).getAliasTable())).findAlaisedColumnContainingColumn(column)) == null) break block13;
                        column = aliasColumn;
                        break block13;
                    }
                    this.m_bChangedDuringLoad = true;
                    IColumn[] aColumns = table.getColumns();
                    String sName = mdoColumn.getSASColumnName();
                    for (int index = 0; index < aColumns.length; ++index) {
                        if (!sName.equalsIgnoreCase(aColumns[index].getColumnName(false))) continue;
                        column = aColumns[index];
                        break;
                    }
                }
                if (column == null) continue;
                this.addSource(column);
                continue;
            }
            if (alTables.length == lSources.size()) {
                IPersistableObject table = alTables[iSource];
                if (table instanceof IAliasTable) {
                    IAliasColumn aliasColumn2 = ((IAliasTable)table).findAlaisedColumnContainingColumn(column);
                    if (aliasColumn2 != null) {
                        column = aliasColumn2;
                    }
                } else {
                    qTable = ((SelectResultsContainer)this.m_parent).findSourceTable((IPhysicalTable)table);
                    if (qTable != null && (aliasColumn = ((IAliasTable)qTable).findAlaisedColumnContainingColumn(column)) != null) {
                        column = aliasColumn;
                    }
                }
                if (column == null) continue;
                this.addSource(column);
                continue;
            }
            if (column == null) continue;
            if (alTables.length > 0) {
                for (int iTable = 0; iTable < alTables.length; ++iTable) {
                    IColumn baseColumn = column;
                    ITable qTable2 = (ITable)alTables[iTable];
                    if (qTable2 != null) {
                        IAliasColumn aliasColumn3 = ((IAliasTable)qTable2).findAlaisedColumnContainingColumn(column);
                        if (aliasColumn3 == null) continue;
                        baseColumn = aliasColumn3;
                    }
                    if (baseColumn == null) continue;
                    this.addSource(baseColumn);
                }
                continue;
            }
            ITable table = column.getTable();
            qTable = ((SelectResultsContainer)this.m_parent).findSourceTable((IPhysicalTable)table);
            if (qTable != null && (aliasColumn = ((IAliasTable)qTable).findAlaisedColumnContainingColumn(column)) != null) {
                column = aliasColumn;
            }
            if (column == null) continue;
            this.addSource(column);
        }
    }

    @Override
    protected void loadExpressionFromOMR(OMRAdapter omr, FeatureMap mdoFM) throws RemoteException, MdException {
        Text mdoExpression = mdoFM.getSourceCode();
        if (mdoExpression != null) {
            super.loadExpressionFromOMR(omr, mdoFM);
        } else {
            AssociationList lTransTargets = mdoFM.getTransformationTargets();
            if (lTransTargets != null && !lTransTargets.isEmpty()) {
                Root mdoTarget = (Root)lTransTargets.get(0);
                IExpression exp = this.loadSpecialExpression(omr, mdoTarget);
                this.setExpression(exp);
            }
        }
    }

    private IExpression loadSpecialExpression(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        IExpression expression = null;
        if (mdo.getCMetadataType().equalsIgnoreCase("Select")) {
            ISubquery subquery;
            String sRole = ((Select)mdo).getTransformRole();
            if ("SUBQUERY".equals(sRole) && (subquery = (ISubquery)this.getModel().getObject(mdo.getFQID())) == null) {
                subquery = (ISubquery)this.getModel().getObjectFactory().createObjectFromOMRObject(mdo);
                IQuery parentQuery = this.m_parent.getParentQuery();
                subquery.setParentQuery(this.m_parent.getParentQuery());
                subquery.setTransformModel(parentQuery.getTransformModel());
                subquery.loadFromOMR(omr);
                expression = subquery;
            }
        } else if (mdo.getCMetadataType().equalsIgnoreCase("FeatureMap")) {
            expression = this.createNewTextOperand(omr, mdo);
        } else if (mdo.getCMetadataType().equalsIgnoreCase("ClassifierMap") && ((ClassifierMap)mdo).getTransformRole().equalsIgnoreCase("CaseStatement")) {
            expression = (IExpression)this.getModel().getObject(mdo.getFQID());
            if (expression == null) {
                expression = this.getModel().getObjectFactory().createSQLCaseStatement(mdo.getFQID(), this.m_parent.getParentQuery());
                expression.loadFromOMR(omr);
            }
        } else {
            expression = (IExpression)omr.acquireObject(mdo);
        }
        return expression;
    }

    protected ITextOperand createNewTextOperand(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        ITextOperand operand = (ITextOperand)this.getModel().getObject(mdo.getFQID());
        if (operand == null) {
            IQuery parent = this.m_parent.getParentQuery();
            operand = this.getModel().getObjectFactory().createSQLTextOperand(mdo.getFQID(), parent);
            operand.loadFromOMR(omr);
        }
        return operand;
    }
}

