/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.dbmstypes.DBMSTypeFactory;
import com.sas.etl.models.data.dbmstypes.HADOOPType;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.data.dbmstypes.SASHDATType;
import com.sas.etl.models.data.dbmstypes.SASIOIMPType;
import com.sas.etl.models.data.dbmstypes.SASIOLAType;
import com.sas.etl.models.data.impl.PhysicalTablePromptModelCollection;
import com.sas.etl.models.data.impl.TableUtil;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.IMappingRule;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.BaseTransformTableOptions;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLPort;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISelectResultsContainer;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.impl.AbstractSQLTransform;
import com.sas.etl.models.job.transforms.sql.impl.BaseSQLPort;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import com.sas.etl.models.job.transforms.sql.impl.SQLMapping;
import com.sas.etl.models.job.transforms.sql.impl.SelectResultsContainer;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.ICondition;
import com.sas.etl.models.other.IConditionAction;
import com.sas.etl.models.other.IConditionActionSet;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SQLJoinTransformModel
extends AbstractSQLTransform
implements ISQLTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.sql.SQL";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.transforms.sql.SQL";
    private static final String ARM_DISPLAY_NAME = "SQLJoin";
    protected static final String AUTOMATICALLY_JOIN_KEY = "DiagramPanel.AutomaticallyJoin";
    protected static final String USETARGETLIBRARYINFO = "USETARGETLIBRARYINFO";
    protected static final String PROPERTY_SET_ROLE = "SQLModelOptions";
    protected static final String PROPERTY_NAME_PASSTHRU = "PASSTHRU";
    protected static final String PROPERTY_NAME_TARGET_PASSTHRU = "TARGETPASSTHRU";
    protected static final String PROPERTY_NAME_SQL_OPTIONS = "ADDITIONALSQLOPTIONS";
    protected static final String PROPERTY_NAME_MAGIC = "magic";
    protected static final String PROPERTY_NAME_BUFFER_SIZE = "buffersize";
    protected static final String PROPERTY_NAME_INOBS = "inobs";
    protected static final String PROPERTY_NAME_OUTOBS = "outobs";
    protected static final String PROPERTY_NAME_THREADS = "threads";
    protected static final String PROPERTY_NAME_SPDSPARALLELJOIN = "plljoin";
    protected static final String PROPERTY_NAME_SPDS_OPTIONS = "AdditionalSPDSOptions";
    protected static final String PROPERTY_NAME_PRETARGETPASSTHRUACTION = "preTargetPassthruAction";
    protected static final String PROPERTY_NAME_AUTOJOIN = "AutoJoin";
    protected static final String PROPERTY_NAME_DEBUG = "DEBUG";
    protected static final String PROPERTY_TARGET_TABLE_SET_ROLE = "TargetTableOptions";
    protected static final String PROPERTY_NAME_INSERTBUFF = "insertbuff";
    protected static final String PROPERTY_NAME_ADDITIONAL_OPTIONS = "AdditionalOptions";
    protected static final String DEFAULT_VALUE_YES = "YES";
    protected static final String DEFAULT_VALUE_NO = "NO";
    protected static final boolean DEFAULT_TARGET_PASSTHRU = true;
    protected static final boolean DEFAULT_MAGIC = false;
    private boolean m_bUseTargetForConnect = true;
    protected boolean m_bTargetIsPassThru;
    private String m_sPreTargetPassThruAction;
    private String m_sSQLOptions;
    private boolean m_bSuggestSortMergeJoin;
    private String m_sBufferSize;
    private String m_sMaxInputRows;
    private String m_sMaxOutputRows;
    private String m_sThreads;
    private String m_sSPDSParallelJoin;
    private String m_sSPDSOptions;
    private boolean m_bAutoJoin;
    private boolean m_bIsDebug;
    private String m_sCreateDescription;
    protected IQuery m_query;
    private List m_lInputPortDescriptions;
    private boolean m_bUpdatePortDescriptions;
    protected ISelectResultsContainer m_mappingContainer;
    private boolean m_bSPDSTables;
    private boolean m_bTargetPassThruEnabled;

    public SQLJoinTransformModel(String id, IModel model) {
        super(id, model);
        this.createConditionActionSetTemplates();
        this.m_bSuggestSortMergeJoin = false;
        this.m_bTargetIsPassThru = true;
        this.m_bAutoJoin = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(AUTOMATICALLY_JOIN_KEY, true);
        this.m_sBufferSize = "";
        this.m_sMaxInputRows = "";
        this.m_sMaxOutputRows = "";
        this.m_sSPDSOptions = "";
        this.m_sSQLOptions = "";
        this.m_sCreateDescription = "";
        this.m_sSPDSParallelJoin = "systemdefault";
        this.m_sPreTargetPassThruAction = "delete";
        this.m_sThreads = "systemdefault";
        this.m_bSPDSTables = false;
        this.m_bTargetPassThruEnabled = false;
        this.m_bIsDebug = false;
        this.setPassThruEnabled(false);
        this.setDBMSType(DBMSTypeFactory.getDefaultType());
        this.m_lInputPortDescriptions = new ModelList(this, new String[]{"SQLJoinTransformModel:PortAdded", "SQLJoinTransformModel:PortRemoved"}, 0, ISQLPort.class);
        this.m_bUpdatePortDescriptions = true;
        if (this.isNew() && !this.getModel().isCopyPaste()) {
            this.m_query = this.getModel().getObjectFactory().createNewSQLQuery(this.getID());
            this.m_mappingContainer = new SelectResultsContainer(this.m_query.getID(), this.getModel(), this.m_query);
            this.m_mappingContainer.addNotifyListener(this);
            this.m_query.setSelectResults(this.m_mappingContainer);
            this.m_query.setSaveSelectResults(false);
            this.m_query.setTransformModel(this);
            this.m_query.addNotifyListener(this);
        }
    }

    @Override
    protected String getDefaultDBIDirectExecValue() {
        return "DBIDIRECTEXEC";
    }

    @Override
    protected IPromptModel createOptionModel() throws IOException, ParserConfigurationException, SAXException, FileNotFoundException, ServerConnectionException, ServiceException, MdException {
        IPromptModel model = super.createOptionModel();
        IPromptDefinitionValue dbiDefinition = model.getPromptDefinitionValue("OPTION_DBI_DIRECT_EXEC");
        if (dbiDefinition != null) {
            dbiDefinition.setHidden(false);
            dbiDefinition.setDefaultValue(this.getDefaultDBIDirectExecValue());
        }
        return model;
    }

    public static String getTransformTypeID() {
        return "com.sas.wadmin.transforms.sql.SQL";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.wadmin.transforms.sql.SQL";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.wadmin.transforms.sql.SQL";
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("SQLJoinTransformModel.Name.txt");
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.setPassThru(Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("DiagramPanel.AutomaticPassThru", false));
        this.addInput();
        this.addInput();
        this.addNewWorkTable();
        this.loadConditionActionSetTemplatesFromOMR();
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable workTable = super.addNewWorkTable();
            workTable.setView(true);
            IWorkTable iWorkTable = workTable;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SQLJoinTransformModel.Name.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    protected int getMaximumDataSourceCount() {
        return Integer.MAX_VALUE;
    }

    public ISQLPort[] getPortDescriptions() {
        return this.m_lInputPortDescriptions.toArray(new ISQLPort[this.m_lInputPortDescriptions.size()]);
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
    }

    public List getPortDescriptionList() {
        return this.m_lInputPortDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuerySourceTable(int iPortIndex) {
        this.startCompoundUndoable();
        try {
            ISQLPort portDesc = (ISQLPort)this.m_lInputPortDescriptions.get(iPortIndex - 1);
            ISourceTable source = (ISourceTable)portDesc.getObject();
            if (source == null) {
                return;
            }
            IClause parent = source.getParent();
            IQuery query = null;
            query = !(parent instanceof IQuery) ? parent.getParentQuery() : (IQuery)parent;
            query.removeQuerySourceTable(source);
            portDesc.setObject(null);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    public void updatePortDescriptionName(int iPortIndex, String sName) {
        ISQLPort portDesc = (ISQLPort)this.m_lInputPortDescriptions.get(iPortIndex - 1);
        portDesc.setName(sName);
        this.fireModelChangedEvent("DataTransform.InputUpdated", portDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAliasedDataSource(int iPortIndex, IDataObject source, String aliasName) {
        this.startCompoundUndoable();
        try {
            ISQLPort port = (ISQLPort)this.m_lInputPortDescriptions.get(iPortIndex - 1);
            IObject container = port.getObjectContainer();
            IQuery query = null;
            if (container instanceof IQuery) {
                query = (IQuery)container;
            } else if (container instanceof IJoin) {
                query = ((IJoin)container).getParentQuery();
            }
            ISourceTable srcTable = null;
            List lSQLSources = query.getFragmentedSourceObjects();
            for (int index = 0; index < lSQLSources.size(); ++index) {
                ITable aliasedTable;
                ISQLSource sqlSrc = (ISQLSource)lSQLSources.get(index);
                if (!(sqlSrc instanceof ISourceTable) || (aliasedTable = ((ISourceTable)sqlSrc).getAliasedTable()) != source) continue;
                srcTable = (ISourceTable)sqlSrc;
                break;
            }
            if (srcTable == null) {
                srcTable = query.getDeletedSourceTable((ITable)source);
            }
            if (srcTable == null) {
                srcTable = query.addQuerySourceTable((IPhysicalTable)source);
            } else {
                query.addQuerySourceTable(srcTable);
            }
            this.updateSourceTableTypesAttributes();
            srcTable.setAliasName(aliasName);
            if (container instanceof IJoin) {
                String sSide = port.getJoinSide();
                if (sSide.equalsIgnoreCase("Left")) {
                    ((IJoin)container).setLeftSide(srcTable);
                } else {
                    ((IJoin)container).setRightSide(srcTable);
                }
            } else {
                query.setSourceOfFrom(srcTable);
            }
            String alias = srcTable.getName();
            if (alias.length() == 0) {
                alias = ((IPhysicalTable)srcTable.getAliasedTable()).getSASTableName();
            }
            this.updatePortDescriptionName(iPortIndex, alias);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addDataSource(int iSource, IDataObject source) {
        if (!this.containsInDataSources(source) && source != null) {
            super.addDataSource(iSource, source);
        }
    }

    @Override
    protected void postAddDataSource(IDataObject source) {
        super.postAddDataSource(source);
        this.updateSourceTableTypesAttributes();
        this.updateDBMSType();
    }

    @Override
    protected void preRemoveDataSource(IDataObject source) {
        super.preRemoveDataSource(source);
        this.updateSourceTableTypesAttributes();
        if (source instanceof IWorkTable) {
            ISourceTable[] aSources = this.m_query.findInAllQuerySourceTables((ITable)source);
            block0: for (int index = 0; index < aSources.length; ++index) {
                ISourceTable qryTable = aSources[index];
                IClause parent = qryTable.getParent();
                if (parent == null) {
                    List lSources = this.m_query.getQuerySourceTableList();
                    if (lSources.contains(qryTable)) {
                        this.m_query.removeQuerySourceTable(qryTable);
                        continue;
                    }
                    List lSubqueries = this.m_query.getSubqueryList();
                    for (int index2 = 0; index2 < lSubqueries.size(); ++index2) {
                        IQuery subQuery = (IQuery)lSubqueries.get(index2);
                        List lSubSources = subQuery.getQuerySourceTableList();
                        if (!lSubSources.contains(qryTable)) continue;
                        subQuery.removeQuerySourceTable(qryTable);
                        continue block0;
                    }
                    continue;
                }
                IQuery query = null;
                query = parent instanceof IQuery ? (IQuery)parent : parent.getParentQuery();
                if (query == null) continue;
                query.removeQuerySourceTable(qryTable);
            }
        }
    }

    @Override
    protected void preRemoveDataTarget(IDataObject target) {
        super.preRemoveDataTarget(target);
        if (this.m_query != null) {
            this.m_query.setTargetTable(null);
        }
    }

    @Override
    protected void postRemoveDataTarget(IDataObject target) {
        super.postRemoveDataTarget(target);
        this.updateTargetTableTypesAttributes();
    }

    @Override
    protected void preAddDataTarget(IDataObject target) {
        super.preAddDataTarget(target);
        if (this.m_query != null) {
            this.m_query.setTargetTable((ITable)target);
        }
    }

    @Override
    protected void postAddDataTarget(IDataObject target) {
        super.postAddDataTarget(target);
        this.updateTargetTableTypesAttributes();
    }

    @Override
    protected void postAddTransformTableOption(IDataObject table, boolean isSource) {
        if (isSource) {
            return;
        }
        super.postAddTransformTableOption(table, isSource);
    }

    @Override
    protected void preRemoveTransformTableOptions(IDataObject table, boolean isSource) {
        if (isSource) {
            return;
        }
        super.preRemoveTransformTableOptions(table, isSource);
    }

    @Override
    public ITransformTableOptions[] getTableOptionObjects() {
        ISQLSource from;
        ArrayList<ITransformTableOptions> lTableOptions = new ArrayList<ITransformTableOptions>();
        if (this.m_query != null && (from = this.m_query.getSourceOfFrom()) != null) {
            ISourceTable[] sources = from.getSQLSourceTables();
            for (int iSrcs = 0; iSrcs < sources.length; ++iSrcs) {
                lTableOptions.add(sources[iSrcs].getTransformSourceTableOption());
            }
        }
        ITransformTableOptions[] options = super.getTableOptionObjects();
        for (int iTgt = 0; iTgt < options.length; ++iTgt) {
            lTableOptions.add(options[iTgt]);
        }
        return lTableOptions.toArray(new ITransformTableOptions[lTableOptions.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        boolean bAutoJoin = this.m_bAutoJoin;
        this.m_bAutoJoin = false;
        this.startCompoundUndoable();
        try {
            for (int index = 0; index < portIndexes.length; ++index) {
                ITable table;
                ISQLPort port = (ISQLPort)this.m_lInputPortDescriptions.get(portIndexes[index] - 1);
                IObject source = port.getObject();
                if (!(source instanceof ISourceTable) || (table = ((ISourceTable)source).getAliasedTable()) != oldTable) continue;
                ISourceTable oldSrcTbl = (ISourceTable)source;
                IClause parent = oldSrcTbl.getParent();
                IQuery query = null;
                query = parent instanceof IQuery ? (IQuery)parent : parent.getParentQuery();
                ISourceTable newSrcTbl = this.getModel().getObjectFactory().createNewSQLSourceTable(this.getID());
                newSrcTbl.setAliasedTable(newTable);
                newSrcTbl.setAliasName(oldSrcTbl.getAliasName());
                query.replaceTableColumns(oldSrcTbl, newSrcTbl);
                oldSrcTbl.setParent(null);
                query.removeQuerySourceTable(oldSrcTbl);
                query.addQuerySourceTable(newSrcTbl);
                IObject object = port.getObjectContainer();
                if (object instanceof IJoin) {
                    String sJoinSide = port.getJoinSide();
                    if (sJoinSide.equalsIgnoreCase("Left")) {
                        ((IJoin)object).setLeftSide(newSrcTbl);
                        continue;
                    }
                    ((IJoin)object).setRightSide(newSrcTbl);
                    continue;
                }
                ((IQuery)object).setSourceOfFrom(newSrcTbl);
            }
            super.replaceSourceTable(oldTable, newTable, columnsMap, portIndexes);
        }
        finally {
            this.m_bAutoJoin = bAutoJoin;
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            this.replaceSourceMappings(oldTable, newTable, columnsMap);
            this.replaceSourceTableOptions(oldTable, newTable, columnsMap);
            ITable[] aTables = this.m_query.getSourcesInFrom();
            ArrayList<ITable> lSrcTables = new ArrayList<ITable>();
            for (int iTbl = 0; iTbl < aTables.length; ++iTbl) {
                ITable aliasedTable;
                if (!(aTables[iTbl] instanceof IAliasTable) || (aliasedTable = ((IAliasTable)aTables[iTbl]).getAliasedTable()) != oldTable) continue;
                lSrcTables.add(aTables[iTbl]);
            }
            if (lSrcTables.size() == 0) {
                this.removeDataSource(oldTable);
            }
            this.addDataSource(newTable);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected void replaceSourceMappings(ITable oldTable, ITable newTable, Map columnsMap) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            this.m_query.replaceTableColumns(oldTable, newTable);
            super.replaceTargetTable(oldTable, newTable, columnsMap, portIndexes);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void fixMovedTables() {
        ISourceTable[] srcs = this.getAllQuerySourceTables();
        for (int i = 0; i < srcs.length; ++i) {
            ISourceTable table = srcs[i];
            if (!table.isMoved()) continue;
            table.resetAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateDBMSType() {
        if (this.isPassThruEnabled() && this.isPassThru()) {
            ISQLSource from = this.m_query.getSourceOfFrom();
            ISourceTable[] srcs = from != null ? from.getSQLSourceTables() : new ISourceTable[]{};
            ISourceTable sourceTable = null;
            for (int i = 0; i < srcs.length; ++i) {
                IPhysicalTable table = (IPhysicalTable)srcs[i].getAliasedTable();
                if (table == null) continue;
                sourceTable = srcs[i];
                break;
            }
            if (sourceTable != null) {
                try {
                    if (sourceTable.isMoveTableToUploadLibrary()) {
                        sourceTable.moveTable();
                    }
                    this.setDBMSType(((IPhysicalTable)sourceTable.getAliasedTable()).getDBMSType());
                }
                finally {
                    this.fixMovedTables();
                }
            } else {
                this.setDBMSType(DBMSTypeFactory.getDefaultType());
            }
        } else {
            this.setDBMSType(DBMSTypeFactory.getDefaultType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSourceTablesPassthruSupported() {
        try {
            ISourceTable[] sourceTables = this.getAllQuerySourceTables();
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isMoveTableToUploadLibrary()) continue;
                table.moveTable();
            }
            IPhysicalTable[] srcTables = new IPhysicalTable[sourceTables.length];
            boolean passthru = true;
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isPassThruSupported()) {
                    passthru = false;
                    continue;
                }
                srcTables[i] = (IPhysicalTable)table.getAliasedTable();
            }
            if (passthru) {
                try {
                    passthru = TableUtil.hasEqualDeployedComponents(this.getExecutionServer(), srcTables);
                }
                catch (BadLibraryDefinitionException e) {
                    ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
                }
            }
            boolean bl = passthru;
            return bl;
        }
        finally {
            this.fixMovedTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateSourceTableTypesAttributes() {
        try {
            ISourceTable[] sourceTables = this.getAllQuerySourceTables();
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isMoveTableToUploadLibrary()) continue;
                table.moveTable();
            }
            IPhysicalTable[] srcTables = new IPhysicalTable[sourceTables.length];
            boolean spds = true;
            boolean passthru = true;
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isSPDSTable()) {
                    spds = false;
                }
                if (!table.isPassThruSupported()) {
                    passthru = false;
                    continue;
                }
                srcTables[i] = (IPhysicalTable)table.getAliasedTable();
            }
            if (passthru) {
                try {
                    passthru = TableUtil.hasEqualDeployedComponents(this.getExecutionServer(), srcTables);
                }
                catch (BadLibraryDefinitionException e) {
                    ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
                }
            }
            this.setSPDSTables(spds);
            this.setPassThruEnabled(passthru);
            this.updateTargetTableTypesAttributes(passthru);
        }
        finally {
            this.fixMovedTables();
        }
    }

    @Override
    public boolean isSPDSQuery() {
        return this.m_bSPDSTables;
    }

    private void setSPDSTables(boolean spdsTables) {
        if (this.m_bSPDSTables == spdsTables) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSPDSTablesUndoable(this.m_bSPDSTables, spdsTables));
        }
        this.m_bSPDSTables = spdsTables;
        this.fireModelChangedEvent("SQLJoinTransformModel:SPDSSourceTablesChanged", null);
    }

    @Override
    protected void updateTargetTableTypesAttributes() {
        this.updateTargetTableTypesAttributes(this.isSourceTablesPassthruSupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void updateTargetTableTypesAttributes(boolean sourceTablesSupportPassthru) {
        targets = this.getDataTargets();
        targetPassThru = sourceTablesSupportPassthru;
        if (targetPassThru) {
            if (targets.length > 0 && targets[0] instanceof IPhysicalTable) {
                try {
                    targetTable = (IPhysicalTable)targets[0];
                    v0 = targetPassThru = targetPassThru != false && targetTable.getDBMSType().isPassThroughSupported() != false;
                    if (!targetPassThru) ** GOTO lbl32
                    sourceTables = this.getAllQuerySourceTables();
                    for (i = 0; i < sourceTables.length; ++i) {
                        table = sourceTables[i];
                        if (!table.isMoveTableToUploadLibrary()) continue;
                        table.moveTable();
                    }
                    allTables = new IPhysicalTable[sourceTables.length + targets.length];
                    for (i = 0; i < sourceTables.length; ++i) {
                        table = sourceTables[i];
                        allTables[i] = (IPhysicalTable)table.getAliasedTable();
                    }
                    allTables[allTables.length - 1] = targetTable;
                    try {
                        targetPassThru = TableUtil.hasEqualDeployedComponents(this.getExecutionServer(), allTables);
                    }
                    catch (BadLibraryDefinitionException e) {
                        ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
                    }
                }
                finally {
                    this.fixMovedTables();
                }
            } else {
                targetPassThru = false;
            }
        }
lbl32:
        // 6 sources

        this.setTargetPassThruEnabled(targetPassThru);
    }

    @Override
    public boolean isTargetPassThruEnabled() {
        return this.m_bTargetPassThruEnabled;
    }

    private void setTargetPassThruEnabled(boolean targetPassThruEnabled) {
        if (this.m_bTargetPassThruEnabled == targetPassThruEnabled) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetPassThruEnabledUndoable(this.m_bTargetPassThruEnabled, targetPassThruEnabled));
        }
        this.m_bTargetPassThruEnabled = targetPassThruEnabled;
        this.fireModelChangedEvent("SQLJoinTransformModel:TargetPassThruChanged", null);
    }

    @Override
    public boolean isAddInputAvailable() {
        return true;
    }

    @Override
    public boolean isDeleteInputAvailable() {
        if (this.m_lInputPortDescriptions.size() == 1) {
            return false;
        }
        for (int index = 0; index < this.m_lInputPortDescriptions.size(); ++index) {
            ISQLPort port = (ISQLPort)this.m_lInputPortDescriptions.get(index);
            if (port.getObject() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addInput() {
        block7: {
            this.startCompoundUndoable();
            try {
                if (this.m_lInputPortDescriptions.size() > 0) {
                    this.m_bUpdatePortDescriptions = false;
                    try {
                        this.m_query.createAndInsertAJoinInFrom("Inner", this.m_query.getSourceOfFrom());
                        break block7;
                    }
                    finally {
                        this.m_bUpdatePortDescriptions = true;
                        this.updatePortDescriptions();
                    }
                }
                BaseSQLPort portDesc = new BaseSQLPort(this.createIDForNewObject(), this.getModel());
                this.m_lInputPortDescriptions.add(portDesc);
                portDesc.setObjectContainer(this.m_query);
                this.addInputImpl(portDesc, 1);
            }
            finally {
                this.endCompoundUndoable();
            }
        }
    }

    private void addInputImpl(ISQLPort portDesc, int iPortIndex) {
        if (portDesc == null) {
            portDesc = (ISQLPort)this.m_lInputPortDescriptions.get(this.m_lInputPortDescriptions.size() - 1);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new AddInputUndoable(portDesc, iPortIndex));
        }
        if (iPortIndex == -1) {
            this.fireModelChangedEvent("DataTransform.InputAdded", portDesc);
        } else {
            this.fireModelChangedEvent("DataTransform.InputAdded", portDesc, new Integer(iPortIndex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInput() {
        this.startCompoundUndoable();
        try {
            int start;
            for (int iPortIndex = start = this.m_lInputPortDescriptions.size() - 1; iPortIndex > -1; --iPortIndex) {
                ISQLPort portDesc = (ISQLPort)this.m_lInputPortDescriptions.get(iPortIndex);
                if (portDesc.getObject() != null) continue;
                try {
                    IObject object = portDesc.getObjectContainer();
                    if (object != null) {
                        this.m_query.setRemovingInputPort(true);
                        if (object instanceof IJoin) {
                            IJoin oldJoin = (IJoin)object;
                            String side = portDesc.getJoinSide();
                            if (side != null && side.equals("Left")) {
                                this.m_query.replaceSourceInFrom(oldJoin, oldJoin.getRightSide());
                            } else {
                                this.m_query.replaceSourceInFrom(oldJoin, oldJoin.getLeftSide());
                            }
                            this.m_query.removeClause(oldJoin);
                        } else if (object instanceof ISubquery) {
                            ISubquery subquery = (ISubquery)object;
                            IClause parent = subquery.getParent();
                            IQuery parentQuery = subquery.getParentQuery();
                            if (parent == null) {
                                parentQuery.removeSubqueryFromExpression(subquery);
                            } else {
                                if (parentQuery == parent) {
                                    while (parentQuery == parent) {
                                        subquery.setParent(null);
                                        parentQuery.removeInlineSubquery(subquery);
                                        subquery = (ISubquery)parentQuery;
                                        parentQuery = subquery.getParentQuery();
                                        parent = subquery.getParent();
                                    }
                                } else {
                                    subquery.setParent(null);
                                    parentQuery.removeInlineSubquery(subquery);
                                }
                                if (parent instanceof IJoin) {
                                    IJoin oldJoin = (IJoin)parent;
                                    String side = portDesc.getJoinSide();
                                    if (side != null && side.equals("Left")) {
                                        this.m_query.replaceSourceInFrom(oldJoin, oldJoin.getRightSide());
                                    } else {
                                        this.m_query.replaceSourceInFrom(oldJoin, oldJoin.getLeftSide());
                                    }
                                    this.m_query.removeClause(oldJoin);
                                }
                            }
                        } else {
                            IObject source = portDesc.getObject();
                            if (source instanceof IJoin) {
                                IJoin oldJoin = (IJoin)source;
                                String side = portDesc.getJoinSide();
                                if (side != null && side.equals("Left")) {
                                    this.m_query.replaceSourceInFrom(oldJoin, oldJoin.getRightSide());
                                } else {
                                    this.m_query.replaceSourceInFrom(oldJoin, oldJoin.getLeftSide());
                                }
                                this.m_query.removeClause(oldJoin);
                            } else {
                                this.m_query.replaceSourceInFrom((ISQLSource)source, null);
                            }
                        }
                    }
                    break;
                }
                finally {
                    this.m_bUpdatePortDescriptions = true;
                    this.m_query.setRemovingInputPort(false);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void deleteInputImpl(ISQLPort portDesc, int iPortIndex) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new DeleteInputUndoable(portDesc, iPortIndex));
        }
        if (iPortIndex == -1) {
            this.fireModelChangedEvent("DataTransform.InputRemoved", portDesc);
        } else {
            this.fireModelChangedEvent("DataTransform.InputRemoved", portDesc, new Integer(iPortIndex));
        }
    }

    public int findInSourcePort(IPhysicalTable table) {
        for (int i = 0; i < this.m_lInputPortDescriptions.size(); ++i) {
            ISQLPort portDesc = (ISQLPort)this.m_lInputPortDescriptions.get(i);
            ISourceTable sourceTable = (ISourceTable)portDesc.getObject();
            if (sourceTable == null || !sourceTable.containsAliasedTable(table)) continue;
            String sSrcNodeId = sourceTable.getChangedNodeId();
            String sTableNodeId = table.getChangedNodeId();
            IObject container = portDesc.getObjectContainer();
            if (!(container instanceof IQuery)) {
                container = ((IClause)container).getParentQuery();
            }
            IQuery query = (IQuery)container;
            String sLastNodeId = query.getLastChangeNodeId();
            if (sTableNodeId != null && sTableNodeId.length() > 0 && sLastNodeId != null && sLastNodeId.length() > 0) {
                if (!sTableNodeId.equals(sLastNodeId) || !sLastNodeId.equals(sSrcNodeId)) continue;
                return i;
            }
            return i;
        }
        return -1;
    }

    @Override
    public IColumn[] updateMappedColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        return this.m_mappingContainer.updateMappedColumnsToTargetTable(aSourceColumns, tblTarget);
    }

    @Override
    public IColumn[] updateMappedColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        return this.m_mappingContainer.updateMappedColumnsToSourceTable(tblSource, aTargetColumns);
    }

    @Override
    public void mapColumns() {
        this.m_mappingContainer.mapColumns();
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget) {
        this.m_mappingContainer.mapColumns(tblSource, tblTarget);
    }

    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets) {
        this.m_mappingContainer.mapColumns(aSources, aTargets);
    }

    @Override
    public void mapColumns(IMappingRule[] aRules) {
        this.m_mappingContainer.mapColumns(aRules);
    }

    @Override
    public void mapColumns(ITable tblSource, ITable tblTarget, IMappingRule[] aRules) {
        this.m_mappingContainer.mapColumns(tblSource, tblTarget, aRules);
    }

    @Override
    public void mapColumns(IColumn[] aSources, IColumn[] aTargets, IMappingRule[] aRules) {
        this.m_mappingContainer.mapColumns(aSources, aTargets, aRules);
    }

    @Override
    public void propagateColumnsToSourceTables() {
        this.m_mappingContainer.propagateColumnsToSourceTables();
    }

    @Override
    public void propagateColumnsToSourceTables(int eNonWorkTableHandling) {
        this.m_mappingContainer.propagateColumnsToSourceTables(eNonWorkTableHandling);
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        this.m_mappingContainer.propagateColumnsToSourceTables(aSourceTables, aTargetTables);
    }

    @Override
    public void propagateColumnsToSourceTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        this.m_mappingContainer.propagateColumnsToSourceTables(aTargetTables, aSourceTables, eNonWorkTableHandling);
    }

    @Override
    public void propagateColumnsToTargetTables() {
        this.m_mappingContainer.propagateColumnsToTargetTables();
    }

    @Override
    public void propagateColumnsToTargetTables(int eNonWorkTableHandling) {
        this.m_mappingContainer.propagateColumnsToTargetTables(eNonWorkTableHandling);
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables) {
        this.m_mappingContainer.propagateColumnsToTargetTables(aSourceTables, aTargetTables);
    }

    @Override
    public void propagateColumnsToTargetTables(ITable[] aSourceTables, ITable[] aTargetTables, int eNonWorkTableHandling) {
        this.m_mappingContainer.propagateColumnsToTargetTables(aSourceTables, aTargetTables, eNonWorkTableHandling);
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns) {
        return this.m_mappingContainer.propagateColumnsToSourceTable(tblSource, aTargetColumns);
    }

    @Override
    public IColumn[] propagateColumnsToSourceTable(ITable tblSource, IColumn[] aTargetColumns, int eNonWorkTableHandling) {
        return this.m_mappingContainer.propagateColumnsToSourceTable(tblSource, aTargetColumns, eNonWorkTableHandling);
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget) {
        return this.m_mappingContainer.propagateColumnsToTargetTable(aSourceColumns, tblTarget);
    }

    @Override
    public IColumn[] propagateColumnsToTargetTable(IColumn[] aSourceColumns, ITable tblTarget, int eNonWorkTableHandling) {
        return this.m_mappingContainer.propagateColumnsToTargetTable(aSourceColumns, tblTarget, eNonWorkTableHandling);
    }

    @Override
    public void replaceSourceColumns(IColumn[] aOldColumns, IColumn[] aNewColumns) {
        this.m_mappingContainer.replaceSourceColumns(aOldColumns, aNewColumns);
    }

    @Override
    public void replaceTargetColumns(IColumn[] aOldColumns, IColumn[] aNewColumns) {
        this.m_mappingContainer.replaceTargetColumns(aOldColumns, aNewColumns);
    }

    @Override
    public void removeSourceTableFromMappings(ITable tbl) {
        this.m_mappingContainer.removeSourceTableFromMappings(tbl);
    }

    @Override
    public void removeSourceColumnFromMappings(IColumn column) {
        this.m_mappingContainer.removeSourceColumnFromMappings(column);
    }

    @Override
    public void removeTargetTableFromMappings(ITable tbl) {
        this.m_mappingContainer.removeTargetTableFromMappings(tbl);
    }

    @Override
    public void removeTargetColumnFromMappings(IColumn column) {
        this.m_mappingContainer.removeTargetColumnFromMappings(column);
    }

    @Override
    public List getMappingsList() {
        return this.m_mappingContainer.getMappingsList();
    }

    @Override
    public IMapping addMapping(IColumn[] aSources, IColumn[] aTargets) {
        return this.m_mappingContainer.addMapping(aSources, aTargets);
    }

    @Override
    public IMapping addMapping(IColumn[] aSourceColumns, IColumn[] aTargetColumns, String sType, IExpression oExpression) {
        return this.m_mappingContainer.addMapping(aSourceColumns, aTargetColumns, sType, oExpression);
    }

    @Override
    public void addMapping(IMapping mapping) {
        this.m_mappingContainer.addMapping(mapping);
    }

    @Override
    public void addMapping(int iMapping, IMapping mapping) {
        this.m_mappingContainer.addMapping(iMapping, mapping);
    }

    @Override
    public void removeMapping(IMapping mapping) {
        this.m_mappingContainer.removeMapping(mapping);
    }

    @Override
    public boolean containsMapping(IMapping mapping) {
        return this.m_mappingContainer.containsMapping(mapping);
    }

    @Override
    public IColumn[] getColumnsExcludedFromMapping() {
        return this.m_mappingContainer.getColumnsExcludedFromMapping();
    }

    @Override
    public List getListOfColumnsExcludedFromMapping() {
        return this.m_mappingContainer.getListOfColumnsExcludedFromMapping();
    }

    @Override
    public IColumn[] getColumnsExcludedFromPropagation() {
        return this.m_mappingContainer.getColumnsExcludedFromPropagation();
    }

    @Override
    public List getListOfColumnsExcludedFromPropagation() {
        return this.m_mappingContainer.getListOfColumnsExcludedFromPropagation();
    }

    @Override
    public void setCreateDescription(String sCreateDescripion) {
        if (this.m_sCreateDescription.equals(sCreateDescripion)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCreateDescriptionUndoable(this.m_sCreateDescription, sCreateDescripion));
        }
        this.m_sCreateDescription = sCreateDescripion;
        this.fireModelChangedEvent("SQLJoinTransformMOdel:CreateDescriptionChanged", null);
    }

    @Override
    public String getCreateDescription() {
        return this.m_sCreateDescription;
    }

    @Override
    public void setSQLOptions(String sOptions) {
        if (this.m_sSQLOptions.equals(sOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSQLOptionsUndoable(this.m_sSQLOptions, sOptions));
        }
        this.m_sSQLOptions = sOptions;
        this.fireModelChangedEvent("SQLJoinTransformModel:SqlOptionsChanged", null);
    }

    @Override
    public String getSQLOptions() {
        return this.m_sSQLOptions;
    }

    @Override
    public void setTargetPassThru(boolean bTargetPassThru) {
        if (this.m_bTargetIsPassThru == bTargetPassThru) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetTargetPassThruUndoable(this.m_bTargetIsPassThru, bTargetPassThru));
        }
        this.m_bTargetIsPassThru = bTargetPassThru;
        this.fireModelChangedEvent("SQLJoinTransformModel:TargetPassThroughChanged", null);
    }

    @Override
    public boolean isTargetPassThru() {
        return this.m_bTargetIsPassThru;
    }

    @Override
    public void setPreTargetPassThruAction(String sPreTargetPassThruAction) {
        if (this.m_sPreTargetPassThruAction.equals(sPreTargetPassThruAction)) {
            return;
        }
        if (!Arrays.asList(PRETARGET_PASSTHRU_VALUES).contains(sPreTargetPassThruAction)) {
            ModelLogger.getDefaultLogger().debug((Object)("Invalid value has been given, " + sPreTargetPassThruAction + ", forcing the value to be the default."));
            if (this.m_sPreTargetPassThruAction.equalsIgnoreCase("delete")) {
                return;
            }
            sPreTargetPassThruAction = "delete";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetPreTargetPassThruActionUndoable(this.m_sPreTargetPassThruAction, sPreTargetPassThruAction));
        }
        this.m_sPreTargetPassThruAction = sPreTargetPassThruAction;
        this.fireModelChangedEvent("SQLJoinTransformModel:TargetPassThroughActionChanged", null);
    }

    @Override
    public String getPreTargetPassThruAction() {
        return this.m_sPreTargetPassThruAction;
    }

    @Override
    public void setSuggestSortMergeJoin(boolean bSuggestSortMerge) {
        if (this.m_bSuggestSortMergeJoin == bSuggestSortMerge) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSuggestSortMergeJoinUndoable(this.m_bSuggestSortMergeJoin, bSuggestSortMerge));
        }
        this.m_bSuggestSortMergeJoin = bSuggestSortMerge;
        this.fireModelChangedEvent("SQLJoinTransformModel:SuggestSortMergeChanged", null);
    }

    @Override
    public boolean isSuggestSortMergeJoin() {
        return this.m_bSuggestSortMergeJoin;
    }

    @Override
    public boolean isValidateAvailable() {
        return true;
    }

    @Override
    public boolean isDebug() {
        return this.m_bIsDebug;
    }

    @Override
    public void setIsDebug(boolean bDebug) {
        if (this.m_bIsDebug == bDebug) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetDebugUndoable(this.m_bIsDebug, bDebug));
        }
        this.m_bIsDebug = bDebug;
        this.fireModelChangedEvent("SQLJoinTransformModel:DebugChanged", null);
    }

    @Override
    public void setBufferSize(String sBufferSize) {
        if (this.m_sBufferSize.equals(sBufferSize)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetBufferSizeUndoable(this.m_sBufferSize, sBufferSize));
        }
        this.m_sBufferSize = sBufferSize;
        this.fireModelChangedEvent("SQLJoinTransformModel:BufferSizeChanged", null);
    }

    @Override
    public String getBufferSize() {
        return this.m_sBufferSize;
    }

    public void setUseTargetForConnect(boolean bUseTargetForConnect) {
        if (this.m_bUseTargetForConnect == bUseTargetForConnect) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetUseTargetForConnectUndoable(this.m_bUseTargetForConnect, bUseTargetForConnect));
        }
        this.m_bUseTargetForConnect = bUseTargetForConnect;
        this.fireModelChangedEvent("SQLJoinTransformModel:UseTargetConnectChanged", null);
    }

    public boolean isUseTargetForConnect() {
        return this.m_bUseTargetForConnect;
    }

    @Override
    public void setMaxInputRows(String sMaxInputRows) {
        if (this.m_sMaxInputRows.equals(sMaxInputRows)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMaxInputRowsUndoable(this.m_sMaxInputRows, sMaxInputRows));
        }
        this.m_sMaxInputRows = sMaxInputRows;
        this.fireModelChangedEvent("SQLJoinTransformModel:InObsChanged", null);
    }

    @Override
    public String getMaxInputRows() {
        return this.m_sMaxInputRows;
    }

    @Override
    public void setMaxOutputRows(String sMaxOutputRows) {
        if (this.m_sMaxOutputRows.equals(sMaxOutputRows)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetMaxOutputRowsUndoable(this.m_sMaxOutputRows, sMaxOutputRows));
        }
        this.m_sMaxOutputRows = sMaxOutputRows;
        this.fireModelChangedEvent("SQLJoinTransformModel:OutobsChanged", null);
    }

    @Override
    public String getMaxOutputRows() {
        return this.m_sMaxOutputRows;
    }

    @Override
    public void setThreads(String sThreads) {
        if (this.m_sThreads.equals(sThreads)) {
            return;
        }
        if (!Arrays.asList(THREAD_VALUES).contains(sThreads)) {
            ModelLogger.getDefaultLogger().debug((Object)("Invalid value has been given, " + sThreads + ", forcing the value to be the default."));
            if (this.m_sThreads.equalsIgnoreCase("systemdefault")) {
                return;
            }
            sThreads = "systemdefault";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetThreadsUndoable(this.m_sThreads, sThreads));
        }
        this.m_sThreads = sThreads;
        this.fireModelChangedEvent("SQLJoinTransformModel:ThreadsChanged", null);
    }

    @Override
    public String getThreads() {
        return this.m_sThreads;
    }

    @Override
    public void setSPDSParallelJoin(String sSPDSParallelJoin) {
        if (this.m_sSPDSParallelJoin.equals(sSPDSParallelJoin)) {
            return;
        }
        if (!Arrays.asList(SPDS_PARALLEL_VALUES).contains(sSPDSParallelJoin)) {
            ModelLogger.getDefaultLogger().debug((Object)("An invalid value has been given, " + sSPDSParallelJoin + ", forcing the value to be the default."));
            if (this.m_sSPDSParallelJoin.equalsIgnoreCase("systemdefault")) {
                return;
            }
            sSPDSParallelJoin = "systemdefault";
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSPDSParallelJoinUndoable(this.m_sSPDSParallelJoin, sSPDSParallelJoin));
        }
        this.m_sSPDSParallelJoin = sSPDSParallelJoin;
        this.fireModelChangedEvent("SQLJoinTransformModel:SpdsParallelJoinChanged", null);
    }

    @Override
    public String getSPDSParallelJoin() {
        return this.m_sSPDSParallelJoin;
    }

    @Override
    public void setSPDSOptions(String sSPDSOptions) {
        if (this.m_sSPDSOptions.equalsIgnoreCase(sSPDSOptions)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetSPDSOptionsUndoable(this.m_sSPDSOptions, sSPDSOptions));
        }
        this.m_sSPDSOptions = sSPDSOptions;
        this.fireModelChangedEvent("SQLJoinTransformModel:AdditionalSpdsOptionsChanged", null);
    }

    @Override
    public String getSPDSOptions() {
        return this.m_sSPDSOptions;
    }

    @Override
    public void setAutoJoinEnabled(boolean bAutoJoin) {
        if (this.m_bAutoJoin == bAutoJoin) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAutoJoinUndoable(this.m_bAutoJoin, bAutoJoin));
        }
        this.m_bAutoJoin = bAutoJoin;
        this.fireModelChangedEvent("SQLJoinTransformModel:AutoJoinChanged", null);
    }

    @Override
    public boolean isAutoJoinEnabled() {
        return this.m_bAutoJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePortDescriptions() {
        if (!this.m_bUpdatePortDescriptions) {
            return;
        }
        boolean iPortName = false;
        boolean iSourceObject = true;
        int iSourceContainer = 2;
        int iJoinSide = 3;
        this.startCompoundUndoable();
        try {
            IObject oldSource;
            List lChanges;
            int iNewPort;
            List lNewPorts = this.m_query.getPortDescriptions();
            int oldSize = this.m_lInputPortDescriptions.size();
            ArrayList lOldPortDescriptions = new ArrayList();
            lOldPortDescriptions.addAll(this.m_lInputPortDescriptions);
            int newSize = lNewPorts.size();
            HashMap<IObject, Integer> hmMovedSourceTables = new HashMap<IObject, Integer>();
            if (newSize < oldSize) {
                for (iNewPort = 0; iNewPort < newSize; ++iNewPort) {
                    lChanges = (List)lNewPorts.get(iNewPort);
                    IObject newSource = (IObject)lChanges.get(1);
                    for (int iOldPort = 0; iOldPort < this.m_lInputPortDescriptions.size(); ++iOldPort) {
                        ISQLPort port = (ISQLPort)this.m_lInputPortDescriptions.get(iOldPort);
                        oldSource = port.getObject();
                        if (oldSource != newSource || iNewPort == iOldPort) continue;
                        hmMovedSourceTables.put(newSource, new Integer(iOldPort));
                    }
                }
            }
            for (int iOldPort = 0; iOldPort < lOldPortDescriptions.size(); ++iOldPort) {
                ISQLPort oldPort = (ISQLPort)lOldPortDescriptions.get(iOldPort);
                if (iOldPort < newSize) {
                    int iOldPortInteger;
                    ITable table;
                    String sNewName;
                    List lChanges2 = (List)lNewPorts.get(iOldPort);
                    String sName = oldPort.getName();
                    if (!sName.equals(sNewName = (String)lChanges2.get(0))) {
                        this.updatePortDescriptionName(iOldPort + 1, sNewName);
                    }
                    oldPort.setName(sNewName);
                    oldPort.setObjectContainer((IObject)lChanges2.get(2));
                    oldPort.setJoinSide((String)lChanges2.get(3));
                    oldSource = oldPort.getObject();
                    IObject newSource = (IObject)lChanges2.get(1);
                    if (newSource == oldSource) continue;
                    oldPort.setObject(newSource);
                    if (newSource == null) {
                        if (oldSource == null) continue;
                        table = ((ISourceTable)oldSource).getAliasedTable();
                        this.disconnectDataSource(table, iOldPort + 1);
                        continue;
                    }
                    if (oldSource != null) {
                        table = ((ISourceTable)oldSource).getAliasedTable();
                        this.disconnectDataSource(table, iOldPort + 1);
                    }
                    table = ((ISourceTable)newSource).getAliasedTable();
                    Object oldPortInteger = hmMovedSourceTables.get(newSource);
                    if (oldPortInteger != null && (iOldPortInteger = ((Integer)oldPortInteger).intValue()) == iOldPort + 1) {
                        this.disconnectDataSource(table, iOldPortInteger + 1);
                    }
                    if (!this.containsInDataSources(table)) continue;
                    this.connectDataSource(table, iOldPort + 1);
                    continue;
                }
                int iPortRemoved = this.m_lInputPortDescriptions.size() - 1;
                ISQLPort port = (ISQLPort)this.m_lInputPortDescriptions.get(iPortRemoved);
                IObject source = port.getObject();
                if (source != null) {
                    ITable table = ((ISourceTable)source).getAliasedTable();
                    this.disconnectDataSource(table, iPortRemoved + 1);
                }
                this.m_lInputPortDescriptions.remove(iPortRemoved);
                this.deleteInputImpl(oldPort, iPortRemoved + 1);
            }
            if (newSize > oldSize) {
                for (iNewPort = oldSize; iNewPort < lNewPorts.size(); ++iNewPort) {
                    ITable table;
                    lChanges = (List)lNewPorts.get(iNewPort);
                    BaseSQLPort port = new BaseSQLPort(this.createIDForNewObject(), this.getModel());
                    port.setName((String)lChanges.get(0));
                    IObject object = (IObject)lChanges.get(1);
                    port.setObject(object);
                    port.setObjectContainer((IObject)lChanges.get(2));
                    port.setJoinSide((String)lChanges.get(3));
                    this.m_lInputPortDescriptions.add(port);
                    this.addInputImpl(port, iNewPort + 1);
                    if (object == null || !this.containsInDataSources(table = ((ISourceTable)object).getAliasedTable())) continue;
                    this.connectDataSource(table, iNewPort + 1);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public IQuery getQuery() {
        return this.m_query;
    }

    @Override
    public ISourceTable[] getAllQuerySourceTables() {
        ArrayList lAllQuerySources = new ArrayList();
        if (this.m_query != null) {
            lAllQuerySources.addAll(this.m_query.getQuerySourceTableList());
            lAllQuerySources.addAll(this.m_query.getSubquerySourceTableList());
        }
        return lAllQuerySources.toArray(new ISourceTable[lAllQuerySources.size()]);
    }

    @Override
    public void disconnectDataSource(IDataObject table, int iPortIndex) {
        this.fireModelChangedEvent("DataTransform.DataSourceRemoved", table, new Integer(iPortIndex));
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new DisconnectDataSourceUndoable(table, iPortIndex));
        }
    }

    @Override
    public void connectDataSource(IDataObject table, int iPortIndex) {
        this.fireModelChangedEvent("DataTransform.DataSourceAdded", table, new Integer(iPortIndex));
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new ConnectDataSourceUndoable(table, iPortIndex));
        }
    }

    @Override
    public IDataObject getDataTarget() {
        if (this.getDataTargetsCount() > 0) {
            return this.getDataTargets()[0];
        }
        return null;
    }

    @Override
    public IClause addClause(ClauseType type) {
        return this.m_query.addClause(type);
    }

    @Override
    public void removeClause(IClause clause) {
        this.m_query.removeClause(clause);
    }

    @Override
    public IClause getClause(ClauseType type) {
        return this.m_query.getClause(type);
    }

    @Override
    public IClause[] getClauses() {
        ArrayList<IClause> lClauses = new ArrayList<IClause>();
        lClauses.add(this);
        lClauses.addAll(Arrays.asList(this.m_query.getClauses()));
        return lClauses.toArray(new IClause[lClauses.size()]);
    }

    @Override
    public void removeSQLSource(ISQLSource source) {
    }

    @Override
    public void addSQLSource(ISQLSource source) {
    }

    @Override
    public void setParentQuery(IQuery query) {
    }

    @Override
    public IQuery getParentQuery() {
        return this.m_query;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.FROM;
    }

    @Override
    public void notify(NotifyEvent ev) {
        ModelEvent mdEv;
        Object obj = ev.getSource();
        int type = ev.getType();
        if (type == 1 && ev.getSource() == this.m_query) {
            this.fireModelChangedEvent("SQLJoinTransformModel:QueryChanged", null);
        }
        if (obj instanceof IQuery && type == 10) {
            this.updatePortDescriptions();
        }
        if ((mdEv = ev.getModelEvent()) != null) {
            String sType = mdEv.getType();
            if (obj instanceof IPhysicalTable && "PhysicalTable:LibraryChanged".equals(sType)) {
                ISourceTable[] srcs = this.getSourceTablesForAliasTable((IPhysicalTable)obj);
                for (int i = 0; i < srcs.length; ++i) {
                    if (srcs[i].isMoveTableToUploadLibrary()) continue;
                    this.updateSourceTableTypesAttributes();
                    this.updateDBMSType();
                }
                if (obj == this.m_query.getTargetTable()) {
                    this.updateTargetTableTypesAttributes();
                }
            } else if (obj instanceof ISourceTable && "SQLSourceTable:DbmsLibraryChanged".equals(sType)) {
                List<ISourceTable> sourceTables = Arrays.asList(this.getAllQuerySourceTables());
                if (sourceTables.contains(obj)) {
                    this.updateSourceTableTypesAttributes();
                    this.updateDBMSType();
                }
            } else if (obj == this.m_query && "SQLObject:QueryTableRemoved".equals(sType)) {
                this.updateSourceTableTypesAttributes();
                this.updateDBMSType();
            }
        }
    }

    private ISourceTable[] getSourceTablesForAliasTable(IPhysicalTable table) {
        ArrayList<ISourceTable> matches = new ArrayList<ISourceTable>();
        ISourceTable[] srcs = this.getAllQuerySourceTables();
        for (int i = 0; i < srcs.length; ++i) {
            if (srcs[i].getAliasedTable() != table) continue;
            matches.add(srcs[i]);
        }
        return matches.toArray(new ISourceTable[matches.size()]);
    }

    @Override
    public ICodeSegment getGenerateTableIndexes(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return codeSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, validateCode);
        IPhysicalTable target = (IPhysicalTable)this.m_query.getTargetTable();
        ISourceTable[] sourceTables = this.getAllQuerySourceTables();
        ArrayList<ISourceTable> movedSourceTables = new ArrayList<ISourceTable>();
        if (!validateCode) {
            for (int i = 0; i < sourceTables.length; ++i) {
                ISourceTable table = sourceTables[i];
                if (!table.isMoveTableToUploadLibrary()) continue;
                table.moveTableToUploadLibrary(codeSegment);
                movedSourceTables.add(table);
            }
        }
        boolean passthru = this.isPassThru();
        boolean targetPassthru = this.m_bTargetIsPassThru;
        try {
            IPromptDefinitionValue definition;
            PhysicalTablePromptModelCollection optionModel;
            String desc;
            boolean useCreateSyntax;
            boolean hasSPDSOptions;
            boolean isSPDSParallelJoin;
            boolean isDebug = this.isDebug();
            boolean bl = isSPDSParallelJoin = !"systemdefault".equalsIgnoreCase(this.getSPDSParallelJoin());
            if (passthru) {
                this.setPassThru(this.isPassThruEnabled());
            }
            if (targetPassthru) {
                this.m_bTargetIsPassThru = this.isPassThru() && this.m_bTargetPassThruEnabled;
            }
            boolean targetIsView = target.isView();
            if (!validateCode && this.m_bTargetIsPassThru && !targetIsView) {
                codeSegment.addSourceCode("%macro etls_prepareTarget();\n").indent();
                if ("delete".equals(this.m_sPreTargetPassThruAction)) {
                    this.genTableDelete(codeSegment, target);
                    target.getDBMSType().create(codeSegment, target, false, false, false, false, "", null);
                    codeSegment.addSourceCode("%let etls_tableExist = 0;\n\n");
                } else {
                    target.genTableExist(codeSegment);
                    target.getDBMSType().create(codeSegment, target, true, false, false, false, "", this);
                    codeSegment.addSourceCode("%else; \n").addSourceCode("%do;\n").indent();
                    if (!(target.getDBMSType() instanceof HADOOPType) && !(target.getDBMSType() instanceof SASHDATType)) {
                        target.getDBMSType().deleteAllRows(codeSegment, target, true);
                    }
                    codeSegment.unIndent().addSourceCode("%end;\n\n");
                }
                codeSegment.unIndent().addSourceCode("%mend etls_prepareTarget;\n").addSourceCode("%etls_prepareTarget;\n\n");
            }
            if (!(this.m_bTargetIsPassThru && !targetIsView || validateCode)) {
                this.genTableDelete(codeSegment, target);
            }
            boolean bl2 = hasSPDSOptions = isDebug || isSPDSParallelJoin || !"".equals(this.m_sSPDSOptions) || this.m_bSuggestSortMergeJoin || !"".equals(this.m_sMaxInputRows) || !"".equals(this.m_sMaxOutputRows);
            if (isDebug) {
                codeSegment.addSourceCode("%let etls_sasTrace = %sysfunc(getoption(sastrace));\n").addSourceCode("%let etls_fullSTimer = %sysfunc(getoption(fullstimer));\n").addSourceCode("%let etls_sqlIpTrace = %sysfunc(getoption(sql_ip_trace));\n").genDebugOptionCode();
            }
            if (!validateCode) {
                if (!this.isPassThru() && this.m_bSPDSTables && hasSPDSOptions) {
                    codeSegment.addSourceCode("%let spdssqlr = ");
                    if (isDebug) {
                        codeSegment.addSourceCode(" _method");
                    }
                    if (isSPDSParallelJoin) {
                        codeSegment.addSourceCode(" ").addSourceCode(this.m_sSPDSParallelJoin);
                    }
                    if (!"".equals(this.m_sMaxInputRows)) {
                        codeSegment.addSourceCode(" inobs = ").addSourceCode(this.m_sMaxInputRows);
                    }
                    if (!"".equals(this.m_sMaxOutputRows)) {
                        codeSegment.addSourceCode(" outobs = ").addSourceCode(this.m_sMaxOutputRows);
                    }
                    if (this.m_bSuggestSortMergeJoin) {
                        codeSegment.addSourceCode(" magic = 102");
                    }
                    if (!"".equals(this.m_sSPDSOptions)) {
                        codeSegment.addSourceCode("\n").indent().addSourceCode(this.m_sSPDSOptions).addSourceCode("\n").unIndent();
                    }
                    codeSegment.addSourceCode(";\n\n");
                } else if (!this.isPassThru() && this.m_bSPDSTables && !hasSPDSOptions) {
                    codeSegment.addSourceCode("%let spdssqlr = ;\n\n");
                }
            }
            this.generateMappingWarnings(codeSegment, this.getOrdinaryMappings());
            IColumn[] unmappedColumns = this.getOrdinaryUnmappedTargetColumns(null);
            if (unmappedColumns != null && unmappedColumns.length > 0) {
                codeSegment.addSourceCode("data _null_;\n").indent().genPutStatement(MessageFormat.format(RB.getStringResource("SQLJoinTransformModel.UnmappedSetMissing.comment.notrans"), codeSegment.makeColumnList(Arrays.asList(unmappedColumns), "   ", false, ","))).unIndent().addSourceCode("run;\n\n");
            }
            codeSegment.addSourceCode("proc sql");
            if (validateCode) {
                codeSegment.addSourceCode(" noexec");
            }
            if (isDebug) {
                codeSegment.addSourceCode(" _method");
            }
            if (this.m_bSuggestSortMergeJoin) {
                codeSegment.addSourceCode(" magic = 102");
            }
            if (!"".equals(this.m_sBufferSize.trim())) {
                codeSegment.addSourceCode(" buffersize = ").addSourceCode(this.m_sBufferSize);
            }
            if (!"".equals(this.m_sMaxInputRows)) {
                codeSegment.addSourceCode(" inobs = ").addSourceCode(this.m_sMaxInputRows);
            }
            if (!"".equals(this.m_sMaxOutputRows)) {
                codeSegment.addSourceCode(" outobs = ").addSourceCode(this.m_sMaxOutputRows);
            }
            if (!"systemdefault".equalsIgnoreCase(this.m_sThreads)) {
                codeSegment.addSourceCode(" ").addSourceCode(this.m_sThreads);
            }
            if (this.m_sSQLOptions.trim().length() > 0) {
                codeSegment.addSourceCode("\n").indent().addSourceCode(this.m_sSQLOptions).addSourceCode("\n").unIndent();
            }
            codeSegment.addSourceCode(";\n").indent();
            IPhysicalTable sourceTable = (IPhysicalTable)this.getDataSources()[0];
            if (this.isPassThru() && sourceTable != null) {
                sourceTable.getDBMSType().genConnect(codeSegment, sourceTable);
            }
            if (sourceTable != null && this.isPassThru() && this.m_bSPDSTables && hasSPDSOptions) {
                sourceTable.getDBMSType().genExecuteBegin(codeSegment, sourceTable, "");
                codeSegment.addSourceCode("reset\n").indent();
                if (isDebug) {
                    codeSegment.addSourceCode(" _method\n");
                }
                if (isSPDSParallelJoin) {
                    codeSegment.addSourceCode(" ").addSourceCode(this.m_sSPDSParallelJoin).addSourceCode("\n");
                }
                if (!"".equals(this.m_sMaxInputRows)) {
                    codeSegment.addSourceCode(" inobs = ").addSourceCode(this.m_sMaxInputRows).addSourceCode("\n");
                }
                if (!"".equals(this.m_sMaxOutputRows)) {
                    codeSegment.addSourceCode(" outobs = ").addSourceCode(this.m_sMaxOutputRows).addSourceCode("\n");
                }
                if (!"".equals(this.m_sSPDSOptions)) {
                    codeSegment.addSourceCode(" ").addSourceCode(this.m_sSPDSOptions).addSourceCode("\n");
                }
                if (this.m_bSuggestSortMergeJoin) {
                    codeSegment.addSourceCode(" magic = 102\n");
                }
                codeSegment.unIndent();
                sourceTable.getDBMSType().genExecuteEnd(codeSegment, sourceTable, "");
            }
            boolean bl3 = useCreateSyntax = !this.m_bTargetIsPassThru || target.isView();
            if (this.m_bTargetIsPassThru) {
                sourceTable.getDBMSType().genExecuteBegin(codeSegment, sourceTable, "");
            }
            if ((desc = this.getCreateDescription()).length() > 0) {
                codeSegment.addCommentLine(desc);
            }
            if (useCreateSyntax) {
                codeSegment.addSourceCode("create").addSourceCode(target.isView() ? " view " : " table ");
            } else if (target.getDBMSType() instanceof HADOOPType || target.getDBMSType() instanceof SASHDATType || target.getDBMSType() instanceof SASIOIMPType) {
                if (this.m_bTargetIsPassThru && (target.getDBMSType() instanceof HADOOPType || target.getDBMSType() instanceof SASHDATType)) {
                    codeSegment.addSourceCode("insert overwrite table ");
                } else {
                    codeSegment.addSourceCode("insert into table ");
                }
            } else {
                codeSegment.addSourceCode("insert into ");
            }
            String targetName = !validateCode ? target.getFullNameQuotedAsNeeded(codeSegment, this.m_bTargetIsPassThru) : target.getLibref(codeSegment.getCurrentServer()) + "." + codeSegment.getUniqueWorkTableName();
            codeSegment.addSourceCode(targetName);
            StringBuffer targetOptions = this.m_query.getTargetTableOptions();
            ITransformTableOptions targetOptionModel = this.getTableOptionObject(target, false);
            String targetDataOptions = targetOptionModel.getTableOptions(false, "", targetOptions.toString(), codeSegment.getCurrentServer());
            if (!this.m_bTargetIsPassThru && targetOptions != null && targetDataOptions.length() > 0) {
                codeSegment.addSourceCode("\n").addSourceCode("(").indent().addSourceCode("\n").addSourceCode(targetDataOptions).unIndent().addSourceCode("\n").addSourceCode(")");
            } else if (this.m_bTargetIsPassThru && (optionModel = targetOptionModel.getOptionModel()) != null && (definition = optionModel.findDefinition(PROPERTY_NAME_ADDITIONAL_OPTIONS)) != null) {
                try {
                    codeSegment.addSourceCode(optionModel.getOptionsString(new IPromptDefinitionValue[]{definition}, null, null));
                }
                catch (ServerConnectionException e) {
                    throw new ServerException(e);
                }
                catch (ServiceException e) {
                    throw new ServerException(e);
                }
            }
            if (useCreateSyntax) {
                codeSegment.addSourceCode(" as");
            }
            codeSegment.addSourceCode("\n");
            this.m_query.getGeneratedCode(codeSegment, this.isPassThru());
            if (this.isPassThru() && this.m_bTargetIsPassThru && sourceTable != null) {
                codeSegment.addSourceCode("\n");
                sourceTable.getDBMSType().genExecuteEnd(codeSegment, sourceTable, "");
            }
            if (this.isPassThru() && sourceTable != null) {
                sourceTable.getDBMSType().genExecuteCommit(codeSegment, sourceTable, "");
                sourceTable.getDBMSType().genDisconnect(codeSegment, sourceTable);
            }
            if (!this.isPassThru()) {
                codeSegment.addSourceCode(";\n");
            }
            codeSegment.unIndent().addSourceCode("quit;\n\n");
            codeSegment.genPushDownMacroCode();
            if (isDebug) {
                codeSegment.addSourceCode("options sql_ip_trace = &etls_sqlIpTrace sastrace = \"&etls_sasTrace\" &etls_fullSTimer ; \n\n");
            }
            codeSegment.genRCSetCall("&sqlrc");
            for (int i = 0; i < movedSourceTables.size(); ++i) {
                ISourceTable table = (ISourceTable)movedSourceTables.get(i);
                table.genCleanUpMovedTableCode(codeSegment);
            }
            if (this.isGenerateIndexesOnTargetTables() && !validateCode) {
                IDBMSType targetType = target.getDBMSType();
                if ("delete".equals(this.m_sPreTargetPassThruAction) && !target.isView() && targetType.hasIndexes(target)) {
                    codeSegment.addSourceCode("%macro etls_completeTarget();\n").indent();
                    targetType.createIndexes2(codeSegment, target, null, "");
                    codeSegment.unIndent().addSourceCode("%mend etls_completeTarget;\n").addSourceCode("%etls_completeTarget;\n\n");
                }
            }
            if (!validateCode) {
                this.genCodeConditionCheck(codeSegment);
            }
        }
        finally {
            this.setPassThru(passthru);
            this.m_bTargetIsPassThru = targetPassthru;
            this.fixMovedTables();
        }
        return codeSegment;
    }

    protected void genCodeConditionCheck(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        IConditionActionSet[] conditionActions = this.getConditionActionSets();
        if (conditionActions.length == 0) {
            return;
        }
        codeSegment.addCommentLine(RB.getStringResource("SQLJoinTransformModel.RCCheck.msg.txt"));
        codeSegment.addSourceCode("%macro etls_sqlRcCheck; \n").indent();
        for (int iEvent = 0; iEvent < conditionActions.length; ++iEvent) {
            IConditionActionSet lEvent = conditionActions[iEvent];
            String eventRole = lEvent.getUniqueIdentifier();
            if (!"DIS_SETSUCCESS".equals(eventRole) && !"DIS_SETWARN".equals(eventRole) && !"DIS_SETERROR".equals(eventRole)) continue;
            ICondition lEventCondition = lEvent.getCondition();
            codeSegment.addSourceCode(lEventCondition.getConditionMacroCall("trans_rc") + "\n");
            codeSegment.addSourceCode("%do; \n").indent();
            IConditionAction[] actions = lEvent.getActions();
            for (int iAction = 0; iAction < actions.length; ++iAction) {
                codeSegment.addSourceCode(actions[iAction].getActionMacroCall(this.getJob().isUsingNLSDateFormat(), codeSegment));
            }
            codeSegment.unIndent().addSourceCode("%end; \n\n");
        }
        codeSegment.unIndent().addSourceCode("%mend etls_sqlRcCheck; \n").addSourceCode("%etls_sqlRcCheck; \n\n");
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_query.isChanged();
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && (this.isUsingUserWrittenCode() || this.m_query.isComplete());
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (!this.isUsingUserWrittenCode() && !this.m_query.isComplete()) {
            lReasons.addAll(this.m_query.getReasonsIncomplete());
        }
        return lReasons;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = this.getClassifierMapObject(omr);
        mdoCM.setTransformRole("SQL");
        mdoCM.setDesc(this.m_sCreateDescription);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_PASSTHRU, PROPERTY_NAME_PASSTHRU, PROPERTY_NAME_PASSTHRU, this.isPassThru() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_MAGIC, PROPERTY_NAME_MAGIC, PROPERTY_NAME_MAGIC, this.isSuggestSortMergeJoin() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_TARGET_PASSTHRU, PROPERTY_NAME_TARGET_PASSTHRU, PROPERTY_NAME_TARGET_PASSTHRU, this.isTargetPassThru() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_BUFFER_SIZE, PROPERTY_NAME_BUFFER_SIZE, PROPERTY_NAME_BUFFER_SIZE, this.getBufferSize(), 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_INOBS, PROPERTY_NAME_INOBS, PROPERTY_NAME_INOBS, this.getMaxInputRows(), 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_OUTOBS, PROPERTY_NAME_OUTOBS, PROPERTY_NAME_OUTOBS, this.getMaxOutputRows(), 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_PRETARGETPASSTHRUACTION, PROPERTY_NAME_PRETARGETPASSTHRUACTION, PROPERTY_NAME_PRETARGETPASSTHRUACTION, this.getPreTargetPassThruAction(), 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_SPDS_OPTIONS, PROPERTY_NAME_SPDS_OPTIONS, PROPERTY_NAME_SPDS_OPTIONS, this.getSPDSOptions(), 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_SPDSPARALLELJOIN, PROPERTY_NAME_SPDSPARALLELJOIN, PROPERTY_NAME_SPDSPARALLELJOIN, this.getSPDSParallelJoin(), 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_SQL_OPTIONS, PROPERTY_NAME_SQL_OPTIONS, PROPERTY_NAME_SQL_OPTIONS, this.getSQLOptions(), 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_THREADS, PROPERTY_NAME_THREADS, PROPERTY_NAME_THREADS, this.getThreads(), 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_AUTOJOIN, PROPERTY_NAME_AUTOJOIN, PROPERTY_NAME_AUTOJOIN, this.isAutoJoinEnabled() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_DEBUG, PROPERTY_NAME_DEBUG, PROPERTY_NAME_DEBUG, this.isDebug() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.savePropertyToOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, USETARGETLIBRARYINFO, USETARGETLIBRARYINFO, USETARGETLIBRARYINFO, this.isUseTargetForConnect() ? DEFAULT_VALUE_YES : DEFAULT_VALUE_NO, 12, 0);
        this.m_query.saveToOMR(omr);
        Select mdoQuery = (Select)omr.acquireOMRObject(this.m_query);
        AssociationList lTranSrcs = mdoCM.getTransformationSources(false);
        lTranSrcs.add(mdoQuery);
        Root mdoSelect = omr.acquireOMRObject(this.m_query);
        Property property = this.findProperty(omr, mdoSelect, PROPERTY_TARGET_TABLE_SET_ROLE, PROPERTY_NAME_ADDITIONAL_OPTIONS, 0);
        if (property != null) {
            this.deletePropertyFromOMR(omr, PROPERTY_TARGET_TABLE_SET_ROLE, PROPERTY_NAME_ADDITIONAL_OPTIONS);
        }
        if ((property = this.findProperty(omr, mdoSelect, PROPERTY_TARGET_TABLE_SET_ROLE, PROPERTY_NAME_INSERTBUFF, 0)) != null) {
            this.deletePropertyFromOMR(omr, PROPERTY_TARGET_TABLE_SET_ROLE, PROPERTY_NAME_INSERTBUFF);
        }
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        ISourceTable source;
        ISQLSource from;
        ISourceTable[] aSources;
        boolean bFromImport = false;
        TransformationStep mdoStep = (TransformationStep)omr.acquireOMRObject(this);
        AssociationList lTransforms = mdoStep.getTransformations();
        ClassifierMap mdoCM = null;
        if (!lTransforms.isEmpty()) {
            mdoCM = (ClassifierMap)lTransforms.get(0);
            this.m_sCreateDescription = mdoCM.getDesc();
            AssociationList lTranSrcs = mdoCM.getTransformationSources();
            if (!lTranSrcs.isEmpty()) {
                Select mdoSelect = null;
                for (int i = 0; i < lTranSrcs.size(); ++i) {
                    Transformation mdo = (Transformation)lTranSrcs.get(i);
                    if (!mdo.getTransformRole().equals("CreateSelect")) continue;
                    mdoSelect = (Select)mdo;
                    break;
                }
                if (mdoSelect != null) {
                    this.m_query = (IQuery)this.getModel().getObject(mdoSelect.getFQID());
                    if (this.m_query == null) {
                        this.m_query = (IQuery)this.getModel().getObjectFactory().createObjectFromOMRObject((Root)mdoSelect);
                        this.m_query.setTransformModel(this);
                    }
                    this.m_mappingContainer = new SelectResultsContainer(this.createIDForNewObject(), this.getModel(), this.m_query);
                    this.m_query.setSelectResults(this.m_mappingContainer);
                    this.m_query.setSaveSelectResults(false);
                    this.m_query.loadFromOMR(omr);
                    this.m_query.addNotifyListener(this);
                }
            } else {
                this.m_query = this.getModel().getObjectFactory().createNewSQLQuery(this.getID());
                this.m_query.setTransformModel(this);
                this.m_mappingContainer = new SelectResultsContainer(this.createIDForNewObject(), this.getModel(), this.m_query);
                this.m_query.setSelectResults(this.m_mappingContainer);
                this.m_query.setSaveSelectResults(false);
                bFromImport = true;
                this.m_query.addNotifyListener(this);
            }
        }
        super.loadFromOMR(omr);
        if (this.m_query.getAllSourceTables().isEmpty() && this.getDataSourcesCount() > 0) {
            if (this.getDataSourcesCount() == 1) {
                ISourceTable source2 = this.m_query.addQuerySourceTable((ITable)this.getDataSources()[0]);
                this.m_query.setSourceOfFrom(source2);
                this.mapColumns();
            } else {
                IDataObject[] aSourceTables = this.getDataSources();
                for (int index = 0; index < aSourceTables.length; ++index) {
                    IPhysicalTable source3 = (IPhysicalTable)aSourceTables[index];
                    this.m_query.addQuerySourceTable(source3);
                    this.mapColumns();
                }
                aSources = this.m_query.getQuerySourceTables();
                int iSrcs = aSources.length;
                IJoin lastJoin = this.m_query.createAJoin(aSources[0], aSources[1], "Inner");
                for (int i = 2; i < iSrcs; ++i) {
                    IJoin nextJoin;
                    lastJoin = nextJoin = this.m_query.createAJoin(lastJoin, aSources[i], "Inner");
                }
                this.m_query.setSourceOfFrom(lastJoin);
            }
        }
        if ((from = this.m_query.getSourceOfFrom()) != null) {
            aSources = from.getSQLSourceTables();
            for (int iSrc = 0; iSrc < aSources.length; ++iSrc) {
                source = aSources[iSrc];
                ITable table = source.getAliasedTable();
                if (this.containsInDataSources(table) || table == null) continue;
                this.addDataSource(table);
            }
        }
        this.updatePortDescriptions();
        if (mdoCM == null) {
            mdoCM = this.getClassifierMapObject(omr);
        }
        this.setPassThru(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_PASSTHRU, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_YES));
        this.setSuggestSortMergeJoin(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_MAGIC, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_YES));
        this.setTargetPassThru(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_TARGET_PASSTHRU, DEFAULT_VALUE_YES, 0).equalsIgnoreCase(DEFAULT_VALUE_YES));
        this.setBufferSize(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_BUFFER_SIZE, "", 0));
        this.setMaxInputRows(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_INOBS, "", 0));
        this.setMaxOutputRows(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_OUTOBS, "", 0));
        this.setPreTargetPassThruAction(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_PRETARGETPASSTHRUACTION, "delete", 0));
        this.setSPDSOptions(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_SPDS_OPTIONS, "", 0));
        this.setSPDSParallelJoin(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_SPDSPARALLELJOIN, "systemdefault", 0));
        this.setSQLOptions(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_SQL_OPTIONS, "", 0));
        this.setThreads(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_THREADS, "systemdefault", 0));
        this.setAutoJoinEnabled(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_AUTOJOIN, DEFAULT_VALUE_YES, 0).equalsIgnoreCase(DEFAULT_VALUE_YES));
        this.setIsDebug(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, PROPERTY_NAME_DEBUG, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_YES));
        this.setUseTargetForConnect(this.loadPropertyFromOMR(omr, (Root)mdoCM, PROPERTY_SET_ROLE, USETARGETLIBRARYINFO, DEFAULT_VALUE_NO, 0).equalsIgnoreCase(DEFAULT_VALUE_YES));
        if (this.getDataTargetsCount() > 0 && this.m_query != null) {
            this.m_query.setTargetTable((ITable)this.getDataTargets()[0]);
        }
        if (!bFromImport) {
            this.m_query.setChanged(false);
        }
        List lQueryTables = this.m_query.getAllSourceTables();
        for (int index = 0; index < lQueryTables.size(); ++index) {
            source = (ISourceTable)lQueryTables.get(index);
            ITable aliasTable = source.getAliasedTable();
            if (aliasTable != null) continue;
            this.m_query.removeQuerySourceTable(source);
        }
        this.setChanged(false);
    }

    @Override
    protected void saveMappingsToOMR(OMRAdapter omr, ClassifierMap mdoCM, ITable tblTarget) throws MdException, RemoteException {
        mdoCM.getFeatureMaps(false).clear();
        super.saveMappingsToOMR(omr, mdoCM, tblTarget);
    }

    @Override
    protected boolean loadTransformTableOptionsFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        ITransformTableOptions options;
        Root mdAnchor = omr.acquireOMRObject(this);
        boolean changed = false;
        IPhysicalTable target = (IPhysicalTable)this.getDataTarget();
        AssociationList propertySets = mdAnchor.getPropertySets();
        for (int i = 0; i < propertySets.size(); ++i) {
            PropertySet pSet = (PropertySet)propertySets.get(i);
            if (!"TransformTableOptions".equals(pSet.getSetRole())) continue;
            BaseTransformTableOptions transformOpts = new BaseTransformTableOptions(pSet.getFQID(), this.getModel());
            IPhysicalTable table = transformOpts.loadAssociatedObject(omr, pSet.getFQID());
            if (target == table) {
                transformOpts.setOwner(this);
                transformOpts.loadFromOMR(omr);
                this.addTransformTableOption(transformOpts);
                continue;
            }
            this.addToDeletedObjects(transformOpts);
            transformOpts.delete();
            changed = true;
        }
        if (this.getTableOptionObjects().length == 0 && target != null) {
            this.addTransformTableOption(this.createTransformTableOption(target, false));
            changed = true;
        }
        if ((options = this.getTableOptionObject(target, false)) != null) {
            try {
                PhysicalTablePromptModelCollection optionModel = options.getOptionModel();
                if (this.m_query != null) {
                    String sInsertBuffer;
                    Root mdoQuery = omr.acquireOMRObject(this.m_query);
                    String sAdditionalOptions = this.loadPropertyFromOMR(omr, mdoQuery, PROPERTY_TARGET_TABLE_SET_ROLE, PROPERTY_NAME_ADDITIONAL_OPTIONS, "", 0);
                    if (sAdditionalOptions.length() > 0) {
                        optionModel.setOptionValue(PROPERTY_NAME_ADDITIONAL_OPTIONS, (Object)sAdditionalOptions);
                        changed = true;
                    }
                    if ((sInsertBuffer = this.loadPropertyFromOMR(omr, mdoQuery, PROPERTY_TARGET_TABLE_SET_ROLE, PROPERTY_NAME_INSERTBUFF, "", 0)).length() > 0) {
                        optionModel.setOptionValue("INSERTBUFF", (Object)sInsertBuffer);
                        changed = true;
                    }
                }
            }
            catch (IllegalStateException e) {
                ModelLogger.getDefaultLogger().error((Object)"IllegalStateException", (Throwable)e);
            }
            catch (ServiceException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServiceException", (Throwable)e);
            }
            catch (ServerConnectionException e) {
                ModelLogger.getDefaultLogger().error((Object)"ServerConnectionException", (Throwable)e);
            }
        }
        return changed;
    }

    @Override
    protected IMapping createMapping(OMRAdapter omr, FeatureMap mdoFM) throws MdException, RemoteException {
        SQLMapping mapping = (SQLMapping)this.getModel().getObject(mdoFM.getFQID());
        if (mapping == null) {
            mapping = (SQLMapping)this.getModel().getObjectFactory().createSQLMapping(mdoFM.getFQID(), this.m_mappingContainer);
            mapping.loadFromOMR(omr);
        }
        mapping.setExpressionAllowed(this.areExpressionsAllowed());
        if (mapping.isOrdinary()) {
            mapping.setAutoType(true);
        }
        return mapping;
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getClassifierMapType());
        lAssociations.add("PropertySets");
        map.put(this.getClassifierMapType(), lAssociations);
        return map;
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        this.m_query.deleteFromOMR(omr);
        if (this.m_mappingContainer != null) {
            IMapping[] aMappings = this.m_mappingContainer.getMappings();
            for (int iMapping = 0; iMapping < aMappings.length; ++iMapping) {
                aMappings[iMapping].deleteFromOMR(omr);
            }
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_query != null) {
            this.m_query.updateIDs(mapIDs);
        }
    }

    public ICodeSegment getSuperGeneratedCode(ICodeSegment codeSegment, boolean validateCode) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        super.getGeneratedCode(codeSegment, validateCode);
        return codeSegment;
    }

    public List getSuperReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        return lReasons;
    }

    public boolean isValidAsSourceTable(IDataObject source) {
        if (source == null) {
            return false;
        }
        IDBMSType dbmsType = ((IPhysicalTable)source).getDBMSType();
        boolean isDisallowedType = dbmsType instanceof SASHDATType || dbmsType instanceof SASIOLAType;
        return source instanceof IPhysicalTable && !isDisallowedType;
    }

    private class SetSPDSTablesUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldSPDSTables;
        private boolean m_newSPDSTables;

        public SetSPDSTablesUndoable(boolean oldSPDSTables, boolean newSPDSTables) {
            this.m_oldSPDSTables = oldSPDSTables;
            this.m_newSPDSTables = newSPDSTables;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setSPDSTables(this.m_oldSPDSTables);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setSPDSTables(this.m_newSPDSTables);
        }
    }

    private class SetTargetPassThruEnabledUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldTargetPassThruEnabled;
        private boolean m_newTargetPassThruEnabled;

        public SetTargetPassThruEnabledUndoable(boolean oldTargetPassThruEnabled, boolean newTargetPassThruEnabled) {
            this.m_oldTargetPassThruEnabled = oldTargetPassThruEnabled;
            this.m_newTargetPassThruEnabled = newTargetPassThruEnabled;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setTargetPassThruEnabled(this.m_oldTargetPassThruEnabled);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setTargetPassThruEnabled(this.m_newTargetPassThruEnabled);
        }
    }

    private class AddInputUndoable
    extends AbstractUndoableEdit {
        private ISQLPort m_portDesc;
        private int m_iPortIndex;

        public AddInputUndoable(ISQLPort portDesc, int iPortIndex) {
            this.m_portDesc = portDesc;
            this.m_iPortIndex = iPortIndex;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.deleteInputImpl(this.m_portDesc, this.m_iPortIndex);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.addInputImpl(this.m_portDesc, this.m_iPortIndex);
        }

        @Override
        public void die() {
            super.die();
            this.m_portDesc = null;
        }
    }

    private class DeleteInputUndoable
    extends AbstractUndoableEdit {
        private ISQLPort m_portDesc;
        private int m_iPortIndex;

        public DeleteInputUndoable(ISQLPort portDesc, int iPortIndex) {
            this.m_portDesc = portDesc;
            this.m_iPortIndex = iPortIndex;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.addInputImpl(this.m_portDesc, this.m_iPortIndex);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.deleteInputImpl(this.m_portDesc, this.m_iPortIndex);
        }

        @Override
        public void die() {
            super.die();
            this.m_portDesc = null;
        }
    }

    private class SetCreateDescriptionUndoable
    extends AbstractUndoableEdit {
        private String m_oldCreateDescription;
        private String m_newCreateDescription;

        public SetCreateDescriptionUndoable(String oldCreateDescription, String newCreateDescription) {
            this.m_oldCreateDescription = oldCreateDescription;
            this.m_newCreateDescription = newCreateDescription;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setCreateDescription(this.m_oldCreateDescription);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setCreateDescription(this.m_newCreateDescription);
        }
    }

    private class SetSQLOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldSQLOptions;
        private String m_newSQLOptions;

        public SetSQLOptionsUndoable(String oldSQLOptions, String newSQLOptions) {
            this.m_oldSQLOptions = oldSQLOptions;
            this.m_newSQLOptions = newSQLOptions;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setSQLOptions(this.m_oldSQLOptions);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setSQLOptions(this.m_newSQLOptions);
        }
    }

    private class SetTargetPassThruUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldTargetPassThru;
        private boolean m_newTargetPassThru;

        public SetTargetPassThruUndoable(boolean oldTargetPassThru, boolean newTargetPassThru) {
            this.m_oldTargetPassThru = oldTargetPassThru;
            this.m_newTargetPassThru = newTargetPassThru;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setTargetPassThru(this.m_oldTargetPassThru);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setTargetPassThru(this.m_newTargetPassThru);
        }
    }

    private class SetPreTargetPassThruActionUndoable
    extends AbstractUndoableEdit {
        private String m_oldTargetPassThruAction;
        private String m_newTargetPassThruAction;

        public SetPreTargetPassThruActionUndoable(String oldTargetPassThruAction, String newTargetPassThruAction) {
            this.m_oldTargetPassThruAction = oldTargetPassThruAction;
            this.m_newTargetPassThruAction = newTargetPassThruAction;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setPreTargetPassThruAction(this.m_oldTargetPassThruAction);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setPreTargetPassThruAction(this.m_newTargetPassThruAction);
        }
    }

    private class SetSuggestSortMergeJoinUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldSuggestSortMergeJoin;
        private boolean m_newSuggestSortMergeJoin;

        public SetSuggestSortMergeJoinUndoable(boolean oldSuggestSortMergeJoin, boolean newSuggestSortMergeJoin) {
            this.m_oldSuggestSortMergeJoin = oldSuggestSortMergeJoin;
            this.m_newSuggestSortMergeJoin = newSuggestSortMergeJoin;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setSuggestSortMergeJoin(this.m_oldSuggestSortMergeJoin);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setSuggestSortMergeJoin(this.m_newSuggestSortMergeJoin);
        }
    }

    private class SetDebugUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldDebug;
        private boolean m_newDebug;

        public SetDebugUndoable(boolean oldDebug, boolean newDebug) {
            this.m_oldDebug = oldDebug;
            this.m_newDebug = newDebug;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setIsDebug(this.m_oldDebug);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setIsDebug(this.m_newDebug);
        }
    }

    private class SetBufferSizeUndoable
    extends AbstractUndoableEdit {
        private String m_oldBufferSize;
        private String m_newBufferSize;

        public SetBufferSizeUndoable(String oldBufferSize, String newBufferSize) {
            this.m_oldBufferSize = oldBufferSize;
            this.m_newBufferSize = newBufferSize;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setBufferSize(this.m_oldBufferSize);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setBufferSize(this.m_newBufferSize);
        }
    }

    private class SetUseTargetForConnectUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldUseTargetForConnect;
        private boolean m_newUseTargetForConnect;

        public SetUseTargetForConnectUndoable(boolean m_oldUseTargetForConnect, boolean m_newUseTargetForConnect) {
            this.m_oldUseTargetForConnect = m_oldUseTargetForConnect;
            this.m_newUseTargetForConnect = m_newUseTargetForConnect;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setUseTargetForConnect(this.m_oldUseTargetForConnect);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setUseTargetForConnect(this.m_newUseTargetForConnect);
        }
    }

    private class SetMaxInputRowsUndoable
    extends AbstractUndoableEdit {
        private String m_oldInObs;
        private String m_newInObs;

        public SetMaxInputRowsUndoable(String oldInObs, String newInObs) {
            this.m_oldInObs = oldInObs;
            this.m_newInObs = newInObs;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setMaxInputRows(this.m_oldInObs);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setMaxInputRows(this.m_newInObs);
        }
    }

    private class SetMaxOutputRowsUndoable
    extends AbstractUndoableEdit {
        private String m_oldOutObs;
        private String m_newOutObs;

        public SetMaxOutputRowsUndoable(String oldOutObs, String newOutObs) {
            this.m_oldOutObs = oldOutObs;
            this.m_newOutObs = newOutObs;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setMaxOutputRows(this.m_oldOutObs);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setMaxOutputRows(this.m_newOutObs);
        }
    }

    private class SetThreadsUndoable
    extends AbstractUndoableEdit {
        private String m_oldThreads;
        private String m_newThreads;

        public SetThreadsUndoable(String oldThreads, String newThreads) {
            this.m_oldThreads = oldThreads;
            this.m_newThreads = newThreads;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setThreads(this.m_oldThreads);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setThreads(this.m_newThreads);
        }
    }

    private class SetSPDSParallelJoinUndoable
    extends AbstractUndoableEdit {
        private String m_oldSPDSParallelJoin;
        private String m_newSPDSParallelJoin;

        public SetSPDSParallelJoinUndoable(String oldSPDSParallelJoin, String newSPDSParallelJoin) {
            this.m_oldSPDSParallelJoin = oldSPDSParallelJoin;
            this.m_newSPDSParallelJoin = newSPDSParallelJoin;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setSPDSParallelJoin(this.m_oldSPDSParallelJoin);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setSPDSParallelJoin(this.m_newSPDSParallelJoin);
        }
    }

    private class SetSPDSOptionsUndoable
    extends AbstractUndoableEdit {
        private String m_oldSPDSOptions;
        private String m_newSPDSOptions;

        public SetSPDSOptionsUndoable(String oldSPDSOptions, String newSPDSOptions) {
            this.m_oldSPDSOptions = oldSPDSOptions;
            this.m_newSPDSOptions = newSPDSOptions;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setSPDSOptions(this.m_oldSPDSOptions);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setSPDSOptions(this.m_newSPDSOptions);
        }
    }

    private class SetAutoJoinUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldAutoJoin;
        private boolean m_newAutoJoin;

        public SetAutoJoinUndoable(boolean oldAutoJoin, boolean newAutoJoin) {
            this.m_oldAutoJoin = oldAutoJoin;
            this.m_newAutoJoin = newAutoJoin;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.setAutoJoinEnabled(this.m_oldAutoJoin);
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.setAutoJoinEnabled(this.m_newAutoJoin);
        }
    }

    private class DisconnectDataSourceUndoable
    extends AbstractUndoableEdit {
        private IDataObject m_source;
        private int m_iPortIndex;

        public DisconnectDataSourceUndoable(IDataObject source, int iPortIndex) {
            this.m_source = source;
            this.m_iPortIndex = iPortIndex;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.fireModelChangedEvent("DataTransform.DataSourceAdded", this.m_source, new Integer(this.m_iPortIndex));
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.fireModelChangedEvent("DataTransform.DataSourceRemoved", this.m_source, new Integer(this.m_iPortIndex));
        }

        @Override
        public void die() {
            super.die();
            this.m_source = null;
        }
    }

    private class ConnectDataSourceUndoable
    extends AbstractUndoableEdit {
        private IDataObject m_source;
        private int m_iPortIndex;

        public ConnectDataSourceUndoable(IDataObject source, int iPortIndex) {
            this.m_source = source;
            this.m_iPortIndex = iPortIndex;
        }

        @Override
        public void undo() {
            super.undo();
            SQLJoinTransformModel.this.fireModelChangedEvent("DataTransform.DataSourceRemoved", this.m_source, new Integer(this.m_iPortIndex));
        }

        @Override
        public void redo() {
            super.redo();
            SQLJoinTransformModel.this.fireModelChangedEvent("DataTransform.DataSourceAdded", this.m_source, new Integer(this.m_iPortIndex));
        }

        @Override
        public void die() {
            super.die();
            this.m_source = null;
        }
    }
}

