/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.INotifyListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IBooleanExpression;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IClause;
import com.sas.etl.models.job.transforms.sql.IJoin;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISQLTransform;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.etl.models.job.transforms.sql.IWhere;
import com.sas.etl.models.job.transforms.sql.impl.AbstractSQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.impl.ClauseType;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import com.sas.etl.models.job.transforms.sql.impl.SetSQLSourceParentHelper;
import com.sas.etl.models.job.transforms.sql.impl.Subquery;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Select;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class Join
extends AbstractSQLBooleanExpressionContainer
implements IJoin {
    public static final int OBJECT_CHANGED_LEFT = 20;
    public static final int OBJECT_CHANGED_RIGHT = 21;
    public static final String JOIN_TRANSFORM_ROLE = "Join";
    public static final String START_JOIN_TRANSFORM_ROLE = "StartJoin";
    private static final String PROPERTY_NAME_JOIN_TYPE = "JoinType";
    private static final String PROPERTY_NAME_IMPLICIT_JOIN = "Implicit";
    private static final String PROPERTY_NAME_PARENTHESIS = "Parenthesis";
    private static final String VALUE_TRUE = "YES";
    private static final String VALUE_FALSE = "NO";
    private ISQLSource m_leftSide;
    private ISQLSource m_rightSide;
    private boolean m_bImplicit = true;
    private boolean m_bParentheses = false;
    private String m_sType = "Inner";
    private String m_sRole = "Join";
    private SetSQLSourceParentHelper m_setParentHelper = new SetSQLSourceParentHelper(this);
    private boolean m_bHasDefaultJoinRun = false;
    private boolean m_bNoResetSide = false;
    private boolean m_bSkipLeftCodeGen = false;
    private boolean m_bSkipCodeGen = false;

    public Join(String sID, IModel model) {
        super(sID, model);
    }

    @Override
    protected String getDefaultName() {
        return JOIN_TRANSFORM_ROLE;
    }

    @Override
    public boolean isComplete() {
        boolean bExplicitComplete = true;
        if (!(this.useImplicit() || this.m_sType.equals("Cross") || this.m_sType.equals("Union"))) {
            bExplicitComplete = super.isComplete();
        }
        return bExplicitComplete && this.m_leftSide != null && this.m_leftSide.isComplete() && this.m_rightSide != null && this.m_rightSide.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        ArrayList<String> reasons = new ArrayList<String>();
        if (!(this.useImplicit() || this.m_sType.equals("Cross") || this.m_sType.equals("Union"))) {
            reasons.addAll(super.getReasonsIncomplete());
        }
        if (this.m_leftSide == null) {
            reasons.add(RB.getStringResource("Join.ReasonIncomplete.LeftSideMissing.txt"));
        } else {
            reasons.addAll(this.m_leftSide.getReasonsIncomplete());
        }
        if (this.m_rightSide == null) {
            reasons.add(RB.getStringResource("Join.ReasonIncomplete.RightSideMissing.txt"));
        } else {
            reasons.addAll(this.m_rightSide.getReasonsIncomplete());
        }
        return reasons;
    }

    @Override
    public void setRole(String sRole) {
        if (this.m_sRole.equalsIgnoreCase(sRole)) {
            return;
        }
        this.m_sRole = sRole;
        this.setChanged(true);
    }

    @Override
    public String getRole() {
        return this.m_sRole;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.FROM;
    }

    @Override
    public void setLeftSide(ISQLSource leftSide) {
        if (this.m_leftSide == leftSide) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IQuery query = this.getParentQuery();
            if (query != null && this.m_leftSide != null) {
                query.disconnectFromTransformModel(this.m_leftSide);
            }
            if (this.m_leftSide != null) {
                this.m_bNoResetSide = true;
                this.m_leftSide.setParent(null);
            }
            if (query != null && leftSide instanceof ISourceTable && !query.getQuerySourceTableList().contains(leftSide)) {
                query.addQuerySourceTable((ISourceTable)leftSide);
            }
            this.setLeftSideImpl(leftSide);
            if (this.m_leftSide != null) {
                this.m_bNoResetSide = true;
                this.m_leftSide.setParent(this);
            }
            if (query != null && this.m_leftSide != null) {
                query.connectToTransformModel(this.m_leftSide);
            }
            this.fireNotifyEvent(20, null);
            this.runAutoJoin();
        }
        finally {
            this.m_bNoResetSide = false;
            this.endCompoundUndoable();
        }
    }

    private void setLeftSideImpl(ISQLSource leftSide) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetLeftSideUndoable(this.m_leftSide, leftSide));
        }
        this.m_leftSide = leftSide;
        this.m_bHasDefaultJoinRun = false;
        this.fireModelChangedEvent("Join:LeftSideChanged", leftSide);
    }

    @Override
    public ISQLSource getLeftSide() {
        return this.m_leftSide;
    }

    @Override
    public void setRightSide(ISQLSource rightSide) {
        if (this.m_rightSide == rightSide) {
            return;
        }
        this.startCompoundUndoable();
        try {
            IQuery query = this.getParentQuery();
            if (query != null && this.m_rightSide != null) {
                query.disconnectFromTransformModel(this.m_rightSide);
            }
            if (this.m_rightSide != null) {
                this.m_bNoResetSide = true;
                this.m_rightSide.setParent(null);
            }
            if (query != null && rightSide instanceof ISourceTable && !query.getQuerySourceTableList().contains(rightSide)) {
                query.addQuerySourceTable((ISourceTable)rightSide);
            }
            this.setRightSideImpl(rightSide);
            if (this.m_rightSide != null) {
                this.m_bNoResetSide = true;
                this.m_rightSide.setParent(this);
            }
            if (query != null && this.m_rightSide != null) {
                query.connectToTransformModel(this.m_rightSide);
            }
            this.fireNotifyEvent(21, null);
            this.runAutoJoin();
        }
        finally {
            this.m_bNoResetSide = false;
            this.endCompoundUndoable();
        }
    }

    private void setRightSideImpl(ISQLSource rightSide) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetRightSideUndoable(this.m_rightSide, rightSide));
        }
        this.m_rightSide = rightSide;
        this.m_bHasDefaultJoinRun = false;
        this.fireModelChangedEvent("Join:RightSideChanged", rightSide);
    }

    @Override
    public ISQLSource getRightSide() {
        return this.m_rightSide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJoinType(String sType) {
        if (this.m_sType.equalsIgnoreCase(sType)) {
            return;
        }
        this.startCompoundUndoable();
        try {
            boolean runAutoJoin = false;
            if (this.useImplicit() && this.m_sType.equalsIgnoreCase("Inner") && (sType.equalsIgnoreCase("Left") || sType.equalsIgnoreCase("Right") || sType.equalsIgnoreCase("Full"))) {
                runAutoJoin = true;
            }
            String sOldType = this.m_sType;
            this.m_sType = sType == null || sType.length() == 0 ? "Inner" : sType;
            this.fireModelChangedEvent("Join:JoinTypeChanged", null);
            if (!this.m_sType.equalsIgnoreCase("Inner")) {
                this.setImplicit(false);
            } else {
                this.setImplicit(true);
            }
            if (this.m_sType.equalsIgnoreCase("Inner") || this.m_sType.equalsIgnoreCase("Union") || this.m_sType.equalsIgnoreCase("Cross")) {
                this.setUseUserWrittenCode(false);
            }
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SetJoinTypeUndoable(sOldType, sType));
            }
            if (this.m_sType.equalsIgnoreCase("Cross") || this.m_sType.equalsIgnoreCase("Union")) {
                List expressions = this.getBooleanExpressionsList();
                for (int i = 0; i < expressions.size(); ++i) {
                    expressions.remove(i);
                }
            }
            if (runAutoJoin && this.m_leftSide != null && this.m_rightSide != null) {
                this.m_bHasDefaultJoinRun = false;
                this.runAutoJoin();
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected void setJoinTypeImpl(String sType) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetJoinTypeUndoable(this.m_sType, sType));
        }
        this.m_sType = sType;
        this.fireModelChangedEvent("Join:JoinTypeChanged", null);
    }

    @Override
    public String getJoinType() {
        return this.m_sType;
    }

    @Override
    public void setParentheses(boolean bParentheses) {
        if (this.m_bParentheses == bParentheses) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetParenthesesUndoable(this.m_bParentheses, bParentheses));
        }
        this.m_bParentheses = bParentheses;
        this.fireModelChangedEvent("Join:ParenthesesChanged", null);
    }

    @Override
    public boolean useParentheses() {
        return this.m_bParentheses;
    }

    @Override
    public boolean hasParenthesesOnLeftSideInHierarchy() {
        if (this.useParentheses()) {
            return true;
        }
        if (this.m_leftSide != null && this.m_leftSide instanceof IJoin) {
            return ((IJoin)this.m_leftSide).hasParenthesesOnLeftSideInHierarchy();
        }
        return false;
    }

    @Override
    public IJoin[] getLeftSideJoins() {
        ArrayList<ISQLSource> lJoinObjects = new ArrayList<ISQLSource>();
        if (this.m_leftSide != null && this.m_leftSide instanceof IJoin) {
            lJoinObjects.add(this.m_leftSide);
            IJoin[] aJoins = ((IJoin)this.m_leftSide).getLeftSideJoins();
            lJoinObjects.addAll(Arrays.asList(aJoins));
        }
        return lJoinObjects.toArray(new IJoin[lJoinObjects.size()]);
    }

    @Override
    public void setImplicit(boolean bImplicit) {
        if (!this.m_sType.equalsIgnoreCase("Inner") && bImplicit) {
            throw new UnsupportedOperationException("Implicit can only be set to true for inner joins");
        }
        if (this.m_bImplicit == bImplicit) {
            return;
        }
        this.startCompoundUndoable();
        try {
            this.setImplicitImpl(bImplicit);
            if (this.useImplicit()) {
                this.setParentheses(false);
            }
            if (this.useImplicit() && this.size() > 0) {
                this.addExpressionsToWhereClause();
            } else if (this.getJoinType().equalsIgnoreCase("Inner")) {
                this.m_bHasDefaultJoinRun = false;
                this.runAutoJoin();
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    private void setImplicitImpl(boolean bImplicit) {
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetImplicitUndoable(this.m_bImplicit, bImplicit));
        }
        this.m_bImplicit = bImplicit;
        this.fireModelChangedEvent("Join:ImplicitChanged", null);
    }

    @Override
    public boolean useImplicit() {
        return this.m_bImplicit;
    }

    @Override
    public void swapLeftAndRightSides() {
        this.swapLeftAndRightSidesImpl(this.m_rightSide, this.m_leftSide);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapLeftAndRightSidesImpl(ISQLSource rightSide, ISQLSource leftSide) {
        ISQLSource newLeft = rightSide;
        ISQLSource newRight = leftSide;
        this.startCompoundUndoable();
        try {
            this.m_leftSide = null;
            this.m_rightSide = null;
            this.fireModelChangedEvent("Join:RightSideChanged", null);
            this.fireModelChangedEvent("Join:LeftSideChanged", null);
            this.fireNotifyEvent(10);
            this.m_leftSide = newLeft;
            this.fireModelChangedEvent("Join:LeftSideChanged", this.m_leftSide);
            this.m_rightSide = newRight;
            this.fireModelChangedEvent("Join:RightSideChanged", this.m_rightSide);
            if (this.isUndoSupported()) {
                this.undoableEditHappened(new SwapLeftAndRightSidesUndoable(this.m_rightSide, this.m_leftSide));
            }
            this.fireNotifyEvent(10);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void removeSQLSource(ISQLSource source) {
        if (source == null) {
            return;
        }
        IDataObject table = null;
        if (source instanceof IQuery) {
            table = ((IQuery)((Object)source)).getTargetTable();
        } else if (source instanceof ISourceTable) {
            table = (IDataObject)((Object)source);
        }
        if (table != null) {
            IQuery query = this.getParentQuery();
            if (query != null) {
                query.removeSQLSource(source);
            }
            super.removeSQLSource(source);
            if (query instanceof Subquery) {
                query.getParentQuery().removeSQLSource(source);
            }
        }
        if (this.m_leftSide == source && !this.m_bNoResetSide) {
            this.setLeftSide(null);
        }
        if (this.m_rightSide == source && !this.m_bNoResetSide) {
            this.setRightSide(null);
        }
    }

    @Override
    public void addSQLSource(ISQLSource source) {
        if (source == null) {
            return;
        }
        IDataObject table = null;
        if (source instanceof IQuery) {
            table = ((IQuery)((Object)source)).getTargetTable();
        } else if (source instanceof ISourceTable) {
            table = (IDataObject)((Object)source);
        }
        if (table != null) {
            IQuery query = this.getParentQuery();
            if (query != null) {
                query.addSQLSource(source);
            }
            super.addSQLSource(source);
            if (query instanceof Subquery) {
                query.getParentQuery().addSQLSource(source);
            }
        }
    }

    @Override
    public boolean hasOpenPorts() {
        if (this.m_leftSide == null) {
            return true;
        }
        if (this.m_rightSide == null) {
            return true;
        }
        if (this.m_leftSide.hasOpenPorts()) {
            return true;
        }
        return this.m_rightSide.hasOpenPorts();
    }

    @Override
    public ISQLSource[] getObjectsWithOpenPorts() {
        ISQLSource[] alObjects;
        ArrayList<ISQLSource> lObjects = new ArrayList<ISQLSource>();
        if (this.m_leftSide != null) {
            alObjects = this.m_leftSide.getObjectsWithOpenPorts();
            lObjects.addAll(Arrays.asList(alObjects));
        }
        if (this.m_rightSide != null) {
            alObjects = this.m_rightSide.getObjectsWithOpenPorts();
            lObjects.addAll(Arrays.asList(alObjects));
        }
        if (this.m_leftSide == null || this.m_rightSide == null) {
            lObjects.add(this);
        }
        return lObjects.toArray(new ISQLSource[lObjects.size()]);
    }

    @Override
    public ISourceTable[] getSQLSourceTables() {
        ISourceTable[] alObjects;
        ArrayList<ISourceTable> lSources = new ArrayList<ISourceTable>();
        if (this.m_leftSide != null) {
            alObjects = this.m_leftSide.getSQLSourceTables();
            lSources.addAll(Arrays.asList(alObjects));
        }
        if (this.m_rightSide != null) {
            alObjects = this.m_rightSide.getSQLSourceTables();
            lSources.addAll(Arrays.asList(alObjects));
        }
        ISubquery[] alSubqueries = this.getSubqueries();
        for (int i = 0; i < alSubqueries.length; ++i) {
            ISourceTable[] alObjects2 = alSubqueries[i].getQuerySourceTables();
            lSources.addAll(Arrays.asList(alObjects2));
        }
        return lSources.toArray(new ISourceTable[lSources.size()]);
    }

    @Override
    public ITable[] getInputTables() {
        ITable[] alTables;
        ArrayList<ITable> lInputs = new ArrayList<ITable>();
        if (this.m_leftSide != null) {
            alTables = this.m_leftSide.getInputTables();
            lInputs.addAll(Arrays.asList(alTables));
        }
        if (this.m_rightSide != null) {
            alTables = this.m_rightSide.getInputTables();
            lInputs.addAll(Arrays.asList(alTables));
        }
        return lInputs.toArray(new ITable[lInputs.size()]);
    }

    @Override
    public List getPortDescriptions() {
        ArrayList<Object> lPortObjects;
        List lPortObjects2;
        List lPorts;
        boolean iName = false;
        boolean iObject = true;
        int iContainer = 2;
        int iJoinSide = 3;
        ArrayList lObjects = new ArrayList();
        if (this.m_leftSide != null) {
            lPorts = this.m_leftSide.getPortDescriptions();
            if (this.m_leftSide instanceof ISourceTable) {
                lPortObjects2 = (List)lPorts.get(0);
                lPortObjects2.add(3, "Left");
            }
            lObjects.addAll(lPorts);
        } else {
            lPortObjects = new ArrayList<Object>();
            lPortObjects.add(0, RB.getStringResource("BaseSQLPort.DefaultPortName.txt"));
            lPortObjects.add(1, null);
            lPortObjects.add(2, this);
            lPortObjects.add(3, "Left");
            lObjects.add(lPortObjects);
        }
        if (this.m_rightSide != null) {
            lPorts = this.m_rightSide.getPortDescriptions();
            if (this.m_rightSide instanceof ISourceTable) {
                lPortObjects2 = (List)lPorts.get(0);
                lPortObjects2.add(3, "Right");
            }
            lObjects.addAll(lPorts);
        } else {
            lPortObjects = new ArrayList();
            lPortObjects.add(0, RB.getStringResource("BaseSQLPort.DefaultPortName.txt"));
            lPortObjects.add(1, null);
            lPortObjects.add(2, this);
            lPortObjects.add(3, "Right");
            lObjects.add(lPortObjects);
        }
        List lSubqueries = this.getSubqueryList();
        for (int i = 0; i < lSubqueries.size(); ++i) {
            lObjects.addAll(((ISQLSource)lSubqueries.get(i)).getPortDescriptions());
        }
        return lObjects;
    }

    @Override
    public List getAllJoins() {
        ArrayList<Join> lJoins = new ArrayList<Join>();
        lJoins.add(this);
        if (this.m_leftSide != null) {
            lJoins.addAll(this.m_leftSide.getAllJoins());
        }
        if (this.m_rightSide != null) {
            lJoins.addAll(this.m_rightSide.getAllJoins());
        }
        return lJoins;
    }

    @Override
    public ISubquery[] getSQLSourceSubqueries() {
        ArrayList<ISubquery> lSubqueries = new ArrayList<ISubquery>();
        if (this.m_leftSide != null) {
            lSubqueries.addAll(Arrays.asList(this.m_leftSide.getSQLSourceSubqueries()));
        }
        if (this.m_rightSide != null) {
            lSubqueries.addAll(Arrays.asList(this.m_rightSide.getSQLSourceSubqueries()));
        }
        if (!this.m_bImplicit) {
            lSubqueries.addAll(this.getSubqueryList());
        }
        return lSubqueries.toArray(new ISubquery[lSubqueries.size()]);
    }

    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
        this.startCompoundUndoable();
        try {
            if (!this.useImplicit()) {
                super.replaceColumn(oldColumn, newColumn);
            }
            if (this.m_leftSide != null) {
                this.m_leftSide.replaceColumn(oldColumn, newColumn);
            }
            if (this.m_rightSide != null) {
                this.m_rightSide.replaceColumn(oldColumn, newColumn);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        boolean bJoinContainsRememberedColumn = false;
        if (!this.useImplicit()) {
            bJoinContainsRememberedColumn = super.containsRememberedColumn(column);
        }
        boolean bLeftSideContainsColumn = false;
        if (this.m_leftSide != null) {
            bLeftSideContainsColumn = this.m_leftSide.containsRememberedColumn(column);
        }
        boolean bRightSideContainsColumn = false;
        if (this.m_rightSide != null) {
            bRightSideContainsColumn = this.m_rightSide.containsRememberedColumn(column);
        }
        return bJoinContainsRememberedColumn || bRightSideContainsColumn || bLeftSideContainsColumn;
    }

    @Override
    public boolean hasImplicitJoin() {
        if (this.useImplicit()) {
            return true;
        }
        if (this.m_rightSide.hasImplicitJoin()) {
            return true;
        }
        return this.m_leftSide.hasImplicitJoin();
    }

    @Override
    public void setParent(IClause clause) {
        this.m_setParentHelper.set(clause);
    }

    @Override
    public IClause getParent() {
        return (IClause)this.m_setParentHelper.get();
    }

    @Override
    public void setSkipLeftCodeGen(boolean bSkipLeft) {
        this.m_bSkipLeftCodeGen = bSkipLeft;
    }

    @Override
    public void setSkipGenerateCode(boolean bGenCode) {
        this.m_bSkipCodeGen = bGenCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment parentSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        try {
            ICodeSegment codeSegment = parentSegment.createNewCodeSegment(this);
            if (this.m_bSkipCodeGen) {
                ICodeSegment iCodeSegment = codeSegment;
                return iCodeSegment;
            }
            String desc = this.getDescription();
            if (desc.length() > 0) {
                codeSegment.addCommentLine(desc);
            }
            if (this.m_bParentheses && !this.m_bImplicit) {
                codeSegment.addSourceCode("(");
                if (this.m_leftSide != null) {
                    this.m_leftSide.getGeneratedCode(codeSegment, passthru);
                }
            } else if (this.m_leftSide != null) {
                if (this.m_bSkipLeftCodeGen && this.m_leftSide instanceof IJoin) {
                    ((IJoin)this.m_leftSide).setSkipLeftCodeGen(true);
                    this.m_leftSide.getGeneratedCode(codeSegment, passthru);
                }
                if (!this.m_bSkipLeftCodeGen) {
                    this.m_leftSide.getGeneratedCode(codeSegment, passthru);
                }
            }
            ArrayList<IJoin> lJoinsToResetSkipGenCode = new ArrayList<IJoin>();
            if (this.m_bImplicit) {
                codeSegment.addSourceCode(", ");
            } else if ("Inner".equalsIgnoreCase(this.m_sType)) {
                codeSegment.addSourceCode(" inner join ");
            } else if ("Left".equalsIgnoreCase(this.m_sType)) {
                codeSegment.addSourceCode(" left join ");
            } else if ("Right".equalsIgnoreCase(this.m_sType)) {
                codeSegment.addSourceCode(" right join ");
            } else if ("Full".equalsIgnoreCase(this.m_sType)) {
                codeSegment.addSourceCode(" full join ");
            } else if ("Cross".equalsIgnoreCase(this.m_sType)) {
                codeSegment.addSourceCode(" cross join ");
            } else if ("Union".equalsIgnoreCase(this.m_sType)) {
                codeSegment.addSourceCode(" union join ");
            }
            codeSegment.addSourceCode("\n");
            if (this.m_rightSide != null && this.m_rightSide instanceof IJoin) {
                if (this.m_bImplicit) {
                    this.m_rightSide.getGeneratedCode(codeSegment, passthru);
                } else if (((IJoin)this.m_rightSide).useParentheses()) {
                    this.m_rightSide.getGeneratedCode(codeSegment, passthru);
                    this.genExplicitOnClause(codeSegment, passthru);
                    if (this.m_bParentheses) {
                        codeSegment.addSourceCode(")");
                    }
                } else if (((IJoin)this.m_rightSide).hasParenthesesOnLeftSideInHierarchy()) {
                    IJoin[] aLeftJoins = ((IJoin)this.m_rightSide).getLeftSideJoins();
                    for (int index = 0; index < aLeftJoins.length; ++index) {
                        IJoin leftJoin = aLeftJoins[index];
                        if (!leftJoin.useParentheses()) continue;
                        leftJoin.getGeneratedCode(codeSegment, passthru);
                        leftJoin.setSkipGenerateCode(true);
                        lJoinsToResetSkipGenCode.add(leftJoin);
                        break;
                    }
                    this.genExplicitOnClause(codeSegment, passthru);
                    if (this.m_bParentheses) {
                        codeSegment.addSourceCode(")");
                    }
                    this.m_rightSide.getGeneratedCode(codeSegment, passthru);
                } else {
                    ISourceTable[] tables = this.m_rightSide.getSQLSourceTables();
                    if (tables.length > 0) {
                        ISourceTable source = tables[0];
                        source.getGeneratedCode(codeSegment, passthru);
                    }
                    this.genExplicitOnClause(codeSegment, passthru);
                    if (this.m_bParentheses) {
                        codeSegment.addSourceCode(")");
                    }
                    ((IJoin)this.m_rightSide).setSkipLeftCodeGen(true);
                    this.m_rightSide.getGeneratedCode(codeSegment, passthru);
                }
            } else if (this.m_rightSide != null) {
                this.m_rightSide.getGeneratedCode(codeSegment, passthru);
                this.genExplicitOnClause(codeSegment, passthru);
                if (this.m_bParentheses) {
                    codeSegment.addSourceCode(")");
                }
            }
            for (int index = 0; index < lJoinsToResetSkipGenCode.size(); ++index) {
                ((IJoin)lJoinsToResetSkipGenCode.get(index)).setSkipGenerateCode(false);
            }
            ICodeSegment iCodeSegment = codeSegment;
            return iCodeSegment;
        }
        finally {
            this.m_bSkipLeftCodeGen = false;
            this.m_bSkipCodeGen = false;
        }
    }

    private ICodeSegment genExplicitOnClause(ICodeSegment codeSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.m_sType.equalsIgnoreCase("Inner") && !this.m_bImplicit || this.m_sType.equalsIgnoreCase("Left") || this.m_sType.equalsIgnoreCase("Right") || this.m_sType.equalsIgnoreCase("Full")) {
            codeSegment.addSourceCode("\n").indent().addSourceCode("on\n").addSourceCode("(\n").indent();
            super.getGeneratedCode(codeSegment, passthru);
            codeSegment.unIndent().addSourceCode(")").unIndent();
        }
        return codeSegment;
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_leftSide != null && this.m_leftSide.isChanged() || this.m_rightSide != null && this.m_rightSide.isChanged();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        ITable target;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this);
        mdoCM.setTransformRole(this.m_sRole);
        this.savePropertyToOMR(omr, "", PROPERTY_NAME_JOIN_TYPE, PROPERTY_NAME_JOIN_TYPE, PROPERTY_NAME_JOIN_TYPE, this.getJoinType(), 12, 33);
        this.savePropertyToOMR(omr, "", PROPERTY_NAME_IMPLICIT_JOIN, PROPERTY_NAME_IMPLICIT_JOIN, PROPERTY_NAME_IMPLICIT_JOIN, this.useImplicit() ? VALUE_TRUE : VALUE_FALSE, 12, 33);
        this.savePropertyToOMR(omr, "", PROPERTY_NAME_PARENTHESIS, PROPERTY_NAME_PARENTHESIS, PROPERTY_NAME_PARENTHESIS, this.useParentheses() ? VALUE_TRUE : VALUE_FALSE, 12, 33);
        AssociationList lTranSrcs = mdoCM.getTransformationSources(false);
        lTranSrcs.clear();
        AssociationList lTranTgts = mdoCM.getTransformationTargets(false);
        lTranTgts.clear();
        AssociationList lClsSrcs = mdoCM.getClassifierSources(false);
        lClsSrcs.clear();
        AssociationList lClsTgts = mdoCM.getClassifierTargets(false);
        lClsTgts.clear();
        if (this.m_leftSide != null) {
            this.m_leftSide.saveToOMR(omr);
            if (this.m_leftSide instanceof IJoin) {
                lTranSrcs.add(omr.acquireOMRObject(this.m_leftSide));
            } else if (this.m_leftSide instanceof ISourceTable) {
                lClsSrcs.add(omr.acquireOMRObject(this.m_leftSide));
            } else if (this.m_leftSide instanceof ISubquery) {
                target = ((IQuery)((Object)this.m_leftSide)).getTargetTable();
                lClsSrcs.add(omr.acquireOMRObject(target));
            }
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.saveToOMR(omr);
            if (this.m_rightSide instanceof IJoin) {
                lTranTgts.add(omr.acquireOMRObject(this.m_rightSide));
            } else if (this.m_rightSide instanceof ISourceTable) {
                lClsTgts.add(omr.acquireOMRObject(this.m_rightSide));
            } else if (this.m_rightSide instanceof IQuery) {
                target = ((IQuery)((Object)this.m_rightSide)).getTargetTable();
                lClsTgts.add(omr.acquireOMRObject(target));
            }
        }
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        AssociationList lClsTgts;
        String role;
        AssociationList lClsSrcs;
        String role2;
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this);
        this.setRole(mdoCM.getTransformRole());
        AssociationList lTranSrcs = mdoCM.getTransformationSources();
        for (int i = 0; i < lTranSrcs.size(); ++i) {
            Root source = (Root)lTranSrcs.get(i);
            String type = source.getCMetadataType();
            if (!type.equalsIgnoreCase("ClassifierMap") || !(role2 = ((ClassifierMap)source).getTransformRole()).equalsIgnoreCase(JOIN_TRANSFORM_ROLE)) continue;
            this.m_leftSide = (ISQLSource)this.getModel().getObject(source.getFQID());
            if (this.m_leftSide != null) break;
            this.m_leftSide = (ISQLSource)this.getModel().getObjectFactory().createObjectFromOMRObject(source);
            ((IJoin)this.m_leftSide).setParentQuery(this.getParentQuery());
            this.m_leftSide.loadFromOMR(omr);
            break;
        }
        if (this.m_leftSide == null && !(lClsSrcs = mdoCM.getClassifierSources()).isEmpty()) {
            DataTable mdoTable = (DataTable)lClsSrcs.get(0);
            ITable aTable = null;
            if (!mdoTable.getCMetadataType().equalsIgnoreCase("QueryTable")) {
                ISourceTable[] sources;
                ITable table = (ITable)omr.acquireObject((Root)mdoTable);
                IQuery query = this.getParentQuery();
                if (query != null && (sources = query.findQuerySourceTables(table)).length > 0) {
                    aTable = sources[0];
                }
            } else {
                aTable = (ITable)omr.acquireObject((Root)mdoTable);
            }
            role2 = "";
            if (aTable instanceof ISourceTable) {
                role2 = ((ISourceTable)aTable).getRole();
            } else if (aTable instanceof ISubqueryTargetTable) {
                role2 = ((ISubqueryTargetTable)aTable).getRole();
            }
            if (role2.equalsIgnoreCase("Alias")) {
                this.m_leftSide = (ISQLSource)((Object)aTable);
            } else if (role2.equalsIgnoreCase("SubQuery")) {
                AssociationList lTargetCMs = mdoTable.getTargetClassifierMaps();
                for (int i = 0; i < lTargetCMs.size(); ++i) {
                    Select mdoSelect;
                    String sRole;
                    Root mdoObject = (Root)lTargetCMs.get(i);
                    String sType = mdoObject.getCMetadataType();
                    if (!sType.equalsIgnoreCase("Select") || !(sRole = (mdoSelect = (Select)mdoObject).getTransformRole()).equalsIgnoreCase("SUBQUERY")) continue;
                    this.m_leftSide = (ISQLSource)this.getModel().getObject(mdoSelect.getFQID());
                    if (this.m_leftSide != null) continue;
                    this.m_leftSide = this.getModel().getObjectFactory().createSQLSubquery(mdoSelect.getFQID());
                    IQuery parent = this.getParentQuery();
                    ((ISubquery)this.m_leftSide).setParentQuery(parent);
                    ISQLTransform model = parent.getTransformModel();
                    ((ISubquery)this.m_leftSide).setTransformModel(model);
                    this.m_leftSide.loadFromOMR(omr);
                }
            }
        }
        if (this.m_leftSide != null) {
            this.m_leftSide.setParent(this);
            this.m_leftSide.addNotifyListener((INotifyListener)((Object)this.getParentQuery()));
        }
        AssociationList lTranTgts = mdoCM.getTransformationTargets();
        for (int i = 0; i < lTranTgts.size(); ++i) {
            Root source = (Root)lTranTgts.get(i);
            String type = source.getCMetadataType();
            if (!type.equalsIgnoreCase("ClassifierMap") || !(role = ((ClassifierMap)source).getTransformRole()).equalsIgnoreCase(JOIN_TRANSFORM_ROLE)) continue;
            this.m_rightSide = (ISQLSource)this.getModel().getObject(source.getFQID());
            if (this.m_rightSide != null) break;
            this.m_rightSide = (ISQLSource)this.getModel().getObjectFactory().createObjectFromOMRObject(source);
            ((IJoin)this.m_rightSide).setParentQuery(this.getParentQuery());
            this.m_rightSide.loadFromOMR(omr);
            break;
        }
        if (this.m_rightSide == null && !(lClsTgts = mdoCM.getClassifierTargets()).isEmpty()) {
            DataTable mdoTable = (DataTable)lClsTgts.get(0);
            ITable aTable = null;
            if (!mdoTable.getCMetadataType().equalsIgnoreCase("QueryTable")) {
                ISourceTable[] sources;
                ITable table = (ITable)omr.acquireObject((Root)mdoTable);
                IQuery query = this.getParentQuery();
                if (query != null && (sources = query.findQuerySourceTables(table)).length > 0) {
                    aTable = sources[0];
                }
            } else {
                aTable = (ITable)omr.acquireObject((Root)mdoTable);
            }
            role = "";
            if (aTable instanceof ISourceTable) {
                role = ((ISourceTable)aTable).getRole();
            } else if (aTable instanceof ISubqueryTargetTable) {
                role = ((ISubqueryTargetTable)aTable).getRole();
            }
            if (role.equalsIgnoreCase("Alias")) {
                this.m_rightSide = (ISQLSource)((Object)aTable);
            } else if (role.equalsIgnoreCase("SubQuery")) {
                AssociationList lTargetCMs = mdoTable.getTargetClassifierMaps();
                for (int i = 0; i < lTargetCMs.size(); ++i) {
                    Select mdoSelect;
                    String sRole;
                    Root mdoObject = (Root)lTargetCMs.get(i);
                    String sType = mdoObject.getCMetadataType();
                    if (!sType.equalsIgnoreCase("Select") || !(sRole = (mdoSelect = (Select)mdoObject).getTransformRole()).equalsIgnoreCase("SUBQUERY")) continue;
                    this.m_rightSide = (ISQLSource)this.getModel().getObject(mdoSelect.getFQID());
                    if (this.m_rightSide != null) continue;
                    this.m_rightSide = this.getModel().getObjectFactory().createSQLSubquery(mdoSelect.getFQID());
                    IQuery parent = this.getParentQuery();
                    ((ISubquery)this.m_rightSide).setParentQuery(parent);
                    ((ISubquery)this.m_rightSide).setParent(this);
                    ISQLTransform model = parent.getTransformModel();
                    ((ISubquery)this.m_rightSide).setTransformModel(model);
                    this.m_rightSide.loadFromOMR(omr);
                }
            }
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.setParent(this);
            this.m_rightSide.addNotifyListener((INotifyListener)((Object)this.getParentQuery()));
        }
        super.loadFromOMR(omr);
        this.m_sType = this.loadPropertyFromOMR(omr, "", PROPERTY_NAME_JOIN_TYPE, "Inner", 33);
        String sImplicit = this.loadPropertyFromOMR(omr, "", PROPERTY_NAME_IMPLICIT_JOIN, VALUE_TRUE, 33);
        this.m_bImplicit = sImplicit.equalsIgnoreCase(VALUE_TRUE);
        String sParenthesis = this.loadPropertyFromOMR(omr, "", PROPERTY_NAME_PARENTHESIS, VALUE_FALSE, 33);
        this.setParentheses(sParenthesis.equalsIgnoreCase(VALUE_TRUE));
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("ClassifierSources");
            lAssociations.add("ClassifierTargets");
            lAssociations.add("TransformationSources");
            lAssociations.add("TransformationTargets");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("ClassifierSources");
            lAssociations.add("ClassifierTargets");
            lAssociations.add("TransformationSources");
            lAssociations.add("TransformationTargets");
        }
        return map;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_leftSide != null) {
            this.m_leftSide.updateIDs(mapIDs);
        }
        if (this.m_rightSide != null) {
            this.m_rightSide.updateIDs(mapIDs);
        }
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public void runAutoJoinAction() {
        this.createJoinRelationships();
        if (!this.useImplicit()) {
            IWhere where = this.getParentQuery().getWhere();
            if (where != null) {
                List lWhereExprs = where.getBooleanExpressionsList();
                ArrayList<IBooleanExpression> lDuplicateExprs = new ArrayList<IBooleanExpression>();
                block0: for (int i = 0; i < lWhereExprs.size(); ++i) {
                    IBooleanExpression expr = (IBooleanExpression)lWhereExprs.get(i);
                    List lExpressions = this.getBooleanExpressionsList();
                    for (int j = 0; j < lExpressions.size(); ++j) {
                        IBooleanExpression newExpr = (IBooleanExpression)lExpressions.get(j);
                        if (!expr.contentEquals(newExpr)) continue;
                        lDuplicateExprs.add(expr);
                        continue block0;
                    }
                }
                int size = lDuplicateExprs.size();
                for (int i = 0; i < size; ++i) {
                    IBooleanExpression duplicateExpr = (IBooleanExpression)lDuplicateExprs.get(i);
                    where.removeBooleanExpression(duplicateExpr);
                }
                where.autoCorrectFirstExpressionsLogicalOperator();
            }
            if (where != null && where.size() == 0) {
                this.getParentQuery().removeClause(where);
            }
        } else {
            this.addExpressionsToWhereClause();
        }
    }

    protected void runAutoJoin() {
        IQuery parent = this.getParentQuery();
        if (parent == null) {
            return;
        }
        ISQLTransform model = parent.getTransformModel();
        if (model == null) {
            return;
        }
        if (this.m_leftSide == null || this.m_rightSide == null) {
            return;
        }
        if (!model.isAutoJoinEnabled()) {
            return;
        }
        this.runAutoJoinAction();
        this.m_bHasDefaultJoinRun = true;
    }

    protected void createJoinRelationships() {
        int index;
        if (this.m_bHasDefaultJoinRun || this.m_leftSide == null || this.m_rightSide == null) {
            return;
        }
        ITable[] aLeftSide = this.m_leftSide.getInputTables();
        ITable[] aRightSide = this.m_rightSide.getInputTables();
        ArrayList<ITable> lLeftSides = new ArrayList<ITable>();
        ArrayList<ITable> lRightSides = new ArrayList<ITable>();
        for (index = aLeftSide.length - 1; index > -1; --index) {
            lLeftSides.add(aLeftSide[index]);
        }
        for (index = aRightSide.length - 1; index > -1; --index) {
            lRightSides.add(aRightSide[index]);
        }
        this.findJoinRelationships(lLeftSides, lRightSides);
    }

    protected void findJoinRelationships(List lLeftTables, List lRightTables) {
        ArrayList lOldLeftTables = new ArrayList(lLeftTables.size());
        lOldLeftTables.addAll(lLeftTables);
        ArrayList lOldRightTables = new ArrayList(lRightTables.size());
        lOldRightTables.addAll(lRightTables);
        for (int i = 0; i < lLeftTables.size(); ++i) {
            IColumn fkCol;
            IColumn[] alFKColumns;
            IPhysicalTable leftPT;
            ITable leftSrcTable = (ITable)lLeftTables.get(i);
            if (!(leftSrcTable instanceof ISourceTable) || (leftPT = (IPhysicalTable)((ISourceTable)leftSrcTable).getAliasedTable()) == null) continue;
            IKey[] alKeys = leftPT.getKeys();
            for (int j = 0; j < alKeys.length; ++j) {
                IKey key = alKeys[j];
                for (int k = 0; k < lRightTables.size(); ++k) {
                    IPhysicalTable rightPT;
                    ITable rightSrcTable = (ITable)lRightTables.get(k);
                    if (!(rightSrcTable instanceof ISourceTable) || (rightPT = (IPhysicalTable)((ISourceTable)rightSrcTable).getAliasedTable()) == null) continue;
                    IForeignKey[] alFKeys = rightPT.getForeignKeys();
                    for (int l = 0; l < alFKeys.length; ++l) {
                        IForeignKey fKey = alFKeys[l];
                        try {
                            IKey partnerKey = fKey.loadPartnerKeyFromOMR();
                            if (partnerKey == null || partnerKey != key) continue;
                            IColumn[] alPKColumns = key.getColumns();
                            alFKColumns = fKey.getColumns();
                            for (int m = 0; m < alPKColumns.length; ++m) {
                                IColumn pkCol = alPKColumns[m];
                                pkCol = ((IAliasTable)leftSrcTable).findAlaisedColumnContainingColumn(pkCol);
                                fkCol = alFKColumns[m];
                                IBooleanExpression expression = this.createNewBooleanExpression(pkCol, fkCol = ((IAliasTable)rightSrcTable).findAlaisedColumnContainingColumn(fkCol));
                                if (this.doesExpressionAlreadyExistInList(expression)) {
                                    this.addToDeletedObjects(expression);
                                } else {
                                    this.addBooleanExpression(expression);
                                }
                                lOldLeftTables.remove(leftSrcTable);
                                lOldRightTables.remove(rightSrcTable);
                            }
                            continue;
                        }
                        catch (RemoteException ex) {
                            ModelLogger.getDefaultLogger().error((Object)"exception during autojoin", (Throwable)ex);
                            continue;
                        }
                        catch (MdException ex) {
                            ModelLogger.getDefaultLogger().error((Object)"exception during autojoin", (Throwable)ex);
                        }
                    }
                }
            }
            IForeignKey[] alFKeys = leftPT.getForeignKeys();
            for (int j = 0; j < alFKeys.length; ++j) {
                IForeignKey fKey = alFKeys[j];
                try {
                    IKey partnerKey = fKey.loadPartnerKeyFromOMR();
                    if (partnerKey == null) continue;
                    for (int k = 0; k < lRightTables.size(); ++k) {
                        IPhysicalTable rightPT;
                        ITable rightSrcTable = (ITable)lRightTables.get(k);
                        if (!(rightSrcTable instanceof ISourceTable) || (rightPT = (IPhysicalTable)((ISourceTable)rightSrcTable).getAliasedTable()) == null) continue;
                        IKey[] alRightKeys = rightPT.getKeys();
                        for (int l = 0; l < alRightKeys.length; ++l) {
                            IKey rightKey = alRightKeys[l];
                            if (rightKey != partnerKey) continue;
                            alFKColumns = fKey.getColumns();
                            IColumn[] alPKColumns = partnerKey.getColumns();
                            for (int m = 0; m < alPKColumns.length; ++m) {
                                fkCol = alFKColumns[m];
                                fkCol = ((IAliasTable)leftSrcTable).findAlaisedColumnContainingColumn(fkCol);
                                IColumn pkCol = alPKColumns[m];
                                IBooleanExpression expression = this.createNewBooleanExpression(fkCol, pkCol = ((IAliasTable)rightSrcTable).findAlaisedColumnContainingColumn(pkCol));
                                if (this.doesExpressionAlreadyExistInList(expression)) {
                                    this.addToDeletedObjects(expression);
                                } else {
                                    this.addBooleanExpression(expression);
                                }
                                lOldLeftTables.remove(leftSrcTable);
                                lOldRightTables.remove(rightSrcTable);
                            }
                        }
                    }
                    continue;
                }
                catch (RemoteException ex) {
                    ModelLogger.getDefaultLogger().error((Object)"exception during autojoin", (Throwable)ex);
                    continue;
                }
                catch (MdException ex) {
                    ModelLogger.getDefaultLogger().error((Object)"exception during autojoin", (Throwable)ex);
                }
            }
        }
        if (lOldLeftTables.size() > 0 && lOldRightTables.size() > 0) {
            this.findIndexRelationships(lOldLeftTables, lOldRightTables);
        }
    }

    protected void findIndexRelationships(List lLeftTables, List lRightTables) {
        IBooleanExpression expression;
        int m;
        IColumn[] alColumns;
        int l;
        int k;
        IColumn[] alIndexCols;
        IIndex index;
        int j;
        IIndex[] alIndexes;
        int i;
        ArrayList lOldLeftTables = new ArrayList(lLeftTables.size());
        lOldLeftTables.addAll(lLeftTables);
        ArrayList lOldRightTables = new ArrayList(lRightTables.size());
        lOldRightTables.addAll(lRightTables);
        for (i = 0; i < lLeftTables.size(); ++i) {
            IPhysicalTable leftPT;
            ITable leftSrcTable = (ITable)lLeftTables.get(i);
            if (!(leftSrcTable instanceof ISourceTable) || (leftPT = (IPhysicalTable)((ISourceTable)leftSrcTable).getAliasedTable()) == null) continue;
            alIndexes = leftPT.getIndexes();
            for (j = 0; j < alIndexes.length; ++j) {
                index = alIndexes[j];
                alIndexCols = index.getColumns();
                block2: for (k = 0; k < alIndexCols.length; ++k) {
                    IColumn leftColumn = alIndexCols[k];
                    leftColumn = ((IAliasTable)leftSrcTable).findAlaisedColumnContainingColumn(leftColumn);
                    for (l = 0; l < lRightTables.size(); ++l) {
                        ITable rightSrcTable = (ITable)lRightTables.get(l);
                        alColumns = rightSrcTable.getColumns();
                        for (m = 0; m < alColumns.length; ++m) {
                            IColumn rightColumn = alColumns[m];
                            if (!this.doesColumnsMatch(leftColumn, rightColumn)) continue;
                            expression = this.createNewBooleanExpression(leftColumn, rightColumn);
                            if (this.doesExpressionAlreadyExistInList(expression)) {
                                this.addToDeletedObjects(expression);
                            } else {
                                this.addBooleanExpression(expression);
                            }
                            lOldLeftTables.remove(leftSrcTable);
                            lOldRightTables.remove(rightSrcTable);
                            break;
                        }
                        if (lOldRightTables.size() == 0 || lOldRightTables.size() == 0) continue block2;
                    }
                }
                if (lOldRightTables.size() == 0 || lOldRightTables.size() == 0) break;
            }
            if (lOldLeftTables.size() == 0 || lOldRightTables.size() == 0) break;
        }
        for (i = 0; i < lRightTables.size(); ++i) {
            IPhysicalTable rightPT;
            ITable rightSrcTable = (ITable)lRightTables.get(i);
            if (!(rightSrcTable instanceof ISourceTable) || (rightPT = (IPhysicalTable)((ISourceTable)rightSrcTable).getAliasedTable()) == null) continue;
            alIndexes = rightPT.getIndexes();
            for (j = 0; j < alIndexes.length; ++j) {
                index = alIndexes[j];
                alIndexCols = index.getColumns();
                block7: for (k = 0; k < alIndexCols.length; ++k) {
                    IColumn rightColumn = alIndexCols[k];
                    rightColumn = ((IAliasTable)rightSrcTable).findAlaisedColumnContainingColumn(rightColumn);
                    for (l = 0; l < lLeftTables.size(); ++l) {
                        ITable leftSrcTable = (ITable)lLeftTables.get(l);
                        alColumns = leftSrcTable.getColumns();
                        for (m = 0; m < alColumns.length; ++m) {
                            IColumn leftColumn = alColumns[m];
                            if (!this.doesColumnsMatch(leftColumn, rightColumn)) continue;
                            expression = this.createNewBooleanExpression(leftColumn, rightColumn);
                            if (this.doesExpressionAlreadyExistInList(expression)) {
                                this.addToDeletedObjects(expression);
                            } else {
                                this.addBooleanExpression(expression);
                            }
                            lOldLeftTables.remove(leftSrcTable);
                            lOldRightTables.remove(rightSrcTable);
                            break;
                        }
                        if (lOldRightTables.size() == 0 || lOldLeftTables.size() == 0) continue block7;
                    }
                }
                if (lOldRightTables.size() == 0 || lOldLeftTables.size() == 0) break;
            }
            if (lOldRightTables.size() == 0 || lOldLeftTables.size() == 0) break;
        }
        if (lOldLeftTables.size() > 0 && lOldRightTables.size() > 0) {
            this.findColumnNameRelationships(lOldLeftTables, lOldRightTables);
        }
    }

    protected void findColumnNameRelationships(List lLeftTables, List lRightTables) {
        block0: for (int i = 0; i < lLeftTables.size(); ++i) {
            ITable leftSrcTable = (ITable)lLeftTables.get(i);
            IColumn[] alColumns = leftSrcTable.getColumns();
            for (int j = 0; j < alColumns.length; ++j) {
                boolean bWasMatchFound = false;
                IColumn leftColumn = alColumns[j];
                block2: for (int k = 0; k < lRightTables.size(); ++k) {
                    ITable rightSrcTable = (ITable)lRightTables.get(k);
                    IColumn[] alRightColumns = rightSrcTable.getColumns();
                    for (int l = 0; l < alRightColumns.length; ++l) {
                        IColumn rightColumn = alRightColumns[l];
                        if (!this.doesColumnsMatch(leftColumn, rightColumn)) continue;
                        IBooleanExpression expression = this.createNewBooleanExpression(leftColumn, rightColumn);
                        if (this.doesExpressionAlreadyExistInList(expression)) {
                            this.addToDeletedObjects(expression);
                        } else {
                            this.addBooleanExpression(expression);
                        }
                        bWasMatchFound = true;
                        lLeftTables.remove(leftSrcTable);
                        lRightTables.remove(rightSrcTable);
                        continue block2;
                    }
                }
                if (bWasMatchFound) continue block0;
            }
        }
    }

    protected boolean doesExpressionAlreadyExistInList(IBooleanExpression expression) {
        if (this.size() > 0) {
            for (int i = 0; i < this.size(); ++i) {
                IBooleanExpression existingExpr = (IBooleanExpression)this.getBooleanExpressionsList().get(i);
                if (!existingExpr.contentEquals(expression)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean doesColumnsMatch(IColumn leftColumn, IColumn rightColumn) {
        IQuery parent = this.getParentQuery();
        if (parent == null) {
            return false;
        }
        ISQLTransform model = parent.getTransformModel();
        if (model == null) {
            return false;
        }
        boolean useQuotes = model.isQuotingNeeded();
        boolean usePassThru = model.isPassThru();
        String sLeftName = leftColumn.getColumnName(useQuotes, usePassThru);
        int iLeftType = leftColumn.getType();
        int iLeftLength = leftColumn.getLength();
        String sRightName = rightColumn.getColumnName(useQuotes, usePassThru);
        int iRightType = rightColumn.getType();
        int iRightLength = rightColumn.getLength();
        if (sLeftName.equalsIgnoreCase(sRightName) && iLeftType == iRightType) {
            if (iLeftType == 1) {
                if (iLeftLength == iRightLength) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    protected IBooleanExpression createNewBooleanExpression(IColumn leftColumn, IColumn rightColumn) {
        IBooleanExpression expression = this.getModel().getObjectFactory().createNewSQLBooleanExpression(this.getID(), this);
        if (this.size() > 0) {
            expression.setLogicalOperator("and");
        }
        ITextOperand leftOperand = this.createNewTextOperand(leftColumn);
        expression.setLeftOperand(leftOperand);
        ITextOperand rightOperand = this.createNewTextOperand(rightColumn);
        expression.setRightOperand(rightOperand);
        expression.setUseSQLSyntax(true);
        return expression;
    }

    protected ITextOperand createNewTextOperand(IColumn column) {
        IQuery parent = this.getParentQuery();
        if (parent == null) {
            return null;
        }
        ISQLTransform model = parent.getTransformModel();
        if (model == null) {
            return null;
        }
        ITextOperand operand = this.getModel().getObjectFactory().createNewSQLTextOperand(this.getID(), this.getParentQuery());
        ITextExpression expression = this.getModel().getObjectFactory().createNewSQLTextExpression(this.getID(), this.getParentQuery());
        boolean bUseQuoting = model.isQuotingNeeded();
        boolean bUsePassThru = false;
        expression.setUseSQLSyntax(true);
        StringBuffer sbText = new StringBuffer();
        sbText.append(column.getFullColumnName(bUseQuoting, bUsePassThru));
        IObject[] alCols = new IColumn[]{column};
        expression.setText(sbText.toString(), alCols);
        operand.setTextExpression(expression);
        return operand;
    }

    protected void addExpressionsToWhereClause() {
        IBooleanExpression expr;
        int i;
        if (this.size() == 0) {
            return;
        }
        IWhere where = this.getParentQuery().getWhere();
        if (where == null) {
            where = (IWhere)this.getParentQuery().addClause(ClauseType.WHERE);
        }
        List lWhereExprs = where.getBooleanExpressionsList();
        List lExpressions = this.getBooleanExpressionsList();
        for (i = 0; i < this.size(); ++i) {
            expr = (IBooleanExpression)lExpressions.get(i);
            boolean found = false;
            for (int j = 0; j < lWhereExprs.size(); ++j) {
                IBooleanExpression whereExpr = (IBooleanExpression)lWhereExprs.get(j);
                if (!whereExpr.contentEquals(expr)) continue;
                lExpressions.remove(expr);
                --i;
                found = true;
                break;
            }
            if (found) continue;
            if (where.size() > 0 && i == 0) {
                expr.setLogicalOperator("and");
            }
            where.addBooleanExpression(expr);
        }
        for (i = this.size() - 1; i > -1; --i) {
            expr = (IBooleanExpression)lExpressions.remove(i);
            this.removeFromDeletedObjects(expr);
        }
    }

    private class SetLeftSideUndoable
    extends AbstractUndoableEdit {
        private ISQLSource m_oldLeftSide;
        private ISQLSource m_newLeftSide;

        public SetLeftSideUndoable(ISQLSource oldLeftSide, ISQLSource newLeftSide) {
            this.m_oldLeftSide = oldLeftSide;
            this.m_newLeftSide = newLeftSide;
        }

        @Override
        public void undo() {
            super.undo();
            Join.this.setLeftSideImpl(this.m_oldLeftSide);
        }

        @Override
        public void redo() {
            super.redo();
            Join.this.setLeftSideImpl(this.m_newLeftSide);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldLeftSide = null;
            this.m_newLeftSide = null;
        }
    }

    private class SetRightSideUndoable
    extends AbstractUndoableEdit {
        private ISQLSource m_oldRightSide;
        private ISQLSource m_newRightSide;

        public SetRightSideUndoable(ISQLSource oldRightSide, ISQLSource newRightSide) {
            this.m_oldRightSide = oldRightSide;
            this.m_newRightSide = newRightSide;
        }

        @Override
        public void undo() {
            super.undo();
            Join.this.setRightSideImpl(this.m_oldRightSide);
        }

        @Override
        public void redo() {
            super.redo();
            Join.this.setRightSideImpl(this.m_newRightSide);
        }

        @Override
        public void die() {
            super.die();
            this.m_oldRightSide = null;
            this.m_newRightSide = null;
        }
    }

    private class SetJoinTypeUndoable
    extends AbstractUndoableEdit {
        private String m_oldType;
        private String m_newType;

        public SetJoinTypeUndoable(String oldType, String newType) {
            this.m_oldType = oldType;
            this.m_newType = newType;
        }

        @Override
        public void undo() {
            super.undo();
            Join.this.setJoinTypeImpl(this.m_oldType);
        }

        @Override
        public void redo() {
            super.redo();
            Join.this.setJoinTypeImpl(this.m_newType);
        }
    }

    private class SetParenthesesUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldParentheses;
        private boolean m_newParentheses;

        public SetParenthesesUndoable(boolean oldParentheses, boolean newParentheses) {
            this.m_oldParentheses = oldParentheses;
            this.m_newParentheses = newParentheses;
        }

        @Override
        public void undo() {
            super.undo();
            Join.this.setParentheses(this.m_oldParentheses);
        }

        @Override
        public void redo() {
            super.redo();
            Join.this.setParentheses(this.m_newParentheses);
        }
    }

    private class SetImplicitUndoable
    extends AbstractUndoableEdit {
        private boolean m_oldImplicit;
        private boolean m_newImplicit;

        public SetImplicitUndoable(boolean oldImplicit, boolean newImplicit) {
            this.m_oldImplicit = oldImplicit;
            this.m_newImplicit = newImplicit;
        }

        @Override
        public void undo() {
            super.undo();
            Join.this.setImplicitImpl(this.m_oldImplicit);
        }

        @Override
        public void redo() {
            super.redo();
            Join.this.setImplicitImpl(this.m_newImplicit);
        }
    }

    private class SwapLeftAndRightSidesUndoable
    extends AbstractUndoableEdit {
        private ISQLSource m_right;
        private ISQLSource m_left;

        public SwapLeftAndRightSidesUndoable(ISQLSource rightSide, ISQLSource leftSide) {
            this.m_right = rightSide;
            this.m_left = leftSide;
        }

        @Override
        public void undo() {
            super.undo();
            Join.this.swapLeftAndRightSidesImpl(this.m_right, this.m_left);
        }

        @Override
        public void redo() {
            super.redo();
            Join.this.swapLeftAndRightSidesImpl(this.m_left, this.m_right);
        }

        @Override
        public void die() {
            super.die();
            this.m_left = null;
            this.m_right = null;
        }
    }
}

