/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.AbstractExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.impl.RB;
import com.sas.etl.models.job.transforms.sql.ICaseExpression;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class CaseStatement
extends AbstractExpression
implements ICaseStatement {
    private IExpression m_operandCase;
    private IExpression m_operandElse;
    private ModelList m_lExpressions;
    private List m_lInvalidPositions;
    private IQuery m_query;

    public CaseStatement(String sID, IModel model, IQuery query) {
        super(sID, model);
        this.m_query = query;
        this.m_lExpressions = new ModelList(this, new String[]{"Object:CaseExpressionAdded", "Object:CaseExpressionRemoved"}, 3, ICaseExpression.class);
        this.m_lInvalidPositions = new ArrayList();
    }

    @Override
    public void notify(NotifyEvent ev) {
        int iType = ev.getType();
        if (iType == 1) {
            this.fireModelChangedEvent("CaseStatement:Changed", this);
        } else {
            super.notify(ev);
        }
    }

    @Override
    public IQuery getQuery() {
        return this.m_query;
    }

    @Override
    public IExpression getCaseOperand() {
        return this.m_operandCase;
    }

    @Override
    public IExpression getElseOperand() {
        return this.m_operandElse;
    }

    @Override
    public void setCaseOperand(IExpression operand) {
        if (this.m_operandCase == null && operand == null) {
            return;
        }
        if (this.m_operandCase != null) {
            if (this.m_operandCase.equals(operand)) {
                return;
            }
            this.m_operandCase.removeNotifyListener(this);
            this.addToDeletedObjects(this.m_operandCase);
        }
        if (operand != null) {
            this.removeFromDeletedObjects(operand);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetCaseOperandUndoable(this.m_operandCase, operand));
        }
        this.m_operandCase = operand;
        if (this.m_operandCase != null) {
            this.m_operandCase.setUseSQLSyntax(true);
            this.m_operandCase.addNotifyListener(this);
        }
        this.fireModelChangedEvent("CaseStatement:CaseOperandChanged", null);
    }

    @Override
    public void setElseOperand(IExpression operand) {
        if (this.m_operandElse == null && operand == null) {
            return;
        }
        if (this.m_operandElse != null) {
            if (this.m_operandElse.equals(operand)) {
                return;
            }
            this.m_operandElse.removeNotifyListener(this);
            this.addToDeletedObjects(this.m_operandElse);
        }
        if (operand != null) {
            this.removeFromDeletedObjects(operand);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetElseOperandUndoable(this.m_operandElse, operand));
        }
        this.m_operandElse = operand;
        if (this.m_operandElse != null) {
            this.m_operandElse.setUseSQLSyntax(true);
            this.m_operandElse.addNotifyListener(this);
        }
        this.fireModelChangedEvent("CaseStatement:ElseOperandChanged", null);
    }

    @Override
    public boolean containsColumn(IColumn column) {
        for (int iExpression = 0; iExpression < this.m_lExpressions.size(); ++iExpression) {
            if (!((ICaseExpression)this.m_lExpressions.get(iExpression)).containsColumn(column)) continue;
            return true;
        }
        return this.m_operandCase != null && this.m_operandCase.containsColumn(column) || this.m_operandElse != null && this.m_operandElse.containsColumn(column);
    }

    @Override
    public boolean containsTable(ITable table) {
        for (int iExpression = 0; iExpression < this.m_lExpressions.size(); ++iExpression) {
            if (!((ICaseExpression)this.m_lExpressions.get(iExpression)).containsTable(table)) continue;
            return true;
        }
        return this.m_operandCase != null && this.m_operandCase.containsTable(table) || this.m_operandElse != null && this.m_operandElse.containsTable(table);
    }

    @Override
    public boolean contentEquals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseStatement)) {
            return false;
        }
        CaseStatement statement = (CaseStatement)obj;
        if (statement.getExpressionsAsList().size() != this.m_lExpressions.size()) {
            return false;
        }
        for (int iExpression = 0; iExpression < this.m_lExpressions.size(); ++iExpression) {
            ICaseExpression expression;
            ICaseExpression myExpression = (ICaseExpression)this.m_lExpressions.get(iExpression);
            if (myExpression.contentEquals(expression = statement.getExpressions()[iExpression])) continue;
            return false;
        }
        if (this.m_operandCase != null ? !this.m_operandCase.contentEquals(statement.getCaseOperand()) : statement.getCaseOperand() != null) {
            return false;
        }
        return !(this.m_operandElse != null ? !this.m_operandElse.contentEquals(statement.getElseOperand()) : statement.getElseOperand() != null);
    }

    public String getOperandType() {
        return "CaseOperand";
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        if (this.m_operandCase != null && this.m_operandCase.containsRememberedColumn(column) || this.m_operandElse != null && this.m_operandElse.containsRememberedColumn(column)) {
            return true;
        }
        for (int index = 0; index < this.m_lExpressions.size(); ++index) {
            ICaseExpression expr = (ICaseExpression)this.m_lExpressions.get(index);
            if (!expr.containsRememberedColumn(column)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void replaceTableColumns(ITable oldTable, ITable newTable) {
        if (this.m_operandCase != null) {
            this.m_operandCase.replaceTableColumns(oldTable, newTable);
        }
        if (this.m_operandElse != null) {
            this.m_operandElse.replaceTableColumns(oldTable, newTable);
        }
        for (int index = 0; index < this.m_lExpressions.size(); ++index) {
            ICaseExpression expr = (ICaseExpression)this.m_lExpressions.get(index);
            expr.replaceTableColumns(oldTable, newTable);
        }
    }

    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
        for (int iExpression = 0; iExpression < this.m_lExpressions.size(); ++iExpression) {
            ((ICaseExpression)this.m_lExpressions.get(iExpression)).replaceColumn(oldColumn, newColumn);
        }
        if (this.m_operandCase != null) {
            this.m_operandCase.replaceColumn(oldColumn, newColumn);
        }
        if (this.m_operandElse != null) {
            this.m_operandElse.replaceColumn(oldColumn, newColumn);
        }
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "ClassifierMap";
    }

    @Override
    public void addExpression(ICaseExpression expression) {
        this.m_lExpressions.add(this.m_lExpressions.size(), expression);
    }

    @Override
    public void addExpression(int index, ICaseExpression expression) {
        this.m_lExpressions.add(index, expression);
    }

    @Override
    public boolean containsExpression(ICaseExpression expression) {
        return this.m_lExpressions.contains(expression);
    }

    @Override
    public ICaseExpression[] getExpressions() {
        return (ICaseExpression[])this.m_lExpressions.toArray(new ICaseExpression[this.m_lExpressions.size()]);
    }

    @Override
    public List getExpressionsAsList() {
        return this.m_lExpressions;
    }

    @Override
    public void removeExpression(ICaseExpression expression) {
        this.m_lExpressions.remove(expression);
    }

    @Override
    public boolean validateExpression() {
        this.m_lInvalidPositions.clear();
        boolean bValid = true;
        for (int iExpression = 0; iExpression < this.m_lExpressions.size(); ++iExpression) {
            if (((ICaseExpression)this.m_lExpressions.get(iExpression)).validateExpression()) continue;
            bValid = false;
            this.m_lInvalidPositions.add(new Integer(iExpression));
        }
        if (!bValid) {
            return false;
        }
        if (this.m_operandCase != null && !this.m_operandCase.isComplete()) {
            return false;
        }
        return this.m_operandElse == null || this.m_operandElse.isComplete();
    }

    @Override
    public List getInvalidExpressionPositions() {
        return this.m_lInvalidPositions;
    }

    @Override
    public boolean isChanged() {
        for (int iExpression = 0; iExpression < this.m_lExpressions.size(); ++iExpression) {
            if (!((ICaseExpression)this.m_lExpressions.get(iExpression)).isChanged()) continue;
            return true;
        }
        return super.isChanged() || this.m_operandCase != null && this.m_operandCase.isChanged() || this.m_operandElse != null && this.m_operandElse.isChanged();
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.validateExpression();
    }

    protected boolean isCaseExpressionsComplete() {
        for (int index = 0; index < this.m_lExpressions.size(); ++index) {
            ICaseExpression expr = (ICaseExpression)this.m_lExpressions.get(index);
            if (expr.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getWarnings() {
        ArrayList<String> reasons = new ArrayList<String>();
        try {
            String text = this.getText(null, true);
            int lineBreakIndex = text.indexOf("\n");
            if (text.length() > 150 && lineBreakIndex == -1) {
                reasons.add(MessageFormat.format(RB.getStringResource("Expression.ReasonsIncomplete.NoLineBreaks.txt"), new Integer(255)));
            }
        }
        catch (RemoteException e) {
            ModelLogger.getDefaultLogger().debug((Object)"RemoteExcpetion", (Throwable)e);
        }
        catch (CodegenException e) {
            ModelLogger.getDefaultLogger().debug((Object)"CodegenException", (Throwable)e);
        }
        catch (MdException e) {
            ModelLogger.getDefaultLogger().debug((Object)"MdException", (Throwable)e);
        }
        catch (BadServerDefinitionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"BadServerDefinitionException", (Throwable)e);
        }
        catch (BadLibraryDefinitionException e) {
            ModelLogger.getDefaultLogger().debug((Object)"BadLibraryDefinitionException", (Throwable)e);
        }
        catch (ServerException e) {
            ModelLogger.getDefaultLogger().debug((Object)"ServerException", (Throwable)e);
        }
        return reasons;
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_operandCase != null && !this.m_operandCase.isComplete()) {
            lReasons.addAll(this.m_operandCase.getReasonsIncomplete());
        }
        if (this.m_operandElse != null && !this.m_operandElse.isComplete()) {
            lReasons.addAll(this.m_operandElse.getReasonsIncomplete());
        }
        if (this.m_lExpressions.size() <= 0) {
            lReasons.add(RB.getStringResource("CaseStatement.ReasonIncomplete.NoCaseExpression.txt"));
        }
        if (!this.isCaseExpressionsComplete()) {
            for (int index = 0; index < this.m_lExpressions.size(); ++index) {
                ICaseExpression expr = (ICaseExpression)this.m_lExpressions.get(index);
                if (expr.isChanged()) continue;
                lReasons.addAll(expr.getReasonsIncomplete());
            }
        }
        return lReasons;
    }

    protected ITextOperand createTextOperand(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        ITextOperand operand = (ITextOperand)this.getModel().getObject(mdo.getFQID());
        if (operand == null) {
            operand = this.getModel().getObjectFactory().createSQLTextOperand(mdo.getFQID(), this.m_query);
            operand.loadFromOMR(omr);
        }
        return operand;
    }

    protected ICaseExpression createCaseExpression(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        ICaseExpression expression = (ICaseExpression)this.getModel().getObject(mdo.getFQID());
        if (expression == null) {
            expression = this.getModel().getObjectFactory().createSQLCaseExpression(mdo.getFQID(), this);
            expression.loadFromOMR(omr);
        }
        return expression;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        FeatureMap mdoFM;
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this);
        mdoCM.setName("CaseStatement");
        mdoCM.setTransformRole("CaseStatement");
        AssociationList mdoFeatureMaps = mdoCM.getFeatureMaps(false);
        mdoFeatureMaps.removeAllElements();
        if (this.m_operandCase != null) {
            this.m_operandCase.saveToOMR(omr);
            mdoFM = (FeatureMap)omr.acquireOMRObject(this.getModel().createIDForNewObject(this.getID()), "FeatureMap");
            mdoFM.setName("CaseExpression");
            mdoFM.setTransformRole("CaseExpression");
            mdoFM.getSourceTransformations(false).add((Object)omr.acquireOMRObject(this.m_operandCase));
            mdoFeatureMaps.addElement((Object)mdoFM);
        }
        if (this.m_operandElse != null) {
            this.m_operandElse.saveToOMR(omr);
            mdoFM = (FeatureMap)omr.acquireOMRObject(this.getModel().createIDForNewObject(this.getID()), "FeatureMap");
            mdoFM.setName("CaseElse");
            mdoFM.setTransformRole("CaseElse");
            mdoFM.getSourceTransformations(false).add((Object)omr.acquireOMRObject(this.m_operandElse));
            mdoFeatureMaps.addElement((Object)mdoFM);
        }
        for (int iExpression = 0; iExpression < this.m_lExpressions.size(); ++iExpression) {
            ICaseExpression expression = (ICaseExpression)this.m_lExpressions.get(iExpression);
            expression.saveToOMR(omr);
            Root mdoObject = omr.acquireOMRObject(expression);
            mdoFeatureMaps.add((Object)mdoObject);
        }
        this.setChanged(false);
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        super.loadFromOMR(omr);
        ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(this);
        AssociationList mdoFeatureMaps = mdoCM.getFeatureMaps();
        if (mdoFeatureMaps != null && !mdoFeatureMaps.isEmpty()) {
            for (int iMap = 0; iMap < mdoFeatureMaps.size(); ++iMap) {
                Root mdoRoot;
                AssociationList mdoSourceTrans;
                FeatureMap mdoFM = (FeatureMap)mdoFeatureMaps.get(iMap);
                String sTransformRole = mdoFM.getTransformRole();
                if (sTransformRole.equalsIgnoreCase("CaseExpression")) {
                    mdoSourceTrans = mdoFM.getSourceTransformations();
                    mdoRoot = (Root)mdoSourceTrans.get(0);
                    this.setCaseOperand(this.createTextOperand(omr, mdoRoot));
                    continue;
                }
                if (sTransformRole.equalsIgnoreCase("CaseElse")) {
                    mdoSourceTrans = mdoFM.getSourceTransformations();
                    mdoRoot = (Root)mdoSourceTrans.get(0);
                    this.setElseOperand(this.createTextOperand(omr, mdoRoot));
                    continue;
                }
                if (!sTransformRole.equalsIgnoreCase("CaseWhenThen")) continue;
                this.m_lExpressions.add(this.createCaseExpression(omr, (Root)mdoFM));
            }
        }
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_operandCase != null) {
            this.m_operandCase.deleteFromOMR(omr);
        }
        if (this.m_operandElse != null) {
            this.m_operandElse.deleteFromOMR(omr);
        }
        this.m_lExpressions.deleteFromOMR(omr);
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("FeatureMaps");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("FeatureMaps");
        }
        ArrayList<String> lFMAssocs = (ArrayList<String>)map.get("FeatureMap");
        if (lFMAssocs == null) {
            lFMAssocs = new ArrayList<String>();
            lFMAssocs.add("SourceTransformations");
            map.put(this.getOMRType(), lFMAssocs);
        }
        lFMAssocs.add("SourceTransformations");
        return map;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_operandCase != null) {
            this.m_operandCase.updateIDs(mapIDs);
        }
        if (this.m_operandElse != null) {
            this.m_operandElse.updateIDs(mapIDs);
        }
        for (int index = 0; index < this.m_lExpressions.size(); ++index) {
            ((ICaseExpression)this.m_lExpressions.get(index)).updateIDs(mapIDs);
        }
    }

    @Override
    public String getExpressionType() {
        return "CaseOperand";
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        codeSegment.addSourceCode(this.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting(), passthru));
        return codeSegment;
    }

    @Override
    public String getText(IServer currentServer, boolean quotes) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getText(currentServer, quotes, false);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String text;
        StringBuffer code = new StringBuffer();
        code.append("case ");
        if (this.m_operandCase != null) {
            code.append(this.m_operandCase.getText(currentServer, quotes, passthru));
        }
        code.append("\n");
        ICaseExpression[] expressions = this.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            ICaseExpression caseExpr = expressions[i];
            code.append(caseExpr.getText(currentServer, quotes, passthru));
        }
        if (this.m_operandElse != null && (text = this.m_operandElse.getText(currentServer, quotes, passthru)).length() > 0) {
            code.append("else ");
            code.append(this.m_operandElse.getText(currentServer, quotes, passthru)).append("\n");
        }
        code.append("end");
        return code.toString();
    }

    @Override
    public IObject[] getSources() {
        ArrayList lObjects = new ArrayList();
        if (this.m_operandCase != null) {
            this.addUniqueSources(this.m_operandCase.getSources(), lObjects);
        }
        if (this.m_operandElse != null) {
            this.addUniqueSources(this.m_operandElse.getSources(), lObjects);
        }
        for (int iExp = 0; iExp < this.m_lExpressions.size(); ++iExp) {
            ICaseExpression exp = (ICaseExpression)this.m_lExpressions.get(iExp);
            if (exp.getWhenOperand() != null) {
                this.addUniqueSources(exp.getWhenOperand().getSources(), lObjects);
            }
            if (exp.getThenOperand() == null) continue;
            this.addUniqueSources(exp.getThenOperand().getSources(), lObjects);
        }
        return lObjects.toArray(new IObject[lObjects.size()]);
    }

    private void addUniqueSources(IObject[] aSrc, List lSrc) {
        for (int iSrc = 0; iSrc < aSrc.length; ++iSrc) {
            IObject obj = aSrc[iSrc];
            if (lSrc.contains(obj)) continue;
            lSrc.add(obj);
        }
    }

    private class SetCaseOperandUndoable
    extends AbstractUndoableEdit {
        private IExpression m_oldCaseOperand;
        private IExpression m_newCaseOperand;

        public SetCaseOperandUndoable(IExpression oldCaseOperand, IExpression newCaseOperand) {
            this.m_oldCaseOperand = oldCaseOperand;
            this.m_newCaseOperand = newCaseOperand;
        }

        @Override
        public void undo() {
            super.undo();
            CaseStatement.this.setCaseOperand(this.m_oldCaseOperand);
        }

        @Override
        public void redo() {
            super.redo();
            CaseStatement.this.setCaseOperand(this.m_newCaseOperand);
        }

        @Override
        public void die() {
            super.die();
            this.m_newCaseOperand = null;
            this.m_oldCaseOperand = null;
        }
    }

    private class SetElseOperandUndoable
    extends AbstractUndoableEdit {
        private IExpression m_oldElseOperand;
        private IExpression m_newElseOperand;

        public SetElseOperandUndoable(IExpression oldElseOperand, IExpression newElseOperand) {
            this.m_oldElseOperand = oldElseOperand;
            this.m_newElseOperand = newElseOperand;
        }

        @Override
        public void undo() {
            super.undo();
            CaseStatement.this.setElseOperand(this.m_oldElseOperand);
        }

        @Override
        public void redo() {
            super.redo();
            CaseStatement.this.setElseOperand(this.m_newElseOperand);
        }

        @Override
        public void die() {
            super.die();
            this.m_newElseOperand = null;
            this.m_oldElseOperand = null;
        }
    }
}

