/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ITextOperand;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.ICaseExpression;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.impl.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class CaseExpression
extends AbstractPersistableObject
implements ICaseExpression {
    private ITextOperand m_operandWhen;
    private ITextOperand m_operandThen;
    private ICaseStatement m_parent;

    public CaseExpression(String sID, IModel model, ICaseStatement parent) {
        super(sID, model);
        this.m_parent = parent;
    }

    @Override
    public boolean containsColumn(IColumn column) {
        return this.m_operandWhen != null && this.m_operandWhen.containsColumn(column) || this.m_operandThen != null && this.m_operandThen.containsColumn(column);
    }

    @Override
    public boolean containsTable(ITable table) {
        return this.m_operandWhen != null && this.m_operandWhen.containsTable(table) || this.m_operandThen != null && this.m_operandThen.containsTable(table);
    }

    @Override
    public boolean contentEquals(IObject obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseExpression)) {
            return false;
        }
        CaseExpression expression = (CaseExpression)obj;
        if (this.m_operandWhen != null ? !this.m_operandWhen.contentEquals(expression.getWhenOperand()) : expression.getWhenOperand() != null) {
            return false;
        }
        return !(this.m_operandThen != null ? !this.m_operandThen.contentEquals(expression.getThenOperand()) : expression.getThenOperand() != null);
    }

    @Override
    public ITextOperand getThenOperand() {
        return this.m_operandThen;
    }

    @Override
    public ITextOperand getWhenOperand() {
        return this.m_operandWhen;
    }

    @Override
    public void replaceColumn(IColumn oldColumn, IColumn newColumn) {
        if (this.m_operandWhen != null) {
            this.m_operandWhen.replaceColumn(oldColumn, newColumn);
        }
        if (this.m_operandThen != null) {
            this.m_operandThen.replaceColumn(oldColumn, newColumn);
        }
    }

    @Override
    public boolean containsRememberedColumn(IColumn column) {
        if (this.m_operandThen != null && this.m_operandThen.containsRememberedColumn(column)) {
            return true;
        }
        return this.m_operandWhen != null && this.m_operandWhen.containsRememberedColumn(column);
    }

    @Override
    public void replaceTableColumns(ITable oldTable, ITable newTable) {
        if (this.m_operandWhen != null) {
            this.m_operandWhen.replaceTableColumns(oldTable, newTable);
        }
        if (this.m_operandThen != null) {
            this.m_operandThen.replaceTableColumns(oldTable, newTable);
        }
    }

    @Override
    public void setThenOperand(ITextOperand textOperand) {
        if (this.m_operandThen == null && textOperand == null) {
            return;
        }
        if (this.m_operandThen != null) {
            if (this.m_operandThen.equals(textOperand)) {
                return;
            }
            this.m_operandThen.removeNotifyListener(this);
            this.addToDeletedObjects(this.m_operandThen);
        }
        if (textOperand != null) {
            this.removeFromDeletedObjects(textOperand);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetThenOperandUndoable(this.m_operandThen, textOperand));
        }
        this.m_operandThen = textOperand;
        if (this.m_operandThen != null) {
            this.m_operandThen.setUseSQLSyntax(true);
            this.m_operandThen.addNotifyListener(this);
        }
        this.fireModelChangedEvent("CaseExpression:ThenOperandChanged", null);
    }

    @Override
    public void setWhenOperand(ITextOperand textOperand) {
        if (this.m_operandWhen == null && textOperand == null) {
            return;
        }
        if (this.m_operandWhen != null) {
            if (this.m_operandWhen.equals(textOperand)) {
                return;
            }
            this.m_operandWhen.removeNotifyListener(this);
            this.addToDeletedObjects(this.m_operandWhen);
        }
        if (textOperand != null) {
            this.removeFromDeletedObjects(textOperand);
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetWhenOperandUndoable(this.m_operandWhen, textOperand));
        }
        this.m_operandWhen = textOperand;
        if (this.m_operandWhen != null) {
            this.m_operandWhen.setUseSQLSyntax(true);
            this.m_operandWhen.addNotifyListener(this);
        }
        this.fireModelChangedEvent("CaseExpression:WhenOperandChanged", null);
    }

    @Override
    public boolean validateExpression() {
        return this.m_operandWhen != null && this.m_operandWhen.isComplete() && this.m_operandThen != null && this.m_operandThen.isComplete();
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return null;
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return null;
    }

    @Override
    public String getOMRType() {
        return "FeatureMap";
    }

    @Override
    public boolean isChanged() {
        return super.isChanged() || this.m_operandWhen != null && this.m_operandWhen.isChanged() || this.m_operandThen != null && this.m_operandThen.isChanged();
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && this.m_operandThen != null && this.m_operandThen.isComplete() && this.m_operandWhen != null && this.m_operandWhen.isComplete();
    }

    @Override
    public List getReasonsIncomplete() {
        List lReasons = super.getReasonsIncomplete();
        if (this.m_operandThen == null) {
            lReasons.add(RB.getStringResource("CaseExpression.ReasonIncomplete.MissingThen.txt"));
        }
        if (this.m_operandThen != null && !this.m_operandThen.isComplete()) {
            lReasons.addAll(this.m_operandThen.getReasonsIncomplete());
        }
        if (this.m_operandWhen == null) {
            lReasons.add(RB.getStringResource("CaseExpression.ReasonIncomplete.MissingWhen.txt"));
        }
        if (this.m_operandWhen != null && !this.m_operandWhen.isComplete()) {
            lReasons.add(this.m_operandWhen.getReasonsIncomplete());
        }
        return lReasons;
    }

    @Override
    public String getText(IServer currentServer, boolean quotes) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getText(currentServer, quotes, false);
    }

    @Override
    public String getText(IServer currentServer, boolean quotes, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        StringBuffer sb = new StringBuffer();
        sb.append("   ").append("when ").append(this.m_operandWhen != null ? this.m_operandWhen.getText(currentServer, quotes, passthru) : "").append("\n").append("   ").append("   ").append("then ").append(this.m_operandThen != null ? this.m_operandThen.getText(currentServer, quotes, passthru) : "").append("\n");
        return sb.toString();
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        mdoFM.setName("CaseWhenThen");
        mdoFM.setTransformRole("CaseWhenThen");
        AssociationList mdoSourceTrans = mdoFM.getSourceTransformations(false);
        AssociationList mdoTargetTrans = mdoFM.getTargetTransformations(false);
        mdoSourceTrans.removeAllElements();
        mdoTargetTrans.removeAllElements();
        if (this.m_operandWhen != null) {
            this.m_operandWhen.saveToOMR(omr);
            mdoSourceTrans.add((Object)omr.acquireOMRObject(this.m_operandWhen));
        }
        if (this.m_operandThen != null) {
            this.m_operandThen.saveToOMR(omr);
            mdoTargetTrans.add((Object)omr.acquireOMRObject(this.m_operandThen));
        }
        this.setChanged(false);
    }

    protected ITextOperand createTextOperand(OMRAdapter omr, Root mdo) throws MdException, RemoteException {
        ITextOperand operand = (ITextOperand)this.getModel().getObject(mdo.getFQID());
        if (operand == null) {
            operand = this.getModel().getObjectFactory().createSQLTextOperand(mdo.getFQID(), this.m_parent.getQuery());
            operand.loadFromOMR(omr);
        }
        return operand;
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        Root mdoRoot;
        super.loadFromOMR(omr);
        FeatureMap mdoFM = (FeatureMap)omr.acquireOMRObject(this);
        AssociationList mdoSourceTrans = mdoFM.getSourceTransformations();
        AssociationList mdoTargetTrans = mdoFM.getTargetTransformations();
        if (mdoSourceTrans != null && !mdoSourceTrans.isEmpty()) {
            mdoRoot = (Root)mdoSourceTrans.get(0);
            ITextOperand operandWhen = this.createTextOperand(omr, mdoRoot);
            this.setWhenOperand(operandWhen);
        }
        if (mdoTargetTrans != null && !mdoTargetTrans.isEmpty()) {
            mdoRoot = (Root)mdoTargetTrans.get(0);
            ITextOperand operandThen = this.createTextOperand(omr, mdoRoot);
            this.setThenOperand(operandThen);
        }
        this.setChanged(false);
    }

    @Override
    public void deleteFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        if (this.isNew()) {
            return;
        }
        if (this.m_operandWhen != null) {
            this.m_operandWhen.deleteFromOMR(omr);
        }
        if (this.m_operandThen != null) {
            this.m_operandThen.deleteFromOMR(omr);
        }
        super.deleteFromOMR(omr);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        ArrayList<String> lAssociations = (ArrayList<String>)map.get(this.getOMRType());
        if (lAssociations == null) {
            lAssociations = new ArrayList<String>();
            lAssociations.add("SourceTransformations");
            lAssociations.add("TargetTransformations");
            map.put(this.getOMRType(), lAssociations);
        } else {
            lAssociations.add("SourceTransformations");
            lAssociations.add("TargetTransformations");
        }
        return map;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        if (this.m_operandWhen != null) {
            this.m_operandWhen.updateIDs(mapIDs);
        }
        if (this.m_operandThen != null) {
            this.m_operandThen.updateIDs(mapIDs);
        }
    }

    private class SetThenOperandUndoable
    extends AbstractUndoableEdit {
        private ITextOperand m_oldThenOperand;
        private ITextOperand m_newThenOperand;

        public SetThenOperandUndoable(ITextOperand oldThenOperand, ITextOperand newThenOperand) {
            this.m_oldThenOperand = oldThenOperand;
            this.m_newThenOperand = newThenOperand;
        }

        @Override
        public void undo() {
            super.undo();
            CaseExpression.this.setThenOperand(this.m_oldThenOperand);
        }

        @Override
        public void redo() {
            super.redo();
            CaseExpression.this.setThenOperand(this.m_newThenOperand);
        }

        @Override
        public void die() {
            super.die();
            this.m_newThenOperand = null;
            this.m_oldThenOperand = null;
        }
    }

    private class SetWhenOperandUndoable
    extends AbstractUndoableEdit {
        private ITextOperand m_oldWhenOperand;
        private ITextOperand m_newWhenOperand;

        public SetWhenOperandUndoable(ITextOperand oldWhenOperand, ITextOperand newWhenOperand) {
            this.m_oldWhenOperand = oldWhenOperand;
            this.m_newWhenOperand = newWhenOperand;
        }

        @Override
        public void undo() {
            super.undo();
            CaseExpression.this.setWhenOperand(this.m_oldWhenOperand);
        }

        @Override
        public void redo() {
            super.redo();
            CaseExpression.this.setWhenOperand(this.m_newWhenOperand);
        }

        @Override
        public void die() {
            super.die();
            this.m_newWhenOperand = null;
            this.m_oldWhenOperand = null;
        }
    }
}

