/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.AbstractComplexPersistableObject;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.sql.IAliasColumn;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.job.transforms.sql.ISubqueryTargetTable;
import com.sas.metadata.remote.MdException;
import com.sas.util.UsageVersion;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;

public class AliasColumn
extends AbstractComplexPersistableObject
implements IAliasColumn {
    private IColumn m_column;
    private ITable m_table;

    public AliasColumn(String sID, IModel model, IColumn column) {
        super(sID, model);
        this.m_column = column;
    }

    @Override
    public void setAliasedColumn(IColumn column) {
        if (this.m_column == null ? column == null : this.m_column.equals(column)) {
            return;
        }
        if (this.isUndoSupported()) {
            this.undoableEditHappened(new SetAliasedColumnUndoable(this.m_column, column));
        }
        this.m_column = column;
        this.fireModelChangedEvent("AliasedColumn:ColumnChanged", column);
    }

    @Override
    public IColumn getAliasedColumn() {
        return this.m_column;
    }

    @Override
    public void setTable(ITable tbl) {
        this.m_table = tbl;
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    void setAliasColumnID(String sId) {
        this.setID(sId);
    }

    @Override
    public void setName(String sName) {
        super.setName(sName);
    }

    @Override
    public String getName() {
        if (this.m_column != null) {
            return this.m_column.getName();
        }
        return "";
    }

    @Override
    public void setDescription(String sDescription) {
        super.setDescription(sDescription);
    }

    @Override
    public String getDescription() {
        if (this.m_column != null) {
            return this.m_column.getDescription();
        }
        return "";
    }

    @Override
    public String getAttribStatement(boolean needQuotes, boolean isDataStep, boolean needFormats, boolean needLabels) {
        return this.m_column.getAttribStatement(needQuotes, isDataStep, needFormats, needLabels);
    }

    @Override
    public String getAttribStatement(boolean needQuotes, boolean isDataStep, boolean needFormats, boolean needInformats, boolean needLabels) {
        return this.m_column.getAttribStatement(needQuotes, isDataStep, needFormats, needInformats, needLabels);
    }

    @Override
    public void setBeginPosition(int position) {
        this.m_column.setBeginPosition(position);
    }

    @Override
    public int getBeginPosition() {
        return this.m_column.getBeginPosition();
    }

    @Override
    public String getColumnName(ICodeSegment codeSegment) {
        return this.m_column.getColumnName(codeSegment);
    }

    @Override
    public String getColumnName(ICodeSegment codeSegment, boolean passthru) {
        return this.m_column.getColumnName(codeSegment, passthru);
    }

    @Override
    public String getColumnName(boolean quoted) {
        return this.m_column.getColumnName(quoted);
    }

    @Override
    public String getColumnName(boolean quoted, boolean passthru) {
        return this.m_column.getColumnName(quoted, passthru);
    }

    @Override
    public void setEndPosition(int position) {
        this.m_column.setEndPosition(position);
    }

    @Override
    public int getEndPosition() {
        return this.m_column.getEndPosition();
    }

    @Override
    public void setFormat(String sFormat) {
        this.m_column.setFormat(sFormat);
    }

    @Override
    public String getFormat() {
        return this.m_column.getFormat();
    }

    @Override
    public String getFormatStatement() {
        return this.m_column.getFormatStatement();
    }

    @Override
    public String getFullColumnName() {
        return this.getFullColumnName(this.getTable().isQuoted(), false);
    }

    @Override
    public String getFullColumnName(boolean quotes) {
        return this.getFullColumnName(quotes, false);
    }

    @Override
    public String getFullColumnName(boolean quotes, boolean passthru) {
        return this.getFullColumnName(quotes, passthru, null);
    }

    @Override
    public String getFullColumnName(boolean quotes, boolean passthru, IQuery requestingQuery) {
        StringBuffer columnName = new StringBuffer();
        ITable table = this.getTable();
        if (table == null || this.m_column == null) {
            return "";
        }
        if (requestingQuery != null && table != null && requestingQuery.getTargetTable() != table && table instanceof IAliasTable && ((IAliasTable)table).getAliasedTable() instanceof ISubqueryTargetTable && ((ISubqueryTargetTable)((IAliasTable)table).getAliasedTable()).getParentQuery() instanceof ISubquery) {
            ISubquery sQuery = (ISubquery)((ISubqueryTargetTable)((IAliasTable)table).getAliasedTable()).getParentQuery();
            if (requestingQuery != sQuery && sQuery.isAliased()) {
                columnName.append(sQuery.getAliasName()).append(".");
            }
        } else {
            columnName.append(table.getTableName(quotes, passthru)).append(".");
        }
        return columnName.append(this.m_column.getColumnName(quotes, passthru)).toString();
    }

    @Override
    public boolean isColumnNameValidSASV7() {
        return this.m_column.isColumnNameValidSASV7();
    }

    @Override
    public void setInformat(String sInformat) {
        this.m_column.setInformat(sInformat);
    }

    @Override
    public String getInformat() {
        return this.m_column.getInformat();
    }

    @Override
    public String getInformatStatement() {
        return this.m_column.getInformatStatement();
    }

    @Override
    public String getLabelStatement() {
        return this.m_column.getLabelStatement();
    }

    @Override
    public void setLength(int length) {
        this.m_column.setLength(length);
    }

    @Override
    public int getLength() {
        return this.m_column.getLength();
    }

    @Override
    public String getLevel() {
        return null;
    }

    @Override
    public String getLengthStatement(boolean isDataStep) {
        return this.m_column.getLengthStatement(isDataStep);
    }

    @Override
    public String getLengthStatement(boolean isDataStep, boolean includeLabel) {
        return this.m_column.getLengthStatement(isDataStep, includeLabel);
    }

    @Override
    public void setSortOrder(String sSortOrder) {
        this.m_column.setSortOrder(sSortOrder);
    }

    @Override
    public String getSortOrder() {
        return this.m_column.getSortOrder();
    }

    @Override
    public void setSummaryRole(String sSummaryRole) {
        this.m_column.setSummaryRole(sSummaryRole);
    }

    @Override
    public String getSummaryRole() {
        return this.m_column.getSummaryRole();
    }

    @Override
    public void setType(int eType) {
        this.m_column.setType(eType);
    }

    @Override
    public int getType() {
        return this.m_column.getType();
    }

    @Override
    public String getValidFormat() {
        return this.m_column.getValidFormat();
    }

    @Override
    public String getValidInformat() {
        return this.m_column.getValidInformat();
    }

    @Override
    public void setNullable(boolean bNullable) {
        this.m_column.setNullable(bNullable);
    }

    @Override
    public boolean isNullable() {
        return this.m_column.isNullable();
    }

    @Override
    public void copy(IColumn column) {
        this.m_column.copy(column);
    }

    @Override
    public void deepCopy(IColumn column) {
        this.m_column.deepCopy(column);
    }

    @Override
    public boolean equalsFormat(IColumn compareColumn) {
        return this.m_column.equalsFormat(compareColumn);
    }

    @Override
    public boolean equalsInformat(IColumn compareColumn) {
        return this.m_column.equalsInformat(compareColumn);
    }

    @Override
    public boolean equalsLabel(IColumn compareColumn) {
        return this.m_column.equalsLabel(compareColumn);
    }

    @Override
    public boolean equalsName(IColumn compareColumn, boolean quotes) {
        return this.m_column.equalsName(compareColumn, quotes);
    }

    @Override
    public boolean equalsName(String compareName, boolean quotes) {
        return this.m_column.equalsName(compareName, quotes);
    }

    @Override
    public void dump(PrintStream stream) {
        this.m_column.dump(stream);
    }

    @Override
    public UsageVersion getArchitectureVersionNumber() {
        return this.m_column.getArchitectureVersionNumber();
    }

    protected void fireSpecialModelChangedEvent(String sType) {
        this.fireModelChangedEvent(sType, null);
    }

    public String getPublicType() {
        return "Embedded:Column";
    }

    @Override
    public boolean isPublicObject() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.m_column.isComplete() && this.getTable() != null;
    }

    @Override
    public boolean isChanged() {
        return this.m_column.isChanged();
    }

    @Override
    public IOMRPersistable getOMRObject() {
        return this.m_column;
    }

    @Override
    public String getOMRType() {
        return "Column";
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws MdException, RemoteException {
    }

    @Override
    public void updateIDs(Map mapIDs) {
    }

    @Override
    public void loadFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        this.setChanged(false);
    }

    @Override
    public Map getOMRCheckOutTemplateMap() {
        return this.m_column.getOMRCheckOutTemplateMap();
    }

    @Override
    public Map getOMRCopyTemplateMap() {
        return this.m_column.getOMRCopyTemplateMap();
    }

    @Override
    public Map getOMRExportTemplateMap() {
        return this.m_column.getOMRExportTemplateMap();
    }

    private class SetAliasedColumnUndoable
    extends AbstractUndoableEdit {
        private IColumn m_oldColumn;
        private IColumn m_newColumn;

        public SetAliasedColumnUndoable(IColumn oldColumn, IColumn newColumn) {
            this.m_oldColumn = oldColumn;
            this.m_newColumn = newColumn;
        }

        @Override
        public void undo() {
            super.undo();
            AliasColumn.this.setAliasedColumn(this.m_oldColumn);
        }

        @Override
        public void redo() {
            super.redo();
            AliasColumn.this.setAliasedColumn(this.m_newColumn);
        }

        @Override
        public void die() {
            super.die();
            this.m_newColumn = null;
            this.m_oldColumn = null;
        }
    }
}

