/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.sql.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.NotifyEvent;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelLogger;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.IBooleanExpression;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IExpression;
import com.sas.etl.models.job.impl.AbstractBooleanExpressionContainer;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.ICaseStatement;
import com.sas.etl.models.job.transforms.sql.IQuery;
import com.sas.etl.models.job.transforms.sql.ISQLBooleanExpressionContainer;
import com.sas.etl.models.job.transforms.sql.ISQLSource;
import com.sas.etl.models.job.transforms.sql.ISourceTable;
import com.sas.etl.models.job.transforms.sql.ISubquery;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Select;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSQLBooleanExpressionContainer
extends AbstractBooleanExpressionContainer
implements ISQLBooleanExpressionContainer {
    private IQuery m_query;

    public AbstractSQLBooleanExpressionContainer(String sID, IModel model) {
        super(sID, model);
        this.setUseSQLSyntax(true);
    }

    @Override
    public void notify(NotifyEvent ev) {
        if (ev.getType() == 31) {
            this.fireNotifyEvent(31);
        }
        if (ev.getType() == 32) {
            this.fireNotifyEvent(32);
        }
        super.notify(ev);
    }

    @Override
    public ISubquery createNewSubquery() {
        return this.m_query.createNewSubquery();
    }

    @Override
    public void removeBooleanExpression(IBooleanExpression expression) {
        super.removeBooleanExpression(expression);
        IExpression rightOperand = expression.getRightOperand();
        IExpression leftOperand = expression.getLeftOperand();
        if (rightOperand != null && rightOperand instanceof ISubquery) {
            this.fireModelChangedEvent("BooleanExpression.SubqueryRemoved", rightOperand);
            this.fireNotifyEvent(32);
        }
        if (leftOperand != null && leftOperand instanceof ISubquery) {
            this.fireModelChangedEvent("BooleanExpression.SubqueryRemoved", leftOperand);
            this.fireNotifyEvent(32);
        }
    }

    @Override
    public void removeSubqueryFromExpression(ISubquery subquery) {
        IBooleanExpression[] aExpressions = this.getBooleanExpressions();
        for (int index = 0; index < aExpressions.length; ++index) {
            IBooleanExpression expression = aExpressions[index];
            IExpression rightOperand = expression.getRightOperand();
            IExpression leftOperand = expression.getLeftOperand();
            if (rightOperand != null && rightOperand == subquery) {
                expression.setRightOperand(null);
                for (int index2 = subquery.getQuerySourceTableCount() - 1; index2 > -1; --index2) {
                    subquery.removeQuerySourceTable(subquery.getQuerySourceTables()[index2]);
                }
            } else {
                if (leftOperand == null || leftOperand != subquery) continue;
                expression.setLeftOperand(null);
                for (int index2 = subquery.getQuerySourceTableCount(); index2 > 0; --index2) {
                    subquery.removeQuerySourceTable(subquery.getQuerySourceTables()[index2]);
                }
            }
            break;
        }
    }

    @Override
    public ICaseStatement[] getCaseStatements() {
        List lCases = this.getCaseStatementList();
        return lCases.toArray(new ICaseStatement[lCases.size()]);
    }

    @Override
    public List getCaseStatementList() {
        ArrayList<IExpression> lCases = new ArrayList<IExpression>();
        IBooleanExpression[] alExpression = this.getBooleanExpressions();
        for (int i = 0; i < this.size(); ++i) {
            IExpression rightOperand;
            IBooleanExpression expression = alExpression[i];
            IExpression leftOperand = expression.getLeftOperand();
            if (leftOperand != null && leftOperand.getExpressionType().equalsIgnoreCase("CaseOperand")) {
                lCases.add(leftOperand);
            }
            if ((rightOperand = expression.getRightOperand()) == null || !rightOperand.getExpressionType().equalsIgnoreCase("CaseOperand")) continue;
            lCases.add(rightOperand);
        }
        return lCases;
    }

    @Override
    public void removeSQLSource(ISQLSource source) {
        if (source == null) {
            return;
        }
        ITable table = null;
        if (source instanceof ISubquery) {
            table = ((ISubquery)source).getAliasTable();
        } else if (source instanceof ISourceTable) {
            table = (ITable)((Object)source);
        } else {
            return;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            IBooleanExpression expression = (IBooleanExpression)this.getBooleanExpressionsList().get(i);
            IColumn[] aCols = table.getColumns();
            for (int index = 0; index < aCols.length; ++index) {
                if (!expression.containsColumn(aCols[index])) continue;
                expression.replaceColumn(aCols[index], null);
            }
        }
    }

    @Override
    public void addSQLSource(ISQLSource source) {
        if (source == null) {
            return;
        }
        ITable table = null;
        if (source instanceof ISubquery) {
            table = ((ISubquery)source).getAliasTable();
        } else if (source instanceof ISourceTable) {
            table = (ITable)((Object)source);
        } else {
            return;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            IBooleanExpression expression = (IBooleanExpression)this.getBooleanExpressionsList().get(i);
            IColumn[] aCols = table.getColumns();
            for (int index = 0; index < aCols.length; ++index) {
                if (!expression.containsRememberedColumn(aCols[index])) continue;
                expression.replaceColumn(null, aCols[index]);
            }
        }
    }

    @Override
    public void setParentQuery(IQuery query) {
        this.m_query = query;
    }

    @Override
    public IQuery getParentQuery() {
        return this.m_query;
    }

    @Override
    public boolean isQuotingNeeded() {
        boolean quote = false;
        if (this.m_query != null && this.m_query.getTransformModel() != null) {
            quote = this.m_query.getTransformModel().isQuotingNeeded();
        }
        return quote;
    }

    @Override
    public IBooleanExpression createNewBooleanExpression() {
        return this.getModel().getObjectFactory().createNewSQLBooleanExpression(this.getID(), this);
    }

    @Override
    public IBooleanExpression createBooleanExpression(OMRAdapter omr, FeatureMap mdo) throws MdException, RemoteException {
        String sID = mdo.getFQID();
        IBooleanExpression object = (IBooleanExpression)this.getModel().getObject(sID);
        if (object != null) {
            return object;
        }
        object = this.getModel().getObjectFactory().createSQLBooleanExpression(sID, this);
        object.loadFromOMR(omr);
        return object;
    }

    @Override
    public boolean isPassThru() {
        boolean passthru = false;
        IQuery query = this.getParentQuery();
        if (query != null && query.getTransformModel() != null) {
            passthru = query.getTransformModel().isPassThru();
        }
        return passthru;
    }

    @Override
    public String getText(IServer currentServer, boolean quotes) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        return this.getText(currentServer, quotes, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getText(IServer currentServer, boolean quotes, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        StringBuffer text = new StringBuffer();
        IBooleanExpression[] expressions = this.getBooleanExpressions();
        boolean userWritten = this.isUsingUserWrittenCode();
        if (!userWritten && expressions != null && expressions.length > 0) {
            for (int i = 0; i < expressions.length; ++i) {
                IBooleanExpression expr = expressions[i];
                String code = expr.getText(currentServer, quotes, passthru);
                if (code == null || code.length() <= 0) continue;
                text.append(code);
            }
            return text.toString();
        } else {
            if (!userWritten) return text.toString();
            try {
                String code = this.getUserWrittenCode().getCode();
                if (code == null || code.length() <= 0) return text.toString();
                text.append(code);
                return text.toString();
            }
            catch (ServerException exc) {
                ModelLogger.getDefaultLogger().error((Object)"ServerException", (Throwable)exc);
            }
        }
        return text.toString();
    }

    @Override
    public ICodeSegment getGeneratedCode(ICodeSegment codeSegment, boolean passthru) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        String code;
        IBooleanExpression[] expressions = this.getBooleanExpressions();
        boolean userWritten = this.isUsingUserWrittenCode();
        if (!userWritten && expressions != null && expressions.length > 0) {
            for (int i = 0; i < expressions.length; ++i) {
                IBooleanExpression expr = expressions[i];
                expr.getGeneratedCode(codeSegment, passthru);
                codeSegment.addSourceCode("\n");
            }
        } else if (userWritten && (code = this.getUserWrittenCode().getCode()) != null && code.length() > 0) {
            codeSegment.addSourceCode(code).addSourceCode("\n");
        }
        return codeSegment;
    }

    @Override
    public void saveToOMR(OMRAdapter omr) throws RemoteException, MdException {
        if (!this.isChanged()) {
            return;
        }
        super.saveToOMR(omr);
        IQuery parent = this.getParentQuery();
        if (parent != null) {
            Select mdoSelect = (Select)omr.acquireOMRObject(this.getParentQuery());
            AssociationList lTransSources = mdoSelect.getTransformationSources(false);
            ICaseStatement[] aCases = this.getCaseStatements();
            for (int iCase = 0; iCase < aCases.length; ++iCase) {
                ICaseStatement oCase = aCases[iCase];
                lTransSources.add((Object)omr.acquireOMRObject(oCase));
            }
            ISubquery[] aSubqueries = this.getSubqueries();
            for (int iSub = 0; iSub < aSubqueries.length; ++iSub) {
                ISubquery oSub = aSubqueries[iSub];
                lTransSources.add((Object)omr.acquireOMRObject(oSub));
            }
        }
        this.setChanged(false);
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getOMRType());
        lAssociations.add("TransformationSources");
        map.put(this.getOMRType(), lAssociations);
        return map;
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        List lSubqueries = this.getSubqueryList();
        for (int index = 0; index < lSubqueries.size(); ++index) {
            ((ISubquery)lSubqueries.get(index)).updateIDs(mapIDs);
        }
        List lCaseStats = this.getCaseStatementList();
        for (int index = 0; index < lCaseStats.size(); ++index) {
            ((ICaseStatement)lCaseStats.get(index)).updateIDs(mapIDs);
        }
    }
}

