/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.splitter;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IDataObject;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.data.impl.BaseWorkTable;
import com.sas.etl.models.impl.AbstractPersistableObject;
import com.sas.etl.models.impl.ModelList;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.IMapping;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.etl.models.job.impl.AbstractDataTransform;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.splitter.IRowSelector;
import com.sas.etl.models.job.transforms.splitter.IRowSelectorTransform;
import com.sas.etl.models.job.transforms.splitter.RB;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.RowSelector;
import com.sas.metadata.remote.TransformationStep;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SplitterTransformModel
extends AbstractDataTransform
implements IRowSelectorTransform {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.visuals.SASSplitter";
    private static final String TRANSFORMATION_ROLE = "com.sas.wadmin.visuals.SASSplitter";
    private static final String ARM_DISPLAY_NAME = "Splitter";
    private List m_lRowSels;
    private List m_lClassifierMapIDs = new ArrayList();
    private List m_lUnusedClassifierMapIDs = new ArrayList();
    private static final String ETLS_MAPPED = "etls_mapped";
    private static final String WORK_ETLS_MAPPED = "work.etls_mapped";

    public SplitterTransformModel(String sID, IModel model) {
        super(sID, model);
        this.m_lRowSels = new RowSelectorList(this, new String[]{"RowSelector:RowSelectorAdded", "RowSelector:RowSelectorRemoved"}, 3, IRowSelector.class);
    }

    public static String getTransformTypeID() {
        return "com.sas.wadmin.visuals.SASSplitter";
    }

    @Override
    protected String getTransformClass() {
        return "com.sas.wadmin.visuals.SASSplitter";
    }

    @Override
    protected String getTransformRole() {
        return "com.sas.wadmin.visuals.SASSplitter";
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("SplitterTranformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("SplitterTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public void addDefaultSettings() {
        this.addNewWorkTable();
        this.addNewWorkTable();
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return true;
    }

    @Override
    public IWorkTable addNewWorkTable() {
        this.startCompoundUndoable();
        try {
            IWorkTable tbl = this.getObjectFactory().createNewWorkTable(this.getID());
            tbl.setName(this.getName() + " " + this.getDataTargetsCount());
            this.addRowSelectorAndDataTarget(tbl);
            IWorkTable iWorkTable = tbl;
            return iWorkTable;
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected boolean areExpressionsAllowed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowSelectorAndDataTarget(IDataObject target) {
        this.startCompoundUndoable();
        try {
            IRowSelector rowSel = null;
            List deletedObjects = this.getDeletedObjects();
            for (int i = 0; i < deletedObjects.size(); ++i) {
                IPersistableObject object = (IPersistableObject)deletedObjects.get(i);
                if (!(object instanceof IRowSelector) || !((IRowSelector)object).containsTable((ITable)target)) continue;
                rowSel = (IRowSelector)object;
                this.removeFromDeletedObjects(object);
                this.m_lRowSels.add(rowSel);
                this.addDataTarget(target);
                return;
            }
            rowSel = this.getModel().getObjectFactory().createNewRowSelector(this.getID());
            rowSel.setTable((ITable)target);
            rowSel.setClassifierMapID(this.createIDForNewObject());
            this.m_lRowSels.add(rowSel);
            this.addDataTarget(target);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postAddDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            super.postAddDataSource(source);
            IColumn[] aCols = ((ITable)source).getColumns();
            for (int index = 0; index < aCols.length; ++index) {
                for (int index2 = 0; index2 < this.m_lRowSels.size(); ++index2) {
                    IRowSelector rowSel = (IRowSelector)this.m_lRowSels.get(index2);
                    ITextExpression expr = rowSel.getExpression();
                    if (expr == null) continue;
                    expr.replaceColumn(null, aCols[index]);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preRemoveDataSource(IDataObject source) {
        this.startCompoundUndoable();
        try {
            super.preRemoveDataSource(source);
            IColumn[] aCols = ((ITable)source).getColumns();
            for (int index = 0; index < aCols.length; ++index) {
                for (int index2 = 0; index2 < this.m_lRowSels.size(); ++index2) {
                    IRowSelector rowSel = (IRowSelector)this.m_lRowSels.get(index2);
                    ITextExpression expr = rowSel.getExpression();
                    if (expr == null) continue;
                    expr.replaceColumn(aCols[index], null);
                }
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    public void addDataTarget(int iTarget, IDataObject target) {
        if (this.containsInDataTargets(target)) {
            return;
        }
        super.addDataTarget(iTarget, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preRemoveDataTarget(IDataObject target) {
        this.startCompoundUndoable();
        try {
            super.preRemoveDataTarget(target);
            for (int i = 0; i < this.m_lRowSels.size(); ++i) {
                IRowSelector rowSel = (IRowSelector)this.m_lRowSels.get(i);
                if (!rowSel.containsTable((ITable)target)) continue;
                this.m_lRowSels.remove(rowSel);
                break;
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    @Override
    protected int getMaximumDataTargetCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public IRowSelector[] getRowSelectorObjects() {
        return this.m_lRowSels.toArray(new IRowSelector[this.m_lRowSels.size()]);
    }

    @Override
    public List getRowSelectorList() {
        return this.m_lRowSels;
    }

    @Override
    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        for (int i = 0; i < this.m_lRowSels.size(); ++i) {
            IRowSelector data = (IRowSelector)this.m_lRowSels.get(i);
            if (!data.isChanged()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        int i;
        int i2;
        super.getGeneratedCode(codeSegment);
        IPhysicalTable sourceTable = (IPhysicalTable)this.getDataSources()[0];
        int numMaps = this.m_lRowSels.size();
        IPhysicalTable[] targetTables = new IPhysicalTable[numMaps];
        boolean[] targetMapNeeded = new boolean[numMaps];
        IPhysicalTable[] tempTargetTables = new IPhysicalTable[numMaps];
        for (i2 = 0; i2 < numMaps; ++i2) {
            IPhysicalTable target;
            IRowSelector rowSel = (IRowSelector)this.m_lRowSels.get(i2);
            targetTables[i2] = target = (IPhysicalTable)rowSel.getTable();
            targetMapNeeded[i2] = this.isMappingNeeded(codeSegment.isQuoting(), sourceTable, target);
            if (targetMapNeeded[i2]) {
                IModel mdl = this.getModel();
                boolean bUndoSupported = mdl.isUndoSupported();
                mdl.setUndoSupported(false);
                try {
                    tempTargetTables[i2] = new BaseWorkTable(this.createIDForNewObject(), this.getModel());
                    if (tempTargetTables[i2] instanceof IWorkTable && this.getJob().getAlternateTemporaryLibrary() != null) {
                        ((IWorkTable)tempTargetTables[i2]).setAlternateJobLibrary(this.getJob().getAlternateTemporaryLibrary());
                    }
                    tempTargetTables[i2].setSASTableName(target.getSASTableName());
                    this.getModel().removeObject(tempTargetTables[i2]);
                    tempTargetTables[i2].dispose();
                    continue;
                }
                finally {
                    mdl.setUndoSupported(bUndoSupported);
                }
            }
            tempTargetTables[i2] = target;
        }
        this.genTableDelete(codeSegment, Arrays.asList(tempTargetTables));
        codeSegment.addSourceCode("data ");
        for (i2 = 0; i2 < numMaps; ++i2) {
            codeSegment.addSourceCode("\n").addSourceCode("     ").addSourceCode(tempTargetTables[i2].getFullNameQuotedAsNeeded(codeSegment));
            if (targetMapNeeded[i2]) continue;
            ITransformTableOptions targetOptions = this.getTableOptionObject(targetTables[i2], false);
            codeSegment.addSourceCode(" ").addSourceCode(targetOptions.getTableOptions(true, codeSegment.getCurrentServer()));
        }
        codeSegment.addSourceCode(";\n");
        codeSegment.indent().addSourceCode("set &SYSLAST");
        ITransformTableOptions sourceTableOptions = this.getTableOptionObject(sourceTable, true);
        if (sourceTableOptions.getTableOptions(codeSegment.getCurrentServer()).length() > 0) {
            codeSegment.addSourceCode(sourceTableOptions.getTableOptions(true, codeSegment.getCurrentServer()));
        }
        codeSegment.addSourceCode(";\n");
        for (i = 0; i < numMaps; ++i) {
            IRowSelector rowSel = (IRowSelector)this.m_lRowSels.get(i);
            if (rowSel == null) continue;
            String rslType = rowSel.getRowSelectorType().toUpperCase();
            if (!rslType.startsWith("All Rows".toUpperCase())) {
                ITextExpression iSel = rowSel.getExpression();
                String expression = "";
                if (iSel != null) {
                    expression = iSel.getText(codeSegment.getCurrentServer(), codeSegment.isQuoting(), false);
                }
                if (rslType.startsWith("User Defined Statements".toUpperCase())) {
                    if (expression.length() > 0) {
                        codeSegment.addSourceCode(expression);
                        codeSegment.addSourceCode("\n");
                        continue;
                    }
                    codeSegment.addSourceCode("output ").addSourceCode(tempTargetTables[i].getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(";\n");
                    continue;
                }
                if (!rslType.startsWith("Row Selection Conditions".toUpperCase())) continue;
                if (expression.length() > 0) {
                    codeSegment.addSourceCode("if " + expression).addSourceCode(" then \n").addSourceCode("   output " + tempTargetTables[i].getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(";\n");
                    continue;
                }
                codeSegment.addSourceCode("output ").addSourceCode(tempTargetTables[i].getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(";\n");
                continue;
            }
            codeSegment.addSourceCode("output ").addSourceCode(tempTargetTables[i].getFullNameQuotedAsNeeded(codeSegment)).addSourceCode(";\n");
        }
        codeSegment.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        for (i = 0; i < targetTables.length; ++i) {
            IPhysicalTable targetTable = targetTables[i];
            boolean isMapGenerated = targetMapNeeded[i];
            if (!isMapGenerated) continue;
            this.getOrdinaryMappingCode(codeSegment, sourceTable, targetTable, WORK_ETLS_MAPPED, tempTargetTables[i].getFullNameQuotedAsNeeded(codeSegment), "", "", false, true, true);
            codeSegment.addSourceCode("data " + targetTable.getFullNameQuotedAsNeeded(codeSegment) + ";");
            codeSegment.newLine();
            codeSegment.addSourceCode("  set work.etls_mapped;");
            codeSegment.newLine();
            codeSegment.addSourceCode("run;");
            codeSegment.newLine();
            boolean bUndoSupported = this.getModel().isUndoSupported();
            this.getModel().setUndoSupported(false);
            try {
                IWorkTable workTable = this.getModel().getObjectFactory().createNewWorkTable(this.getID());
                workTable.setSASTableName(ETLS_MAPPED);
                this.getModel().removeObject(workTable);
                workTable.dispose();
                codeSegment.newLine();
                workTable.genTableDelete(codeSegment);
                codeSegment.genRCSetCall("&syscc");
            }
            finally {
                this.getModel().setUndoSupported(bUndoSupported);
            }
            tempTargetTables[i].delete();
        }
        return codeSegment;
    }

    @Override
    protected void loadDataSourcesTargetsFromOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        this.m_lClassifierMapIDs.clear();
        this.m_lRowSels.clear();
        AssociationList lTransformations = mdoStep.getTransformations();
        for (int iTransformation = 0; iTransformation < lTransformations.size(); ++iTransformation) {
            ClassifierMap mdoCM = (ClassifierMap)lTransformations.get(iTransformation);
            this.m_lClassifierMapIDs.add(mdoCM.getFQID());
            AssociationList lSources = mdoCM.getClassifierSources();
            for (int iSource = 0; iSource < lSources.size(); ++iSource) {
                Root mdoSource = (Root)lSources.get(iSource);
                IDataObject source = (IDataObject)omr.acquireObject(mdoSource);
                if (this.containsInDataSources(source) || iSource >= this.getMaximumDataSourceCount()) continue;
                this.addDataSource(source);
            }
            AssociationList lTargets = mdoCM.getClassifierTargets();
            for (int iTarget = 0; iTarget < lTargets.size(); ++iTarget) {
                Root mdoTarget = (Root)lTargets.get(iTarget);
                IDataObject target = (IDataObject)omr.acquireObject(mdoTarget);
                if (!this.containsInDataTargets(target)) {
                    this.addDataTarget(this.getDataTargetsCount(), target);
                }
                RowSelector mdoRS = mdoCM.getAssociatedRowSelector();
                IRowSelector rowSel = null;
                rowSel = mdoRS != null ? (IRowSelector)omr.acquireObject((Root)mdoRS) : this.getModel().getObjectFactory().createNewRowSelector(this.createIDForNewObject());
                rowSel.setTable((ITable)target);
                rowSel.setClassifierMapID(mdoCM.getFQID());
                if (this.m_lRowSels.contains(rowSel)) continue;
                this.m_lRowSels.add(rowSel);
            }
            this.loadMappingsFromOMR(omr, mdoCM);
        }
    }

    @Override
    protected AbstractTransformation getUserWrittenCodeAnchor(OMRAdapter omr) throws MdException, RemoteException {
        return (AbstractTransformation)omr.acquireOMRObject(this);
    }

    @Override
    public void replaceSourceTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        for (int index = 0; index < this.m_lRowSels.size(); ++index) {
            IRowSelector rowSelector = (IRowSelector)this.m_lRowSels.get(index);
            ITextExpression expression = rowSelector.getExpression();
            if (expression == null) continue;
            expression.replaceTableColumns(oldTable, newTable);
        }
        super.replaceSourceTable(oldTable, newTable, columnsMap, portIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTargetTable(ITable oldTable, ITable newTable, Map columnsMap, Integer[] portIndexes) {
        this.startCompoundUndoable();
        try {
            for (int index = 0; index < this.m_lRowSels.size(); ++index) {
                IRowSelector rowSelector = (IRowSelector)this.m_lRowSels.get(index);
                if (rowSelector.getTable() != oldTable) continue;
                rowSelector.setTable(newTable);
                ITextExpression expression = rowSelector.getExpression();
                if (expression == null) break;
                expression.replaceTableColumns(oldTable, newTable);
                break;
            }
            super.replaceTargetTable(oldTable, newTable, columnsMap, portIndexes);
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void replaceTargetMappings(ITable oldTable, ITable newTable, Map columnsMap) {
        this.startCompoundUndoable();
        try {
            IMapping mapping;
            int iMap;
            ArrayList<IMapping> lChangedMappings = new ArrayList<IMapping>();
            IMapping[] aMappings = this.getTargetTableMapping(oldTable);
            IColumn[] aNewColumns = newTable.getColumns();
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                IColumn[] aColumns = mapping.getTargets();
                block4: for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
                    IColumn column = aColumns[iColumn];
                    if (columnsMap != null && (IColumn)columnsMap.get(aColumns[iColumn]) != null) {
                        mapping.replaceTargetColumn(column, (IColumn)columnsMap.get(aColumns[iColumn]));
                        lChangedMappings.add(mapping);
                        continue;
                    }
                    if (Arrays.asList(oldTable.getColumns()).indexOf(column) == -1) continue;
                    for (int iNewColumn = 0; iNewColumn < aNewColumns.length; ++iNewColumn) {
                        IColumn newColumn = aNewColumns[iNewColumn];
                        if (!column.getName().equals(newColumn.getName()) || column.getLength() < newColumn.getLength() || column.getType() != newColumn.getType()) continue;
                        mapping.replaceTargetColumn(column, newColumn);
                        lChangedMappings.add(mapping);
                        continue block4;
                    }
                }
            }
            for (iMap = 0; iMap < aMappings.length; ++iMap) {
                mapping = aMappings[iMap];
                if (lChangedMappings.indexOf(mapping) != -1 || mapping.getType() != "ONETOONE") continue;
                this.removeMapping(mapping);
            }
        }
        finally {
            this.endCompoundUndoable();
        }
    }

    protected IMapping[] getTargetTableMapping(ITable table) {
        ArrayList<IMapping> lMappings = new ArrayList<IMapping>();
        IColumn[] aCols = table.getColumns();
        for (int index = 0; index < aCols.length; ++index) {
            IMapping mapping = this.getOrdinaryMappingsForTargetColumn(aCols[index]);
            if (mapping == null) continue;
            lMappings.add(mapping);
        }
        return lMappings.toArray(new IMapping[lMappings.size()]);
    }

    @Override
    protected void saveClassifierMapToOMR(OMRAdapter omr, TransformationStep mdoStep) throws MdException, RemoteException {
        List lOldClassifierMapIDs = this.m_lClassifierMapIDs;
        this.m_lClassifierMapIDs = new ArrayList();
        AssociationList lTransformations = mdoStep.getTransformations(false);
        lTransformations.clear();
        IDataObject[] tables = this.getDataTargets();
        if (tables.length == 0) {
            String sName = this.getName();
            String sClassiferMapID = this.createIDForNewObject();
            this.m_lClassifierMapIDs.add(sClassiferMapID);
            ClassifierMap mdoCM = (ClassifierMap)omr.acquireOMRObject(sClassiferMapID, this.getClassifierMapType());
            mdoCM.setName(sName);
            mdoCM.getClassifierTargets(false).clear();
            mdoCM.getClassifierSources(false).clear();
            IDataObject[] sources = this.getDataSources();
            for (int iDataSource = 0; iDataSource < sources.length; ++iDataSource) {
                IDataObject objSource = sources[iDataSource];
                if (!(objSource instanceof ITable)) continue;
                ITable tblSource = (ITable)objSource;
                mdoCM.getClassifierSources(false).add((Object)omr.acquireOMRObject(tblSource));
            }
            lTransformations.add(mdoCM);
        } else {
            IDataObject[] targets = this.getDataTargets();
            for (int iDataTarget = 0; iDataTarget < targets.length; ++iDataTarget) {
                IDataObject objTarget = targets[iDataTarget];
                if (!(objTarget instanceof ITable)) continue;
                ITable tblTarget = (ITable)objTarget;
                String sClassifierMapID = "";
                ClassifierMap mdoCM = null;
                for (int i = 0; i < this.m_lRowSels.size(); ++i) {
                    IRowSelector rowSel = (IRowSelector)this.m_lRowSels.get(i);
                    if (!rowSel.containsTable(tblTarget)) continue;
                    sClassifierMapID = rowSel.getClassifierMapID();
                    if (sClassifierMapID == null || sClassifierMapID.length() == 0) {
                        sClassifierMapID = this.createIDForNewObject();
                        rowSel.setClassifierMapID(sClassifierMapID);
                    }
                    lOldClassifierMapIDs.remove(sClassifierMapID);
                    mdoCM = (ClassifierMap)omr.acquireOMRObject(sClassifierMapID, this.getClassifierMapType());
                    mdoCM.getAssociatedRowSelectors(false).clear();
                    rowSel.saveToOMR(omr);
                    RowSelector mdoRS = (RowSelector)omr.acquireOMRObject(rowSel);
                    mdoCM.setAssociatedRowSelector(mdoRS);
                }
                if (mdoCM == null) {
                    mdoCM = (ClassifierMap)omr.acquireOMRObject(lOldClassifierMapIDs.size() > 0 ? (String)lOldClassifierMapIDs.remove(0) : this.createIDForNewObject(), this.getClassifierMapType());
                }
                String sName = this.getName() + ":" + tblTarget.getName();
                mdoCM.setName(sName);
                lTransformations.add(mdoCM);
                mdoCM.getClassifierTargets(false).clear();
                mdoCM.getClassifierTargets(false).add((Object)omr.acquireOMRObject(tblTarget));
                mdoCM.getClassifierSources(false).clear();
                IDataObject[] sources = this.getDataSources();
                for (int iDataSource = 0; iDataSource < sources.length; ++iDataSource) {
                    IDataObject objSource = sources[iDataSource];
                    if (!(objSource instanceof ITable)) continue;
                    ITable tblSource = (ITable)objSource;
                    mdoCM.getClassifierSources(false).add((Object)omr.acquireOMRObject(tblSource));
                }
                mdoCM.getFeatureMaps(false).clear();
                this.saveMappingsToOMR(omr, mdoCM, tblTarget);
            }
            while (!lOldClassifierMapIDs.isEmpty()) {
                String sID = (String)lOldClassifierMapIDs.remove(0);
                if (sID == null) continue;
                omr.deleteOMRObject(sID, this.getClassifierMapType());
            }
            while (!this.m_lUnusedClassifierMapIDs.isEmpty()) {
                String sID = (String)this.m_lUnusedClassifierMapIDs.remove(0);
                if (sID == null) continue;
                omr.deleteOMRObject(sID, this.getClassifierMapType());
            }
        }
    }

    @Override
    public void updateIDs(Map mapIDs) {
        super.updateIDs(mapIDs);
        for (int iClassifierMapID = 0; iClassifierMapID < this.m_lClassifierMapIDs.size(); ++iClassifierMapID) {
            String sClassifierMapID = (String)this.m_lClassifierMapIDs.get(iClassifierMapID);
            if (sClassifierMapID == null) continue;
            this.m_lClassifierMapIDs.set(iClassifierMapID, this.updateSubordinateID(sClassifierMapID, mapIDs));
        }
        for (int i = 0; i < this.m_lRowSels.size(); ++i) {
            IRowSelector rowSel = (IRowSelector)this.m_lRowSels.get(i);
            rowSel.updateIDs(mapIDs);
        }
    }

    @Override
    protected void deleteClassifierMapFromOMR(OMRAdapter omr) throws MdException, RemoteException {
        IMapping[] mappings = this.getMappings();
        for (int iMapping = 0; iMapping < mappings.length; ++iMapping) {
            mappings[iMapping].deleteFromOMR(omr);
        }
        while (!this.m_lClassifierMapIDs.isEmpty()) {
            String sID = (String)this.m_lClassifierMapIDs.remove(0);
            if (sID == null) continue;
            omr.deleteOMRObject(sID, this.getClassifierMapType());
        }
        for (int i = 0; i < this.m_lRowSels.size(); ++i) {
            IRowSelector rowSel = (IRowSelector)this.m_lRowSels.get(i);
            rowSel.deleteFromOMR(omr);
        }
    }

    @Override
    public Map getOMRLoadTemplateMap() {
        Map map = super.getOMRLoadTemplateMap();
        List lAssociations = (List)map.get(this.getClassifierMapType());
        lAssociations.add("AssociatedRowSelector");
        return map;
    }

    private class RowSelectorList
    extends ModelList {
        public RowSelectorList(AbstractPersistableObject owner, String[] aEventIDs, int ePersistenceType, Class clsAllowedType) {
            super(owner, aEventIDs, ePersistenceType, clsAllowedType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void addImpl(int iObj, Object obj) {
            SplitterTransformModel.this.startCompoundUndoable();
            try {
                super.addImpl(iObj, obj);
                IRowSelector rowSel = (IRowSelector)obj;
                String sClsID = rowSel.getClassifierMapID();
                if (sClsID == null || sClsID.length() == 0) {
                    sClsID = SplitterTransformModel.this.createIDForNewObject();
                    rowSel.setClassifierMapID(sClsID);
                }
                if (!SplitterTransformModel.this.m_lClassifierMapIDs.contains(sClsID)) {
                    SplitterTransformModel.this.m_lClassifierMapIDs.add(sClsID);
                }
                SplitterTransformModel.this.m_lUnusedClassifierMapIDs.remove(sClsID);
            }
            finally {
                SplitterTransformModel.this.endCompoundUndoable();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object removeImpl(int iObject) {
            SplitterTransformModel.this.startCompoundUndoable();
            try {
                IRowSelector rowSel = (IRowSelector)super.removeImpl(iObject);
                String clsID = rowSel.getClassifierMapID();
                if (clsID != null && clsID.length() > 0) {
                    SplitterTransformModel.this.m_lClassifierMapIDs.remove(clsID);
                    SplitterTransformModel.this.m_lUnusedClassifierMapIDs.add(clsID);
                }
                IRowSelector iRowSelector = rowSel;
                return iRowSelector;
            }
            finally {
                SplitterTransformModel.this.endCompoundUndoable();
            }
        }
    }
}

