/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IObject;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.RB;
import com.sas.etl.models.job.transforms.queues.impl.CommonQueueTransformModel;
import com.sas.etl.models.job.transforms.queues.impl.MSMQQueueWriterCodegen;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.prompts.IPromptDefinitionValue;
import com.sas.etl.models.prompts.IPromptModel;
import com.sas.etl.models.prompts.impl.BasePromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.storage.exception.ServerConnectionException;
import com.sas.workspace.Workspace;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MSMQWriterTransformModel
extends CommonQueueTransformModel {
    private static final String TRANSFORMATION_CLASS = "com.sas.wadmin.transforms.queues.QueueWriter";
    private static final String TRANSFORMATION_ROLE = "QueueWriter:HIDE";
    private static final String ARM_DISPLAY_NAME = "MSMQWriter";

    public MSMQWriterTransformModel(String sID, IModel model) {
        super(sID, model);
        super.setCollectSourceTableRowCounts(false);
        super.setCollectTargetTableRowCounts(false);
        this.setReader(false);
        this.setMQSystem("MSMQ");
        this.createConditionActionSetTemplates();
    }

    public static String getTransformTypeID() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getTransformRole() {
        return TRANSFORMATION_ROLE;
    }

    @Override
    public boolean isAddWorkTableAvailable() {
        return false;
    }

    @Override
    protected String getTransformClass() {
        return TRANSFORMATION_CLASS;
    }

    @Override
    protected String getDefaultName() {
        return RB.getStringResource("MSMQWriterTransformModel.Name.txt");
    }

    @Override
    public String getDisplayType() {
        return RB.getStringResource("MSMQWriterTransformModel.DisplayType.txt");
    }

    @Override
    public String getAbsoluteName() {
        return ARM_DISPLAY_NAME;
    }

    @Override
    public void addDefaultSettings() throws MdException, RemoteException {
        this.loadConditionActionSetTemplatesFromOMR();
    }

    @Override
    protected IPromptModel createMessageOptionModel() throws RemoteException, MdException, ServiceException, ServerConnectionException, ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        BasePromptModel p = new BasePromptModel(this.getModel(), this);
        p.setPromptGroup(p.createPromptGroup(this.getClass().getResource("res/Options_MSQWriter_Template.xml")));
        return p;
    }

    @Override
    public IWorkTable addNewWorkTable() {
        throw new UnsupportedOperationException("Microsoft queue writer transform does not support work tables");
    }

    protected void createConditionActionSetTemplates() {
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETSUCCESS");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETWARN");
        this.getDefinedConditionActionSetUniqueIds().add("DIS_SETERROR");
    }

    @Override
    protected ICodeSegment getGeneratedCode(ICodeSegment codeSegment) throws CodegenException, MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        this.setMSMQPromptValuesToModel(this.loadPromptValuesToHashMap());
        super.getGeneratedCode(codeSegment);
        MSMQQueueWriterCodegen cg = new MSMQQueueWriterCodegen();
        try {
            codeSegment = cg.getGeneratedCode(codeSegment, this);
            if (codeSegment.isRunTableStatisticsEnabled() && this.isTableMessage()) {
                codeSegment.genRowsProcessedCount(this.getSourceTable(), null);
            }
        }
        catch (RemoteException e) {
            throw new CodegenException(e, (IObject)this);
        }
        catch (MdException e) {
            throw new CodegenException((Exception)((Object)e), (IObject)this);
        }
        catch (BadLibraryDefinitionException e) {
            throw new CodegenException(e, (IObject)this);
        }
        return codeSegment;
    }

    @Override
    public ICodeSegment getGeneratedLibnameCodeForSources(ICodeSegment codeSegment) throws MdException, RemoteException, BadServerDefinitionException, BadLibraryDefinitionException, CodegenException, ServerException {
        if (this.isTableMessage()) {
            super.getGeneratedLibnameCodeForSources(codeSegment);
        }
        return codeSegment;
    }

    public HashMap loadPromptValuesToHashMap() {
        HashMap m_hmPromptValues = new HashMap();
        try {
            IPromptDefinitionValue[] promptValues = this.getPromptDefinitionValues();
            for (int iPrompts = 0; iPrompts < promptValues.length; ++iPrompts) {
                String sValue = "";
                if (promptValues[iPrompts].getValue() != null) {
                    sValue = promptValues[iPrompts].getValue().toString();
                }
                this.addOption(m_hmPromptValues, promptValues[iPrompts].getName(), sValue);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (ServerConnectionException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return m_hmPromptValues;
    }

    private void addOption(HashMap hashMap, String sName, String sValue) {
        hashMap.put(sName.toUpperCase(), sValue);
        Workspace.getDefaultLogger().debug((Object)("Name = " + sName + "   Value = " + sValue));
    }
}

