/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.queues.impl.MQLog;
import com.sas.etl.models.job.transforms.queues.impl.MQROOT;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MQSETPARMS
extends MQROOT {
    public static final String MQSETPARMS_Comment_notrans = "SAS Variable to hold message to be sent to queue";
    public static final String MQSETPARMS_Tempvars_notrans = "Temporary Variables";
    public static final String MQSETPARMS_AssignValues_notrans = "Assign values from sas table columns to SAS variables";
    public static final String MQSETPARMS_CreateDD_notrans = "Creates a data descriptor that describes the actual base SAS variables along with an associated data mapping. This data descriptor can then be used on a subsequent MQPUT or MQPUT1 call";
    public static final String MQSETPARMS_Failed_Comment_notrans = "MQSETPARMS: failed";
    public static final String MQSETPARMS_NoFormatDefinition_error_fmt_txt = "An appropriate SAS format must be defined or message type be changed for column \"{0}\"";
    ArrayList m_Descriptors = new ArrayList();
    protected static String ETLS_MSGBUF = "etls_msgbuf";
    protected List m_TableColumns;
    protected boolean bQuoteCols = false;

    public MQSETPARMS(ICodeSegment cgReq, boolean bQueueWriter, HashMap hmUserInput) throws MdException, RemoteException {
        super(cgReq, bQueueWriter, hmUserInput);
    }

    public void generateLengthStatements() {
        this.addBlankLine();
        this.addRBComment("SASVAR_DATADESCRIPTOR_HANDLE");
        this.addLengthStatement("etls_hdata", true, "8");
        if (this.isTextOptionSelected()) {
            this.addBlankLine();
            this.m_cg.addCommentLine(MQSETPARMS_Comment_notrans);
            this.addLengthStatement("etls_read", false, (String)this.m_hmUserInput.get("etls_message_length"));
        } else if (this.isTableOptionSelected()) {
            this.addBlankLine();
            this.m_cg.addCommentLine(MQSETPARMS_Tempvars_notrans);
            for (int i = 0; i < this.m_TableColumns.size(); ++i) {
                String mqType = ((String[])this.m_TableColumns.get(i))[3];
                boolean bNumeric = true;
                String sLength = "8";
                if (mqType.compareToIgnoreCase("CHAR") == 0) {
                    bNumeric = false;
                    sLength = ((String[])this.m_TableColumns.get(i))[2];
                }
                this.addLengthStatement("etls_var" + i, bNumeric, sLength);
            }
        }
    }

    public void generateAssignmentStatements() {
        this.addBlankLine();
        if (this.isTextOptionSelected()) {
            this.assignVariable("etls_read", "symget('etls_msg')", false);
        } else if (this.isTableOptionSelected()) {
            this.m_cg.addCommentLine(MQSETPARMS_AssignValues_notrans);
            for (int i = 0; i < this.m_TableColumns.size(); ++i) {
                String sUseFormats;
                String mqType = ((String[])this.m_TableColumns.get(i))[3];
                String sasType = ((String[])this.m_TableColumns.get(i))[6];
                String sColumnName = ((String[])this.m_TableColumns.get(i))[0];
                boolean bMQNumeric = true;
                boolean bSASColNumeric = true;
                if (mqType.compareToIgnoreCase("CHAR") == 0) {
                    bMQNumeric = false;
                }
                if (sasType.compareToIgnoreCase("C") == 0) {
                    bSASColNumeric = false;
                }
                if ((sUseFormats = (String)this.m_hmUserInput.get("CGEN_FORMATS")) == null) {
                    sUseFormats = "YES";
                }
                String sFormat = ((String[])this.m_TableColumns.get(i))[4];
                if (bMQNumeric == bSASColNumeric || sUseFormats.compareToIgnoreCase("NO") == 0) {
                    this.m_cg.addSourceCode("etls_var" + i + " = ");
                    if (this.isQuoteCols()) {
                        this.m_cg.addSourceCode("\"");
                    }
                    this.m_cg.addSourceCode(sColumnName);
                    if (this.isQuoteCols()) {
                        this.m_cg.addSourceCode("\"");
                        this.m_cg.addSourceCode("n");
                    }
                    this.addCloseLine();
                    continue;
                }
                if (sFormat.length() == 0) {
                    this.m_cg.addSourceCode("etls_var" + i + " = ");
                    if (this.isQuoteCols()) {
                        this.m_cg.addSourceCode("\"");
                    }
                    this.m_cg.addSourceCode(sColumnName);
                    if (this.isQuoteCols()) {
                        this.m_cg.addSourceCode("\"");
                        this.m_cg.addSourceCode("n");
                    }
                    this.addCloseLine();
                    continue;
                }
                this.m_cg.addSourceCode("etls_var" + i + " = put(");
                if (this.isQuoteCols()) {
                    this.m_cg.addSourceCode("\"");
                }
                this.m_cg.addSourceCode(sColumnName);
                if (this.isQuoteCols()) {
                    this.m_cg.addSourceCode("\"");
                    this.m_cg.addSourceCode("n");
                }
                this.m_cg.addSourceCode(", ");
                if (sFormat.length() == 0) {
                    String msgString = MQLog.formatString(MQSETPARMS_NoFormatDefinition_error_fmt_txt, sColumnName);
                    MessageUtil.displayMessage((String)msgString, (int)2);
                }
                this.m_cg.addSourceCode(sFormat);
                this.m_cg.addSourceCode(")");
                this.addCloseLine();
            }
        }
    }

    public void generateFunctionCall() {
        this.addBlankLine();
        this.m_cg.addCommentLine(MQSETPARMS_CreateDD_notrans);
        this.buildFunctionCall(this.getFunctionParms());
        this.addFailCondition(MQSETPARMS_Failed_Comment_notrans);
    }

    public void generateSASCode() {
        this.addBlankLine();
        this.addRBComment("SASVAR_DATADESCRIPTOR_HANDLE");
        this.addLengthStatement("etls_hdata", true, "8");
        if (this.isTextOptionSelected()) {
            this.addLengthStatement("etls_read", false, (String)this.m_hmUserInput.get("etls_message_length"));
            this.assignVariable("etls_read", "&etls_msg", true);
        } else if (this.isTableOptionSelected() || this.isFileOptionSelected()) {
            // empty if block
        }
        this.addBlankLine();
        this.buildFunctionCall(this.getFunctionParms());
        this.addFailCondition("MQSETPARMS: failed ");
    }

    public void addDescriptor(List lTableColumns) {
        this.m_TableColumns = lTableColumns;
        for (int i = 0; i < lTableColumns.size(); ++i) {
            this.m_Descriptors.add("etls_var" + i);
        }
    }

    public void addDescriptorForFileWrite() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.m_hmUserInput.get(ETLS_MSGBUF));
        list.add(new Boolean(true));
        this.m_Descriptors.add(list);
    }

    public void addDescriptor(String sValue, boolean bCharacter) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(sValue);
        list.add(new Boolean(bCharacter));
        this.m_Descriptors.add(list);
    }

    public void addMessageDescriptor() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.m_hmUserInput.get("etls_text_message"));
        list.add(new Boolean(true));
        this.m_Descriptors.add(list);
    }

    public List getFunctionParms() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("etls_hdata");
        list.add("etls_hmap");
        list.add("etls_qrc");
        if (this.isTextOptionSelected()) {
            list.add("etls_read");
        } else if (this.isTableOptionSelected()) {
            for (int i = 0; i < this.m_Descriptors.size(); ++i) {
                list.add((String)this.m_Descriptors.get(i));
            }
        } else if (this.isFileOptionSelected()) {
            list.add(ETLS_MSGBUF);
        }
        return list;
    }

    protected boolean isQuoteCols() {
        return this.bQuoteCols;
    }

    protected void setQuoteCols(boolean quoteCols) {
        this.bQuoteCols = quoteCols;
    }
}

