/*
 * Decompiled with CFR 0.152.
 */
package com.sas.etl.models.job.transforms.queues.impl;

import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.transforms.queues.impl.MQLog;
import com.sas.etl.models.job.transforms.queues.impl.MQPO;
import com.sas.etl.models.job.transforms.queues.impl.RB;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MQOPEN
extends MQPO {
    public static final String MQOPEN_Comment_notrans = "Establishes access to an MQSeries object (queue, process definition, or queue manager)";
    public static final String MQOPEN_FailConditions_Comment_notrans = "MQOPEN failure conditions";
    protected static String INPUT_AS_Q_DEF = "INPUT_AS_Q_DEF";
    protected static String INPUT_SHARED = "INPUT_SHARED";
    protected static String INPUT_EXCLUSIVE = "INPUT_EXCLUSIVE";
    protected static String BROWSE = "BROWSE";
    protected static String OUTPUT = "OUTPUT";
    protected static String INQUIRE = "INQUIRE";
    protected static String SET = "SET";
    protected static String SAVE_ALL_CONTEXT = "SAVE_ALL_CONTEXT";
    protected static String PASS_IDENTITY_CONTEXT = "PASS_IDENTITY_CONTEXT";
    protected static String PASS_ALL_CONTEXT = "PASS_ALL_CONTEXT";
    protected static String SET_IDENTITY_CONTEXT = "SET_IDENTITY_CONTEXT";
    protected static String SET_ALL_CONTEXT = "SET_ALL_CONTEXT";
    protected static String ALTERNATE_USER_AUTHORITY = "ALTERNATE_USER_AUTHORITY";
    protected static String FAIL_IF_QUIESCING = "FAIL_IF_QUIESCING";

    public MQOPEN(ICodeSegment cgReq, boolean bQueueWriter, HashMap hmUserInput) throws MdException, RemoteException {
        super(cgReq, bQueueWriter, hmUserInput);
        this.initializeOptions();
        this.createOptions();
    }

    private void createOptions() {
        Boolean oBoolean = new Boolean(false);
        this.m_hmOptions.put(INPUT_AS_Q_DEF, oBoolean);
        this.m_hmOptions.put(INPUT_SHARED, oBoolean);
        this.m_hmOptions.put(INPUT_EXCLUSIVE, oBoolean);
        this.m_hmOptions.put(BROWSE, oBoolean);
        this.m_hmOptions.put(OUTPUT, oBoolean);
        this.m_hmOptions.put(INQUIRE, oBoolean);
        this.m_hmOptions.put(SET, oBoolean);
        this.m_hmOptions.put(SAVE_ALL_CONTEXT, oBoolean);
        this.m_hmOptions.put(PASS_IDENTITY_CONTEXT, oBoolean);
        this.m_hmOptions.put(PASS_ALL_CONTEXT, oBoolean);
        this.m_hmOptions.put(SET_IDENTITY_CONTEXT, oBoolean);
        this.m_hmOptions.put(SET_ALL_CONTEXT, oBoolean);
        this.m_hmOptions.put(ALTERNATE_USER_AUTHORITY, oBoolean);
        this.m_hmOptions.put(FAIL_IF_QUIESCING, oBoolean);
    }

    public void generateLengthStatements() {
        this.addBlankLine();
        this.addRBComment("SASVAR_OBJECT_HANDLE");
        this.addLengthStatement(this.getObjectHandle(), true, "8");
    }

    public void generateAssignmentStatements() {
        this.addBlankLine();
        this.addRBComment("SASVAR_OPTIONS");
    }

    public void generateFunctionCall() {
        this.addBlankLine();
        this.m_cg.addCommentLine(RB.getStringResource("MQOPEN.Comment.notrans"));
        this.generateOptionsStatement();
        this.addBlankLine();
        this.buildFunctionCall(this.getFunctionParms());
        this.addFailConditions();
    }

    public List getFunctionParms() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("etls_hconn");
        list.add("etls_hod");
        list.add("etls_options");
        list.add(this.getObjectHandle());
        list.add("etls_compcode");
        list.add("etls_qrc");
        return list;
    }

    private void addFailConditions() {
        this.m_cg.addCommentLine(RB.getStringResource("MQOPEN.FailConditions.Comment.notrans"));
        this.addString("if ");
        this.addString("etls_compcode");
        this.addString(" ^= 0 then \ndo;\n");
        this.m_cg.indent();
        this.m_cg.genRCSetDSCall("8000", true);
        this.addString("if ");
        this.addString("etls_qrc");
        this.addString("=2085 then \ndo; \n");
        String msgString = MQLog.formatString("Reason Code 2085. Unknown Object Name. Check spelling and case of the queue name that is used in the application and is defined in the queue manager.", this.getQueueManagerName());
        this.m_cg.indent();
        this.m_cg.genPutStatement(msgString, "ERROR%QUOTE(:)");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addString("else \ndo;\n");
        this.m_cg.indent();
        msgString = "Please refer to Websphere MQ Application Programming Reference (http://www-306.ibm.com/software/integration/wmq/library/).";
        this.addString("put \"ERROR%QUOTE(:) Reason Code \" ");
        this.addString("etls_qrc");
        this.addString(";\n");
        this.m_cg.genPutStatement(msgString, "ERROR%QUOTE(:)");
        this.m_cg.unIndent();
        this.addString("end;\n");
        this.addBlankLine();
        this.addExitLine();
        this.m_cg.unIndent();
        this.addString("end;\n");
    }
}

